/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CompilerExecutor {
    static final long COMPILER_STACK_SIZE = 0x4000000L;
    private Thread compilerThread = null;
    private boolean useThreads = true;
    private int timeout = 0;

    CompilerExecutor() {
    }

    @GwtIncompatible(value="java.util.concurrent.ExecutorService")
    ExecutorService getExecutorService() {
        return CompilerExecutor.getDefaultExecutorService();
    }

    static ExecutorService getDefaultExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, "jscompiler", 0x4000000L);
                t.setDaemon(true);
                return t;
            }
        });
    }

    void disableThreads() {
        this.useThreads = false;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    <T> T runInCompilerThread(Callable<T> callable, boolean dumpTraceReport) {
        ExecutorService executor = this.getExecutorService();
        Object result = null;
        Throwable[] exception = new Throwable[1];
        Preconditions.checkState(this.compilerThread == null || this.compilerThread == Thread.currentThread(), "Please do not share the Compiler across threads");
        if (this.useThreads && this.compilerThread == null) {
            try {
                Callable<Object> bootCompilerThread = () -> {
                    try {
                        this.compilerThread = Thread.currentThread();
                        if (dumpTraceReport) {
                            Tracer.initCurrentThreadTrace();
                        }
                        Object v = callable.call();
                        return v;
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                    }
                    finally {
                        this.compilerThread = null;
                        if (dumpTraceReport) {
                            Tracer.logCurrentThreadTrace();
                        }
                        Tracer.clearCurrentThreadTrace();
                    }
                    return null;
                };
                Future<Object> future = executor.submit(bootCompilerThread);
                if (this.timeout > 0) {
                    result = future.get(this.timeout, TimeUnit.SECONDS);
                }
                result = future.get();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
            finally {
                executor.shutdown();
            }
        } else {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                exception[0] = e;
            }
        }
        if (exception[0] != null) {
            Throwables.throwIfUnchecked(exception[0]);
            throw new RuntimeException(exception[0]);
        }
        return (T)result;
    }
}

