/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConcretizeStaticInheritanceForInlining
implements CompilerPass {
    static final DiagnosticType DUPLICATE_CLASS = DiagnosticType.error("DUPLICATE_CLASS", "Multiple classes cannot share the same name: {0}");
    private final Set<String> duplicateClassNames = new HashSet<String>();
    private static final ImmutableSet<String> BANNED_PROP_NAMES = ImmutableSet.of("prototype", "getInstance");
    private final AbstractCompiler compiler;
    private final LinkedHashMap<String, JavascriptClass> classByAlias = new LinkedHashMap();

    public ConcretizeStaticInheritanceForInlining(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindStaticMembers findStaticMembers = new FindStaticMembers();
        NodeTraversal.traverse(this.compiler, root, findStaticMembers);
        this.processInherits(findStaticMembers);
    }

    private void processInherits(FindStaticMembers findStaticMembers) {
        for (Node inheritsCall : findStaticMembers.inheritsCalls) {
            Node superclassNameNode = inheritsCall.getLastChild();
            String superclassQname = superclassNameNode.getQualifiedName();
            Node subclassNameNode = superclassNameNode.getPrevious();
            String subclassQname = subclassNameNode.getQualifiedName();
            JavascriptClass superClass = this.classByAlias.get(superclassQname);
            JavascriptClass subClass = this.classByAlias.get(subclassQname);
            if (this.duplicateClassNames.contains(superclassQname)) {
                this.compiler.report(JSError.make(inheritsCall, DUPLICATE_CLASS, superclassQname));
                return;
            }
            if (superClass == null || subClass == null) continue;
            this.copyStaticMembers(superClass, subClass, inheritsCall, findStaticMembers);
            this.copyDeclarations(superClass, subClass, inheritsCall);
        }
    }

    private void copyDeclarations(JavascriptClass superClass, JavascriptClass subClass, Node inheritsCall) {
        for (Node staticGetProp : superClass.staticFieldAccess) {
            Preconditions.checkState(staticGetProp.isGetProp());
            String memberName = staticGetProp.getString();
            if (!superClass.definedProperties.contains(memberName) || this.isOverriden(subClass, memberName)) continue;
            Node subclassNameNode = inheritsCall.getSecondChild();
            Node getprop = IR.getprop(subclassNameNode.cloneTree(), memberName);
            getprop.setJSDocInfo(null);
            Node declaration = IR.exprResult(getprop);
            declaration.srcrefTreeIfMissing(inheritsCall);
            Node parent = inheritsCall.getParent();
            declaration.insertBefore(parent);
            this.compiler.reportChangeToEnclosingScope(parent);
            if (subClass.definedProperties.contains(memberName)) continue;
            subClass.staticFieldAccess.add(getprop);
            subClass.definedProperties.add(memberName);
        }
    }

    private void copyStaticMembers(JavascriptClass superClass, JavascriptClass subClass, Node inheritsCall, FindStaticMembers findStaticMembers) {
        for (Node staticMember : superClass.staticMembers) {
            Node function;
            Preconditions.checkState(staticMember.isAssign(), staticMember);
            String memberName = staticMember.getFirstChild().getString();
            if (superClass.definedProperties.contains(memberName) || this.isOverriden(subClass, memberName) || findStaticMembers.isBefore(inheritsCall, staticMember)) continue;
            JSDocInfo.Builder info = JSDocInfo.Builder.maybeCopyFrom(staticMember.getJSDocInfo());
            Node sourceInfoNode = function = staticMember.getLastChild();
            if (function.isFunction()) {
                sourceInfoNode = function.getFirstChild();
            }
            Node subclassNameNode = inheritsCall.getSecondChild();
            Node superclassNameNode = subclassNameNode.getNext();
            Node assign = IR.assign(IR.getprop(subclassNameNode.cloneTree(), memberName), IR.getprop(superclassNameNode.cloneTree(), memberName));
            assign.setJSDocInfo(info.build());
            Node exprResult = IR.exprResult(assign);
            exprResult.srcrefTreeIfMissing(sourceInfoNode);
            Node inheritsExpressionResult = inheritsCall.getParent();
            exprResult.insertAfter(inheritsExpressionResult);
            this.compiler.reportChangeToEnclosingScope(inheritsExpressionResult);
            subClass.addStaticMember(assign);
        }
    }

    private boolean isOverriden(JavascriptClass subClass, String memberName) {
        if (subClass.staticMemberNames.contains(memberName)) {
            return true;
        }
        return subClass.definedProperties.contains(memberName);
    }

    private boolean isReferenceToClass(NodeTraversal t, Node n) {
        String className = n.getQualifiedName();
        if (!this.classByAlias.containsKey(className)) {
            return false;
        }
        if (!n.isName()) {
            return true;
        }
        Var var = (Var)t.getScope().getVar(className);
        return var == null || !var.isLocal();
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        final List<Node> inheritsCalls = new ArrayList<Node>();
        final Map<Node, Integer> nodeOrder = new HashMap<Node, Integer>();

        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    if (n.getFirstChild().matchesQualifiedName("$jscomp.inherits")) {
                        this.inheritsCalls.add(n);
                        this.nodeOrder.put(n, this.nodeOrder.size());
                    }
                    if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) break;
                    this.visitDefinedPropertiesCall(t, n);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    this.visitVariableDeclaration(n);
                    break;
                }
                case ASSIGN: {
                    this.visitAssign(t, n);
                    break;
                }
                case GETPROP: {
                    if (!parent.isExprResult()) break;
                    this.visitGetProp(t, n);
                    break;
                }
                case FUNCTION: {
                    this.visitFunctionClassDef(n);
                    break;
                }
            }
        }

        private void visitDefinedPropertiesCall(NodeTraversal t, Node definePropertiesCall) {
            Node object = definePropertiesCall.getSecondChild();
            if (ConcretizeStaticInheritanceForInlining.this.isReferenceToClass(t, object)) {
                String className = object.getQualifiedName();
                JavascriptClass c = (JavascriptClass)ConcretizeStaticInheritanceForInlining.this.classByAlias.get(className);
                for (Node prop : NodeUtil.getObjectDefinedPropertiesKeys(definePropertiesCall)) {
                    c.definedProperties.add(prop.getString());
                }
            }
        }

        private void visitFunctionClassDef(Node n) {
            JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(n);
            if (classInfo != null && classInfo.isConstructor()) {
                String name = NodeUtil.getName(n);
                if (ConcretizeStaticInheritanceForInlining.this.classByAlias.containsKey(name)) {
                    ConcretizeStaticInheritanceForInlining.this.duplicateClassNames.add(name);
                } else {
                    ConcretizeStaticInheritanceForInlining.this.classByAlias.put(name, new JavascriptClass());
                }
            }
        }

        private void setAlias(String original, String alias) {
            Preconditions.checkArgument(ConcretizeStaticInheritanceForInlining.this.classByAlias.containsKey(original));
            ConcretizeStaticInheritanceForInlining.this.classByAlias.put(alias, (JavascriptClass)ConcretizeStaticInheritanceForInlining.this.classByAlias.get(original));
        }

        private void visitGetProp(NodeTraversal t, Node n) {
            Node classNode = n.getFirstChild();
            if (ConcretizeStaticInheritanceForInlining.this.isReferenceToClass(t, classNode)) {
                ((JavascriptClass)ConcretizeStaticInheritanceForInlining.this.classByAlias.get(classNode.getQualifiedName())).staticFieldAccess.add(n);
            }
        }

        private void visitAssign(NodeTraversal t, Node n) {
            Node getProp;
            Node classNode;
            String existingClassQname = n.getLastChild().getQualifiedName();
            if (existingClassQname != null && ConcretizeStaticInheritanceForInlining.this.classByAlias.containsKey(existingClassQname)) {
                String alias = n.getFirstChild().getQualifiedName();
                if (alias != null) {
                    this.setAlias(existingClassQname, alias);
                }
            } else if (n.getFirstChild().isGetProp() && ConcretizeStaticInheritanceForInlining.this.isReferenceToClass(t, classNode = (getProp = n.getFirstChild()).getFirstChild()) && !BANNED_PROP_NAMES.contains(getProp.getString())) {
                ((JavascriptClass)ConcretizeStaticInheritanceForInlining.this.classByAlias.get(classNode.getQualifiedName())).addStaticMember(n);
                this.nodeOrder.put(n, this.nodeOrder.size());
            }
        }

        private void visitVariableDeclaration(Node n) {
            String maybeAlias;
            Node child = n.getFirstChild();
            if (!child.hasChildren()) {
                return;
            }
            String maybeOriginalName = child.getFirstChild().getQualifiedName();
            if (ConcretizeStaticInheritanceForInlining.this.classByAlias.containsKey(maybeOriginalName) && (maybeAlias = child.getQualifiedName()) != null) {
                this.setAlias(maybeOriginalName, maybeAlias);
            }
        }

        boolean isBefore(Node earlier, Node later) {
            Integer earlierPosition = this.nodeOrder.get(earlier);
            Integer laterPosition = this.nodeOrder.get(later);
            return earlierPosition != null && laterPosition != null && earlierPosition < laterPosition;
        }
    }

    private static class JavascriptClass {
        private final Set<Node> staticMembers = new LinkedHashSet<Node>();
        private final Set<String> staticMemberNames = new HashSet<String>();
        private final Set<Node> staticFieldAccess = new LinkedHashSet<Node>();
        private final Set<String> definedProperties = new LinkedHashSet<String>();

        private JavascriptClass() {
        }

        void addStaticMember(Node node) {
            this.staticMembers.add(node);
            this.staticMemberNames.add(node.getFirstChild().getString());
        }
    }
}

