/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public final class ControlFlowAnalysis
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private Map<Node, Integer> astPosition;
    private Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> nodePriorities;
    private final Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> priorityComparator = Comparator.comparingInt(digraphNode -> this.astPosition.get(digraphNode.getValue()));
    private int astPositionCounter;
    private int priorityCounter;
    private final boolean shouldTraverseFunctions;
    private final boolean edgeAnnotations;
    private Node root;
    private final Deque<Node> exceptionHandler = new ArrayDeque<Node>();
    private final Multimap<Node, Node> finallyMap = HashMultimap.create();

    ControlFlowAnalysis(AbstractCompiler compiler, boolean shouldTraverseFunctions, boolean edgeAnnotations) {
        this.compiler = compiler;
        this.shouldTraverseFunctions = shouldTraverseFunctions;
        this.edgeAnnotations = edgeAnnotations;
    }

    public static ControlFlowGraph<Node> getCfg(AbstractCompiler compiler, Node cfgRoot) {
        Preconditions.checkArgument(NodeUtil.isValidCfgRoot(cfgRoot));
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(compiler, false, true);
        cfa.process(null, cfgRoot);
        return cfa.getCfg();
    }

    ControlFlowGraph<Node> getCfg() {
        return this.cfg;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument(NodeUtil.isValidCfgRoot(root), "Unexpected control flow graph root %s", (Object)root);
        this.root = root;
        this.astPositionCounter = 0;
        this.astPosition = new HashMap<Node, Integer>();
        this.nodePriorities = new HashMap<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer>();
        this.cfg = new AstControlFlowGraph(ControlFlowAnalysis.computeFallThrough(root), this.nodePriorities, this.edgeAnnotations);
        NodeTraversal.traverse(this.compiler, root, this);
        this.astPosition.put(null, ++this.astPositionCounter);
        this.priorityCounter = 0;
        DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> entry = this.cfg.getEntry();
        this.prioritizeFromEntryNode(entry);
        if (this.shouldTraverseFunctions) {
            for (DiGraph.DiGraphNode diGraphNode : this.cfg.getNodes()) {
                Node value = (Node)diGraphNode.getValue();
                if (value == null || !value.isFunction()) continue;
                this.prioritizeFromEntryNode(diGraphNode);
            }
        }
        for (DiGraph.DiGraphNode diGraphNode : this.cfg.getNodes()) {
            this.nodePriorities.computeIfAbsent(diGraphNode, k -> ++this.priorityCounter);
        }
        this.nodePriorities.put(this.cfg.getImplicitReturn(), ++this.priorityCounter);
    }

    private void prioritizeFromEntryNode(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> entry) {
        PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> worklist = new PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(10, this.priorityComparator);
        worklist.add(entry);
        while (!worklist.isEmpty()) {
            DiGraph.DiGraphNode current = (DiGraph.DiGraphNode)worklist.remove();
            if (this.nodePriorities.containsKey(current)) continue;
            this.nodePriorities.put(current, ++this.priorityCounter);
            List successors = this.cfg.getDirectedSuccNodes(current);
            worklist.addAll(successors);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        this.astPosition.put(n, this.astPositionCounter++);
        switch (n.getToken()) {
            case FUNCTION: {
                if (this.shouldTraverseFunctions || n == this.cfg.getEntry().getValue()) {
                    this.exceptionHandler.push(n);
                    return true;
                }
                return false;
            }
            case TRY: {
                this.exceptionHandler.push(n);
                return true;
            }
        }
        if (parent != null) {
            switch (parent.getToken()) {
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: {
                    return n == parent.getLastChild();
                }
                case DO: {
                    return n != parent.getSecondChild();
                }
                case IF: 
                case WHILE: 
                case WITH: 
                case SWITCH: 
                case CASE: 
                case CATCH: 
                case LABEL: {
                    return n != parent.getFirstChild();
                }
                case FUNCTION: {
                    return n == parent.getLastChild();
                }
                case CLASS: {
                    return this.shouldTraverseFunctions && n == parent.getLastChild();
                }
                case COMPUTED_PROP: 
                case CONTINUE: 
                case BREAK: 
                case EXPR_RESULT: 
                case VAR: 
                case LET: 
                case CONST: 
                case EXPORT: 
                case IMPORT: 
                case RETURN: 
                case THROW: {
                    return false;
                }
                case TRY: {
                    if ((NodeUtil.hasFinally(parent) || n != NodeUtil.getCatchBlock(parent)) && !NodeUtil.isTryFinallyNode(parent, n)) break;
                    Preconditions.checkState(this.exceptionHandler.peek() == parent);
                    this.exceptionHandler.pop();
                    break;
                }
            }
            if (parent.hasParent() && parent.getParent().isArrowFunction() && !parent.isBlock()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case IF: {
                this.handleIf(n);
                return;
            }
            case WHILE: {
                this.handleWhile(n);
                return;
            }
            case DO: {
                this.handleDo(n);
                return;
            }
            case FOR: {
                this.handleFor(n);
                return;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                this.handleEnhancedFor(n);
                return;
            }
            case SWITCH: {
                this.handleSwitch(n);
                return;
            }
            case CASE: {
                this.handleCase(n);
                return;
            }
            case DEFAULT_CASE: {
                this.handleDefault(n);
                return;
            }
            case BLOCK: 
            case ROOT: 
            case SCRIPT: 
            case MODULE_BODY: {
                this.handleStmtList(n);
                return;
            }
            case FUNCTION: {
                this.handleFunction(n);
                return;
            }
            case EXPR_RESULT: {
                this.handleExpr(n);
                return;
            }
            case THROW: {
                this.handleThrow(n);
                return;
            }
            case TRY: {
                this.handleTry(n);
                return;
            }
            case CATCH: {
                this.handleCatch(n);
                return;
            }
            case BREAK: {
                this.handleBreak(n);
                return;
            }
            case CONTINUE: {
                this.handleContinue(n);
                return;
            }
            case RETURN: {
                this.handleReturn(n);
                return;
            }
            case WITH: {
                this.handleWith(n);
                return;
            }
            case LABEL: 
            case CLASS_MEMBERS: 
            case MEMBER_FUNCTION_DEF: {
                return;
            }
        }
        this.handleStmt(n);
    }

    private void handleIf(Node node) {
        Node thenBlock = node.getSecondChild();
        Node elseBlock = thenBlock.getNext();
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(thenBlock));
        if (elseBlock == null) {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFallThrough(elseBlock));
        }
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleWhile(Node node) {
        Node cond = node.getFirstChild();
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(cond.getNext()));
        if (!cond.isTrue()) {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleDo(Node node) {
        Node cond = node.getFirstChild();
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(cond));
        if (!cond.isTrue()) {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleEnhancedFor(Node forNode) {
        Node item = forNode.getFirstChild();
        Node collection = item.getNext();
        Node body = collection.getNext();
        this.createEdge(collection, ControlFlowGraph.Branch.UNCOND, forNode);
        this.createEdge(forNode, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(body));
        this.createEdge(forNode, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(forNode, this));
        this.connectToPossibleExceptionHandler(forNode, collection);
    }

    private void handleFor(Node forNode) {
        Node init = forNode.getFirstChild();
        Node cond = init.getNext();
        Node iter = cond.getNext();
        Node body = iter.getNext();
        this.createEdge(init, ControlFlowGraph.Branch.UNCOND, forNode);
        this.createEdge(forNode, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(body));
        if (!cond.isEmpty() && !cond.isTrue()) {
            this.createEdge(forNode, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(forNode, this));
        }
        this.createEdge(iter, ControlFlowGraph.Branch.UNCOND, forNode);
        this.connectToPossibleExceptionHandler(init, init);
        this.connectToPossibleExceptionHandler(forNode, cond);
        this.connectToPossibleExceptionHandler(iter, iter);
    }

    private void handleSwitch(Node node) {
        Node next = ControlFlowAnalysis.getNextSiblingOfType(node.getSecondChild(), Token.CASE, Token.EMPTY);
        if (next != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, next);
        } else if (node.getSecondChild() != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getSecondChild());
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleCase(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, node.getSecondChild());
        Node next = ControlFlowAnalysis.getNextSiblingOfType(node.getNext(), Token.CASE);
        if (next != null) {
            Preconditions.checkState(next.isCase());
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, next);
        } else {
            Node parent = node.getParent();
            Node deflt = ControlFlowAnalysis.getNextSiblingOfType(parent.getSecondChild(), Token.DEFAULT_CASE);
            if (deflt != null) {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, deflt);
            } else {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
            }
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleDefault(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleWith(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleStmtList(Node node) {
        Node child;
        Node parent = node.getParent();
        if (node.isBlock() && parent.isTry() && NodeUtil.getCatchBlock(parent) == node && !NodeUtil.hasCatchHandler(node)) {
            return;
        }
        for (child = node.getFirstChild(); child != null && child.isFunction(); child = child.getNext()) {
        }
        if (child != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(child));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        if (parent != null) {
            switch (parent.getToken()) {
                case TRY: 
                case CASE: 
                case DEFAULT_CASE: {
                    break;
                }
                case ROOT: {
                    if (!node.isRoot() || node.getNext() == null) break;
                    this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getNext());
                    break;
                }
                default: {
                    if (!node.isBlock() || !node.isSyntheticBlock()) break;
                    this.createEdge(node, ControlFlowGraph.Branch.SYN_BLOCK, ControlFlowAnalysis.computeFollowNode(node, this));
                }
            }
        }
    }

    private void handleFunction(Node node) {
        Preconditions.checkState(node.isFunction());
        Preconditions.checkState(node.hasXChildren(3));
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(node.getLastChild()));
        Preconditions.checkState(this.exceptionHandler.peek() == node);
        this.exceptionHandler.pop();
    }

    private void handleExpr(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleThrow(Node node) {
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleTry(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleCatch(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
    }

    private void handleBreak(Node node) {
        String label = null;
        if (node.hasChildren()) {
            label = node.getFirstChild().getString();
        }
        Node previous = null;
        Node parent = node.getParent();
        Node cur = node;
        Node lastJump = node;
        while (!ControlFlowAnalysis.isBreakTarget(cur, label)) {
            if (cur.isTry() && NodeUtil.hasFinally(cur) && cur.getLastChild() != previous) {
                if (lastJump == node) {
                    this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                } else {
                    this.finallyMap.put(lastJump, ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                }
                lastJump = cur;
            }
            if (parent == null) {
                if (this.compiler.getOptions().canContinueAfterErrors()) {
                    return;
                }
                throw new IllegalStateException("Cannot find break target.");
            }
            previous = cur;
            cur = parent;
            parent = parent.getParent();
        }
        if (lastJump == node) {
            this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(cur, this));
        } else {
            this.finallyMap.put(lastJump, ControlFlowAnalysis.computeFollowNode(cur, this));
        }
    }

    private void handleContinue(Node node) {
        String label = null;
        if (node.hasChildren()) {
            label = node.getFirstChild().getString();
        }
        Node previous = null;
        Node cur = node;
        Node lastJump = node;
        while (!ControlFlowAnalysis.isContinueTarget(cur, label)) {
            if (cur.isTry() && NodeUtil.hasFinally(cur) && cur.getLastChild() != previous) {
                if (lastJump == node) {
                    this.createEdge(lastJump, ControlFlowGraph.Branch.UNCOND, cur.getLastChild());
                } else {
                    this.finallyMap.put(lastJump, ControlFlowAnalysis.computeFallThrough(cur.getLastChild()));
                }
                lastJump = cur;
            }
            Preconditions.checkState(cur.hasParent(), "Cannot find continue target.");
            previous = cur;
            cur = cur.getParent();
        }
        Node iter = cur;
        if (cur.isVanillaFor()) {
            iter = cur.getChildAtIndex(2);
        }
        if (lastJump == node) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, iter);
        } else {
            this.finallyMap.put(lastJump, iter);
        }
    }

    private void handleReturn(Node node) {
        Node lastJump = null;
        for (Node curHandler : this.exceptionHandler) {
            if (curHandler.isFunction()) break;
            if (!NodeUtil.hasFinally(curHandler)) continue;
            if (lastJump == null) {
                this.createEdge(node, ControlFlowGraph.Branch.UNCOND, curHandler.getLastChild());
            } else {
                this.finallyMap.put(lastJump, ControlFlowAnalysis.computeFallThrough(curHandler.getLastChild()));
            }
            lastJump = curHandler;
        }
        if (node.hasChildren()) {
            this.connectToPossibleExceptionHandler(node, node.getFirstChild());
        }
        if (lastJump == null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, null);
        } else {
            this.finallyMap.put(lastJump, null);
        }
    }

    private void handleStmt(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    static Node computeFollowNode(Node node, ControlFlowAnalysis cfa) {
        return ControlFlowAnalysis.computeFollowNode(node, node, cfa);
    }

    static Node computeFollowNode(Node node) {
        return ControlFlowAnalysis.computeFollowNode(node, node, null);
    }

    private static Node computeFollowNode(Node fromNode, Node node, ControlFlowAnalysis cfa) {
        Node nextSibling;
        Node parent = node.getParent();
        if (parent == null || parent.isFunction() || cfa != null && node == cfa.root) {
            return null;
        }
        switch (parent.getToken()) {
            case IF: {
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
            case CASE: 
            case DEFAULT_CASE: {
                if (parent.getNext() != null) {
                    if (parent.getNext().isCase()) {
                        return parent.getNext().getSecondChild();
                    }
                    if (parent.getNext().isDefaultCase()) {
                        return parent.getNext().getFirstChild();
                    }
                    throw new IllegalStateException("Not reachable");
                }
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                return parent;
            }
            case FOR: {
                return parent.getSecondChild().getNext();
            }
            case DO: 
            case WHILE: {
                return parent;
            }
            case TRY: {
                if (parent.getFirstChild() == node) {
                    if (NodeUtil.hasFinally(parent)) {
                        return ControlFlowAnalysis.computeFallThrough(parent.getLastChild());
                    }
                    return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
                }
                if (NodeUtil.getCatchBlock(parent) == node) {
                    if (NodeUtil.hasFinally(parent)) {
                        return ControlFlowAnalysis.computeFallThrough(node.getNext());
                    }
                    return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
                }
                if (parent.getLastChild() != node) break;
                if (cfa != null) {
                    for (Node finallyNode : cfa.finallyMap.get(parent)) {
                        cfa.createEdge(fromNode, ControlFlowGraph.Branch.ON_EX, finallyNode);
                    }
                }
                return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
            }
        }
        for (nextSibling = node.getNext(); nextSibling != null && nextSibling.isFunction(); nextSibling = nextSibling.getNext()) {
        }
        if (nextSibling != null) {
            return ControlFlowAnalysis.computeFallThrough(nextSibling);
        }
        return ControlFlowAnalysis.computeFollowNode(fromNode, parent, cfa);
    }

    static Node computeFallThrough(Node n) {
        switch (n.getToken()) {
            case FOR: 
            case DO: {
                return ControlFlowAnalysis.computeFallThrough(n.getFirstChild());
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                return n.getSecondChild();
            }
            case LABEL: {
                return ControlFlowAnalysis.computeFallThrough(n.getLastChild());
            }
        }
        return n;
    }

    private void createEdge(Node fromNode, ControlFlowGraph.Branch branch, Node toNode) {
        this.cfg.createNode((Object)fromNode);
        this.cfg.createNode((Object)toNode);
        this.cfg.connectIfNotFound(fromNode, branch, toNode);
    }

    private void connectToPossibleExceptionHandler(Node cfgNode, Node target) {
        if (ControlFlowAnalysis.mayThrowException(target) && !this.exceptionHandler.isEmpty()) {
            Node lastJump = cfgNode;
            for (Node handler : this.exceptionHandler) {
                if (handler.isFunction()) {
                    return;
                }
                Preconditions.checkState(handler.isTry());
                Node catchBlock = NodeUtil.getCatchBlock(handler);
                boolean lastJumpInCatchBlock = false;
                for (Node ancestor : lastJump.getAncestors()) {
                    if (ancestor == handler) break;
                    if (ancestor != catchBlock) continue;
                    lastJumpInCatchBlock = true;
                    break;
                }
                if (!NodeUtil.hasCatchHandler(catchBlock) || lastJumpInCatchBlock) {
                    if (lastJump == cfgNode) {
                        this.createEdge(cfgNode, ControlFlowGraph.Branch.ON_EX, handler.getLastChild());
                    } else {
                        this.finallyMap.put(lastJump, handler.getLastChild());
                    }
                } else {
                    if (lastJump == cfgNode) {
                        this.createEdge(cfgNode, ControlFlowGraph.Branch.ON_EX, catchBlock);
                        return;
                    }
                    this.finallyMap.put(lastJump, catchBlock);
                }
                lastJump = handler;
            }
        }
    }

    private static Node getNextSiblingOfType(Node first, Token ... types) {
        for (Node c = first; c != null; c = c.getNext()) {
            for (Token type : types) {
                if (c.getToken() != type) continue;
                return c;
            }
        }
        return null;
    }

    public static boolean isBreakTarget(Node target, String label) {
        return ControlFlowAnalysis.isBreakStructure(target, label != null) && ControlFlowAnalysis.matchLabel(target.getParent(), label);
    }

    static boolean isContinueTarget(Node target, String label) {
        return NodeUtil.isLoopStructure(target) && ControlFlowAnalysis.matchLabel(target.getParent(), label);
    }

    private static boolean matchLabel(Node target, String label) {
        if (label == null) {
            return true;
        }
        while (target.isLabel()) {
            if (target.getFirstChild().getString().equals(label)) {
                return true;
            }
            target = target.getParent();
        }
        return false;
    }

    public static boolean mayThrowException(Node n) {
        switch (n.getToken()) {
            case THROW: 
            case CALL: 
            case TAGGED_TEMPLATELIT: 
            case GETPROP: 
            case GETELEM: 
            case NEW: 
            case ASSIGN: 
            case INC: 
            case DEC: 
            case INSTANCEOF: 
            case IN: 
            case YIELD: 
            case AWAIT: {
                return true;
            }
            case FUNCTION: {
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (ControlFlowGraph.isEnteringNewCfgNode(c) || !ControlFlowAnalysis.mayThrowException(c)) continue;
            return true;
        }
        return false;
    }

    static boolean isBreakStructure(Node n, boolean labeled) {
        switch (n.getToken()) {
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case DO: 
            case WHILE: 
            case SWITCH: {
                return true;
            }
            case TRY: 
            case IF: 
            case BLOCK: 
            case ROOT: {
                return labeled;
            }
        }
        return false;
    }

    static Node getExceptionHandler(Node n) {
        Node cur = n;
        while (!cur.isScript() && !cur.isFunction()) {
            Node catchNode = ControlFlowAnalysis.getCatchHandlerForBlock(cur);
            if (catchNode != null) {
                return catchNode;
            }
            cur = cur.getParent();
        }
        return null;
    }

    static Node getCatchHandlerForBlock(Node block) {
        if (block.isBlock() && block.getParent().isTry() && block.getParent().getFirstChild() == block) {
            for (Node s = block.getNext(); s != null; s = s.getNext()) {
                if (!NodeUtil.hasCatchHandler(s)) continue;
                return s.getFirstChild();
            }
        }
        return null;
    }

    private static class AstControlFlowGraph
    extends ControlFlowGraph<Node> {
        private final Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> priorities;

        private AstControlFlowGraph(Node entry, Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> priorities, boolean edgeAnnotations) {
            super(entry, true, edgeAnnotations);
            this.priorities = priorities;
        }

        @Override
        public Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> getOptionalNodeComparator(boolean isForward) {
            if (isForward) {
                return Comparator.comparingInt(this::getPosition);
            }
            return Comparator.comparingInt(this::getPosition).reversed();
        }

        private int getPosition(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> n) {
            Integer priority = this.priorities.get(n);
            Preconditions.checkNotNull(priority);
            return priority;
        }
    }
}

