/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class Es6ConvertSuperConstructorCalls
implements NodeTraversal.Callback {
    private static final String TMP_ERROR = "$jscomp$tmp$error";
    private static final String SUPER_THIS = "$jscomp$super$this";
    private final AbstractCompiler compiler;
    private final Deque<ConstructorData> constructorDataStack;
    private final AstFactory astFactory;
    private GlobalNamespace globalNamespace;
    private final StaticScope transpilationNamespace;

    public Es6ConvertSuperConstructorCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.transpilationNamespace = compiler.getTranspilationNamespace();
        this.constructorDataStack = new ArrayDeque<ConstructorData>();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            this.constructorDataStack.push(new ConstructorData(n));
        } else if (n.isSuper()) {
            Preconditions.checkState(n.isFirstChildOf(parent), parent);
            if (parent.isGetProp()) {
                t.report(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "super access with no extends clause");
                return false;
            }
            Preconditions.checkState(parent.isCall(), parent);
            ConstructorData constructorData = Preconditions.checkNotNull(this.constructorDataStack.peek());
            constructorData.superCalls.add(parent);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        ConstructorData constructorData = this.constructorDataStack.peek();
        if (constructorData != null && n == constructorData.constructor) {
            this.constructorDataStack.pop();
            this.visitSuper(t, constructorData);
        }
    }

    private void visitSuper(NodeTraversal t, ConstructorData constructorData) {
        Node constructor = constructorData.constructor;
        List<Node> superCalls = constructorData.superCalls;
        if (superCalls.isEmpty()) {
            return;
        }
        if (constructor.isFromExterns()) {
            for (Node superCall : superCalls) {
                Node enclosingStatement = NodeUtil.getEnclosingStatement(superCall);
                Node enclosingScope = enclosingStatement.getParent();
                enclosingStatement.detach();
                this.compiler.reportChangeToEnclosingScope(enclosingScope);
            }
        } else {
            Node superClassNameNode = this.getSuperClassQNameNode(constructor);
            String superClassQName = superClassNameNode.getQualifiedName();
            AstFactory.Type thisType = this.getTypeOfThisForConstructor(constructorData.constructor);
            if (this.isNativeObjectClass(t, superClassQName)) {
                for (Node superCall : superCalls) {
                    Node thisNode = this.astFactory.createThis(thisType).srcref(superCall);
                    superCall.replaceWith(thisNode);
                    this.compiler.reportChangeToEnclosingScope(thisNode);
                }
            } else if (this.isKnownNativeClass(t, superClassQName)) {
                this.convertSuperCallsToJsCompConstructCalls(constructor, superCalls, superClassNameNode, thisType);
            } else if (this.isNativeErrorClass(t, superClassQName)) {
                for (Node superCall : superCalls) {
                    Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, thisType, AstFactory.type(superCall));
                    this.replaceNativeErrorSuperCall(superCall, newSuperCall);
                }
            } else if (this.isKnownToReturnOnlyUndefined(superClassQName)) {
                for (Node superCall : superCalls) {
                    Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, thisType, AstFactory.type(StandardColors.NULL_OR_VOID));
                    Node superCallParent = superCall.getParent();
                    if (superCallParent.hasOneChild() && NodeUtil.isStatement(superCallParent)) {
                        superCall.replaceWith(newSuperCall);
                    } else {
                        superCall.replaceWith(this.astFactory.createComma(newSuperCall, this.astFactory.createThis(thisType)).srcrefTreeIfMissing(superCall));
                    }
                    this.compiler.reportChangeToEnclosingScope(superCallParent);
                }
            } else {
                Node constructorBody = Preconditions.checkNotNull(constructor.getChildAtIndex(2));
                Node firstStatement = constructorBody.getFirstChild();
                Node firstSuperCall = superCalls.get(0);
                if (constructorBody.hasOneChild() && firstStatement.isExprResult() && firstStatement.hasOneChild() && firstStatement.getFirstChild() == firstSuperCall) {
                    Preconditions.checkState(superCalls.size() == 1, constructor);
                    Node newReturn = this.astFactory.createOr(this.createNewSuperCall(superClassNameNode, superCalls.get(0), AstFactory.type(superCalls.get(0)), AstFactory.type(StandardColors.UNKNOWN)), this.astFactory.createThis(thisType));
                    firstStatement.replaceWith(IR.returnNode(newReturn).srcrefTreeIfMissing(firstStatement));
                } else {
                    AstFactory.Type typeOfThis = this.getTypeOfThisForConstructor(constructor);
                    this.updateThisToSuperThis(typeOfThis, constructorBody, superCalls);
                    constructorBody.addChildToFront(IR.var(this.astFactory.createName(SUPER_THIS, typeOfThis)).srcrefTree(constructorBody));
                    constructorBody.addChildToBack(IR.returnNode(this.astFactory.createName(SUPER_THIS, typeOfThis)).srcrefTree(constructorBody));
                    for (Node superCall : superCalls) {
                        Node newSuperCall = this.createNewSuperCall(superClassNameNode, superCall, typeOfThis, AstFactory.type(StandardColors.UNKNOWN));
                        superCall.replaceWith(this.astFactory.createAssign(this.astFactory.createName(SUPER_THIS, typeOfThis), this.astFactory.createOr(newSuperCall, this.astFactory.createThis(typeOfThis))).srcrefTreeIfMissing(superCall));
                    }
                }
                this.compiler.reportChangeToEnclosingScope(constructorBody);
            }
        }
    }

    private void convertSuperCallsToJsCompConstructCalls(Node constructor, List<Node> superCalls, Node superClassNameNode, AstFactory.Type thisType) {
        Node constructorBody = Preconditions.checkNotNull(constructor.getChildAtIndex(2));
        Node firstStatement = constructorBody.getFirstChild();
        Preconditions.checkNotNull(firstStatement, "Empty constructor body");
        Node firstSuperCall = superCalls.get(0);
        if (constructorBody.hasOneChild() && firstStatement.isExprResult() && firstStatement.hasOneChild() && firstStatement.getFirstChild() == firstSuperCall) {
            Preconditions.checkState(superCalls.size() == 1, constructor);
            firstStatement.replaceWith(this.astFactory.createReturn(this.createJSCompConstructorCall(superClassNameNode, firstSuperCall, thisType)));
        } else {
            AstFactory.Type typeOfThis = this.getTypeOfThisForConstructor(constructor);
            this.updateThisToSuperThis(typeOfThis, constructorBody, superCalls);
            constructorBody.addChildToFront(this.astFactory.createSingleVarNameDeclaration(SUPER_THIS).srcrefTree(constructorBody));
            constructorBody.addChildToBack(this.astFactory.createReturn(this.astFactory.createName(SUPER_THIS, typeOfThis)).srcrefTree(constructorBody));
            for (Node superCall : superCalls) {
                superCall.replaceWith(this.astFactory.createAssign(this.astFactory.createName(SUPER_THIS, typeOfThis).srcref(superCall), this.createJSCompConstructorCall(superClassNameNode, superCall, thisType)).srcref(superCall));
            }
        }
        this.compiler.reportChangeToEnclosingScope(constructorBody);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isKnownToReturnOnlyUndefined(String functionQName) {
        if (this.globalNamespace == null) {
            return false;
        }
        GlobalNamespace.Name globalName = this.globalNamespace.getSlot(functionQName);
        if (globalName == null) {
            return false;
        }
        GlobalNamespace.Ref declarationRef = globalName.getDeclaration();
        if (declarationRef == null) {
            for (GlobalNamespace.Ref ref : globalName.getRefs()) {
                if (!ref.isSet()) continue;
                declarationRef = ref;
            }
        }
        if (declarationRef == null) {
            return false;
        }
        Node declaredVarOrProp = declarationRef.getNode();
        if (declaredVarOrProp.isFromExterns()) {
            return false;
        }
        Node declaration = declaredVarOrProp.getParent();
        Node declaredValue = null;
        if (declaration.isFunction()) {
            declaredValue = declaration;
            return this.isNodeKnownToOnlyReturnUndefined(declaredValue);
        } else if (NodeUtil.isNameDeclaration(declaration) && declaredVarOrProp.isName()) {
            if (!declaredVarOrProp.hasChildren()) return false;
            declaredValue = Preconditions.checkNotNull(declaredVarOrProp.getFirstChild());
            return this.isNodeKnownToOnlyReturnUndefined(declaredValue);
        } else if (declaration.isAssign() && declaration.getFirstChild() == declaredVarOrProp) {
            declaredValue = Preconditions.checkNotNull(declaration.getSecondChild());
            return this.isNodeKnownToOnlyReturnUndefined(declaredValue);
        } else {
            if (!declaration.isObjectLit() || !declaredVarOrProp.hasOneChild()) throw new IllegalStateException("Unexpected declaration format:\n" + declaration.toStringTree());
            declaredValue = Preconditions.checkNotNull(declaredVarOrProp.getFirstChild());
        }
        return this.isNodeKnownToOnlyReturnUndefined(declaredValue);
    }

    private boolean isNodeKnownToOnlyReturnUndefined(Node node) {
        if (node.isFunction()) {
            Node functionBody = Preconditions.checkNotNull(node.getChildAtIndex(2));
            return !new UndefinedReturnValueCheck().mayReturnDefinedValue(functionBody);
        }
        if (node.isQualifiedName()) {
            return this.isKnownToReturnOnlyUndefined(node.getQualifiedName());
        }
        if (node.isHook()) {
            Node left = node.getSecondChild();
            Node right = node.getLastChild();
            return this.isNodeKnownToOnlyReturnUndefined(left) && this.isNodeKnownToOnlyReturnUndefined(right);
        }
        return false;
    }

    private Node createNewSuperCall(Node superClassQNameNode, Node superCall, AstFactory.Type thisType, AstFactory.Type resultType) {
        Preconditions.checkArgument(superClassQNameNode.isQualifiedName(), superClassQNameNode);
        Preconditions.checkArgument(superCall.isCall(), superCall);
        Node callee = superCall.removeFirstChild();
        Preconditions.checkState(callee.isSuper(), callee);
        ArrayList<Node> args = new ArrayList<Node>();
        boolean hasSpreadArg = false;
        while (superCall.hasChildren()) {
            Node arg = superCall.removeFirstChild();
            hasSpreadArg = hasSpreadArg || arg.isSpread();
            args.add(arg);
        }
        if (hasSpreadArg) {
            Node superClassDotApply = this.astFactory.createGetPropWithUnknownType(superClassQNameNode.cloneTree(), "apply").srcrefTree(callee);
            Node newSuperCall = this.astFactory.createCall(superClassDotApply, resultType, new Node[0]).srcref(superCall);
            newSuperCall.addChildToBack(this.astFactory.createThis(thisType).srcref(callee));
            newSuperCall.putBooleanProp(Node.FREE_CALL, false);
            if (Es6ConvertSuperConstructorCalls.isSingleSpreadOfArguments(args)) {
                newSuperCall.addChildToBack(Iterables.getOnlyElement(args).getOnlyChild().detach());
            } else {
                newSuperCall.addChildToBack(this.astFactory.createArraylit(args).srcref(superCall));
            }
            return newSuperCall;
        }
        Node superClassDotCall = this.astFactory.createGetProp(superClassQNameNode.cloneTree(), "call", AstFactory.type(StandardColors.TOP_OBJECT)).srcrefTree(callee);
        Node newSuperCall = this.astFactory.createCall(superClassDotCall, resultType, new Node[0]).srcref(superCall);
        newSuperCall.addChildToBack(this.astFactory.createThis(thisType).srcref(callee));
        newSuperCall.putBooleanProp(Node.FREE_CALL, false);
        for (Node arg : args) {
            newSuperCall.addChildToBack(arg);
        }
        return newSuperCall;
    }

    private Node createJSCompConstructorCall(Node superClassQNameNode, Node superCall, AstFactory.Type thisType) {
        Preconditions.checkArgument(superClassQNameNode.isQualifiedName(), superClassQNameNode);
        Preconditions.checkArgument(superCall.isCall(), superCall);
        Node callee = Preconditions.checkNotNull(superCall.removeFirstChild(), superCall);
        Preconditions.checkState(callee.isSuper(), callee);
        Node jscompDotConstruct = this.astFactory.createQName(this.transpilationNamespace, "$jscomp.construct").srcrefTree(callee);
        Node superClassQName = superClassQNameNode.cloneTree();
        ArrayList<Node> superCallArgList = new ArrayList<Node>();
        while (superCall.hasChildren()) {
            superCallArgList.add(superCall.removeFirstChild());
        }
        Node superArgs2 = Es6ConvertSuperConstructorCalls.isSingleSpreadOfArguments(superCallArgList) ? Iterables.getOnlyElement(superCallArgList).getOnlyChild().detach() : this.astFactory.createArraylit(superCallArgList).srcref(superCall);
        Node thisDotConstructor = this.astFactory.createGetProp(this.astFactory.createThis(thisType), "constructor", AstFactory.type(superClassQNameNode)).srcrefTree(superCall);
        return this.astFactory.createCall(jscompDotConstruct, AstFactory.type(superCall), superClassQName, superArgs2, thisDotConstructor).srcref(superCall);
    }

    private static boolean isSingleSpreadOfArguments(List<Node> nodeList) {
        return nodeList.size() == 1 && Es6ConvertSuperConstructorCalls.isSpreadOfArguments(Iterables.getOnlyElement(nodeList));
    }

    private static boolean isSpreadOfArguments(Node node) {
        return node.isSpread() && node.getOnlyChild().matchesName("arguments");
    }

    private void replaceNativeErrorSuperCall(Node superCall, Node newSuperCall) {
        Node superStatement = NodeUtil.getEnclosingStatement(superCall);
        Node body = superStatement.getParent();
        Preconditions.checkState(body.isBlock(), body);
        AstFactory.Type thisType = AstFactory.type(newSuperCall);
        Node getError = IR.var(this.astFactory.createName(TMP_ERROR, thisType)).srcrefTreeIfMissing(superCall);
        getError.insertBefore(superStatement);
        Node getTmpError = this.astFactory.createAssign(this.astFactory.createName(TMP_ERROR, thisType), newSuperCall);
        Node copyMessage = this.astFactory.createAssign(this.astFactory.createGetProp(this.astFactory.createThis(thisType), "message", AstFactory.type(StandardColors.STRING)), this.astFactory.createGetProp(this.astFactory.createName(TMP_ERROR, thisType), "message", AstFactory.type(StandardColors.STRING)));
        Node setStack = this.astFactory.createAnd(this.astFactory.createIn(this.astFactory.createString("stack"), this.astFactory.createName(TMP_ERROR, thisType)), this.astFactory.createAssign(this.astFactory.createGetProp(this.astFactory.createThis(thisType), "stack", AstFactory.type(StandardColors.STRING)), this.astFactory.createGetProp(this.astFactory.createName(TMP_ERROR, thisType), "stack", AstFactory.type(StandardColors.STRING))));
        Node superErrorExpr = this.astFactory.createCommas(getTmpError, copyMessage, setStack, this.astFactory.createThis(thisType)).srcrefTreeIfMissing(superCall);
        superCall.replaceWith(superErrorExpr);
        this.compiler.reportChangeToEnclosingScope(superErrorExpr);
    }

    private boolean isNativeObjectClass(NodeTraversal t, String className) {
        return className.equals("Object") && !this.isDefinedInSources(t, className);
    }

    private boolean isNativeErrorClass(NodeTraversal t, String superClassName) {
        switch (superClassName) {
            case "AggregateError": 
            case "Error": 
            case "EvalError": 
            case "RangeError": 
            case "ReferenceError": 
            case "SyntaxError": 
            case "TypeError": 
            case "URIError": {
                return !this.isDefinedInSources(t, superClassName);
            }
        }
        return false;
    }

    private boolean isKnownNativeClass(NodeTraversal t, String className) {
        switch (className) {
            case "Array": 
            case "ArrayBuffer": 
            case "Boolean": 
            case "DataView": 
            case "Date": 
            case "Float32Array": 
            case "Function": 
            case "Generator": 
            case "GeneratorFunction": 
            case "Int16Array": 
            case "Int32Array": 
            case "Int8Array": 
            case "InternalError": 
            case "Map": 
            case "Number": 
            case "Object": 
            case "Promise": 
            case "Proxy": 
            case "RegExp": 
            case "Set": 
            case "String": 
            case "Symbol": 
            case "TypedArray": 
            case "Uint16Array": 
            case "Uint32Array": 
            case "Uint8Array": 
            case "Uint8ClampedArray": 
            case "WeakMap": 
            case "WeakSet": {
                return !this.isDefinedInSources(t, className);
            }
        }
        return false;
    }

    private boolean isDefinedInSources(NodeTraversal t, String varName) {
        Var objectVar = (Var)t.getScope().getVar(varName);
        return objectVar != null && !objectVar.isExtern();
    }

    private void updateThisToSuperThis(final AstFactory.Type typeOfThis, Node constructorBody, final List<Node> superCalls) {
        NodeTraversal.Callback replaceThisWithSuperThis = new NodeTraversal.Callback(){

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                if (superCalls.contains(n)) {
                    return false;
                }
                return !n.isFunction() || n.isArrowFunction();
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isThis()) {
                    Node superThis = Es6ConvertSuperConstructorCalls.this.astFactory.createName(Es6ConvertSuperConstructorCalls.SUPER_THIS, AstFactory.type(n)).srcref(n);
                    n.replaceWith(superThis);
                } else if (n.isReturn() && !n.hasChildren()) {
                    n.addChildToFront(Es6ConvertSuperConstructorCalls.this.astFactory.createName(Es6ConvertSuperConstructorCalls.SUPER_THIS, typeOfThis).srcref(n));
                }
            }
        };
        NodeTraversal.traverse(this.compiler, constructorBody, replaceThisWithSuperThis);
    }

    private AstFactory.Type getTypeOfThisForConstructor(Node constructor) {
        Preconditions.checkArgument(constructor.isFunction(), constructor);
        Color constructorType = constructor.getColor();
        return constructorType != null && !constructorType.getInstanceColors().isEmpty() ? AstFactory.type(Color.createUnion(constructorType.getInstanceColors())) : AstFactory.type(StandardColors.UNKNOWN);
    }

    private Node getSuperClassQNameNode(Node constructor) {
        String className = NodeUtil.getNameNode(constructor).getQualifiedName();
        Node constructorStatement = Preconditions.checkNotNull(NodeUtil.getEnclosingStatement(constructor));
        Node superClassNameNode = null;
        for (Node statement = constructorStatement.getNext(); statement != null && (superClassNameNode = this.getSuperClassNameNodeIfIsInheritsStatement(statement, className)) == null; statement = statement.getNext()) {
        }
        return Preconditions.checkNotNull(superClassNameNode, "$jscomp.inherits() call not found.");
    }

    private Node getSuperClassNameNodeIfIsInheritsStatement(Node statement, String className) {
        if (!statement.isExprResult()) {
            return null;
        }
        Node callNode = statement.getFirstChild();
        if (!callNode.isCall()) {
            return null;
        }
        Node jscompDotInherits = callNode.getFirstChild();
        if (!jscompDotInherits.matchesQualifiedName("$jscomp.inherits")) {
            return null;
        }
        Node classNameNode = Preconditions.checkNotNull(jscompDotInherits.getNext());
        if (classNameNode.matchesQualifiedName(className)) {
            return Preconditions.checkNotNull(classNameNode.getNext());
        }
        return null;
    }

    void setGlobalNamespace(GlobalNamespace globalNamespace) {
        this.globalNamespace = globalNamespace;
    }

    private class UndefinedReturnValueCheck {
        private boolean foundNonEmptyReturn;

        private UndefinedReturnValueCheck() {
        }

        boolean mayReturnDefinedValue(Node functionBody) {
            this.foundNonEmptyReturn = false;
            NodeTraversal.AbstractShallowCallback checkForDefinedReturnValue = new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (!UndefinedReturnValueCheck.this.foundNonEmptyReturn && n.isReturn() && n.hasChildren() && !n.getFirstChild().matchesName("undefined")) {
                        UndefinedReturnValueCheck.this.foundNonEmptyReturn = true;
                    }
                }
            };
            NodeTraversal.traverse(Es6ConvertSuperConstructorCalls.this.compiler, functionBody, checkForDefinedReturnValue);
            return this.foundNonEmptyReturn;
        }
    }

    private static final class ConstructorData {
        final Node constructor;
        final List<Node> superCalls;

        ConstructorData(Node constructor) {
            this.constructor = constructor;
            this.superCalls = new ArrayList<Node>();
        }
    }
}

