/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;

public class Es6RewriteArrowFunction
implements NodeTraversal.Callback,
CompilerPass {
    private static final String ARGUMENTS_VAR = "$jscomp$arguments";
    static final String THIS_VAR = "$jscomp$this";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Deque<ThisAndArgumentsContext> contextStack;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ARROW_FUNCTIONS);

    public Es6RewriteArrowFunction(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.contextStack = new ArrayDeque<ThisAndArgumentsContext>();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.contextStack.push(this.contextForScript(n));
                break;
            }
            case FUNCTION: {
                if (n.isArrowFunction()) break;
                this.contextStack.push(this.contextForFunction(n));
                break;
            }
            case SUPER: {
                ThisAndArgumentsContext context = Preconditions.checkNotNull(this.contextStack.peek());
                if (!context.isConstructor || !parent.isCall() || parent.getFirstChild() != n) break;
                context.lastSuperStatement = this.getEnclosingStatement(parent, context.scopeBody);
                break;
            }
        }
        return true;
    }

    private Node getEnclosingStatement(Node n, Node block) {
        while (Preconditions.checkNotNull(n.getParent()) != block) {
            n = Preconditions.checkNotNull(NodeUtil.getEnclosingStatement(n.getParent()));
        }
        return n;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        ThisAndArgumentsContext context = this.contextStack.peek();
        if (n.isArrowFunction()) {
            this.visitArrowFunction(t, n, Preconditions.checkNotNull(context));
        } else if (context != null && context.scopeBody == n) {
            this.contextStack.pop();
            this.addVarDeclarations(t, context);
        }
    }

    private void visitArrowFunction(NodeTraversal t, Node n, ThisAndArgumentsContext context) {
        n.setIsArrowFunction(false);
        Node body = n.getLastChild();
        if (!body.isBlock()) {
            body.detach();
            body = IR.block(IR.returnNode(body)).srcrefTreeIfMissing(body);
            n.addChildToBack(body);
        }
        ThisAndArgumentsReferenceUpdater updater = new ThisAndArgumentsReferenceUpdater(this.compiler, context, this.astFactory);
        NodeTraversal.traverse(this.compiler, body, updater);
        t.reportCodeChange();
    }

    private void addVarDeclarations(NodeTraversal t, ThisAndArgumentsContext context) {
        Node scopeBody = context.scopeBody;
        if (context.needsThisVar) {
            Node name = this.astFactory.createName(THIS_VAR, context.getThisType());
            Node thisVar = IR.constNode(name, this.astFactory.createThis(context.getThisType()));
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
            thisVar.srcrefTreeIfMissing(scopeBody);
            this.makeTreeNonIndexable(thisVar);
            if (context.lastSuperStatement == null) {
                scopeBody.addChildToFront(thisVar);
            } else {
                thisVar.insertAfter(context.lastSuperStatement);
            }
            this.compiler.reportChangeToEnclosingScope(thisVar);
        }
        if (context.needsArgumentsVar) {
            Node argumentsVar = this.astFactory.createArgumentsAliasDeclaration(ARGUMENTS_VAR);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
            scopeBody.addChildToFront(argumentsVar);
            argumentsVar.srcrefTreeIfMissing(scopeBody);
            this.compiler.reportChangeToEnclosingScope(argumentsVar);
        }
    }

    private void makeTreeNonIndexable(Node n) {
        n.makeNonIndexable();
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            this.makeTreeNonIndexable(child);
        }
    }

    private ThisAndArgumentsContext contextForFunction(Node functionNode) {
        Node scopeBody = functionNode.getLastChild();
        return new ThisAndArgumentsContext(scopeBody, NodeUtil.isEs6Constructor(functionNode));
    }

    private ThisAndArgumentsContext contextForScript(Node scriptNode) {
        return new ThisAndArgumentsContext(scriptNode, false);
    }

    private static class ThisAndArgumentsReferenceUpdater
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final ThisAndArgumentsContext context;
        private final AstFactory astFactory;

        public ThisAndArgumentsReferenceUpdater(AbstractCompiler compiler, ThisAndArgumentsContext context, AstFactory astFactory) {
            this.compiler = compiler;
            this.context = context;
            this.astFactory = astFactory;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                this.context.setNeedsThisVarWithType(AstFactory.type(n));
                Node name = this.astFactory.createName(Es6RewriteArrowFunction.THIS_VAR, this.context.getThisType()).srcref(n);
                name.makeNonIndexable();
                if (this.compiler.getOptions().preservesDetailedSourceInfo()) {
                    name.setOriginalName("this");
                }
                n.replaceWith(name);
            } else if (n.isName() && n.getString().equals("arguments")) {
                this.context.setNeedsArgumentsVar();
                Node name = this.astFactory.createName(Es6RewriteArrowFunction.ARGUMENTS_VAR, AstFactory.type(n)).srcref(n);
                if (this.compiler.getOptions().preservesDetailedSourceInfo()) {
                    name.setOriginalName("arguments");
                }
                n.replaceWith(name);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }

    private class ThisAndArgumentsContext {
        final Node scopeBody;
        final boolean isConstructor;
        Node lastSuperStatement = null;
        boolean needsThisVar = false;
        @Nullable
        private AstFactory.Type thisType;
        boolean needsArgumentsVar = false;

        private ThisAndArgumentsContext(Node scopeBody, boolean isConstructor) {
            this.scopeBody = scopeBody;
            this.isConstructor = isConstructor;
        }

        @Nullable
        AstFactory.Type getThisType() {
            return this.thisType;
        }

        ThisAndArgumentsContext setNeedsThisVarWithType(AstFactory.Type type) {
            this.thisType = type;
            this.needsThisVar = true;
            return this;
        }

        ThisAndArgumentsContext setNeedsArgumentsVar() {
            this.needsArgumentsVar = true;
            return this;
        }
    }
}

