/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleRenaming;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBasedTable;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Table;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6RewriteModules
implements CompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType LHS_OF_GOOG_REQUIRE_MUST_BE_CONST = DiagnosticType.error("JSC_LHS_OF_GOOG_REQUIRE_MUST_BE_CONST", "The left side of a goog.require() or goog.requireType() must use ''const'' (not ''let'' or ''var'')");
    static final DiagnosticType REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST = DiagnosticType.error("JSC_REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST", "goog.requireType alias for ES6 module should be const.");
    static final DiagnosticType FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST = DiagnosticType.error("JSC_FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST", "goog.forwardDeclare alias for ES6 module should be const.");
    static final DiagnosticType SHOULD_IMPORT_ES6_MODULE = DiagnosticType.warning("JSC_SHOULD_IMPORT_ES6_MODULE", "ES6 modules should import other ES6 modules rather than goog.require them.");
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final JSType unknownType;
    private static final Splitter DOT_SPLITTER = Splitter.on(".");
    @Nullable
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private Map<String, ModuleRenaming.GlobalizedModuleName> namesToInlineByAlias;
    private Set<String> typedefs;
    private final ModuleMetadataMap moduleMetadataMap;
    private final ModuleMap moduleMap;
    private final TypedScope globalTypedScope;
    private final CompilerOptions.ChunkOutputType chunkOutputType;

    Es6RewriteModules(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap, ModuleMap moduleMap, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, @Nullable TypedScope globalTypedScope) {
        this(compiler, moduleMetadataMap, moduleMap, preprocessorSymbolTable, globalTypedScope, CompilerOptions.ChunkOutputType.GLOBAL_NAMESPACE);
    }

    Es6RewriteModules(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap, ModuleMap moduleMap, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, @Nullable TypedScope globalTypedScope, CompilerOptions.ChunkOutputType chunkOutputType) {
        Preconditions.checkNotNull(moduleMetadataMap);
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.moduleMetadataMap = moduleMetadataMap;
        this.moduleMap = moduleMap;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.globalTypedScope = globalTypedScope;
        this.unknownType = compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        this.chunkOutputType = chunkOutputType;
    }

    public static boolean isEs6ModuleRoot(Node scriptNode) {
        Preconditions.checkArgument(scriptNode.isScript(), scriptNode);
        if (scriptNode.getBooleanProp(Node.GOOG_MODULE)) {
            return false;
        }
        return scriptNode.hasChildren() && scriptNode.getFirstChild().isModuleBody();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument(externs.isRoot(), externs);
        Preconditions.checkArgument(root.isRoot(), root);
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        this.compiler.setFeatureSet(this.compiler.getFeatureSet().without(FeatureSet.Feature.MODULES, new FeatureSet.Feature[0]));
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    private void clearPerFileState() {
        this.typedefs = new HashSet<String>();
        this.namesToInlineByAlias = new HashMap<String, ModuleRenaming.GlobalizedModuleName>();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isScript()) {
            nodeTraversal.getScope();
            new RewriteRequiresForEs6Modules().rewrite(n);
            if (Es6RewriteModules.isEs6ModuleRoot(n)) {
                this.clearPerFileState();
                n.putBooleanProp(Node.TRANSPILED, true);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.maybeWarnExternModule(t, n, parent);
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.maybeWarnExternModule(t, n, parent);
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            this.visitScript(t, n);
        } else if (n.isCall()) {
            if (n.getFirstChild().matchesQualifiedName("goog.declareModuleId")) {
                n.getParent().detach();
            }
        } else if (n.isImportMeta() && this.chunkOutputType != CompilerOptions.ChunkOutputType.ES_MODULES) {
            t.report(n, Es6ToEs3Util.CANNOT_CONVERT, "import.meta. Use --chunk_output_type=ES_MODULES to allow passthrough support.");
        }
    }

    private void maybeWarnExternModule(NodeTraversal t, Node n, Node parent) {
        Preconditions.checkState(parent.isModuleBody());
        if (parent.isFromExterns() && !NodeUtil.isFromTypeSummary(parent.getParent())) {
            t.report(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "ES6 modules in externs");
        }
    }

    private void visitImport(NodeTraversal t, Node importDecl, Node parent) {
        Preconditions.checkArgument(parent.isModuleBody(), parent);
        String importName = importDecl.getLastChild().getString();
        boolean isNamespaceImport = importName.startsWith("goog:");
        if (isNamespaceImport) {
            String namespace = importName.substring("goog:".length());
            ModuleMetadataMap.ModuleMetadata m = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace);
            if (m == null) {
                t.report(importDecl, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
            } else {
                Preconditions.checkState(m.isEs6Module() || m.isGoogModule() || m.isGoogProvide());
            }
        } else {
            ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(importName, importDecl.getSourceFileName(), importDecl.getLineno(), importDecl.getCharno());
            if (modulePath == null) {
                modulePath = t.getInput().getPath().resolveModuleAsPath(importName);
            }
            this.maybeAddImportedFileReferenceToSymbolTable(importDecl.getLastChild(), modulePath.toString());
        }
        for (Node child = importDecl.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isImportSpecs()) {
                for (Node grandChild = child.getFirstChild(); grandChild != null; grandChild = grandChild.getNext()) {
                    this.maybeAddAliasToSymbolTable(grandChild.getFirstChild(), t.getSourceName());
                    Preconditions.checkState(grandChild.hasTwoChildren());
                }
                continue;
            }
            if (!child.isImportStar()) continue;
            this.maybeAddAliasToSymbolTable(child, t.getSourceName());
        }
        importDecl.detach();
        t.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node export, Node parent) {
        Preconditions.checkArgument(parent.isModuleBody(), parent);
        if (export.getBooleanProp(Node.EXPORT_DEFAULT)) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.detach();
                export.replaceWith(decl);
            } else {
                Node var = this.astFactory.createSingleVarNameDeclaration("$jscompDefaultExport", export.removeFirstChild());
                var.setJSDocInfo(child.getJSDocInfo());
                child.setJSDocInfo(null);
                var.srcrefTreeIfMissing(export);
                export.replaceWith(var);
            }
            t.reportCodeChange();
        } else if (export.getBooleanProp(Node.EXPORT_ALL_FROM) || export.hasTwoChildren() || export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
            export.detach();
            t.reportCodeChange();
        } else {
            this.visitExportDeclaration(t, export);
        }
    }

    private void visitExportNameDeclaration(Node declaration) {
        List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(declaration);
        for (Node lhs : lhsNodes) {
            Preconditions.checkState(lhs.isName());
            String name = lhs.getString();
            if (declaration.getJSDocInfo() == null || !declaration.getJSDocInfo().hasTypedefType()) continue;
            this.typedefs.add(name);
        }
    }

    private void visitExportDeclaration(NodeTraversal t, Node export) {
        Node declaration = export.getFirstChild();
        if (NodeUtil.isNameDeclaration(declaration)) {
            this.visitExportNameDeclaration(declaration);
        }
        export.replaceWith(declaration.detach());
        t.reportCodeChange();
    }

    private void inlineModuleToGlobalScope(Node moduleNode) {
        Preconditions.checkState(moduleNode.isModuleBody());
        Node scriptNode = moduleNode.getParent();
        moduleNode.detach();
        scriptNode.addChildrenToFront(moduleNode.removeChildren());
    }

    private void visitScript(NodeTraversal t, Node script) {
        Node moduleBody = script.getFirstChild();
        AstFactory.Type moduleObjectType = AstFactory.type(moduleBody);
        this.inlineModuleToGlobalScope(moduleBody);
        ClosureRewriteModule.checkAndSetStrictModeDirective(t, script);
        Module thisModule = this.moduleMap.getModule(t.getInput().getPath());
        QualifiedName qualifiedName = ModuleRenaming.getGlobalName(thisModule.metadata(), null);
        Preconditions.checkState(qualifiedName.isSimple(), "Unexpected qualified name %s", (Object)qualifiedName);
        String moduleName = qualifiedName.getRoot();
        Node moduleVar = this.createExportsObject(moduleName, t, script, moduleObjectType);
        NodeTraversal.traverse(this.compiler, script, new RenameGlobalVars(thisModule));
        moduleVar.getFirstChild().setString(moduleName);
        moduleVar.makeNonIndexableRecursive();
        this.declareGlobalVariable(moduleVar.getFirstChild(), t);
        this.rewriteRequires(script);
        t.reportCodeChange();
    }

    private Node createExportsObject(String moduleName, NodeTraversal t, Node script, AstFactory.Type moduleObjectType) {
        Node moduleObject = this.astFactory.createObjectLit(moduleObjectType, new Node[0]);
        Node moduleVar = this.astFactory.createSingleVarNameDeclaration("$jscomp$tmp$exports$module$name", moduleObject);
        moduleVar.getFirstChild().putBooleanProp(Node.MODULE_EXPORT, true);
        JSDocInfo.Builder infoBuilder = JSDocInfo.builder();
        infoBuilder.recordConstancy();
        moduleVar.setJSDocInfo(infoBuilder.build());
        moduleVar.getFirstChild().setDeclaredConstantVar(true);
        script.addChildToBack(moduleVar.srcrefTreeIfMissing(script));
        Module thisModule = this.moduleMap.getModule(t.getInput().getPath());
        for (Map.Entry entry : thisModule.namespace().entrySet()) {
            JSDocInfo info;
            String exportedName = (String)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            Node nodeForSourceInfo = binding.sourceNode();
            boolean mutated = binding.isMutated();
            QualifiedName boundVariableQualifiedName = ModuleRenaming.getGlobalName(binding);
            Preconditions.checkState(boundVariableQualifiedName.isSimple(), "unexpected qualified name: %s", (Object)boundVariableQualifiedName);
            String boundVariableName = boundVariableQualifiedName.getRoot();
            Node getProp = this.astFactory.createGetPropWithoutColor(this.astFactory.createName(moduleName, moduleObjectType), exportedName);
            getProp.putBooleanProp(Node.MODULE_EXPORT, true);
            if (this.typedefs.contains(exportedName)) {
                JSDocInfo.Builder builder = JSDocInfo.builder().parseDocumentation();
                JSTypeExpression typeExpr = new JSTypeExpression(this.astFactory.createString(exportedName).srcref(nodeForSourceInfo), script.getSourceFileName());
                builder.recordTypedef(typeExpr);
                info = builder.build();
                getProp.setJSDocInfo(info);
                Node exprResult = this.astFactory.exprResult(getProp).srcrefTreeIfMissing(nodeForSourceInfo);
                script.addChildToBack(exprResult);
                continue;
            }
            if (mutated) {
                Node globalExportName = this.astFactory.createName(boundVariableName, AstFactory.type(getProp));
                this.addGetterExport(script, nodeForSourceInfo, moduleObject, exportedName, globalExportName);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.GETTER, this.compiler);
                continue;
            }
            Node assign = this.astFactory.createAssign(getProp, this.astFactory.createName(boundVariableName, AstFactory.type(getProp)));
            JSDocInfo.Builder builder = JSDocInfo.builder().parseDocumentation();
            builder.recordConstancy();
            info = builder.build();
            assign.setJSDocInfo(info);
            script.addChildToBack(this.astFactory.exprResult(assign).srcrefTreeIfMissing(nodeForSourceInfo));
        }
        return moduleVar;
    }

    private void addGetterExport(Node script, Node forSourceInfo, Node objLit, String exportedName, Node value) {
        Node getter = this.astFactory.createGetterDef(exportedName, value);
        getter.putBooleanProp(Node.MODULE_EXPORT, true);
        objLit.addChildToBack(getter);
        if (!this.astFactory.isAddingTypes()) {
            JSDocInfo.Builder builder = JSDocInfo.builder().parseDocumentation();
            builder.recordReturnType(new JSTypeExpression(new Node(Token.QMARK).srcref(forSourceInfo), script.getSourceFileName()));
            getter.setJSDocInfo(builder.build());
        } else {
            getter.setJSType(this.compiler.getTypeRegistry().createFunctionType(value.getJSType(), new JSType[0]));
        }
        getter.srcrefTreeIfMissing(forSourceInfo);
        this.compiler.reportChangeToEnclosingScope(getter.getFirstChild().getLastChild());
        this.compiler.reportChangeToEnclosingScope(getter);
    }

    private void rewriteRequires(Node script) {
        NodeTraversal.builder().setCompiler(this.compiler).setCallback((t, n, parent) -> {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (fn.matchesQualifiedName("goog.require") || fn.matchesQualifiedName("goog.requireType")) {
                    this.visitRequireOrGet(t, n, parent, true);
                } else if (fn.matchesQualifiedName("goog.module.get")) {
                    this.visitGoogModuleGet(t, n, parent);
                }
            }
        }).traverse(script);
        NodeTraversal.builder().setCompiler(this.compiler).setCallback((t, n, parent) -> {
            Var v;
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.inlineAliasedTypes(t, typeNode);
                }
            }
            if (n.isName() && this.namesToInlineByAlias.containsKey(n.getString()) && ((v = (Var)t.getScope().getVar(n.getString())) == null || v.getNameNode() != n)) {
                ModuleRenaming.GlobalizedModuleName replacementName = this.namesToInlineByAlias.get(n.getString());
                Node replacement = replacementName.toQname(this.astFactory).srcrefTree(n);
                n.replaceWith(replacement);
            }
        }).traverse(script);
    }

    private void inlineAliasedTypes(NodeTraversal t, Node typeNode) {
        if (typeNode.isStringLit()) {
            ModuleRenaming.GlobalizedModuleName replacement;
            String name = typeNode.getString();
            List<String> split = DOT_SPLITTER.limit(2).splitToList(name);
            if (t.getScope().getVar(split.get(0)) == null && (replacement = this.namesToInlineByAlias.get(split.get(0))) != null) {
                String rest = "";
                if (split.size() == 2) {
                    rest = "." + split.get(1);
                }
                typeNode.setOriginalName(name);
                typeNode.setString(replacement.aliasName().join() + rest);
                t.reportCodeChange();
            }
        }
        for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
            this.inlineAliasedTypes(t, child);
        }
    }

    private void visitGoogModuleGet(NodeTraversal t, Node getCall, Node parent) {
        if (!getCall.hasTwoChildren() || !getCall.getLastChild().isStringLit()) {
            t.report(getCall, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
            return;
        }
        if (t.inGlobalHoistScope()) {
            t.report(getCall, ClosurePrimitiveErrors.MODULE_USES_GOOG_MODULE_GET, new String[0]);
            return;
        }
        this.visitRequireOrGet(t, getCall, parent, false);
    }

    private ModuleMetadataMap.ModuleMetadata getFallbackMetadataForNamespace(String namespace) {
        ModuleMetadataMap.ModuleMetadata.Builder builder = ModuleMetadataMap.ModuleMetadata.builder().moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE).usesClosure(true).isTestOnly(false);
        builder.googNamespacesBuilder().add((Object)namespace);
        return builder.build();
    }

    private void visitRequireOrGet(NodeTraversal t, Node requireCall, Node parent, boolean isRequire) {
        ModuleMetadataMap.ModuleMetadata m;
        boolean isFromFallbackMetadata;
        if (!requireCall.hasTwoChildren() || !requireCall.getLastChild().isStringLit()) {
            t.report(requireCall, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
            return;
        }
        if (isRequire && !t.getScope().isGlobal()) {
            t.report(requireCall, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]);
            return;
        }
        String namespace = requireCall.getLastChild().getString();
        boolean isStoredInDeclaration = NodeUtil.isDeclaration(parent.getParent());
        if (isStoredInDeclaration && !parent.getParent().isConst()) {
            this.compiler.report(JSError.make(parent.getParent(), LHS_OF_GOOG_REQUIRE_MUST_BE_CONST, new String[0]));
        }
        boolean bl = isFromFallbackMetadata = (m = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace)) == null;
        if (isFromFallbackMetadata) {
            t.report(requireCall, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
            m = this.getFallbackMetadataForNamespace(namespace);
        }
        if (isStoredInDeclaration) {
            if (isRequire) {
                Node toDetach;
                if (parent.isDestructuringLhs()) {
                    Preconditions.checkState(parent.getFirstChild().isObjectPattern());
                    toDetach = parent.getParent();
                    for (Node child = parent.getFirstFirstChild(); child != null; child = child.getNext()) {
                        Preconditions.checkState(child.isStringKey() && child.getFirstChild().isName(), child);
                        ModuleRenaming.GlobalizedModuleName rep = this.getGlobalNameAndType(m, namespace, isFromFallbackMetadata).getprop(child.getString());
                        this.namesToInlineByAlias.put(child.getFirstChild().getString(), rep);
                    }
                } else if (parent.isName()) {
                    ModuleRenaming.GlobalizedModuleName alias = this.getGlobalNameAndType(m, namespace, isFromFallbackMetadata);
                    this.namesToInlineByAlias.put(parent.getString(), alias);
                    toDetach = parent.getParent();
                } else {
                    Preconditions.checkState(parent.isExprResult());
                    toDetach = parent;
                }
                toDetach.detach();
            } else {
                ModuleRenaming.GlobalizedModuleName name = this.getGlobalNameAndType(m, namespace, isFromFallbackMetadata);
                Node replacement = name.toQname(this.astFactory).srcrefTree(requireCall);
                requireCall.replaceWith(replacement);
            }
        } else {
            Preconditions.checkState(requireCall.getParent().isExprResult());
            requireCall.getParent().detach();
        }
    }

    private ModuleRenaming.GlobalizedModuleName getGlobalNameAndType(ModuleMetadataMap.ModuleMetadata metadata, @Nullable String googNamespace, boolean isFromMissingModuleOrProvide) {
        if (isFromMissingModuleOrProvide) {
            QualifiedName globalName = ModuleRenaming.getGlobalName(metadata, googNamespace);
            return ModuleRenaming.GlobalizedModuleName.create(globalName, this.unknownType);
        }
        return ModuleRenaming.GlobalizedModuleName.create(metadata, googNamespace, this.globalTypedScope);
    }

    private void maybeAddAliasToSymbolTable(Node n, String module) {
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        n.putBooleanProp(Node.MODULE_ALIAS, true);
        String nodeName = n.isStringLit() || n.isImportStar() ? n.getString() : this.preprocessorSymbolTable.getQualifiedName(n);
        String name = "alias_" + module + "_" + nodeName;
        this.preprocessorSymbolTable.addReference(n, name);
    }

    private void maybeAddImportedFileReferenceToSymbolTable(Node importStringNode, String importedFilePath) {
        Node scriptNode;
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        if (this.preprocessorSymbolTable.getSlot(importedFilePath) == null && (scriptNode = this.compiler.getScriptNode(importedFilePath)) != null) {
            this.preprocessorSymbolTable.addReference(scriptNode, importedFilePath);
        }
        this.preprocessorSymbolTable.addReference(importStringNode, importedFilePath);
    }

    private void declareGlobalVariable(Node n, NodeTraversal t) {
        Preconditions.checkState(n.isName());
        if (!this.astFactory.isAddingTypes()) {
            return;
        }
        Preconditions.checkNotNull(this.globalTypedScope);
        String name = n.getString();
        if (this.globalTypedScope.hasOwnSlot(name)) {
            t.report(t.getCurrentScript(), ClosureRewriteModule.ILLEGAL_MODULE_RENAMING_CONFLICT, name);
        } else {
            JSType type = Preconditions.checkNotNull(n.getJSType());
            this.globalTypedScope.declare(name, n, type, t.getInput(), false);
        }
    }

    private class RenameGlobalVars
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Module thisModule;

        RenameGlobalVars(Module thisModule) {
            this.thisModule = thisModule;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            if (n.isName()) {
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    String newName = ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(this.thisModule.metadata(), name).join();
                    n.setString(newName);
                    n.setOriginalName(name);
                    t.reportCodeChange(n);
                    if (NodeUtil.isDeclarationLValue(n)) {
                        Es6RewriteModules.this.declareGlobalVariable(n, t);
                    }
                } else if (var == null && this.thisModule.boundNames().containsKey(name)) {
                    Es6RewriteModules.this.maybeAddAliasToSymbolTable(n, t.getSourceName());
                    Binding binding = this.thisModule.boundNames().get(name);
                    Node replacement = this.replace(n, binding);
                    if (replacement.isName() && parent.isCall() && parent.getFirstChild() == n && parent.getBooleanProp(Node.FREE_CALL)) {
                        parent.putBooleanProp(Node.FREE_CALL, true);
                    }
                    if (NodeUtil.isDeclarationLValue(n)) {
                        Es6RewriteModules.this.declareGlobalVariable(n, t);
                    }
                    t.reportCodeChange();
                }
            }
        }

        private Node replace(Node n, Binding binding) {
            Node newNode;
            QualifiedName globalName;
            Preconditions.checkState(n.isName());
            while (binding.isModuleNamespace() && binding.metadata().isEs6Module() && n.getParent().isGetProp()) {
                String propertyName = n.getParent().getString();
                Module m = Es6RewriteModules.this.moduleMap.getModule(binding.metadata().path());
                if (!m.namespace().containsKey(propertyName)) break;
                binding = m.namespace().get(propertyName);
                n = n.getParent();
            }
            if (!(globalName = ModuleRenaming.getGlobalName(binding)).isSimple()) {
                String root = globalName.getRoot();
                newNode = Es6RewriteModules.this.globalTypedScope != null && Es6RewriteModules.this.globalTypedScope.hasSlot(root) ? Es6RewriteModules.this.astFactory.createQName((StaticScope)Es6RewriteModules.this.globalTypedScope, globalName.join()) : Es6RewriteModules.this.astFactory.createQNameWithUnknownType(globalName.join());
            } else {
                newNode = Es6RewriteModules.this.astFactory.createName(globalName.getRoot(), AstFactory.type(n));
            }
            n.replaceWith(newNode);
            newNode.srcrefTree(n);
            newNode.setOriginalName(n.getString());
            return newNode;
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isStringLit()) {
                Var var;
                Module thisModule = Es6RewriteModules.this.moduleMap.getModule(t.getInput().getPath());
                String name = typeNode.getString();
                List<String> splitted = DOT_SPLITTER.splitToList(name);
                String baseName = splitted.get(0);
                String rest = "";
                if (splitted.size() > 1) {
                    rest = name.substring(baseName.length());
                }
                if ((var = (Var)t.getScope().getVar(baseName)) != null && var.isGlobal()) {
                    this.maybeSetNewName(t, typeNode, name, ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(thisModule.metadata(), baseName).join() + rest);
                } else if (var == null && thisModule.boundNames().containsKey(baseName)) {
                    Binding binding = thisModule.boundNames().get(baseName);
                    String globalName = ModuleRenaming.getGlobalNameForJsDoc(Es6RewriteModules.this.moduleMap, binding, splitted.subList(1, splitted.size()));
                    this.maybeSetNewName(t, typeNode, name, globalName);
                    if (Es6RewriteModules.this.preprocessorSymbolTable != null) {
                        Node onlyBaseName = Node.newString(baseName).srcref(typeNode);
                        onlyBaseName.setLength(baseName.length());
                        Es6RewriteModules.this.maybeAddAliasToSymbolTable(onlyBaseName, t.getSourceName());
                    }
                }
                typeNode.setOriginalName(name);
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }

        private void maybeSetNewName(NodeTraversal t, Node node, String name, String newName) {
            if (!name.equals(newName)) {
                node.setString(newName);
                node.setOriginalName(name);
                t.reportCodeChange();
            }
        }
    }

    private class RewriteRequiresForEs6Modules
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean transpiled = false;
        private Table<Node, String, String> renameTable;

        private RewriteRequiresForEs6Modules() {
        }

        void rewrite(Node scriptNode) {
            this.transpiled = false;
            this.renameTable = HashBasedTable.create();
            NodeTraversal.traverse(Es6RewriteModules.this.compiler, scriptNode, this);
            if (this.transpiled) {
                scriptNode.putBooleanProp(Node.TRANSPILED, true);
            }
            if (!this.renameTable.isEmpty()) {
                NodeTraversal.traverse(Es6RewriteModules.this.compiler, scriptNode, new Es6RenameReferences(this.renameTable, true));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            ModuleMetadataMap.ModuleMetadata currentModuleMetadata;
            if (!n.isCall()) {
                return;
            }
            boolean isRequire = n.getFirstChild().matchesQualifiedName("goog.require");
            boolean isRequireType = n.getFirstChild().matchesQualifiedName("goog.requireType");
            boolean isGet = n.getFirstChild().matchesQualifiedName("goog.module.get");
            boolean isForwardDeclare = n.getFirstChild().matchesQualifiedName("goog.forwardDeclare");
            if (!(isRequire || isRequireType || isGet || isForwardDeclare)) {
                return;
            }
            if (!n.hasTwoChildren() || !n.getLastChild().isStringLit()) {
                if (isRequire) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
                } else if (isRequireType) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_REQUIRE_TYPE_NAMESPACE, new String[0]);
                } else if (isGet) {
                    t.report(n, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
                } else {
                    t.report(n, ClosurePrimitiveErrors.INVALID_FORWARD_DECLARE_NAMESPACE, new String[0]);
                }
                return;
            }
            String name = n.getLastChild().getString();
            ModuleMetadataMap.ModuleMetadata moduleMetadata = Es6RewriteModules.this.moduleMetadataMap.getModulesByGoogNamespace().get(name);
            if (moduleMetadata == null || !moduleMetadata.isEs6Module()) {
                return;
            }
            if (isRequire && (currentModuleMetadata = Es6RewriteModules.this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString())) != null && currentModuleMetadata.isEs6Module()) {
                t.report(n, SHOULD_IMPORT_ES6_MODULE, new String[0]);
            }
            if (isGet && t.inGlobalHoistScope()) {
                t.report(n, ClosurePrimitiveErrors.INVALID_GET_CALL_SCOPE, new String[0]);
                return;
            }
            Node statementNode = NodeUtil.getEnclosingStatement(n);
            boolean importHasAlias = NodeUtil.isNameDeclaration(statementNode);
            if (importHasAlias) {
                if (statementNode.getFirstChild().isDestructuringLhs()) {
                    if (isForwardDeclare) {
                        t.report(n, ClosurePrimitiveErrors.INVALID_DESTRUCTURING_FORWARD_DECLARE, new String[0]);
                        return;
                    }
                    if (isRequireType) {
                        if (!statementNode.isConst()) {
                            t.report(statementNode, REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST, new String[0]);
                            return;
                        }
                        for (Node child = statementNode.getFirstFirstChild().getFirstChild(); child != null; child = child.getNext()) {
                            Preconditions.checkState(child.isStringKey());
                            Preconditions.checkState(child.getFirstChild().isName());
                            this.renameTable.put(t.getScopeRoot(), child.getFirstChild().getString(), ModuleRenaming.getGlobalName(moduleMetadata, name).getprop(child.getString()).join());
                        }
                    } else {
                        for (Node child = statementNode.getFirstFirstChild().getFirstChild(); child != null; child = child.getNext()) {
                            Preconditions.checkState(child.isStringKey());
                            Preconditions.checkState(child.getFirstChild().isName());
                            ModuleRenaming.GlobalizedModuleName globalName = Es6RewriteModules.this.getGlobalNameAndType(moduleMetadata, name, false).getprop(child.getString());
                            Node constNode = Es6RewriteModules.this.astFactory.createSingleConstNameDeclaration(child.getFirstChild().getString(), globalName.toQname(Es6RewriteModules.this.astFactory));
                            constNode.srcrefTree(child);
                            constNode.insertBefore(statementNode);
                        }
                    }
                    statementNode.detach();
                    t.reportCodeChange();
                } else if (isForwardDeclare || isRequireType) {
                    if (!statementNode.isConst()) {
                        DiagnosticType diagnostic = isForwardDeclare ? FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST : REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST;
                        t.report(statementNode, diagnostic, new String[0]);
                        return;
                    }
                    this.renameTable.put(t.getScopeRoot(), statementNode.getFirstChild().getString(), ModuleRenaming.getGlobalName(moduleMetadata, name).join());
                    statementNode.detach();
                    t.reportCodeChange();
                } else {
                    n.replaceWith(Es6RewriteModules.this.astFactory.createName(ModuleRenaming.getGlobalName(moduleMetadata, name).getRoot(), AstFactory.type(n)).srcrefTree(n));
                    t.reportCodeChange();
                }
            } else {
                if (isForwardDeclare || isRequireType) {
                    this.renameTable.put(t.getScopeRoot(), name, ModuleRenaming.getGlobalName(moduleMetadata, name).join());
                    statementNode.detach();
                } else if (statementNode.isExprResult() && statementNode.getFirstChild() == n) {
                    statementNode.detach();
                } else {
                    n.replaceWith(Es6RewriteModules.this.astFactory.createName(ModuleRenaming.getGlobalName(moduleMetadata, name).getRoot(), AstFactory.type(n)).srcrefTree(n));
                }
                t.reportCodeChange();
            }
            this.transpiled = true;
        }
    }
}

