/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Maps;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

final class InvocationTemplateTypeMatcher {
    private final IdentityHashMap<TemplateType, JSType> matchedTypes = Maps.newIdentityHashMap();
    private final Set<JSType> seenTypes = Sets.newIdentityHashSet();
    private final JSTypeRegistry registry;
    private final FunctionType calleeType;
    private final JSType localThisType;
    private final Node invocation;
    private final JSType unknownType;

    InvocationTemplateTypeMatcher(JSTypeRegistry registry, FunctionType calleeType, JSType localThisType, Node invocation) {
        this.registry = registry;
        this.calleeType = calleeType;
        this.localThisType = localThisType;
        this.invocation = invocation;
        this.unknownType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    ImmutableMap<TemplateType, JSType> match() {
        if (this.calleeType.getTemplateTypeMap().isEmpty()) {
            return ImmutableMap.of();
        }
        Node target = this.invocation.getFirstChild();
        if (NodeUtil.isNormalGet(target)) {
            Node obj = target.getFirstChild();
            JSType typeOfThisRequiredByTheFunction = this.calleeType.getTypeOfThis();
            JSType typeOfThisProvidedByTheCall = obj.isSuper() ? this.localThisType : this.getTypeOrUnknown(obj);
            typeOfThisProvidedByTheCall = typeOfThisProvidedByTheCall.restrictByNotNullOrUndefined();
            this.matchTemplateTypesRecursive(typeOfThisRequiredByTheFunction, typeOfThisProvidedByTheCall);
        }
        if (this.invocation.isTaggedTemplateLit()) {
            Iterator calleeParameters = this.calleeType.getParameters().iterator();
            if (!calleeParameters.hasNext()) {
                return ImmutableMap.copyOf(this.matchedTypes);
            }
            this.matchTemplateTypesRecursive(((FunctionType.Parameter)calleeParameters.next()).getJSType(), this.registry.getNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE));
            this.matchTemplateTypesFromNodes(Iterables.skip(this.calleeType.getParameters(), 1), NodeUtil.getInvocationArgsAsIterable(this.invocation));
        } else if (this.invocation.hasMoreThanOneChild()) {
            this.matchTemplateTypesFromNodes(this.calleeType.getParameters(), NodeUtil.getInvocationArgsAsIterable(this.invocation));
        }
        return ImmutableMap.copyOf(this.matchedTypes);
    }

    private void matchTemplateTypesRecursive(JSType paramType, JSType argType) {
        if (paramType.isTemplateType()) {
            this.recordTemplateMatch(paramType.toMaybeTemplateType(), argType);
            return;
        }
        if (paramType.isUnionType()) {
            UnionType unionType = paramType.toMaybeUnionType();
            for (JSType alternate : unionType.getAlternates()) {
                this.matchTemplateTypesRecursive(alternate, argType);
            }
            return;
        }
        if (argType.isUnionType()) {
            UnionType unionType = argType.toMaybeUnionType();
            for (JSType alternate : unionType.getAlternates()) {
                this.matchTemplateTypesRecursive(paramType, alternate);
            }
            return;
        }
        if (paramType.isFunctionType()) {
            FunctionType paramFunctionType = paramType.toMaybeFunctionType();
            FunctionType argFunctionType = argType.restrictByNotNullOrUndefined().collapseUnion().toMaybeFunctionType();
            if (argFunctionType != null && argFunctionType.isSubtype(paramType)) {
                this.matchTemplateTypesRecursive(paramFunctionType.getTypeOfThis(), argFunctionType.getTypeOfThis());
                this.matchTemplateTypesRecursive(paramFunctionType.getReturnType(), argFunctionType.getReturnType());
                this.matchTemplateTypesFromParameters(paramFunctionType.getParameters().iterator(), argFunctionType.getParameters().iterator());
            }
        } else if (paramType.isRecordType() && !paramType.isNominalType()) {
            if (this.seenTypes.add(paramType)) {
                ObjectType paramRecordType = paramType.toObjectType();
                ObjectType argObjectType = argType.restrictByNotNullOrUndefined().toObjectType();
                if (argObjectType != null && !argObjectType.isUnknownType() && !argObjectType.isEmptyType()) {
                    ImmutableSortedSet<String> names = paramRecordType.getPropertyNames();
                    for (String name : names) {
                        if (!paramRecordType.hasOwnProperty(name) || !argObjectType.hasProperty(name)) continue;
                        this.matchTemplateTypesRecursive(paramRecordType.getPropertyType(name), argObjectType.getPropertyType(name));
                    }
                }
                this.seenTypes.remove(paramType);
            }
        } else if (paramType.isTemplatizedType()) {
            TemplatizedType templatizedParamType = paramType.toMaybeTemplatizedType();
            int keyCount = templatizedParamType.getTemplateTypes().size();
            if (keyCount == 0) {
                return;
            }
            ObjectType referencedParamType = templatizedParamType.getReferencedType();
            JSType argObjectType = argType.restrictByNotNullOrUndefined().collapseUnion();
            if (argObjectType.isSubtypeOf(referencedParamType)) {
                TemplateTypeMap paramTypeMap = paramType.getTemplateTypeMap();
                ImmutableList<TemplateType> keys = paramTypeMap.getTemplateKeys();
                TemplateTypeMap argTypeMap = argObjectType.getTemplateTypeMap();
                for (int index = keys.size() - keyCount; index < keys.size(); ++index) {
                    TemplateType key = (TemplateType)keys.get(index);
                    this.matchTemplateTypesRecursive(paramTypeMap.getResolvedTemplateType(key), argTypeMap.getResolvedTemplateType(key));
                }
            }
        }
    }

    private void matchTemplateTypesFromNodes(Iterable<FunctionType.Parameter> declParams, Iterable<Node> callParams) {
        this.matchTemplateTypesFromNodes(declParams.iterator(), callParams.iterator());
    }

    private void matchTemplateTypesFromNodes(Iterator<FunctionType.Parameter> declParams, Iterator<Node> callParams) {
        while (declParams.hasNext() && callParams.hasNext()) {
            FunctionType.Parameter declParam = declParams.next();
            this.matchTemplateTypesRecursive(declParam.getJSType(), this.getTypeOrUnknown(callParams.next()));
            if (!declParam.isVariadic()) continue;
            while (callParams.hasNext()) {
                this.matchTemplateTypesRecursive(declParam.getJSType(), this.getTypeOrUnknown(callParams.next()));
            }
        }
    }

    private void matchTemplateTypesFromParameters(Iterator<FunctionType.Parameter> declParams, Iterator<FunctionType.Parameter> callParams) {
        while (declParams.hasNext() && callParams.hasNext()) {
            FunctionType.Parameter declParam = declParams.next();
            this.matchTemplateTypesRecursive(declParam.getJSType(), callParams.next().getJSType());
            if (!declParam.isVariadic()) continue;
            while (callParams.hasNext()) {
                this.matchTemplateTypesRecursive(declParam.getJSType(), callParams.next().getJSType());
            }
        }
    }

    private void recordTemplateMatch(TemplateType template, JSType match) {
        if (match.isUnknownType()) {
            return;
        }
        this.matchedTypes.merge(template, match, JSType::getLeastSupertype);
    }

    private final JSType getTypeOrUnknown(Node n) {
        JSType type = n.getJSType();
        return type == null ? this.unknownType : type;
    }
}

