/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class PeepholeCollectPropertyAssignments
extends AbstractPeepholeOptimization {
    PeepholeCollectPropertyAssignments() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        if (!subtree.isScript() && !subtree.isBlock()) {
            return subtree;
        }
        boolean codeChanged = false;
        for (Node child = subtree.getFirstChild(); child != null; child = child.getNext()) {
            Node propertyCandidate;
            Node value;
            if (!NodeUtil.isNameDeclaration(child) && !NodeUtil.isExprAssign(child) || !PeepholeCollectPropertyAssignments.isPropertyAssignmentToName(child.getNext())) continue;
            Preconditions.checkState(child.hasOneChild());
            Node name = PeepholeCollectPropertyAssignments.getName(child);
            if (!name.isName() || (value = PeepholeCollectPropertyAssignments.getValue(child)) == null || !PeepholeCollectPropertyAssignments.isInterestingValue(value)) continue;
            while ((propertyCandidate = child.getNext()) != null && this.collectProperty(propertyCandidate, name.getString(), value)) {
                codeChanged = true;
            }
        }
        if (codeChanged) {
            this.reportChangeToEnclosingScope(subtree);
        }
        return subtree;
    }

    private static Node getName(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            return n.getFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstFirstChild();
        }
        throw new IllegalStateException();
    }

    private static Node getValue(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            return n.getFirstFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getLastChild();
        }
        throw new IllegalStateException();
    }

    static boolean isInterestingValue(Node n) {
        return n.isObjectLit() || n.isArrayLit();
    }

    private static boolean isPropertyAssignmentToName(Node propertyCandidate) {
        if (propertyCandidate == null) {
            return false;
        }
        if (!NodeUtil.isExprAssign(propertyCandidate)) {
            return false;
        }
        Node expr = propertyCandidate.getFirstChild();
        Node lhs = expr.getFirstChild();
        if (!NodeUtil.isNormalGet(lhs)) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        return obj.isName();
    }

    private boolean collectProperty(Node propertyCandidate, String name, Node value) {
        if (!PeepholeCollectPropertyAssignments.isPropertyAssignmentToName(propertyCandidate)) {
            return false;
        }
        Node lhs = propertyCandidate.getFirstFirstChild();
        if (!name.equals(lhs.getFirstChild().getString())) {
            return false;
        }
        Node rhs = lhs.getNext();
        if (this.mayHaveSideEffects(rhs) || NodeUtil.canBeSideEffected(rhs)) {
            return false;
        }
        if (!NodeUtil.isLiteralValue(rhs, true) && PeepholeCollectPropertyAssignments.mightContainForwardReference(rhs, name)) {
            return false;
        }
        switch (value.getToken()) {
            case ARRAYLIT: {
                if (PeepholeCollectPropertyAssignments.collectArrayProperty(value, propertyCandidate)) break;
                return false;
            }
            case OBJECTLIT: {
                if (this.collectObjectProperty(value, propertyCandidate)) break;
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private static boolean collectArrayProperty(Node arrayLiteral, Node propertyCandidate) {
        int maxIndexAssigned;
        Node assignment = propertyCandidate.getFirstChild();
        int sizeOfArrayAtStart = arrayLiteral.getChildCount();
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        if (!lhs.isGetElem()) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        Node property = obj.getNext();
        if (!property.isNumber()) {
            return false;
        }
        double dindex = property.getDouble();
        if (!(dindex >= 0.0) || Double.isInfinite(dindex) || dindex > 2.147483647E9) {
            return false;
        }
        int index = (int)dindex;
        if (dindex != (double)index) {
            return false;
        }
        if (maxIndexAssigned + 4 < index) {
            return false;
        }
        if (index > maxIndexAssigned) {
            for (maxIndexAssigned = sizeOfArrayAtStart - 1; maxIndexAssigned < index - 1; ++maxIndexAssigned) {
                Node emptyNode = IR.empty().srcref(arrayLiteral);
                arrayLiteral.addChildToBack(emptyNode);
            }
            arrayLiteral.addChildToBack(rhs.detach());
        } else {
            Node currentValue = arrayLiteral.getChildAtIndex(index);
            if (!currentValue.isEmpty()) {
                return false;
            }
            currentValue.replaceWith(rhs.detach());
        }
        propertyCandidate.detach();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean collectObjectProperty(Node objectLiteral, Node propertyCandidate) {
        String propertyName;
        Node assignment = propertyCandidate.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        Node obj = lhs.getFirstChild();
        Preconditions.checkState(lhs.isGetProp() || lhs.isGetElem(), lhs);
        if (lhs.isGetElem()) {
            Node property = obj.getNext();
            if (property.isNumber()) {
                propertyName = this.getSideEffectFreeStringValue(property);
            } else {
                if (!property.isStringLit()) return false;
                propertyName = property.getString();
            }
        } else {
            if (!lhs.isGetProp()) return false;
            propertyName = lhs.getString();
        }
        Node existingProperty = null;
        for (Node currentProperty = objectLiteral.getFirstChild(); currentProperty != null; currentProperty = currentProperty.getNext()) {
            String currentPropertyName;
            if (currentProperty.isStringKey() || currentProperty.isMemberFunctionDef()) {
                currentPropertyName = currentProperty.getString();
                Node currentValue = currentProperty.getFirstChild();
                if (!currentPropertyName.equals(propertyName)) continue;
                existingProperty = currentProperty;
                boolean isCurrentValueSideEffect = NodeUtil.canBeSideEffected(currentValue);
                boolean isNewValueSideEffect = NodeUtil.canBeSideEffected(rhs);
                if (!isCurrentValueSideEffect && !isNewValueSideEffect) break;
                return false;
            }
            if (!currentProperty.isGetterDef() && !currentProperty.isSetterDef() || !(currentPropertyName = currentProperty.getString()).equals(propertyName)) continue;
            return false;
        }
        Node newProperty = IR.stringKey(propertyName).srcrefIfMissing(propertyCandidate);
        if (lhs.isGetElem()) {
            newProperty.setQuotedString();
        }
        Node newValue = rhs.detach();
        newProperty.addChildToBack(newValue);
        if (existingProperty != null) {
            this.deleteNode(existingProperty);
        }
        objectLiteral.addChildToBack(newProperty);
        propertyCandidate.detach();
        return true;
    }

    private static boolean mightContainForwardReference(Node node, String varName) {
        if (node.isName()) {
            return varName.equals(node.getString());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            if (!PeepholeCollectPropertyAssignments.mightContainForwardReference(child, varName)) continue;
            return true;
        }
        return false;
    }
}

