/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicates;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ReferenceCollector
implements CompilerPass,
StaticSymbolTable<Var, Reference> {
    private final Map<Var, ReferenceCollection> referenceMap = new LinkedHashMap<Var, ReferenceCollection>();
    private ArrayDeque<BasicBlock> blockStack = new ArrayDeque();
    private final Behavior behavior;
    private final ScopeCreator scopeCreator;
    private final AbstractCompiler compiler;
    private final Predicate<Var> varFilter;
    private final CollectorCallback callback = new CollectorCallback();
    private final HashSet<Node> collectedHoistedFunctions = new HashSet();
    private Scope narrowScope;
    static final Behavior DO_NOTHING_BEHAVIOR = new Behavior(){

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        }
    };

    public ReferenceCollector(AbstractCompiler compiler, Behavior behavior, ScopeCreator creator) {
        this(compiler, behavior, creator, Predicates.alwaysTrue());
    }

    ReferenceCollector(AbstractCompiler compiler, Behavior behavior, ScopeCreator creator, Predicate<Var> varFilter) {
        this.compiler = compiler;
        this.behavior = behavior;
        this.scopeCreator = creator;
        this.varFilter = varFilter;
    }

    @Override
    public void process(Node externs, Node root) {
        this.createTraversalBuilder().traverseRoots(externs, root);
    }

    public void process(Node root) {
        this.createTraversalBuilder().traverse(root);
    }

    void processScope(Scope scope) {
        boolean shouldAddToBlockStack = !scope.isHoistScope();
        this.narrowScope = scope;
        if (shouldAddToBlockStack) {
            this.pushNewBlock(scope.getRootNode());
        }
        this.createTraversalBuilder().traverseAtScope(scope);
        if (shouldAddToBlockStack) {
            this.popLastBlock(scope.getRootNode());
        }
        this.narrowScope = null;
    }

    private NodeTraversal.Builder createTraversalBuilder() {
        return NodeTraversal.builder().setCompiler(this.compiler).setCallback(this.callback).setScopeCreator(this.scopeCreator).setObeyDestructuringAndDefaultValueExecutionOrder(true);
    }

    @Override
    public Iterable<Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    public Scope getScope(Var var) {
        return (Scope)var.getScope();
    }

    public ReferenceCollection getReferences(Var v) {
        return this.referenceMap.get(v);
    }

    private void maybeJumpToHoistedFunction(Var var, NodeTraversal t) {
        Node fnNode = var.getParentNode();
        Scope varScope = (Scope)var.getScope();
        if (fnNode == null || !NodeUtil.isHoistedFunctionDeclaration(fnNode) || this.narrowScope != null && this.narrowScope.getDepth() > varScope.getDepth() || this.collectedHoistedFunctions.contains(fnNode)) {
            return;
        }
        ArrayDeque<BasicBlock> oldBlockStack = this.blockStack;
        this.blockStack = new ArrayDeque();
        if (varScope.isGlobal()) {
            this.blockStack.addLast(oldBlockStack.getFirst());
        } else {
            for (BasicBlock b : oldBlockStack) {
                this.blockStack.addLast(b);
                if (b.getRoot() != varScope.getRootNode()) continue;
                break;
            }
        }
        this.addReference(var, fnNode.getFirstChild(), t);
        this.createTraversalBuilder().traverseAtScope(this.scopeCreator.createScope(fnNode, varScope));
        this.blockStack = oldBlockStack;
    }

    private void pushNewBlock(Node root) {
        this.blockStack.addLast(new BasicBlock(this.blockStack.peekLast(), root));
    }

    private void popLastBlock(Node root) {
        BasicBlock last = this.blockStack.removeLast();
        Preconditions.checkState(JSCompObjects.identical(root, last.getRoot()), root);
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getToken()) {
                case DO: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case TRY: 
                case WHILE: 
                case WITH: 
                case CLASS: {
                    return true;
                }
                case AND: 
                case HOOK: 
                case IF: 
                case OR: 
                case SWITCH: 
                case COALESCE: 
                case OPTCHAIN_GETPROP: 
                case OPTCHAIN_GETELEM: 
                case OPTCHAIN_CALL: 
                case DEFAULT_VALUE: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReference(Var v, Node n, NodeTraversal t) {
        if (!this.varFilter.apply(v)) {
            return;
        }
        ReferenceCollection collection = this.referenceMap.computeIfAbsent(v, k -> new ReferenceCollection());
        collection.add(new Reference(n, t, this.blockStack.getLast()));
    }

    public static interface Behavior {
        public void afterExitScope(NodeTraversal var1, ReferenceMap var2);
    }

    static class ReferenceMapWrapper
    implements ReferenceMap {
        private final Map<Var, ReferenceCollection> referenceMap;

        public ReferenceMapWrapper(Map<Var, ReferenceCollection> referenceMap) {
            this.referenceMap = referenceMap;
        }

        @Override
        public ReferenceCollection getReferences(Var var) {
            return this.referenceMap.get(var);
        }

        Map<Var, ReferenceCollection> getRawReferenceMap() {
            return this.referenceMap;
        }

        public String toString() {
            return this.referenceMap.toString();
        }
    }

    private final class CollectorCallback
    implements NodeTraversal.ScopedCallback {
        private CollectorCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (NodeUtil.isHoistedFunctionDeclaration(n) && !ReferenceCollector.this.collectedHoistedFunctions.add(n)) {
                return false;
            }
            if (ReferenceCollector.isBlockBoundary(n, parent)) {
                ReferenceCollector.this.pushNewBlock(n);
            }
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.isHoistScope()) {
                ReferenceCollector.this.pushNewBlock(t.getScopeRoot());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.isHoistScope()) {
                ReferenceCollector.this.popLastBlock(t.getScopeRoot());
            }
            ReferenceCollector.this.behavior.afterExitScope(t, new ReferenceMapWrapper(ReferenceCollector.this.referenceMap));
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() || n.isImportStar()) {
                if (parent.isImportSpec() && n != parent.getLastChild() || parent.isExportSpec() && n != parent.getFirstChild()) {
                    return;
                }
                Var v = (Var)t.getScope().getVar(n.getString());
                if (v != null) {
                    ReferenceCollector.this.addReference(v, n, t);
                    ReferenceCollector.this.maybeJumpToHoistedFunction(v, t);
                }
            }
            if (ReferenceCollector.isBlockBoundary(n, parent)) {
                ReferenceCollector.this.popLastBlock(n);
            }
        }
    }
}

