/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;

final class RemoveUnnecessarySyntheticExterns
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final LinkedHashSet<Node> nodesToDetach = new LinkedHashSet();

    RemoveUnnecessarySyntheticExterns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        Node globalRoot = externs.getParent();
        SyntacticScopeCreator scopeCreator = new SyntacticScopeCreator(this.compiler, new RedeclarationCheckHandler());
        scopeCreator.createScope(globalRoot, (AbstractScope<?, ?>)null);
        if (this.nodesToDetach.isEmpty()) {
            return;
        }
        for (Node n : this.nodesToDetach) {
            n.detach();
        }
        Node syntheticExternsScript = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
        this.compiler.reportChangeToEnclosingScope(syntheticExternsScript);
    }

    private class RedeclarationCheckHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private RedeclarationCheckHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Preconditions.checkArgument(s.isGlobal(), "Unexpected non-global redeclaration %s in scope %s", (Object)n, (Object)s);
            boolean isSynthetic = input.equals(RemoveUnnecessarySyntheticExterns.this.compiler.getSynthesizedExternsInput());
            Var origVar = (Var)s.getVar(name);
            Node origNode = origVar.getNode();
            if (isSynthetic) {
                if (n.getParent().isSynthesizedUnfulfilledNameDeclaration()) {
                    RemoveUnnecessarySyntheticExterns.this.nodesToDetach.add(n.getParent());
                }
            } else if (origNode != null && origNode.getParent().isSynthesizedUnfulfilledNameDeclaration()) {
                RemoveUnnecessarySyntheticExterns.this.nodesToDetach.add(origNode.getParent());
            }
        }
    }
}

