/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

class RewriteLogicalAssignmentOperatorsHelper {
    private static final String TEMP_VAR_NAME_PREFIX = "$jscomp$logical$assign$tmp";
    private static final String TEMP_INDEX_VAR_NAME_PREFIX = "$jscomp$logical$assign$tmpindex";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final UniqueIdSupplier uniqueIdSupplier;

    public RewriteLogicalAssignmentOperatorsHelper(AbstractCompiler compiler, AstFactory astFactory, UniqueIdSupplier uniqueIdSupplier) {
        this.compiler = compiler;
        this.astFactory = astFactory;
        this.uniqueIdSupplier = uniqueIdSupplier;
    }

    public void visitLogicalAssignmentOperator(NodeTraversal t, Node logicalAssignment) {
        Node replacement;
        Node enclosingStatement = NodeUtil.getEnclosingStatement(logicalAssignment);
        Node left = logicalAssignment.removeFirstChild();
        Node right = logicalAssignment.getLastChild().detach();
        while (left.isCast()) {
            left = left.removeFirstChild();
        }
        if (left.isName()) {
            replacement = this.handleLHSName(logicalAssignment, left, right);
        } else {
            Preconditions.checkState(left.isGetProp() || left.isGetElem(), left);
            replacement = this.handleLHSPropertyReference(t, logicalAssignment, left, right, enclosingStatement);
        }
        logicalAssignment.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(enclosingStatement);
    }

    public Node handleLHSName(Node logicalAssignment, Node left, Node right) {
        Node assignToRHS = this.astFactory.createAssign(left, right).srcref(right);
        return new Node(NodeUtil.getOpFromAssignmentOp(logicalAssignment), left.cloneNode(), assignToRHS).copyTypeFrom(logicalAssignment).srcref(logicalAssignment);
    }

    public Node handleLHSPropertyReference(NodeTraversal t, Node logicalAssignment, Node left, Node right, Node enclosingStatement) {
        Node newLHS;
        Node assignToRHS;
        CompilerInput input = t.getInput();
        String uniqueId = this.uniqueIdSupplier.getUniqueId(input);
        String tempVarName = TEMP_VAR_NAME_PREFIX + uniqueId;
        Node objectNode = left.removeFirstChild();
        Node let = this.astFactory.createSingleLetNameDeclaration(tempVarName).srcrefTree(logicalAssignment);
        let.insertBefore(enclosingStatement);
        Node tempName = this.astFactory.createName(tempVarName, AstFactory.type(objectNode)).srcref(objectNode);
        Node assignTemp = this.astFactory.createAssign(tempName, objectNode).srcref(objectNode);
        if (left.isGetProp()) {
            String propertyName = left.getString();
            Node tempProp = this.astFactory.createGetProp(tempName.cloneNode(), propertyName, AstFactory.type(left)).srcref(right);
            assignToRHS = this.astFactory.createAssign(tempProp, right).srcref(right);
            newLHS = this.astFactory.createGetProp(assignTemp, propertyName, AstFactory.type(left)).srcref(left);
        } else {
            Preconditions.checkState(left.isGetElem(), left);
            String tempIndexVarName = TEMP_INDEX_VAR_NAME_PREFIX + uniqueId;
            Node indexExprNode = left.getLastChild().detach();
            Node letIndex = this.astFactory.createSingleLetNameDeclaration(tempIndexVarName).srcrefTree(logicalAssignment);
            letIndex.insertBefore(enclosingStatement);
            Node tempIndexName = this.astFactory.createName(tempIndexVarName, AstFactory.type(indexExprNode)).srcref(indexExprNode);
            Node assignTempIndex = this.astFactory.createAssign(tempIndexName, indexExprNode).srcref(indexExprNode);
            Node tempElem = this.astFactory.createGetElem(tempName.cloneNode(), tempIndexName.cloneNode()).copyTypeFrom(left).srcref(right);
            assignToRHS = this.astFactory.createAssign(tempElem, right).srcref(right);
            newLHS = this.astFactory.createGetElem(assignTemp, assignTempIndex).copyTypeFrom(left).srcref(left);
        }
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        return new Node(NodeUtil.getOpFromAssignmentOp(logicalAssignment), newLHS, assignToRHS).copyTypeFrom(logicalAssignment).srcref(logicalAssignment);
    }
}

