/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.Promises;
import com.google.javascript.jscomp.RemoveCastNodes;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

class RuntimeTypeCheck
implements CompilerPass {
    private static final Comparator<JSType> ALPHA = new Comparator<JSType>(){

        @Override
        public int compare(JSType t1, JSType t2) {
            return this.getName(t1).compareTo(this.getName(t2));
        }

        private String getName(JSType type) {
            if (type.isInstanceType()) {
                return ((ObjectType)type).getReferenceName();
            }
            if (type.isNullType() || type.isBooleanValueType() || type.isNumberValueType() || type.isStringValueType() || type.isVoidType()) {
                return type.toString();
            }
            return "";
        }
    };
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final JSTypeRegistry typeRegistry;
    private final String logFunction;

    RuntimeTypeCheck(AbstractCompiler compiler, @Nullable String logFunction) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.typeRegistry = compiler.getTypeRegistry();
        this.logFunction = logFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new AddMarkers(this.compiler, this.astFactory));
        NodeTraversal.traverse(this.compiler, root, new AddChecks());
        this.addBoilerplateCode();
        new RemoveCastNodes(this.compiler).process(externs, root);
        new Normalize(this.compiler, false).process(externs, root);
    }

    private static ImmutableList<Node> paramNamesOf(Node paramList) {
        Preconditions.checkArgument(paramList.isParamList(), paramList);
        ImmutableList.Builder builder = ImmutableList.builder();
        NodeUtil.getParamOrPatternNames(paramList, builder::add);
        return builder.build();
    }

    private void addBoilerplateCode() {
        Node newNode = this.compiler.ensureLibraryInjected("runtime_type_check", false);
        if (newNode != null) {
            this.injectCustomLogFunction(newNode);
        }
    }

    @VisibleForTesting
    void injectCustomLogFunction(Node node) {
        if (this.logFunction == null) {
            return;
        }
        Preconditions.checkState(NodeUtil.isValidQualifiedName(this.compiler.getFeatureSet(), this.logFunction), "%s is not a valid qualified name", (Object)this.logFunction);
        Node logOverride = IR.exprResult(this.astFactory.createAssign(this.astFactory.createQNameWithUnknownType("$jscomp.typecheck.log"), this.astFactory.createQNameWithUnknownType(this.logFunction))).srcrefTree(node);
        Preconditions.checkState(node.getParent().isScript(), node.getParent());
        logOverride.insertAfter(node);
        this.compiler.reportChangeToEnclosingScope(node);
    }

    private Node jsCode(String prop) {
        return this.astFactory.createQNameWithUnknownType("$jscomp.typecheck." + prop);
    }

    private class AddChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private AddChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isInSyntheticScript(n)) {
                return;
            }
            switch (n.getToken()) {
                case FUNCTION: {
                    this.visitFunction(n);
                    break;
                }
                case RETURN: 
                case YIELD: {
                    this.visitTerminal(t, n);
                    break;
                }
            }
        }

        private void visitFunction(Node n) {
            Node block = n.getLastChild();
            Node insertionPoint = null;
            for (Node next = block.getFirstChild(); next != null && NodeUtil.isFunctionDeclaration(next); next = next.getNext()) {
                insertionPoint = next;
            }
            for (Node paramName : RuntimeTypeCheck.paramNamesOf(NodeUtil.getFunctionParameters(n))) {
                Preconditions.checkState(paramName.isName(), paramName);
                Node checkNode = this.createCheckTypeCallNode(paramName.getJSType(), paramName.cloneTree());
                if (checkNode == null) continue;
                checkNode = IR.exprResult(checkNode).srcrefTreeIfMissing(paramName);
                if (insertionPoint == null) {
                    block.addChildToFront(checkNode);
                } else {
                    checkNode.insertAfter(insertionPoint);
                }
                RuntimeTypeCheck.this.compiler.reportChangeToEnclosingScope(block);
                insertionPoint = checkNode;
            }
        }

        private void visitTerminal(NodeTraversal t, Node n) {
            Node checkNode;
            Node function = t.getEnclosingFunction();
            FunctionType funType = JSType.toMaybeFunctionType(function.getJSType());
            if (funType == null) {
                return;
            }
            Node retValue = n.getFirstChild();
            if (retValue == null) {
                return;
            }
            JSType expectedTerminalType = funType.getReturnType();
            if (function.isGeneratorFunction()) {
                expectedTerminalType = JsIterables.getElementType(expectedTerminalType, RuntimeTypeCheck.this.typeRegistry);
            }
            if (function.isAsyncFunction()) {
                expectedTerminalType = Promises.createAsyncReturnableType(RuntimeTypeCheck.this.typeRegistry, expectedTerminalType);
            }
            if (n.isYieldAll()) {
                expectedTerminalType = JsIterables.createIterableTypeOf(expectedTerminalType, RuntimeTypeCheck.this.typeRegistry);
            }
            if ((checkNode = this.createCheckTypeCallNode(expectedTerminalType, retValue.cloneTree())) == null) {
                return;
            }
            retValue.replaceWith(checkNode.srcrefTreeIfMissing(retValue));
            t.reportCodeChange();
        }

        private Node createCheckTypeCallNode(JSType type, Node expr) {
            AbstractCollection alternates;
            if (type.isUnionType()) {
                alternates = new TreeSet(ALPHA);
                alternates.addAll(type.toMaybeUnionType().getAlternates());
            } else {
                alternates = ImmutableList.of(type);
            }
            Node arrayNode = RuntimeTypeCheck.this.astFactory.createArraylit(new Node[0]);
            for (JSType alternate : alternates) {
                Node checkerNode = this.createCheckerNode(alternate);
                if (checkerNode == null) {
                    return null;
                }
                arrayNode.addChildToBack(checkerNode);
            }
            return RuntimeTypeCheck.this.astFactory.createCallWithUnknownType(RuntimeTypeCheck.this.jsCode("checkType"), expr, arrayNode);
        }

        private Node createCheckerNode(JSType type) {
            if (type.isNullType()) {
                return RuntimeTypeCheck.this.jsCode("nullChecker");
            }
            if (type.isBooleanValueType() || type.isNumberValueType() || type.isStringValueType() || type.isVoidType()) {
                return RuntimeTypeCheck.this.astFactory.createCallWithUnknownType(RuntimeTypeCheck.this.jsCode("valueChecker"), RuntimeTypeCheck.this.astFactory.createString(type.toString()));
            }
            if (type.isInstanceType()) {
                ObjectType objType = (ObjectType)type;
                String refName = objType.getReferenceName();
                if (refName.equals("Object")) {
                    return RuntimeTypeCheck.this.jsCode("objectChecker");
                }
                StaticSourceFile sourceFile = NodeUtil.getSourceFile(objType.getConstructor().getSource());
                if (sourceFile == null || sourceFile.isExtern()) {
                    return RuntimeTypeCheck.this.astFactory.createCallWithUnknownType(RuntimeTypeCheck.this.jsCode("externClassChecker"), RuntimeTypeCheck.this.astFactory.createString(refName));
                }
                return RuntimeTypeCheck.this.astFactory.createCallWithUnknownType(RuntimeTypeCheck.this.jsCode(objType.getConstructor().isInterface() ? "interfaceChecker" : "classChecker"), RuntimeTypeCheck.this.astFactory.createString(refName));
            }
            if (type.isFunctionType()) {
                return RuntimeTypeCheck.this.astFactory.createCallWithUnknownType(RuntimeTypeCheck.this.jsCode("valueChecker"), RuntimeTypeCheck.this.astFactory.createString("function"));
            }
            return null;
        }
    }

    private static class AddMarkers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;
        private final AstFactory astFactory;
        private NodeTraversal traversal;

        private AddMarkers(AbstractCompiler compiler, AstFactory astFactory) {
            this.compiler = compiler;
            this.astFactory = astFactory;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node unused) {
            this.traversal = t;
            FunctionType funType = JSType.toMaybeFunctionType(node.getJSType());
            switch (node.getToken()) {
                case FUNCTION: {
                    if (NodeUtil.isEs6Constructor(node)) break;
                    this.visitPossibleClassDeclaration(funType, this.findNodeToInsertAfter(node), this::addMarkerToFunction, node);
                    break;
                }
                case CLASS: {
                    this.visitPossibleClassDeclaration(funType, node.getChildAtIndex(2), this::addMarkerToClass, node);
                    break;
                }
            }
        }

        private void visitPossibleClassDeclaration(@Nullable FunctionType funType, Node insertionPoint, MarkerInserter inserter, Node srcref) {
            if (funType == null || funType.getSource() == null || !funType.isConstructor()) {
                return;
            }
            String className = NodeUtil.getName(funType.getSource());
            ArrayList<String> markerNames = new ArrayList<String>();
            for (ObjectType interfaceType : funType.getAllImplementedInterfaces()) {
                markerNames.add("implements__" + interfaceType.getReferenceName());
            }
            markerNames.sort(Comparator.naturalOrder());
            if (className != null) {
                markerNames.add(0, "instance_of__" + className);
            }
            for (String markerName : markerNames) {
                insertionPoint = inserter.insert(markerName, className, insertionPoint, srcref);
            }
        }

        private Node addMarkerToClass(String markerName, @Nullable String unused, Node classMembers, Node srcref) {
            Node function = this.astFactory.createFunction("", IR.paramList(new Node[0]), IR.block(), AstFactory.type(JSTypeNative.FUNCTION_TYPE));
            Node member = IR.computedProp(this.astFactory.createString(markerName), function).srcrefTree(srcref);
            member.putBooleanProp(Node.COMPUTED_PROP_METHOD, true);
            classMembers.addChildToBack(member);
            this.compiler.reportChangeToEnclosingScope(member);
            this.compiler.reportChangeToChangeScope(function);
            NodeUtil.addFeatureToScript(this.traversal.getCurrentScript(), FeatureSet.Feature.COMPUTED_PROPERTIES, this.compiler);
            return classMembers;
        }

        private Node addMarkerToFunction(String markerName, @Nullable String className, Node nodeToInsertAfter, Node srcref) {
            if (className == null) {
                return nodeToInsertAfter;
            }
            Node classNode = this.astFactory.createQNameWithUnknownType(className);
            Node assign = IR.exprResult(this.astFactory.createAssign(this.astFactory.createGetElem(this.astFactory.createPrototypeAccess(classNode), this.astFactory.createString(markerName)), this.astFactory.createBoolean(true))).srcrefTree(srcref);
            assign.insertAfter(nodeToInsertAfter);
            this.compiler.reportChangeToEnclosingScope(assign);
            return assign;
        }

        private Node findNodeToInsertAfter(Node n) {
            Node nodeToInsertAfter = AddMarkers.findEnclosingConstructorDeclaration(n);
            Node next = nodeToInsertAfter.getNext();
            while (next != null && this.isClassDefiningCall(next)) {
                nodeToInsertAfter = next;
                next = nodeToInsertAfter.getNext();
            }
            return nodeToInsertAfter;
        }

        private static Node findEnclosingConstructorDeclaration(Node n) {
            while (!n.getParent().isScript() && !n.getParent().isBlock()) {
                n = n.getParent();
            }
            return n;
        }

        private boolean isClassDefiningCall(Node next) {
            return NodeUtil.isExprCall(next) && this.compiler.getCodingConvention().getClassesDefinedByCall(next.getFirstChild()) != null;
        }

        private static interface MarkerInserter {
            public Node insert(String var1, @Nullable String var2, Node var3, Node var4);
        }
    }
}

