/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;

public final class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    @Nullable
    private final String sourceFileToCheck;

    private SourceInformationAnnotator(String sourceFileToCheck) {
        this.sourceFileToCheck = sourceFileToCheck;
    }

    static SourceInformationAnnotator create() {
        return new SourceInformationAnnotator(null);
    }

    static SourceInformationAnnotator createWithAnnotationChecks(String sourceFile) {
        return new SourceInformationAnnotator(sourceFile);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        String functionName;
        if (this.sourceFileToCheck != null) {
            Preconditions.checkState(this.sourceFileToCheck.equals(n.getSourceFileName()));
        }
        if (SourceInformationAnnotator.isStringNodeRequiringOriginalName(n)) {
            SourceInformationAnnotator.setOriginalName(n, n.getString());
            return;
        }
        if (n.isFunction() && (functionName = NodeUtil.getNearestFunctionName(n)) != null) {
            SourceInformationAnnotator.setOriginalName(n, functionName);
        }
    }

    public static boolean isStringNodeRequiringOriginalName(Node node) {
        switch (node.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: 
            case NAME: {
                return true;
            }
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case STRING_KEY: {
                return node.getParent().isObjectLit() && !node.isQuotedString();
            }
        }
        return false;
    }

    private static void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getOriginalName() == null) {
            n.setOriginalName(name);
        }
    }
}

