/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.io.BaseEncoding;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.StaticSourceFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;

@GwtIncompatible(value="Accesses the file system")
public class SourceMapResolver {
    private static final String BASE64_URL_PREFIX = "data:";
    private static final String BASE64_START = "base64,";
    private static final ImmutableSet<String> ACCEPTED_MEDIA_TYPES = ImmutableSet.of("application/json;charset=utf-8;", "application/json;");

    static SourceFile extractSourceMap(SourceFile jsFile, String sourceMapURL, boolean parseInlineSourceMaps) {
        if (parseInlineSourceMaps && sourceMapURL.startsWith(BASE64_URL_PREFIX)) {
            String extractedString = SourceMapResolver.extractBase64String(sourceMapURL);
            if (extractedString != null) {
                return SourceFile.fromCode(jsFile.getName() + ".inline.map", extractedString, StaticSourceFile.SourceKind.NON_CODE);
            }
            return null;
        }
        if (SourceMapResolver.isAbsolute(sourceMapURL)) {
            return null;
        }
        return SourceMapResolver.getRelativePath(jsFile.getName(), sourceMapURL);
    }

    @Nullable
    private static String extractBase64String(String url) {
        if (url.startsWith(BASE64_URL_PREFIX) && url.contains(BASE64_START)) {
            int base64StartIndex = url.indexOf(BASE64_START);
            String mediaType = url.substring(BASE64_URL_PREFIX.length(), base64StartIndex);
            if (ACCEPTED_MEDIA_TYPES.contains(mediaType)) {
                byte[] data = BaseEncoding.base64().decode(url.substring(base64StartIndex + BASE64_START.length()));
                return new String(data, StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    private static boolean isAbsolute(String url) {
        try {
            return new URI(url).isAbsolute() || url.startsWith("/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Sourcemap url was invalid: " + url, e);
        }
    }

    @Nullable
    static SourceFile getRelativePath(String baseFilePath, String relativePath) {
        return SourceFile.builder().withPath(FileSystems.getDefault().getPath(baseFilePath, new String[0]).resolveSibling(relativePath).normalize()).withKind(StaticSourceFile.SourceKind.NON_CODE).build();
    }
}

