/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashSet;

class StrictModeCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType USE_OF_WITH = DiagnosticType.error("JSC_USE_OF_WITH", "The 'with' statement cannot be used in strict mode.");
    static final DiagnosticType EVAL_DECLARATION = DiagnosticType.error("JSC_EVAL_DECLARATION", "\"eval\" cannot be redeclared in strict mode");
    static final DiagnosticType EVAL_ASSIGNMENT = DiagnosticType.error("JSC_EVAL_ASSIGNMENT", "the \"eval\" object cannot be reassigned in strict mode");
    static final DiagnosticType ARGUMENTS_DECLARATION = DiagnosticType.error("JSC_ARGUMENTS_DECLARATION", "\"arguments\" cannot be redeclared in strict mode");
    static final DiagnosticType ARGUMENTS_ASSIGNMENT = DiagnosticType.error("JSC_ARGUMENTS_ASSIGNMENT", "the \"arguments\" object cannot be reassigned in strict mode");
    static final DiagnosticType ARGUMENTS_CALLEE_FORBIDDEN = DiagnosticType.error("JSC_ARGUMENTS_CALLEE_FORBIDDEN", "\"arguments.callee\" cannot be used in strict mode");
    static final DiagnosticType ARGUMENTS_CALLER_FORBIDDEN = DiagnosticType.error("JSC_ARGUMENTS_CALLER_FORBIDDEN", "\"arguments.caller\" cannot be used in strict mode");
    static final DiagnosticType FUNCTION_CALLER_FORBIDDEN = DiagnosticType.error("JSC_FUNCTION_CALLER_FORBIDDEN", "A function''s \"caller\" property cannot be used in strict mode");
    static final DiagnosticType FUNCTION_ARGUMENTS_PROP_FORBIDDEN = DiagnosticType.error("JSC_FUNCTION_ARGUMENTS_PROP_FORBIDDEN", "A function''s \"arguments\" property cannot be used in strict mode");
    static final DiagnosticType DELETE_VARIABLE = DiagnosticType.error("JSC_DELETE_VARIABLE", "variables, functions, and arguments cannot be deleted in strict mode");
    static final DiagnosticType DUPLICATE_MEMBER = DiagnosticType.warning("JSC_DUPLICATE_MEMBER", "Class or object literal contains duplicate member \"{0}\". In non-strict code, the last duplicate will overwrite the others.");
    private final AbstractCompiler compiler;
    private final CheckLevel defaultLevel;

    StrictModeCheck(AbstractCompiler compiler, CheckLevel defaultLevel) {
        this.compiler = compiler;
        this.defaultLevel = defaultLevel;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        NodeTraversal.traverse(this.compiler, root, new NonExternChecks());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isAssign()) {
            this.checkAssignment(n);
        } else if (n.isDelProp()) {
            this.checkDelete(t, n);
        } else if (n.isObjectLit()) {
            this.checkObjectLiteralOrClass(n);
        } else if (n.isClass()) {
            this.checkObjectLiteralOrClass(n.getLastChild());
        } else if (n.isWith()) {
            this.checkWith(n);
        }
    }

    private void checkWith(Node n) {
        boolean allowWith;
        JSDocInfo info = n.getJSDocInfo();
        boolean bl = allowWith = info != null && info.getSuppressions().contains("with");
        if (!allowWith) {
            this.report(n, USE_OF_WITH, new String[0]);
        }
    }

    private static boolean isDeclaration(Node n) {
        switch (n.getParent().getToken()) {
            case LET: 
            case CONST: 
            case VAR: 
            case CATCH: {
                return true;
            }
            case FUNCTION: {
                return n == n.getParent().getFirstChild();
            }
            case PARAM_LIST: {
                return n.getGrandparent().isFunction();
            }
        }
        return false;
    }

    private void checkAssignment(Node n) {
        if (n.getFirstChild().isName()) {
            if ("arguments".equals(n.getFirstChild().getString())) {
                this.report(n, ARGUMENTS_ASSIGNMENT, new String[0]);
            } else if ("eval".equals(n.getFirstChild().getString())) {
                this.report(n, EVAL_ASSIGNMENT, new String[0]);
            }
        }
    }

    private void checkDelete(NodeTraversal t, Node n) {
        Var v;
        if (n.getFirstChild().isName() && (v = (Var)t.getScope().getVar(n.getFirstChild().getString())) != null) {
            this.report(n, DELETE_VARIABLE, new String[0]);
        }
    }

    private void checkObjectLiteralOrClass(Node n) {
        HashSet getters = new HashSet();
        HashSet setters = new HashSet();
        HashSet<String> staticGetters = new HashSet<String>();
        HashSet staticSetters = new HashSet();
        for (Node key = n.getLastChild(); key != null; key = key.getPrevious()) {
            HashSet<String> set;
            if (key.isEmpty() || key.isComputedProp() || key.isSpread() || key.isComputedFieldDef()) continue;
            String keyName = key.getString();
            if (!key.isSetterDef()) {
                HashSet<String> hashSet = set = key.isStaticMember() ? staticGetters : getters;
                if (!set.add(keyName)) {
                    this.report(key, DUPLICATE_MEMBER, keyName);
                }
            }
            if (key.isGetterDef()) continue;
            HashSet<Object> hashSet = set = key.isStaticMember() ? staticSetters : setters;
            if (set.add(keyName)) continue;
            this.report(key, DUPLICATE_MEMBER, keyName);
        }
    }

    private static boolean isFunctionType(Node n) {
        JSType type = n.getJSType();
        return type != null && type.isFunctionType();
    }

    private void report(Node n, DiagnosticType diagnostic, String ... args) {
        this.compiler.report(JSError.make(n, this.defaultLevel, diagnostic, args));
    }

    private class NonExternChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private NonExternChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && StrictModeCheck.isDeclaration(n)) {
                this.checkDeclaration(n);
            } else if (n.isGetProp()) {
                this.checkGetProp(n);
            }
        }

        private void checkDeclaration(Node n) {
            if ("eval".equals(n.getString())) {
                StrictModeCheck.this.report(n, EVAL_DECLARATION, new String[0]);
            } else if ("arguments".equals(n.getString())) {
                StrictModeCheck.this.report(n, ARGUMENTS_DECLARATION, new String[0]);
            }
        }

        private void checkGetProp(Node n) {
            Node target = n.getFirstChild();
            String name = n.getString();
            if (name.equals("callee")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    StrictModeCheck.this.report(n, ARGUMENTS_CALLEE_FORBIDDEN, new String[0]);
                }
            } else if (name.equals("caller")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    StrictModeCheck.this.report(n, ARGUMENTS_CALLER_FORBIDDEN, new String[0]);
                } else if (StrictModeCheck.isFunctionType(target)) {
                    StrictModeCheck.this.report(n, FUNCTION_CALLER_FORBIDDEN, new String[0]);
                }
            } else if (name.equals("arguments") && StrictModeCheck.isFunctionType(target)) {
                StrictModeCheck.this.report(n, FUNCTION_ARGUMENTS_PROP_FORBIDDEN, new String[0]);
            }
        }
    }
}

