/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.resources;

import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.BuildException;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.Project;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.DataType;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.Resource;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.ResourceCollection;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.resources.AppendableResourceCollection;
import com.google.javascript.jscomp.jarjar.org.apache.tools.ant.types.resources.FailFast;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.stream.Collectors;

public class Resources
extends DataType
implements AppendableResourceCollection {
    public static final ResourceCollection NONE = new ResourceCollection(){

        @Override
        public boolean isFilesystemOnly() {
            return true;
        }

        @Override
        public Iterator<Resource> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }
    };
    public static final Iterator<Resource> EMPTY_ITERATOR = new Iterator<Resource>(){

        @Override
        public Resource next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private List<ResourceCollection> rc;
    private Collection<Resource> coll;
    private boolean cache = false;

    public Resources() {
    }

    public Resources(Project project) {
        this.setProject(project);
    }

    public synchronized void setCache(boolean b) {
        this.cache = b;
    }

    @Override
    public synchronized void add(ResourceCollection c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        if (this.rc == null) {
            this.rc = Collections.synchronizedList(new ArrayList());
        }
        this.rc.add(c);
        this.invalidateExistingIterators();
        this.coll = null;
        this.setChecked(false);
    }

    @Override
    public synchronized Iterator<Resource> iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.validate();
        return new FailFast(this, this.coll.iterator());
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.validate();
        return this.coll.size();
    }

    @Override
    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return this.getRef().isFilesystemOnly();
        }
        this.validate();
        return this.getNested().stream().allMatch(ResourceCollection::isFilesystemOnly);
    }

    @Override
    public synchronized String toString() {
        if (this.isReference()) {
            return this.getRef().toString();
        }
        this.validate();
        if (this.coll == null || this.coll.isEmpty()) {
            return "";
        }
        return this.coll.stream().map(Object::toString).collect(Collectors.joining(File.pathSeparator));
    }

    @Override
    protected void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (ResourceCollection resourceCollection : this.getNested()) {
                if (!(resourceCollection instanceof DataType)) continue;
                Resources.pushAndInvokeCircularReferenceCheck((DataType)((Object)resourceCollection), stk, p);
            }
            this.setChecked(true);
        }
    }

    protected void invalidateExistingIterators() {
        FailFast.invalidate(this);
    }

    private ResourceCollection getRef() {
        return this.getCheckedRef(ResourceCollection.class);
    }

    private synchronized void validate() {
        this.dieOnCircularReference();
        this.coll = this.coll == null ? new MyCollection() : this.coll;
    }

    private synchronized List<ResourceCollection> getNested() {
        return this.rc == null ? Collections.emptyList() : this.rc;
    }

    private class MyCollection
    extends AbstractCollection<Resource> {
        private Collection<Resource> cached;

        MyCollection() {
        }

        @Override
        public int size() {
            return this.getCache().size();
        }

        @Override
        public Iterator<Resource> iterator() {
            return this.getCache().iterator();
        }

        private synchronized Collection<Resource> getCache() {
            Collection<Resource> coll = this.cached;
            if (coll == null) {
                coll = new ArrayList<Resource>();
                new MyIterator().forEachRemaining(coll::add);
                if (Resources.this.cache) {
                    this.cached = coll;
                }
            }
            return coll;
        }

        private class MyIterator
        implements Iterator<Resource> {
            private Iterator<ResourceCollection> rci;
            private Iterator<Resource> ri;

            private MyIterator() {
                this.rci = Resources.this.getNested().iterator();
                this.ri = null;
            }

            @Override
            public boolean hasNext() {
                boolean result;
                boolean bl = result = this.ri != null && this.ri.hasNext();
                while (!result && this.rci.hasNext()) {
                    this.ri = this.rci.next().iterator();
                    result = this.ri.hasNext();
                }
                return result;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.ri.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

