/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class CheckConstantCaseNames
implements NodeTraversal.Callback,
CompilerPass {
    public static final DiagnosticType MISSING_CONST_PROPERTY = DiagnosticType.disabled("JSC_MISSING_CONST_ON_CONSTANT_CASE", "CONSTANT_CASE name \"{0}\" is constant-by-convention, so must be explicitly `const` or @const");
    public static final DiagnosticType REASSIGNED_CONSTANT_CASE_NAME = DiagnosticType.disabled("JSC_REASSIGNED_CONSTANT_CASE_NAME", "CONSTANT_CASE name \"{0}\" is constant-by-convention but is reassigned. Use camelCase instead.");
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private LinkedHashMap<String, Node> invalidNamesPerModule = new LinkedHashMap();
    private LinkedHashSet<String> reassignedNames = new LinkedHashSet();

    public CheckConstantCaseNames(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            return n.hasChildren() && n.getFirstChild().isModuleBody();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isModuleBody()) {
            this.reportWarningsAndClear();
            return;
        }
        switch (n.getToken()) {
            case VAR: 
            case LET: {
                if (!t.inModuleScope()) {
                    return;
                }
                JSDocInfo info = n.getJSDocInfo();
                if (info != null && info.hasConstAnnotation()) break;
                for (Node name : NodeUtil.findLhsNodesInNode(n)) {
                    if (!this.convention.isConstant(name.getString())) continue;
                    this.invalidNamesPerModule.put(name.getString(), name);
                }
                break;
            }
            case NAME: {
                if (!this.invalidNamesPerModule.containsKey(n.getString())) {
                    return;
                }
                if (!NodeUtil.isLValue(n)) {
                    return;
                }
                Var v = (Var)t.getScope().getVar(n.getString());
                if (!v.getScopeRoot().isModuleBody()) break;
                this.reassignedNames.add(n.getString());
                break;
            }
        }
    }

    private void reportWarningsAndClear() {
        for (Node nameNode : this.invalidNamesPerModule.values()) {
            String name = nameNode.getString();
            if (this.reassignedNames.contains(name)) {
                this.compiler.report(JSError.make(nameNode, REASSIGNED_CONSTANT_CASE_NAME, name));
                continue;
            }
            this.compiler.report(JSError.make(nameNode, MISSING_CONST_PROPERTY, name));
        }
        this.invalidNamesPerModule = new LinkedHashMap();
        this.reassignedNames = new LinkedHashSet();
    }
}

