/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CheckExtraRequires
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<String, Node> requires = new HashMap<String, Node>();
    private final Set<String> usages = new HashSet<String>();
    @Nullable
    private final ImmutableSet<String> requiresToRemove;
    public static final DiagnosticType EXTRA_REQUIRE_WARNING = DiagnosticType.disabled("JSC_EXTRA_REQUIRE_WARNING", "extra require: ''{0}'' is never referenced in this file");
    private static final ImmutableSet<String> DEFAULT_EXTRA_NAMESPACES = ImmutableSet.of("goog.testing.asserts", "goog.testing.jsunit", "goog.testing.JsTdTestCaseAdapter");

    public CheckExtraRequires(AbstractCompiler compiler, @Nullable ImmutableSet<String> requiresToRemove) {
        this.compiler = compiler;
        this.requiresToRemove = requiresToRemove;
    }

    @Override
    public void process(Node externs, Node root) {
        this.reset();
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private String extractNamespace(Node call, String ... primitiveNames) {
        Node callee = call.getFirstChild();
        if (!callee.isGetProp()) {
            return null;
        }
        for (String primitiveName : primitiveNames) {
            Node target;
            if (!callee.matchesQualifiedName(primitiveName) || (target = callee.getNext()) == null || !target.isStringLit()) continue;
            return target.getString();
        }
        return null;
    }

    private String extractNamespaceIfRequire(Node call) {
        return this.extractNamespace(call, "goog.require", "goog.requireType");
    }

    private String extractNamespaceIfForwardDeclare(Node call) {
        return this.extractNamespace(call, "goog.forwardDeclare");
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.maybeAddJsDocUsages(n);
        switch (n.getToken()) {
            case NAME: {
                if (NodeUtil.isLValue(n) || parent.isGetProp() || parent.isImportSpec()) break;
                this.visitQualifiedName(n);
                break;
            }
            case GETPROP: {
                if (parent.isGetProp() || !n.isQualifiedName()) break;
                this.visitQualifiedName(n);
                break;
            }
            case CALL: {
                this.visitCallNode(n, parent);
                break;
            }
            case SCRIPT: {
                this.visitScriptNode();
                this.reset();
                break;
            }
            case IMPORT: {
                this.visitImportNode(n);
                break;
            }
        }
    }

    private void reset() {
        this.usages.clear();
        this.requires.clear();
    }

    private void visitScriptNode() {
        for (Map.Entry<String, Node> entry : this.requires.entrySet()) {
            String require = entry.getKey();
            Node call = entry.getValue();
            if (this.usages.contains(require) || this.requiresToRemove != null && !this.requiresToRemove.contains(require)) continue;
            this.reportExtraRequireWarning(call, require);
        }
    }

    private void reportExtraRequireWarning(Node call, String require) {
        if (DEFAULT_EXTRA_NAMESPACES.contains(require)) {
            return;
        }
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(call);
        if (jsDoc != null && jsDoc.getSuppressions().contains("extraRequire")) {
            return;
        }
        this.compiler.report(JSError.make(call, EXTRA_REQUIRE_WARNING, require));
    }

    private void visitRequire(String localName, Node node) {
        this.requires.putIfAbsent(localName, node);
    }

    private void visitImportNode(Node importNode) {
        Node namedImports;
        Node defaultImport = importNode.getFirstChild();
        if (defaultImport.isName()) {
            this.visitRequire(defaultImport.getString(), importNode);
        }
        if ((namedImports = defaultImport.getNext()).isImportSpecs()) {
            for (Node importSpec = namedImports.getFirstChild(); importSpec != null; importSpec = importSpec.getNext()) {
                this.visitRequire(importSpec.getLastChild().getString(), importNode);
            }
        }
    }

    private void visitForwardDeclare(String namespace, Node forwardDeclareCall, Node parent) {
        this.visitGoogRequire(namespace, forwardDeclareCall, parent);
    }

    private void visitGoogRequire(String namespace, Node googRequireCall, Node parent) {
        if (parent.isName()) {
            this.visitRequire(parent.getString(), googRequireCall);
        } else if (parent.isDestructuringLhs() && parent.getFirstChild().isObjectPattern()) {
            if (parent.getFirstChild().hasChildren()) {
                for (Node stringKey = parent.getFirstFirstChild(); stringKey != null; stringKey = stringKey.getNext()) {
                    Node importName = stringKey.getFirstChild();
                    if (!importName.isName()) continue;
                    this.visitRequire(importName.getString(), importName);
                }
            } else {
                this.visitRequire(namespace, googRequireCall);
            }
        } else {
            this.visitRequire(namespace, googRequireCall);
        }
    }

    private void visitCallNode(Node call, Node parent) {
        String required = this.extractNamespaceIfRequire(call);
        if (required != null) {
            this.visitGoogRequire(required, call, parent);
            return;
        }
        String declare = this.extractNamespaceIfForwardDeclare(call);
        if (declare != null) {
            this.visitForwardDeclare(declare, call, parent);
            return;
        }
        Node callee = call.getFirstChild();
        if (callee.matchesQualifiedName("goog.module.get") && call.getSecondChild().isStringLit()) {
            this.usages.add(call.getSecondChild().getString());
        }
    }

    private void addUsagesOfAllPrefixes(QualifiedName qualifiedName) {
        this.usages.add(qualifiedName.join());
        while (!qualifiedName.isSimple()) {
            qualifiedName = qualifiedName.getOwner();
            this.usages.add(qualifiedName.join());
        }
    }

    private void visitQualifiedName(Node n) {
        Preconditions.checkArgument(n.isQualifiedName(), n);
        this.addUsagesOfAllPrefixes(n.getQualifiedNameObject());
    }

    private void maybeAddJsDocUsages(Node n) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            return;
        }
        info.getTypeExpressions().stream().flatMap(e -> e.getAllTypeNames().stream()).map(QualifiedName::of).forEach(this::addUsagesOfAllPrefixes);
    }
}

