/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

public final class CheckNestedNames
implements CompilerPass,
NodeTraversal.Callback {
    public static final DiagnosticType NESTED_NAME_IN_GOOG_MODULE = DiagnosticType.disabled("JSC_NESTED_NAME_IN_GOOG_MODULE", "A nested {0} is created on the name `{1}`. Fix this linter finding by converting the module-level static property assignment on `{1}` into a module-level flat name (i.e. change `{1}.prop = ...` into `{1}_prop = ...`. You can (if required) export this flat name using named exports (`exports.{1}_prop = {1}_prop`).");
    private final AbstractCompiler compiler;
    private static final ImmutableMap<DeclarationKind, String> NESTED_KIND_TO_REPORT = ImmutableMap.of(DeclarationKind.CLASS, "class", DeclarationKind.ENUM, "enum", DeclarationKind.INTERFACE, "interface", DeclarationKind.TYPEDEF, "typedef");

    public CheckNestedNames(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isScript()) {
            return n.getBooleanProp(Node.GOOG_MODULE);
        }
        return nodeTraversal.inGlobalOrModuleScope();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Preconditions.checkArgument(t.inGlobalOrModuleScope());
        if (!n.isGetProp() || !n.isQualifiedName()) {
            return;
        }
        Node targetGetProp = CheckNestedNames.getTargetGetProp(n);
        if ((parent.isAssign() || parent.isExprResult()) && n.isFirstChildOf(parent) && !CheckNestedNames.isDotPrototype(targetGetProp)) {
            Node owner = targetGetProp.getFirstChild();
            if (!owner.isName() || owner.getString().equals("exports")) {
                return;
            }
            String ownerName = owner.getString();
            DeclarationKind declarationKind = this.getNestedDeclarationKind(n, parent);
            if (NESTED_KIND_TO_REPORT.containsKey((Object)declarationKind)) {
                String nestedKind = NESTED_KIND_TO_REPORT.get((Object)declarationKind);
                t.report(targetGetProp, NESTED_NAME_IN_GOOG_MODULE, nestedKind, ownerName);
            }
        }
    }

    private static Node getTargetGetProp(Node n) {
        Preconditions.checkArgument(n.isGetProp(), n);
        if (n.getFirstChild().isGetProp()) {
            return CheckNestedNames.getTargetGetProp(n.getFirstChild());
        }
        return n;
    }

    private static boolean isDotPrototype(Node getProp) {
        return getProp.isGetProp() && getProp.getString().equals("prototype");
    }

    private DeclarationKind getNestedDeclarationKind(Node lhs, Node parent) {
        Preconditions.checkArgument(lhs.isFirstChildOf(parent), lhs);
        if (lhs.getTypedefTypeProp() != null) {
            return DeclarationKind.TYPEDEF;
        }
        JSType type = lhs.getJSType();
        if (type != null) {
            if (type.isEnumType()) {
                return DeclarationKind.ENUM;
            }
            if (type.isInterface()) {
                return DeclarationKind.INTERFACE;
            }
            if (type.isConstructor()) {
                return DeclarationKind.CLASS;
            }
        }
        return null;
    }

    private static enum DeclarationKind {
        CLASS,
        ENUM,
        TYPEDEF,
        INTERFACE;

    }
}

