/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.refactoring.Matcher;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;

public final class Matchers {
    public static Matcher anything() {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return true;
            }
        };
    }

    public static Matcher allOf(final Matcher ... matchers) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                for (Matcher m : matchers) {
                    if (m.matches(node, metadata)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Matcher anyOf(final Matcher ... matchers) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                for (Matcher m : matchers) {
                    if (!m.matches(node, metadata)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Matcher not(final Matcher matcher) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return !matcher.matches(node, metadata);
            }
        };
    }

    public static Matcher constructor() {
        return Matchers.constructor(null);
    }

    public static Matcher constructor(final String name) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSDocInfo info = node.getJSDocInfo();
                if (info != null && info.isConstructor()) {
                    Node firstChild = node.getFirstChild();
                    if (name == null) {
                        return true;
                    }
                    if ((firstChild.isGetProp() || firstChild.isName()) && firstChild.matchesQualifiedName(name)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Matcher newClass() {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return node.isNew();
            }
        };
    }

    public static Matcher newClass(final String className) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                if (!node.isNew()) {
                    return false;
                }
                JSType providedJsType = Matchers.getJsType(metadata, className);
                if (providedJsType == null) {
                    return false;
                }
                JSType jsType = node.getJSType();
                if (jsType == null) {
                    return false;
                }
                jsType = jsType.restrictByNotNullOrUndefined();
                return Matchers.areTypesEquivalentIgnoringGenerics(jsType, providedJsType);
            }
        };
    }

    public static Matcher functionCall() {
        return Matchers.functionCall(null);
    }

    public static Matcher functionCall(final String name) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return node.isCall() && Matchers.propertyAccess(name).matches(node.getFirstChild(), metadata);
            }
        };
    }

    public static Matcher functionCallWithNumArgs(final int numArgs) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return node.isCall() && node.hasXChildren(numArgs + 1);
            }
        };
    }

    public static Matcher functionCallWithNumArgs(String name, int numArgs) {
        return Matchers.allOf(Matchers.functionCallWithNumArgs(numArgs), Matchers.functionCall(name));
    }

    public static Matcher googRequirelike(String namespace) {
        return (node, metadata) -> Matchers.googRequirelike().matches(node, metadata) && node.getSecondChild().isStringLit() && node.getSecondChild().getString().equals(namespace);
    }

    public static Matcher googRequirelike() {
        return Matchers.anyOf(Matchers.googRequire(), Matchers.googRequireType(), Matchers.googForwardDeclare());
    }

    public static Matcher googRequire() {
        return Matchers.functionCall("goog.require");
    }

    public static Matcher googRequireType() {
        return Matchers.functionCall("goog.requireType");
    }

    public static Matcher googForwardDeclare() {
        return Matchers.functionCall("goog.forwardDeclare");
    }

    public static Matcher googModule() {
        return Matchers.functionCall("goog.module");
    }

    public static Matcher googModuleOrProvide() {
        return Matchers.anyOf(Matchers.googModule(), Matchers.functionCall("goog.provide"));
    }

    public static Matcher propertyAccess() {
        return Matchers.propertyAccess(null);
    }

    public static Matcher propertyAccess(final String name) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                if (node.isGetProp()) {
                    if (name == null) {
                        return true;
                    }
                    if (node.matchesQualifiedName(name)) {
                        return true;
                    }
                    if (name.contains(".prototype.")) {
                        return Matchers.matchesPrototypeInstanceVar(node, metadata, name);
                    }
                }
                return false;
            }
        };
    }

    public static Matcher enumDefinition() {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSType jsType = node.getJSType();
                return jsType != null && jsType.isEnumType();
            }
        };
    }

    public static Matcher enumDefinitionOfType(final String type) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSType providedJsType = Matchers.getJsType(metadata, type);
                if (providedJsType == null) {
                    return false;
                }
                providedJsType = providedJsType.restrictByNotNullOrUndefined();
                JSType jsType = node.getJSType();
                return jsType != null && jsType.isEnumType() && providedJsType.equals(jsType.toMaybeEnumType().getElementsType().getPrimitiveType());
            }
        };
    }

    public static Matcher assignmentWithRhs(final Matcher rhsMatcher) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                return node.isAssign() && rhsMatcher.matches(node.getLastChild(), metadata);
            }
        };
    }

    public static Matcher prototypeVariableDeclaration() {
        return Matchers.matcherForPrototypeDeclaration(false);
    }

    public static Matcher prototypeMethodDeclaration() {
        return Matchers.matcherForPrototypeDeclaration(true);
    }

    public static Matcher jsDocType(final String type) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSType providedJsType = Matchers.getJsType(metadata, type);
                if (providedJsType == null) {
                    return false;
                }
                providedJsType = providedJsType.restrictByNotNullOrUndefined();
                JSDocInfo jsDoc = NodeUtil.isNameDeclaration(node.getParent()) ? node.getParent().getJSDocInfo() : node.getJSDocInfo();
                JSType jsType = node.getJSType();
                return jsDoc != null && jsDoc.hasType() && jsType != null && providedJsType.equals(jsType.restrictByNotNullOrUndefined());
            }
        };
    }

    public static Matcher constructorPropertyDeclaration() {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSDocInfo jsDoc;
                if (!(node.isAssign() && node.getFirstChild().isGetProp() && node.getFirstFirstChild().isThis())) {
                    return false;
                }
                while (node != null && !node.isFunction()) {
                    node = node.getParent();
                }
                if (node != null && node.isFunction() && (jsDoc = NodeUtil.getBestJSDocInfo(node)) != null) {
                    return jsDoc.isConstructor();
                }
                return false;
            }
        };
    }

    public static Matcher isPrivate() {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(node);
                if (jsDoc != null) {
                    return jsDoc.getVisibility() == JSDocInfo.Visibility.PRIVATE;
                }
                return false;
            }
        };
    }

    private static JSType getJsType(NodeMetadata metadata, String type) {
        return metadata.getCompiler().getTypeRegistry().getGlobalType(type);
    }

    private static JSType getJsType(NodeMetadata metadata, JSTypeNative nativeType) {
        return metadata.getCompiler().getTypeRegistry().getNativeType(nativeType);
    }

    private static boolean areTypesEquivalentIgnoringGenerics(JSType a, JSType b) {
        boolean equivalent = a.equals(b);
        if (equivalent) {
            return true;
        }
        if (a.isTemplatizedType()) {
            return a.toMaybeTemplatizedType().getReferencedType().equals(b);
        }
        return false;
    }

    private static boolean matchesPrototypeInstanceVar(Node node, NodeMetadata metadata, String name) {
        String[] parts = name.split(".prototype.");
        String className = parts[0];
        String propertyName = parts[1];
        JSType providedJsType = Matchers.getJsType(metadata, className);
        if (providedJsType == null) {
            return false;
        }
        JSType jsType = null;
        if (node.hasChildren()) {
            jsType = node.getFirstChild().getJSType();
        }
        if (jsType == null) {
            return false;
        }
        if (!(jsType = jsType.restrictByNotNullOrUndefined()).isUnknownType() && !jsType.isAllType() && jsType.isSubtypeOf(providedJsType)) {
            if (node.isName() && propertyName.equals(node.getString())) {
                return true;
            }
            if (node.isGetProp() && propertyName.equals(node.getString())) {
                return true;
            }
        }
        return false;
    }

    private static Matcher matcherForPrototypeDeclaration(final boolean requireFunctionType) {
        return new Matcher(){

            @Override
            public boolean matches(Node node, NodeMetadata metadata) {
                Node firstChild = node.getFirstChild();
                if (node.isGetProp() && firstChild.isGetProp() && "prototype".equals(firstChild.getString())) {
                    JSType fnJsType = Matchers.getJsType(metadata, JSTypeNative.FUNCTION_FUNCTION_TYPE);
                    JSType jsType = node.getJSType();
                    if (jsType == null) {
                        return false;
                    }
                    if (requireFunctionType) {
                        return jsType.canCastTo(fnJsType);
                    }
                    return !jsType.canCastTo(fnJsType);
                }
                return false;
            }
        };
    }

    private Matchers() {
    }
}

