/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.List;
import java.util.Objects;

final class ArrowType
extends JSType {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.ARROW;
    private final ImmutableList<FunctionType.Parameter> parameterList;
    private JSType returnType;
    final boolean returnTypeInferred;

    ArrowType(JSTypeRegistry registry, @Nullable List<FunctionType.Parameter> parameters, @Nullable JSType returnType, boolean returnTypeInferred) {
        super(registry);
        this.parameterList = parameters == null ? registry.createParametersWithVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) : ImmutableList.copyOf(parameters);
        this.returnType = returnType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : returnType;
        this.returnTypeInferred = returnTypeInferred;
        registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    int recursionUnsafeHashCode() {
        int hashCode = Objects.hashCode(this.returnType);
        for (FunctionType.Parameter param : this.parameterList) {
            hashCode = hashCode * 31 + Objects.hashCode(param.getJSType());
        }
        return hashCode;
    }

    public JSType getReturnType() {
        return this.returnType;
    }

    ImmutableList<FunctionType.Parameter> getParameterList() {
        return this.parameterList;
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSType getGreatestSubtype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tri testForEquality(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.returnType = ArrowType.safeResolve(this.returnType, reporter);
        for (FunctionType.Parameter param : this.parameterList) {
            param.getJSType().resolve(reporter);
        }
        return this;
    }

    boolean hasUnknownParamsOrReturn() {
        for (FunctionType.Parameter param : this.parameterList) {
            JSType type = param.getJSType();
            if (!type.isUnknownType()) continue;
            return true;
        }
        return this.returnType == null || this.returnType.isUnknownType();
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        sb.append("[ArrowType]");
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.returnType.hasAnyTemplateTypes() || this.hasTemplatedParameterType();
    }

    private boolean hasTemplatedParameterType() {
        for (FunctionType.Parameter param : this.parameterList) {
            JSType type = param.getJSType();
            if (!type.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }
}

