/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.linker.backend;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.scalajs.linker.backend.LinkerBackendImpl;
import org.scalajs.linker.backend.javascript.ByteArrayWriter;
import org.scalajs.linker.backend.javascript.SourceMapWriter;
import org.scalajs.linker.backend.wasmemitter.Emitter;
import org.scalajs.linker.backend.wasmemitter.Emitter$Config$;
import org.scalajs.linker.backend.webassembly.BinaryWriter$;
import org.scalajs.linker.backend.webassembly.Modules;
import org.scalajs.linker.backend.webassembly.TextWriter$;
import org.scalajs.linker.interface.IRFile;
import org.scalajs.linker.interface.ModuleKind;
import org.scalajs.linker.interface.ModuleKind$ESModule$;
import org.scalajs.linker.interface.OutputDirectory;
import org.scalajs.linker.interface.Report;
import org.scalajs.linker.interface.unstable.OutputDirectoryImpl;
import org.scalajs.linker.interface.unstable.OutputDirectoryImpl$;
import org.scalajs.linker.interface.unstable.OutputPatternsImpl$;
import org.scalajs.linker.interface.unstable.ReportImpl;
import org.scalajs.linker.standard.LinkedGlobalInfo;
import org.scalajs.linker.standard.ModuleSet;
import org.scalajs.linker.standard.SymbolRequirement;
import org.scalajs.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\b\u0010\u0005aA\u0011\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0013\t\u000b\u0019\u0002A\u0011A\u0014\t\u000f)\u0002!\u0019!C\u0001W!1\u0011\b\u0001Q\u0001\n1BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019y\u0005\u0001)A\u0005\u0013\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003k\u0001\u0011\u00051\u000e\u0003\u0004k\u0001\u0011%\u00111\u0004\u0002\u0019/\u0016\u0014\u0017i]:f[\nd\u0017\u0010T5oW\u0016\u0014()Y2lK:$'B\u0001\t\u0012\u0003\u001d\u0011\u0017mY6f]\u0012T!AE\n\u0002\r1Lgn[3s\u0015\t!R#A\u0004tG\u0006d\u0017M[:\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\b\n\u0005qy!!\u0005'j].,'OQ1dW\u0016tG-S7qY\u000611m\u001c8gS\u001e\u0004\"a\b\u0012\u000f\u0005i\u0001\u0013BA\u0011\u0010\u0003Ea\u0015N\\6fe\n\u000b7m[3oI&k\u0007\u000f\\\u0005\u0003G\u0011\u0012aaQ8oM&<'BA\u0011\u0010\u0013\ti2$\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"A\u0007\u0001\t\u000bu\u0011\u0001\u0019\u0001\u0010\u0002!1|\u0017\rZ3s\u0015N3\u0015\u000e\\3OC6,W#\u0001\u0017\u0011\u000552dB\u0001\u00185!\ty#'D\u00011\u0015\t\tt#\u0001\u0004=e>|GO\u0010\u0006\u0002g\u0005)1oY1mC&\u0011QGM\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026e\u0005\tBn\\1eKJT5KR5mK:\u000bW.\u001a\u0011\u0002\u001b\u0019\u0014\u0018mZ7f]RLe\u000eZ3y+\u0005a\u0004CA\u001fD\u001d\tq\u0014)D\u0001@\u0015\t\u0001u\"\u0001\u0006kCZ\f7o\u0019:jaRL!AQ \u0002\u001fM{WO]2f\u001b\u0006\u0004xK]5uKJL!\u0001R#\u0003\u000b%sG-\u001a=\u000b\u0005\t{\u0014A\u00044sC\u001elWM\u001c;J]\u0012,\u0007\u0010I\u0001\bK6LG\u000f^3s+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0010\u0003-9\u0018m]7f[&$H/\u001a:\n\u00059[%aB#nSR$XM]\u0001\tK6LG\u000f^3sA\u0005\u00112/_7c_2\u0014V-];je\u0016lWM\u001c;t+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+\u0012\u0003!\u0019H/\u00198eCJ$\u0017BA,U\u0005E\u0019\u00160\u001c2pYJ+\u0017/^5sK6,g\u000e^\u0001\u0014gfl'm\u001c7SKF,\u0018N]3nK:$8\u000fI\u0001\u0010S:TWm\u0019;fI&\u0013f)\u001b7fgV\t1\fE\u0002]C\u0012t!!X0\u000f\u0005=r\u0016\"A\u001a\n\u0005\u0001\u0014\u0014a\u00029bG.\fw-Z\u0005\u0003E\u000e\u00141aU3r\u0015\t\u0001'\u0007\u0005\u0002fQ6\taM\u0003\u0002h#\u0005I\u0011N\u001c;fe\u001a\f7-Z\u0005\u0003S\u001a\u0014a!\u0013*GS2,\u0017\u0001B3nSR$b\u0001\\>\u0002\u0002\u0005-ACA7w!\rq\u0017o]\u0007\u0002_*\u0011\u0001OM\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001:p\u0005\u00191U\u000f^;sKB\u0011Q\r^\u0005\u0003k\u001a\u0014aAU3q_J$\b\"B<\r\u0001\bA\u0018AA3d!\tq\u00170\u0003\u0002{_\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006y2\u0001\r!`\u0001\n[>$W\u000f\\3TKR\u0004\"a\u0015@\n\u0005}$&!C'pIVdWmU3u\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000b\taa\\;uaV$\bcA3\u0002\b%\u0019\u0011\u0011\u00024\u0003\u001f=+H\u000f];u\t&\u0014Xm\u0019;pefDq!!\u0004\r\u0001\u0004\ty!\u0001\u0004m_\u001e<WM\u001d\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\n\u0002\u000f1|wmZ5oO&!\u0011\u0011DA\n\u0005\u0019aunZ4feRQ\u0011QDA\u0011\u0003g\ti$a\u0010\u0015\u00075\fy\u0002C\u0003x\u001b\u0001\u000f\u0001\u0010C\u0004\u0002$5\u0001\r!!\n\u0002\u0015=tG._'pIVdW\r\u0005\u0003\u0002(\u00055bbA*\u0002*%\u0019\u00111\u0006+\u0002\u00135{G-\u001e7f'\u0016$\u0018\u0002BA\u0018\u0003c\u0011a!T8ek2,'bAA\u0016)\"9\u0011QG\u0007A\u0002\u0005]\u0012AC4m_\n\fG.\u00138g_B\u00191+!\u000f\n\u0007\u0005mBK\u0001\tMS:\\W\rZ$m_\n\fG.\u00138g_\"9\u00111A\u0007A\u0002\u0005\u0015\u0001bBA\u0007\u001b\u0001\u0007\u0011q\u0002")
public final class WebAssemblyLinkerBackend
extends LinkerBackendImpl {
    private final String loaderJSFileName;
    private final SourceMapWriter.Index fragmentIndex;
    private final Emitter emitter;
    private final SymbolRequirement symbolRequirements;

    public String loaderJSFileName() {
        return this.loaderJSFileName;
    }

    private SourceMapWriter.Index fragmentIndex() {
        return this.fragmentIndex;
    }

    private Emitter emitter() {
        return this.emitter;
    }

    @Override
    public SymbolRequirement symbolRequirements() {
        return this.symbolRequirements;
    }

    @Override
    public Seq<IRFile> injectedIRFiles() {
        return this.emitter().injectedIRFiles();
    }

    @Override
    public Future<Report> emit(ModuleSet moduleSet, OutputDirectory output, Logger logger, ExecutionContext ec) {
        List<ModuleSet.Module> list = moduleSet.modules();
        if (Nil$.MODULE$.equals(list)) {
            OutputDirectoryImpl outputImpl = OutputDirectoryImpl$.MODULE$.fromOutputDirectory(output);
            return outputImpl.listFiles(ec).flatMap((Function1 & Serializable)currentFilesList -> Future$.MODULE$.traverse((IterableOnce)currentFilesList, (Function1 & Serializable)f -> outputImpl.delete((String)f, ec), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)x$1 -> {
                List list = x$1;
                return new ReportImpl((Iterable<Report.Module>)Nil$.MODULE$);
            }, ec), ec);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            ModuleSet.Module onlyModule = (ModuleSet.Module)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return this.emit(onlyModule, moduleSet.globalInfo(), output, logger, ec);
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(66).append("The WebAssembly backend does not support multiple modules. Found: ").append(list.map((Function1 & Serializable)x$2 -> x$2.id().id()).mkString(", ")).toString());
    }

    private Future<Report> emit(ModuleSet.Module onlyModule, LinkedGlobalInfo globalInfo, OutputDirectory output, Logger logger, ExecutionContext ec) {
        String moduleID = onlyModule.id().id();
        Emitter.Result emitterResult = this.emitter().emit(onlyModule, globalInfo, logger);
        Modules.Module wasmModule = emitterResult.wasmModule();
        OutputDirectoryImpl outputImpl = OutputDirectoryImpl$.MODULE$.fromOutputDirectory(output);
        String watFileName = new StringBuilder(4).append(moduleID).append(".wat").toString();
        String wasmFileName = new StringBuilder(5).append(moduleID).append(".wasm").toString();
        String sourceMapFileName = new StringBuilder(4).append(wasmFileName).append(".map").toString();
        String jsFileName = OutputPatternsImpl$.MODULE$.jsFile(super.config().outputPatterns(), moduleID);
        Set filesToProduce0 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{wasmFileName, this.loaderJSFileName(), jsFileName}));
        Set filesToProduce1 = super.config().sourceMap() ? (Set)filesToProduce0.$plus((Object)sourceMapFileName) : filesToProduce0;
        Set filesToProduce = super.config().prettyPrint() ? (Set)filesToProduce1.$plus((Object)watFileName) : filesToProduce1;
        return outputImpl.listFiles(ec).flatMap((Function1 & Serializable)existingFiles -> Future$.MODULE$.sequence((IterableOnce)existingFiles.filterNot((Function1)filesToProduce).map((Function1 & Serializable)x$4 -> outputImpl.delete((String)x$4, ec)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).flatMap((Function1 & Serializable)x$9 -> {
            List list = x$9;
            return this.maybeWriteWatFile$1(wasmModule, outputImpl, watFileName, ec).flatMap((Function1 & Serializable)x$8 -> {
                BoxedUnit boxedUnit = x$8;
                return this.writeWasmFile$1(wasmFileName, sourceMapFileName, wasmModule, outputImpl, ec).flatMap((Function1 & Serializable)x$7 -> {
                    BoxedUnit boxedUnit = x$7;
                    return this.writeLoaderFile$1(outputImpl, emitterResult, ec).flatMap((Function1 & Serializable)x$6 -> {
                        BoxedUnit boxedUnit = x$6;
                        return WebAssemblyLinkerBackend.writeJSFile$1(outputImpl, jsFileName, emitterResult, ec).map((Function1 & Serializable)x$5 -> {
                            BoxedUnit boxedUnit = x$5;
                            ReportImpl.ModuleImpl reportModule = new ReportImpl.ModuleImpl(moduleID, jsFileName, (Option<String>)None$.MODULE$, this.coreSpec().moduleKind());
                            return new ReportImpl((Iterable<Report.Module>)new .colon.colon((Object)reportModule, (List)Nil$.MODULE$));
                        }, ec);
                    }, ec);
                }, ec);
            }, ec);
        }, ec), ec);
    }

    private final Future maybeWriteWatFile$1(Modules.Module wasmModule$1, OutputDirectoryImpl outputImpl$2, String watFileName$1, ExecutionContext ec$2) {
        if (super.config().prettyPrint()) {
            String textOutput = TextWriter$.MODULE$.write(wasmModule$1);
            byte[] textOutputBytes = textOutput.getBytes(StandardCharsets.UTF_8);
            return outputImpl$2.writeFull(watFileName$1, ByteBuffer.wrap(textOutputBytes), ec$2);
        }
        return Future$.MODULE$.unit();
    }

    private final Future writeWasmFile$1(String wasmFileName$1, String sourceMapFileName$1, Modules.Module wasmModule$1, OutputDirectoryImpl outputImpl$2, ExecutionContext ec$2) {
        boolean emitDebugInfo;
        boolean bl = emitDebugInfo = !super.config().minify();
        if (super.config().sourceMap()) {
            ByteArrayWriter sourceMapWriter = new ByteArrayWriter();
            String wasmFileURI = new StringBuilder(2).append("./").append(wasmFileName$1).toString();
            String sourceMapURI = new StringBuilder(2).append("./").append(sourceMapFileName$1).toString();
            SourceMapWriter smWriter = new SourceMapWriter(sourceMapWriter, wasmFileURI, super.config().relativizeSourceMapBase(), this.fragmentIndex());
            ByteBuffer binaryOutput = BinaryWriter$.MODULE$.writeWithSourceMap(wasmModule$1, emitDebugInfo, smWriter, sourceMapURI);
            smWriter.complete();
            return outputImpl$2.writeFull(wasmFileName$1, binaryOutput, ec$2).flatMap((Function1 & Serializable)x$3 -> outputImpl$2.writeFull(sourceMapFileName$1, sourceMapWriter.toByteBuffer(), ec$2), ec$2);
        }
        ByteBuffer binaryOutput = BinaryWriter$.MODULE$.write(wasmModule$1, emitDebugInfo);
        return outputImpl$2.writeFull(wasmFileName$1, binaryOutput, ec$2);
    }

    private final Future writeLoaderFile$1(OutputDirectoryImpl outputImpl$2, Emitter.Result emitterResult$1, ExecutionContext ec$2) {
        return outputImpl$2.writeFull(this.loaderJSFileName(), ByteBuffer.wrap(emitterResult$1.loaderContent()), ec$2);
    }

    private static final Future writeJSFile$1(OutputDirectoryImpl outputImpl$2, String jsFileName$1, Emitter.Result emitterResult$1, ExecutionContext ec$2) {
        return outputImpl$2.writeFull(jsFileName$1, ByteBuffer.wrap(emitterResult$1.jsFileContent()), ec$2);
    }

    public WebAssemblyLinkerBackend(LinkerBackendImpl.Config config) {
        super(config);
        ModuleKind moduleKind = this.coreSpec().moduleKind();
        ModuleKind$ESModule$ moduleKind$ESModule$ = ModuleKind$ESModule$.MODULE$;
        Predef$.MODULE$.require(!(moduleKind != null ? !moduleKind.equals(moduleKind$ESModule$) : moduleKind$ESModule$ != null), (Function0 & Serializable)() -> new StringBuilder(55).append("The WebAssembly backend only supports ES modules; was ").append(this.coreSpec().moduleKind()).append(".").toString());
        Predef$.MODULE$.require(this.coreSpec().esFeatures().useECMAScript2015Semantics(), (Function0 & Serializable)() -> "The WebAssembly backend only supports the ECMAScript 2015 semantics.");
        Predef$.MODULE$.require(this.coreSpec().targetIsWebAssembly(), (Function0 & Serializable)() -> "A WebAssembly backend cannot be used with CoreSpec targeting JavaScript");
        this.loaderJSFileName = OutputPatternsImpl$.MODULE$.jsFile(super.config().outputPatterns(), "__loader");
        this.fragmentIndex = new SourceMapWriter.Index();
        String loaderModuleName = OutputPatternsImpl$.MODULE$.moduleName(super.config().outputPatterns(), "__loader");
        this.emitter = new Emitter(Emitter$Config$.MODULE$.apply(this.coreSpec(), loaderModuleName));
        this.symbolRequirements = this.emitter().symbolRequirements();
    }
}

