/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.ssh;

import gridscale.ssh.JobId;
import gridscale.ssh.SSH;
import gridscale.ssh.SSHJobDescription;
import gridscale.ssh.SSHJobDescription$;
import gridscale.ssh.package$package$;
import java.io.Serializable;
import org.openmole.core.preference.Preference;
import org.openmole.core.threadprovider.IUpdatable;
import org.openmole.core.workflow.execution.ExecutionState$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.AccessControl$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.BatchExecutionJob;
import org.openmole.plugin.environment.batch.environment.Runtime;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageSpace;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.plugin.environment.ssh.Frontend$;
import org.openmole.plugin.environment.ssh.RuntimeInstallation;
import org.openmole.plugin.environment.ssh.RuntimeInstallation$;
import org.openmole.plugin.environment.ssh.SSHAuthentication$isGridScaleAuthentication$;
import org.openmole.plugin.environment.ssh.SSHEnvironment;
import org.openmole.plugin.environment.ssh.SSHEnvironment$Failed$;
import org.openmole.plugin.environment.ssh.SSHEnvironment$Submitted$;
import org.openmole.plugin.environment.ssh.SSHJobService$;
import org.openmole.plugin.environment.ssh.SharedStorage;
import org.openmole.plugin.environment.ssh.SharedStorage$;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.ref.WeakReference;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Try;

public class SSHJobService<S> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SSHJobService.class.getDeclaredField("installation$lzy1"));
    private final S s;
    private StorageSpace space;
    private final BatchEnvironment.Services services;
    private final SSHEnvironment env;
    private final AccessControl accessControl;
    private final StorageInterface<S> storageInterface;
    private final HierarchicalStorageInterface<S> hierarchicalStorageInterface;
    private final SSH ssh;
    private Preference preference;
    private TmpDirectory tmpDirectory;
    private volatile Object installation$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SSHJobService$.class.getDeclaredField("Log$lzy1"));

    public static JavaLogger$Log$ Log() {
        return SSHJobService$.MODULE$.Log();
    }

    public SSHJobService(S s, StorageSpace space, BatchEnvironment.Services services, SSHEnvironment env, AccessControl accessControl, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, SSH ssh, Preference preference, TmpDirectory tmpDirectory) {
        this.s = s;
        this.space = space;
        this.services = services;
        this.env = env;
        this.accessControl = accessControl;
        this.storageInterface = storageInterface;
        this.hierarchicalStorageInterface = hierarchicalStorageInterface;
        this.ssh = ssh;
        this.preference = preference;
        this.tmpDirectory = tmpDirectory;
    }

    public AccessControl accessControl() {
        return this.accessControl;
    }

    public RuntimeInstallation<S> installation() {
        Object object = this.installation$lzy1;
        if (object instanceof RuntimeInstallation) {
            return (RuntimeInstallation)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RuntimeInstallation)this.installation$lzyINIT1();
    }

    private Object installation$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.installation$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RuntimeInstallation<S> runtimeInstallation = null;
                    try {
                        runtimeInstallation = RuntimeInstallation$.MODULE$.apply(Frontend$.MODULE$.ssh(this.env.host(), this.env.port(), this.env.timeout(), this.env.authentication(), SSHAuthentication$isGridScaleAuthentication$.MODULE$, this.ssh), this.s, this.space.baseDirectory(), this.preference, this.tmpDirectory, this.storageInterface, this.hierarchicalStorageInterface);
                        object2 = runtimeInstallation == null ? LazyVals.NullValue$.MODULE$ : runtimeInstallation;
                        this.space = null;
                        this.preference = null;
                        this.tmpDirectory = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.installation$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.installation$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return runtimeInstallation;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SSHEnvironment.SSHJob register(BatchExecutionJob batchExecutionJob, SerializedJob serializedJob, String outputPath, String jobDirectory, Object priority) {
        String workDirectory = (String)this.env.workDirectory().getOrElse(SSHJobService::$anonfun$1);
        SharedStorage.JobScript remoteScript = this.buildScript$1(jobDirectory, workDirectory, outputPath, priority, serializedJob);
        SSHJobDescription jobDescription = SSHJobDescription$.MODULE$.apply("/bin/bash " + remoteScript.path(), jobDirectory, this.env.killAfter());
        return this.env.stateRegistry().registerJob(jobDescription, batchExecutionJob, remoteScript.jobWorkDirectory());
    }

    public Option<SSHEnvironment.SSHRunState> submit(SSHEnvironment.SSHJob job, SSHJobDescription description, BatchExecutionJob batchExecutionJob) {
        Option<SSHEnvironment.SSHRunState> option;
        try {
            JobId id = package$package$.MODULE$.submit(description, this.ssh);
            option = this.env.stateRegistry().update(job, SSHEnvironment$Submitted$.MODULE$.apply(id));
        }
        catch (Throwable t) {
            this.env.stateRegistry().update(job, SSHEnvironment$Failed$.MODULE$);
            throw t;
        }
        return option;
    }

    public byte state(SSHEnvironment.SSHJob job, Object priority) {
        Option<SSHEnvironment.SSHRunState> option = this.env.stateRegistry().get(job);
        if (None$.MODULE$.equals(option)) {
            return ExecutionState$.MODULE$.DONE();
        }
        if (option instanceof Some) {
            SSHEnvironment.SSHRunState sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value();
            if (sSHRunState instanceof SSHEnvironment.Queued) {
                SSHEnvironment.Queued state = (SSHEnvironment.Queued)sSHRunState;
                return ExecutionState$.MODULE$.SUBMITTED();
            }
            if (SSHEnvironment$Failed$.MODULE$.equals(sSHRunState)) {
                return ExecutionState$.MODULE$.FAILED();
            }
            if (sSHRunState instanceof SSHEnvironment.Submitted) {
                JobId jobId;
                SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
                JobId id = jobId = submitted._1();
                return BoxesRunTime.unboxToByte((Object)this.accessControl().apply((Function1 & Serializable)contextual$1 -> GridScaleJobService$.MODULE$.translateStatus(package$package$.MODULE$.state(id, this.ssh)), SSHJobService.given_Priority$2(priority)));
            }
        }
        throw new MatchError(option);
    }

    public void delete(SSHEnvironment.SSHJob job, Object priority) {
        SSHEnvironment.SSHRunState sSHRunState;
        Option<SSHEnvironment.SSHRunState> jobState = this.env.stateRegistry().remove(job);
        Option<SSHEnvironment.SSHRunState> option = jobState;
        if (option instanceof Some && (sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value()) instanceof SSHEnvironment.Submitted) {
            JobId jobId;
            SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
            JobId id = jobId = submitted._1();
            this.accessControl().apply((Function1 & Serializable)contextual$5 -> {
                package$package$.MODULE$.clean(id, this.ssh);
                return package$package$.MODULE$.run("rm -rf " + job.workDirectory(), package$package$.MODULE$.run$default$2(), this.ssh);
            }, SSHJobService.given_Priority$3(priority));
            return;
        }
    }

    public Tuple2<String, String> stdOutErr(SSHEnvironment.SSHJob j, Object priority) {
        SSHEnvironment.SSHRunState sSHRunState;
        Option<SSHEnvironment.SSHRunState> jobState = this.env.stateRegistry().get(j);
        Option<SSHEnvironment.SSHRunState> option = jobState;
        if (option instanceof Some && (sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value()) instanceof SSHEnvironment.Submitted) {
            JobId jobId;
            SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
            JobId id = jobId = submitted._1();
            return (Tuple2)this.accessControl().apply((Function1 & Serializable)contextual$2 -> Tuple2$.MODULE$.apply((Object)package$package$.MODULE$.stdOut(id, this.ssh), (Object)package$package$.MODULE$.stdErr(id, this.ssh)), SSHJobService.given_Priority$4(priority));
        }
        return Tuple2$.MODULE$.apply((Object)"", (Object)"");
    }

    private static final Object given_Priority$1(Object priority$1) {
        return priority$1;
    }

    private static final String $anonfun$1() {
        return "/tmp";
    }

    private final SharedStorage.JobScript buildScript$1(String jobDirectory$1, String workDirectory$1, String outputPath$1, Object priority$2, SerializedJob serializedJob) {
        return SharedStorage$.MODULE$.buildScript((Function1<Runtime, String>)(Function1 & Serializable)runtime -> this.installation().apply((Runtime)runtime), jobDirectory$1, workDirectory$1, this.env.openMOLEMemory(), serializedJob, outputPath$1, this.s, this.env.modules(), this.env.debug(), this.services.newFile(), this.services.preference(), this.storageInterface, this.hierarchicalStorageInterface, SSHJobService.given_Priority$1(priority$2));
    }

    private static final Object given_Priority$2(Object priority$3) {
        return priority$3;
    }

    private static final Object given_Priority$3(Object priority$4) {
        return priority$4;
    }

    private static final Object given_Priority$4(Object priority$5) {
        return priority$5;
    }

    public static class Updater
    implements IUpdatable {
        private final WeakReference<SSHEnvironment> environment;
        private boolean stop;

        public Updater(WeakReference<SSHEnvironment> environment) {
            this.environment = environment;
            this.stop = false;
        }

        public boolean stop() {
            return this.stop;
        }

        public void stop_$eq(boolean x$1) {
            this.stop = x$1;
        }

        public boolean update() {
            if (this.stop()) {
                return false;
            }
            Option option = this.environment.get();
            if (option instanceof Some) {
                SSHEnvironment env = (SSHEnvironment)((Some)option).value();
                Seq<Tuple2<SSHEnvironment.SSHJob, JobId>> sshJobIds = env.stateRegistry().submitted();
                List runningJobResults = (List)AccessControl$.MODULE$.defaultPrirority(arg_0 -> SSHJobService$.org$openmole$plugin$environment$ssh$SSHJobService$Updater$$_$_$$anonfun$2(env, sshJobIds, arg_0));
                List errors = runningJobResults.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Try x) {
                        Try try_ = x;
                        if (try_ instanceof Failure) {
                            Throwable x2 = ((Failure)try_).exception();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Try x, Function1 function1) {
                        Try try_ = x;
                        if (try_ instanceof Failure) {
                            Throwable x2 = ((Failure)try_).exception();
                            return x2;
                        }
                        return function1.apply((Object)x);
                    }
                });
                errors.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SSHJobService$.org$openmole$plugin$environment$ssh$SSHJobService$Updater$$_$update$$anonfun$1(env, arg_0)));
                int boundNumberOfRunningJobs = runningJobResults.map(SSHJobService$::org$openmole$plugin$environment$ssh$SSHJobService$Updater$$_$_$$anonfun$3).count(SSHJobService$::org$openmole$plugin$environment$ssh$SSHJobService$Updater$$_$_$$anonfun$adapted$1);
                int nbSubmit = env.slots() - boundNumberOfRunningJobs;
                Iterable toSubmit = (Iterable)env.stateRegistry().queued().take(nbSubmit);
                toSubmit.foreach(arg_0 -> SSHJobService$.org$openmole$plugin$environment$ssh$SSHJobService$Updater$$_$update$$anonfun$2(env, arg_0));
                return !this.stop();
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        }
    }
}

