/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.spatialsampling;

import java.io.Serializable;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random;
import scala.util.Right;

public final class Math$ {
    public static final Math$ MODULE$ = new Math$();

    public double[][] kernelMixture(Either<Object, Tuple2<Object, Object>> worldSize, Either<Object, Seq<Tuple2<Object, Object>>> centers, Function2<Object, Object, Object> kernel, Random rng) {
        Seq seq;
        Right right;
        Tuple2 tuple2;
        int n;
        Right right2;
        Tuple2 tuple22;
        int n2;
        Either<Object, Tuple2<Object, Object>> either = worldSize;
        if (either instanceof Left) {
            int l;
            Left left = (Left)either;
            n2 = l = BoxesRunTime.unboxToInt((Object)left.value());
        } else if (either instanceof Right && (tuple22 = (Tuple2)(right2 = (Right)either).value()) != null) {
            int ww;
            n2 = ww = tuple22._1$mcI$sp();
        } else {
            throw new MatchError(either);
        }
        int w = n2;
        Either<Object, Tuple2<Object, Object>> either2 = worldSize;
        if (either2 instanceof Left) {
            int l;
            Left left = (Left)either2;
            n = l = BoxesRunTime.unboxToInt((Object)left.value());
        } else if (either2 instanceof Right && (tuple2 = (Tuple2)(right = (Right)either2).value()) != null) {
            int hh;
            n = hh = tuple2._2$mcI$sp();
        } else {
            throw new MatchError(either2);
        }
        int h = n;
        double[][] vals = (double[][])Array$.MODULE$.fill(w, h, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        Either<Object, Seq<Tuple2<Object, Object>>> either3 = centers;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            int i2 = BoxesRunTime.unboxToInt((Object)left.value());
            seq = (Seq)Seq$.MODULE$.fill(i2, (Function0 & Serializable)() -> new Tuple2.mcII.sp(rng.nextInt(w), rng.nextInt(h)));
        } else if (either3 instanceof Right) {
            Seq c;
            Right right3 = (Right)either3;
            seq = c = (Seq)right3.value();
        } else {
            throw new MatchError(either3);
        }
        Seq coords = seq;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), w).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), h).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> coords.foreach((Function1 & Serializable)c -> {
            vals[i][j] = vals[i][j] + kernel.apply$mcDDD$sp((double)(i - c._1$mcI$sp()), (double)(j - c._2$mcI$sp()));
            return BoxedUnit.UNIT;
        })));
        return vals;
    }

    public double[][] diffuse(double[][] a, double alpha) {
        double[][] newVals = (double[][])a.clone();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(a.length, a[0].length);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int height = sp2._1$mcI$sp();
        int width = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(height, width);
        Tuple2.mcII.sp sp4 = sp3;
        int height2 = sp4._1$mcI$sp();
        int width2 = sp4._2$mcI$sp();
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])a)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.doubleArrayOps(a[0])).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            block8: {
                double d = a[i][j];
                if (Predef$.MODULE$.double2Double(d).isNaN()) break block8;
                if (i >= 1) {
                    newVals$1[i$2 - 1][j] = newVals[i - 1][j] + alpha / (double)8 * d;
                }
                if (i < height2 - 1) {
                    newVals$1[i$2 + 1][j] = newVals[i + 1][j] + alpha / (double)8 * d;
                }
                if (j >= 1) {
                    newVals$1[i$2][j - 1] = newVals[i][j - 1] + alpha / (double)8 * d;
                }
                if (j < width2 - 1) {
                    newVals$1[i$2][j + 1] = newVals[i][j + 1] + alpha / (double)8 * d;
                }
                if (i >= 1 && j >= 1) {
                    newVals$1[i$2 - 1][j - 1] = newVals[i - 1][j - 1] + alpha / (double)8 * d;
                }
                if (i >= 1 && j < width2 - 1) {
                    newVals$1[i$2 - 1][j + 1] = newVals[i - 1][j + 1] + alpha / (double)8 * d;
                }
                if (i < height2 - 1 && j >= 1) {
                    newVals$1[i$2 + 1][j - 1] = newVals[i + 1][j - 1] + alpha / (double)8 * d;
                }
                if (i < height2 - 1 && j < width2 - 1) {
                    newVals$1[i$2 + 1][j + 1] = newVals[i + 1][j + 1] + alpha / (double)8 * d;
                }
                newVals$1[i$2][j] = newVals[i][j] - alpha * d;
            }
        }));
        return newVals;
    }

    public double[][] convolution2dDirect(double[][] matrix, double[][] mask, Function1<Object, Object> filter) {
        Predef$.MODULE$.assert(mask.length % 2 == 1 && mask[0].length % 2 == 1, (Function0 & Serializable)() -> "mask should be of uneven size");
        int[] sizes = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Math$.$anonfun$convolution2dDirect$2(x$2)), (ClassTag)ClassTag$.MODULE$.Int());
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(sizes).max((Ordering)Ordering.Int$.MODULE$)) == BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(sizes).min((Ordering)Ordering.Int$.MODULE$)), (Function0 & Serializable)() -> "array should be rectangular");
        int[] masksizes = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])mask), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Math$.$anonfun$convolution2dDirect$4(x$3)), (ClassTag)ClassTag$.MODULE$.Int());
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(masksizes).max((Ordering)Ordering.Int$.MODULE$)) == BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(masksizes).min((Ordering)Ordering.Int$.MODULE$)), (Function0 & Serializable)() -> "mask should be rectangular");
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp((mask.length - 1) / 2, (mask[0].length - 1) / 2);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int paddingx = sp2._1$mcI$sp();
        int paddingy = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(paddingx, paddingy);
        Tuple2.mcII.sp sp4 = sp3;
        int paddingx2 = sp4._1$mcI$sp();
        int paddingy2 = sp4._2$mcI$sp();
        double[][] padded = (double[][])Array$.MODULE$.tabulate(matrix.length + 2 * paddingx2, matrix[0].length + 2 * paddingy2, (Function2)(JFunction2.mcDII.sp & Serializable)(x0$1, x1$1) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
            if (sp2 != null) {
                int i = sp2._1$mcI$sp();
                int j = sp2._2$mcI$sp();
                if (i < paddingx2) return 0.0;
                if (i >= matrix.length + paddingx2) return 0.0;
                if (j < paddingy2) return 0.0;
                if (j >= matrix[0].length + paddingy2) {
                    return 0.0;
                }
            }
            if (sp2 == null) throw new MatchError((Object)sp2);
            int i = sp2._1$mcI$sp();
            int j = sp2._2$mcI$sp();
            return matrix[i - paddingx2][j - paddingy2];
        }, (ClassTag)ClassTag$.MODULE$.Double());
        double[][] res = (double[][])Array$.MODULE$.fill(matrix.length + 2 * paddingx2, matrix[0].length + 2 * paddingy2, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(paddingx2), res.length - paddingx2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(paddingy2), res[0].length - paddingy2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[][] masked = (double[][])Array$.MODULE$.fill(mask.length, mask[0].length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-paddingx2), paddingx2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-paddingy2), paddingy2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)l -> {
                masked$1[k$1 + paddingx$1][l + paddingy$1] = padded[i + k][j + l] * mask[k + paddingx2][l + paddingy2];
            }));
            res$1[i$3][j] = filter.apply$mcDD$sp(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])masked), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }));
        return (double[][])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])res), (Function1 & Serializable)row -> (double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(row), paddingy2, ((double[])row).length - paddingy2), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), paddingx2, res.length - paddingx2);
    }

    public Function1<Object, Object> convolution2dDirect$default$3() {
        return (JFunction1.mcDD.sp & Serializable)d -> d > 0.0 ? 1.0 : 0.0;
    }

    public double entropy(double[] values) {
        double[] x = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(values), (Function1)(JFunction1.mcDD.sp & Serializable)d -> Predef$.MODULE$.double2Double(d).isNaN() ? 0.0 : d, (ClassTag)ClassTag$.MODULE$.Double());
        double totalQuantity = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(x).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double d2 = totalQuantity;
        double d3 = 0.0 == d2 ? 0.0 : BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x), (Function1)(JFunction1.mcDD.sp & Serializable)p -> {
            double quantityRatio = p / totalQuantity;
            double localEntropy = quantityRatio == 0.0 ? 0.0 : quantityRatio * package$.MODULE$.log(quantityRatio);
            return localEntropy;
        }, (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) * ((double)-1 / package$.MODULE$.log((double)x.length));
        return d3;
    }

    public Tuple2<Object, Object> slope(double[] values) {
        SimpleRegression simpleRegression = new SimpleRegression(true);
        simpleRegression.addData(Math$.distributionLog$1(values));
        return new Tuple2.mcDD.sp(simpleRegression.getSlope(), simpleRegression.getRSquare());
    }

    public <T> Vector<T> sampleWithoutReplacement(Iterable<T> sampled, int samples, Random rng) {
        return this.sampleWithoutReplacementBy(sampled, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)Math$.$anonfun$sampleWithoutReplacement$1(sampled, x$6)), samples, rng);
    }

    public <T> Vector<T> sampleWithoutReplacementBy(Iterable<T> sampled, Function1<T, Object> probability, int samples, Random rng) {
        Predef$.MODULE$.assert(samples <= sampled.size(), (Function0 & Serializable)() -> new StringBuilder(42).append("Can not sample more than vector size : ").append(samples).append(" / ").append(sampled.size()).toString());
        return (Vector)((Tuple2)scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2(sampled, (Object)scala.package$.MODULE$.Vector().empty()), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable rest = (Iterable)tuple2._1();
            Vector res = (Vector)tuple2._2();
            double totproba = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)rest.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)Math$.$anonfun$sampleWithoutReplacementBy$3(probability, x$7)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Seq normalizedProba = (Seq)rest.toSeq().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)Math$.$anonfun$sampleWithoutReplacementBy$4(probability, totproba, x$8)));
            Tuple2 sample = (Tuple2)MODULE$.sampleOneBy((Iterable)((IterableOps)rest.toSeq().zipWithIndex()).zip((IterableOnce)normalizedProba), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9._2$mcD$sp()), rng);
            Tuple2 tuple22 = new Tuple2(((IterableOps)((IterableOps)rest.toSeq().zipWithIndex()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Math$.$anonfun$sampleWithoutReplacementBy$6(sample, x$10)))).map((Function1 & Serializable)x$11 -> x$11._1()), ((IterableOps)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((Tuple2)sample._1())._1()}))).$plus$plus((IterableOnce)res));
            return tuple22;
        }).take(samples).toSeq().last())._2();
    }

    public <T> T sampleOneBy(Iterable<T> sampled, Function1<T, Object> probability, Random rng) {
        return (T)Math$.f$1((Tuple4)scala.package$.MODULE$.Iterator().iterate((Object)new Tuple4(sampled, sampled.head(), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())), (Function1 & Serializable)s -> Math$.f$1(s, probability)).takeWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Math$.$anonfun$sampleOneBy$2(s))).toSeq().last(), probability)._2();
    }

    public static final /* synthetic */ int $anonfun$convolution2dDirect$2(double[] x$2) {
        return x$2.length;
    }

    public static final /* synthetic */ int $anonfun$convolution2dDirect$4(double[] x$3) {
        return x$3.length;
    }

    private static final double[] distribution$1(double[] values$1) {
        return (double[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.doubleArrayOps(values$1), (Function1)(JFunction1.mcZD.sp & Serializable)x$5 -> x$5 > 0.0)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
    }

    private static final double[][] distributionLog$1(double[] values$1) {
        return (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(Math$.distribution$1(values$1)))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double q = tuple2._1$mcD$sp();
            int i = tuple2._2$mcI$sp();
            double[] dArray = new double[]{package$.MODULE$.log((double)(i + 1)), package$.MODULE$.log(q)};
            return dArray;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public static final /* synthetic */ double $anonfun$sampleWithoutReplacement$1(Iterable sampled$1, Object x$6) {
        return 1.0 / (double)sampled$1.size();
    }

    public static final /* synthetic */ double $anonfun$sampleWithoutReplacementBy$3(Function1 probability$1, Object x$7) {
        return BoxesRunTime.unboxToDouble((Object)probability$1.apply(x$7));
    }

    public static final /* synthetic */ double $anonfun$sampleWithoutReplacementBy$4(Function1 probability$1, double totproba$1, Object x$8) {
        return BoxesRunTime.unboxToDouble((Object)probability$1.apply(x$8)) / totproba$1;
    }

    public static final /* synthetic */ boolean $anonfun$sampleWithoutReplacementBy$6(Tuple2 sample$1, Tuple2 x$10) {
        return x$10._2$mcI$sp() != ((Tuple2)sample$1._1())._2$mcI$sp();
    }

    private static final Tuple4 f$1(Tuple4 s, Function1 probability$2) {
        return new Tuple4(((IterableOps)s._1()).tail(), ((IterableOps)s._1()).head(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)s._3()) + BoxesRunTime.unboxToDouble((Object)probability$2.apply(((IterableOps)s._1()).head())))), s._4());
    }

    public static final /* synthetic */ boolean $anonfun$sampleOneBy$2(Tuple4 s) {
        return BoxesRunTime.unboxToDouble((Object)s._3()) < BoxesRunTime.unboxToDouble((Object)s._4()) && ((IterableOnceOps)s._1()).nonEmpty();
    }

    private Math$() {
    }
}

