/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.HeadingSmoother;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.Vect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Observer
extends Agent
implements org.nlogo.api.Observer {
    final HeadingSmoother headingSmoother = new HeadingSmoother();
    Perspective perspective = PerspectiveJ.OBSERVE();
    org.nlogo.api.Agent targetAgent = null;
    private double _oxcor;
    private double _oycor;
    private double _ozcor;
    double heading;
    double pitch;
    double roll;
    Vect rotationPoint;
    int followDistance = 5;
    public static final int BIT = 1;

    public Observer(World world) {
        super(world);
        this.resetPerspective();
    }

    @Override
    Agent realloc(boolean forRecompile) {
        int i;
        Object[] oldvars = this.variables;
        Object[] newvars = new Object[this.world.getVariablesArraySize(this)];
        ValueConstraint[] newcons = new ValueConstraint[this.world.getVariablesArraySize(this)];
        for (i = 0; newvars.length != i; ++i) {
            newvars[i] = World.ZERO;
            newcons[i] = null;
        }
        if (oldvars != null && forRecompile) {
            for (i = 0; i < oldvars.length && i < this.world.oldGlobals.size(); ++i) {
                String name = this.world.oldGlobals.get(i);
                int newpos = this.world.observerOwnsIndexOf(name);
                if (newpos == -1) continue;
                newvars[newpos] = oldvars[i];
            }
        }
        this.variables = newvars;
        this.variableConstraints = newcons;
        return null;
    }

    @Override
    public Object getVariable(int vn) {
        return this.variables[vn];
    }

    @Override
    public String variableName(int vn) {
        return this.world.observerOwnsNameAt(vn);
    }

    @Override
    public Object getObserverVariable(int vn) {
        return this.variables[vn];
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getPatchVariable(int vn) throws AgentException {
        throw new AgentException("the observer can't access a patch variable without specifying which patch");
    }

    @Override
    public void setVariable(int vn, Object value2) throws AgentException, LogoException {
        this.setObserverVariable(vn, value2);
    }

    public void assertVariableConstraint(int vn, Object value2) throws AgentException, LogoException {
        ValueConstraint con = this.variableConstraint(vn);
        if (con != null) {
            con.assertConstraint(value2);
        }
    }

    @Override
    public void setObserverVariable(int vn, Object value2) throws AgentException, LogoException {
        this.assertVariableConstraint(vn, value2);
        this.variables[vn] = value2;
        this.world.notifyWatchers(this, vn, value2);
    }

    @Override
    public void setTurtleVariable(int vn, Object value2) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setTurtleVariable(int vn, double value2) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String name, Object value2) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setPatchVariable(int vn, Object value2) throws AgentException {
        throw new AgentException("the observer can't set a patch variable without specifying which turtle");
    }

    @Override
    public void setPatchVariable(int vn, double value2) throws AgentException {
        throw new AgentException("the observer can't set a patch variable without specifying which turtle");
    }

    @Override
    public void setLinkVariable(int vn, Object value2) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setLinkVariable(int vn, double value2) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value2) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value2) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Perspective perspective() {
        return this.perspective;
    }

    public void perspective(Perspective perspective) {
        this.perspective = perspective;
    }

    @Override
    public org.nlogo.api.Agent targetAgent() {
        return this.targetAgent;
    }

    public void targetAgent(org.nlogo.api.Agent agent) {
        this.targetAgent = agent;
    }

    @Override
    public double oxcor() {
        return this._oxcor;
    }

    public void oxcor(double oxcor) {
        this._oxcor = oxcor;
    }

    @Override
    public double oycor() {
        return this._oycor;
    }

    public void oycor(double oycor) {
        this._oycor = oycor;
    }

    @Override
    public double ozcor() {
        return this._ozcor;
    }

    public void ozcor(double ozcor) {
        this._ozcor = ozcor;
    }

    public void oxyandzcor(double oxcor, double oycor, double ozcor) {
        this._oxcor = oxcor;
        this._oycor = oycor;
        this._ozcor = ozcor;
    }

    public double followOffsetX() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            return this._oxcor - ((double)this.world.minPxcor() - 0.5 + (double)this.world.worldWidth() / 2.0);
        }
        return 0.0;
    }

    public double followOffsetY() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            return this._oycor - ((double)this.world.minPycor() - 0.5 + (double)this.world.worldHeight() / 2.0);
        }
        return 0.0;
    }

    @Override
    public double heading() {
        return this.heading;
    }

    public void heading(double heading) {
        this.heading = (heading % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double pitch() {
        return this.pitch;
    }

    public void pitch(double pitch) {
        this.pitch = (pitch % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double roll() {
        return this.roll;
    }

    public void roll(double roll) {
        this.roll = (roll % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double dist() {
        return StrictMath.sqrt((this.rotationPoint.x() - this._oxcor) * (this.rotationPoint.x() - this._oxcor) + (this.rotationPoint.y() - this._oycor) * (this.rotationPoint.y() - this._oycor) + (this.rotationPoint.z() - this._ozcor) * (this.rotationPoint.z() - this._ozcor));
    }

    public void setRotationPoint(Vect v) {
        this.rotationPoint = v;
    }

    public void setRotationPoint(double x2, double y, double z) {
        this.rotationPoint = new Vect(x2, y, z);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof org.nlogo.api.Turtle) {
            org.nlogo.api.Turtle t = (org.nlogo.api.Turtle)agent;
            this.setRotationPoint(t.xcor(), t.ycor(), 0.0);
        } else if (agent instanceof org.nlogo.api.Link) {
            org.nlogo.api.Link link = (org.nlogo.api.Link)agent;
            this.setRotationPoint(link.midpointX(), link.midpointY(), 0.0);
        } else {
            org.nlogo.api.Patch p = (org.nlogo.api.Patch)agent;
            this.setRotationPoint(p.pxcor(), p.pycor(), 0.0);
        }
    }

    public Vect rotationPoint() {
        return this.rotationPoint;
    }

    @Override
    public int followDistance() {
        return this.followDistance;
    }

    public void followDistance(int followDistance) {
        this.followDistance = followDistance;
    }

    public void setOrientation(double heading, double pitch, double roll) {
        this.heading = heading;
        this.pitch = pitch;
        this.roll = roll;
    }

    @Override
    public double dx() {
        double value2 = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.sin(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value2) < Constants.Infinitesimal()) {
            value2 = 0.0;
        }
        return value2;
    }

    @Override
    public double dy() {
        double value2 = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(value2) < Constants.Infinitesimal()) {
            value2 = 0.0;
        }
        return value2;
    }

    @Override
    public double dz() {
        double value2 = StrictMath.sin(StrictMath.toRadians(this.pitch));
        if (StrictMath.abs(value2) < Constants.Infinitesimal()) {
            value2 = 0.0;
        }
        return value2;
    }

    public void face(org.nlogo.api.Agent agent) {
        try {
            this.heading(this.world.protractor().towards(this, agent, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, agent, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(agent);
    }

    public void face(double x2, double y) {
        try {
            this.heading(this.world.protractor().towards(this, x2, y, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, x2, y, 0.0, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(x2, y, 0.0);
    }

    public void moveto(Agent otherAgent) throws AgentException {
        if (otherAgent instanceof Turtle) {
            Turtle t = (Turtle)otherAgent;
            this.oxyandzcor(t.xcor(), t.ycor(), 0.0);
        } else if (otherAgent instanceof Patch) {
            Patch p = (Patch)otherAgent;
            this.oxyandzcor(p.pxcor, p.pycor, 0.0);
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y());
    }

    @Override
    public void setPerspective(Perspective perspective, org.nlogo.api.Agent agent) {
        this.perspective = perspective;
        this.targetAgent = agent;
        this.updatePosition();
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public boolean updatePosition() {
        boolean changed2 = false;
        if (this.perspective == PerspectiveJ.OBSERVE()) {
            return false;
        }
        if (this.perspective == PerspectiveJ.WATCH()) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.setRotationPoint(this.targetAgent);
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle turtle2 = (Turtle)this.targetAgent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), 0.0);
            double newHeading = this.headingSmoother.follow(this.targetAgent);
            if (this.perspective == PerspectiveJ.FOLLOW()) {
                changed2 = this.heading != newHeading;
                this.heading(newHeading);
            } else {
                this.heading(turtle2.heading());
            }
            this.pitch(0.0);
            this.roll(0.0);
        }
        return changed2;
    }

    public double distance(org.nlogo.api.Agent agent) {
        double y;
        double x2;
        if (agent instanceof Turtle) {
            x2 = ((Turtle)agent).xcor();
            y = ((Turtle)agent).ycor();
        } else {
            if (agent instanceof Link) {
                return this.world.protractor().distance(agent, this._oxcor, this._oycor, true);
            }
            x2 = ((Patch)agent).pxcor;
            y = ((Patch)agent).pycor;
        }
        return this.distance(x2, y);
    }

    public double distance(org.nlogo.api.Turtle t) {
        return this.distance(t.xcor(), t.ycor());
    }

    double distance(double x2, double y) {
        return StrictMath.sqrt((x2 - this._oxcor) * (x2 - this._oxcor) + (y - this._oycor) * (y - this._oycor) + this._ozcor * this._ozcor);
    }

    public void resetPerspective() {
        this.setPerspective(PerspectiveJ.OBSERVE(), null);
        this.home();
    }

    public void home() {
        this._oxcor = (double)this.world.minPxcor() + (double)(this.world.maxPxcor() - this.world.minPxcor()) / 2.0;
        this._oycor = (double)this.world.minPycor() + (double)(this.world.maxPycor() - this.world.minPycor()) / 2.0;
        this._ozcor = (double)StrictMath.max(this.world.worldWidth(), this.world.worldHeight()) * 1.5;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.roll = 0.0;
        this.setRotationPoint(this._oxcor, this._oycor, 0.0);
    }

    public boolean atHome2D() {
        return this.perspective == PerspectiveJ.OBSERVE() && this._oxcor == 0.0 && this._oycor == 0.0;
    }

    public boolean atHome3D() {
        return this.perspective == PerspectiveJ.OBSERVE() && this._oxcor == 0.0 && this._oycor == 0.0 && this._ozcor == (double)StrictMath.max(this.world.worldWidth(), this.world.worldHeight()) * 1.5 && this.heading == 0.0 && this.pitch == 90.0 && this.roll == 0.0 && this.rotationPoint.x() == 0.0 && this.rotationPoint.y() == 0.0 && this.rotationPoint.z() == 0.0;
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        return this.world.getPatchAt(dx, dy);
    }

    public String toString() {
        return "observer";
    }

    @Override
    public String classDisplayName() {
        return "observer";
    }

    public Class<Observer> getAgentClass() {
        return Observer.class;
    }

    @Override
    public int getAgentBit() {
        return 1;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 0.0;
    }

    public void orbitRight(double delta) {
        delta = -delta;
        double newHeading = this.heading + delta;
        double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(this.pitch));
        double x2 = -dxy * StrictMath.sin(StrictMath.toRadians(newHeading));
        double y = -dxy * StrictMath.cos(StrictMath.toRadians(newHeading));
        this.oxyandzcor(x2 + this.rotationPoint.x(), y + this.rotationPoint.y(), this._ozcor);
        this.heading(newHeading);
    }

    public void orbitUp(double delta) {
        delta = -delta;
        double newPitch = this.pitch - delta;
        double z = this.dist() * StrictMath.sin(StrictMath.toRadians(newPitch));
        double dxy = this.dist() * StrictMath.cos(StrictMath.toRadians(newPitch));
        double x2 = -dxy * StrictMath.sin(StrictMath.toRadians(this.heading));
        double y = -dxy * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (z + this.rotationPoint.z() > 0.0 && newPitch < 90.0) {
            this.oxyandzcor(x2 + this.rotationPoint.x(), y + this.rotationPoint.y(), z + this.rotationPoint.z());
            this.pitch(newPitch);
        }
    }

    public void translate(double thetaX, double thetaY) {
        double headingR = StrictMath.toRadians(this.heading);
        double sinH = StrictMath.sin(headingR);
        double cosH = StrictMath.cos(headingR);
        this._oxcor -= (cosH * thetaX + sinH * thetaY) * 0.1;
        this._oycor += (sinH * thetaX - cosH * thetaY) * 0.1;
        this.rotationPoint = new Vect(this.rotationPoint.x() - (cosH * thetaX + sinH * thetaY) * 0.1, this.rotationPoint.y() + (sinH * thetaX - cosH * thetaY) * 0.1, this.rotationPoint.z());
    }

    @Override
    public int alpha() {
        return 0;
    }
}

