/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import java.awt.Point;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.gl.render.Builtins;
import org.nlogo.gl.render.CustomShapes;
import org.nlogo.gl.render.GLLinkShape;
import org.nlogo.gl.render.GLLinkShape3D;
import org.nlogo.gl.render.GLShape;
import org.nlogo.gl.render.Polygons;
import org.nlogo.gl.render.Rectangle;
import org.nlogo.gl.render.Tessellator;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Curve;
import org.nlogo.shape.Element;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.shape.Line;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.VectorShape;
import scala.ScalaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShapeManager {
    static final int SMOOTHNESS = 16;
    private final GLUquadric quadric;
    private int lastList;
    private final Map<String, GLShape> shapes = new HashMap<String, GLShape>();
    private final List<AddShapeRequest> queue = new LinkedList<AddShapeRequest>();
    private final Map<String, String> shapeMap = new HashMap<String, String>();
    final Map<String, List<String>> customShapes = new HashMap<String, List<String>>();
    private final ShapeList turtleShapeList;
    private final ShapeList linkShapeList;
    private final Map<String, GLShape> modelShapes = new HashMap<String, GLShape>();
    private final Map<String, GLLinkShape> linkShapes = new HashMap<String, GLLinkShape>();
    private final Tessellator tessellator = new Tessellator();
    private final GLUtessellator tess;
    private final boolean is3D;

    ShapeManager(GL2 gl, GLU glu, ShapeList turtleShapeList, ShapeList linkShapeList, Map<String, List<String>> customShapes, boolean is3D2) {
        this.is3D = is3D2;
        this.tess = glu.gluNewTess();
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100106, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100110, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100107, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100108, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100111, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100109, (GLUtessellatorCallback)this.tessellator);
        GLU.gluTessProperty((GLUtessellator)this.tess, (int)100140, (double)100130.0);
        this.quadric = glu.gluNewQuadric();
        glu.gluQuadricNormals(this.quadric, 100000);
        this.lastList = new Builtins(gl, glu, this.quadric).add(this.shapes, this.shapeMap);
        this.turtleShapeList = turtleShapeList;
        this.linkShapeList = linkShapeList;
        this.addModelShapes(gl, glu);
        this.addLinkShapes(gl, glu);
        if (customShapes != null) {
            this.lastList = CustomShapes.updateShapes(gl, this.lastList, this.shapes, customShapes);
        }
    }

    GLShape getShape(String name) {
        if (this.shapes.containsKey(name)) {
            return this.shapes.get(name);
        }
        if (this.shapeMap.containsKey(name)) {
            return this.shapes.get(this.shapeMap.get(name));
        }
        if (this.modelShapes.containsKey(name)) {
            return this.modelShapes.get(name);
        }
        return this.shapes.get("default");
    }

    GLLinkShape getLinkShape(String name) {
        return this.linkShapes.get(name);
    }

    boolean modelLibraryShape(String name) {
        return this.modelShapes.containsKey(name) && !this.shapes.containsKey(name) && !this.shapeMap.containsKey(name);
    }

    public void invalidateTurtleShape(String shape2) {
        this.queue.add(new AddShapeRequest(AddShapeRequestType.LIBRARY_TURTLE, shape2));
    }

    public void invalidateLinkShape(String shape2) {
        this.queue.add(new AddShapeRequest(AddShapeRequestType.LIBRARY_LINK, shape2));
    }

    public void addCustomShapes(String filename) throws IOException, InvalidShapeDescriptionException {
        for (CustomShapes.Description shape2 : CustomShapes.readShapes(filename)) {
            this.queue.add(new AddShapeRequest(AddShapeRequestType.IMPORT, shape2));
        }
    }

    void checkQueue(GL2 gl, GLU glu) {
        block0: for (AddShapeRequest req : this.queue) {
            ScalaObject shape2;
            if (req.type == AddShapeRequestType.IMPORT) {
                shape2 = (CustomShapes.Description)req.data;
                this.lastList = CustomShapes.addNewShape(gl, this.shapes, (CustomShapes.Description)shape2);
                this.customShapes.put(((CustomShapes.Description)shape2).name(), ((CustomShapes.Description)shape2).javaLines());
                continue;
            }
            if (req.type == AddShapeRequestType.LIBRARY_TURTLE) {
                List<Shape> modelShapeList = this.turtleShapeList.getShapes();
                if (this.modelShapes.containsKey(req.data)) {
                    GLShape shape3 = this.modelShapes.get(req.data);
                    gl.glDeleteLists(shape3.displayListIndex(), 1);
                    this.modelShapes.remove(req.data);
                }
                this.lastList = gl.glGenLists(1);
                for (int j = 0; j < modelShapeList.size(); ++j) {
                    VectorShape vShape = (VectorShape)modelShapeList.get(j);
                    if (!vShape.getName().equals(req.data)) continue;
                    this.addModelShape(gl, glu, vShape, this.lastList);
                    continue block0;
                }
                continue;
            }
            if (req.type == AddShapeRequestType.LIBRARY_LINK) {
                if (this.modelShapes.containsKey(req.data)) {
                    shape2 = this.linkShapes.get(req.data);
                    gl.glDeleteLists(((GLLinkShape)shape2).directionIndicator().displayListIndex(), 1);
                    this.linkShapes.remove(req.data);
                }
                this.addLinkShape(gl, glu, (LinkShape)this.linkShapeList.shape((String)req.data), gl.glGenLists(1));
                continue;
            }
            throw new IllegalStateException();
        }
        this.queue.clear();
    }

    private void addLinkShapes(GL2 gl, GLU glu) {
        List<Shape> lols = this.linkShapeList.getShapes();
        int nextIndex = gl.glGenLists(lols.size());
        Iterator<Shape> iter2 = lols.iterator();
        int i = nextIndex;
        while (iter2.hasNext()) {
            this.addLinkShape(gl, glu, (LinkShape)iter2.next(), i);
            ++i;
        }
    }

    private void addLinkShape(GL2 gl, GLU glu, LinkShape shape2, int index) {
        VectorShape vShape = (VectorShape)shape2.getDirectionIndicator();
        GLLinkShape gShape = this.is3D ? new GLLinkShape3D(shape2, new GLShape(vShape.getName(), index, vShape.isRotatable())) : new GLLinkShape(shape2, new GLShape(vShape.getName(), index, vShape.isRotatable()));
        this.linkShapes.put(shape2.getName(), gShape);
        this.compileShape(gl, glu, vShape, index, vShape.isRotatable());
    }

    private void addModelShapes(GL2 gl, GLU glu) {
        List<Shape> modelShapeList = this.turtleShapeList.getShapes();
        this.lastList = gl.glGenLists(modelShapeList.size());
        for (int i = 0; i < modelShapeList.size(); ++i) {
            VectorShape vShape = (VectorShape)modelShapeList.get(i);
            this.addModelShape(gl, glu, vShape, this.lastList + i);
        }
    }

    private void addModelShape(GL2 gl, GLU glu, VectorShape vShape, int index) {
        boolean rotatable = vShape.isRotatable();
        this.modelShapes.put(vShape.getName(), new GLShape(vShape.getName(), index, rotatable));
        this.compileShape(gl, glu, vShape, index, rotatable);
    }

    void compileShape(GL2 gl, GLU glu, VectorShape vShape, int index, boolean rotatable) {
        gl.glNewList(index, 4864);
        if (!rotatable) {
            gl.glDisable(2896);
        }
        List<Element> elements2 = vShape.getElements();
        for (int i = 0; i < elements2.size(); ++i) {
            Element element = elements2.get(i);
            if (element instanceof org.nlogo.shape.Rectangle) {
                this.renderRectangle(gl, i, (org.nlogo.shape.Rectangle)element, rotatable);
                continue;
            }
            if (element instanceof Polygon) {
                Polygons.renderPolygon(gl, glu, this.tessellator, this.tess, i, (Polygon)element, rotatable, this.is3D);
                continue;
            }
            if (element instanceof Circle) {
                this.renderCircle(gl, glu, i, (Circle)element, rotatable);
                continue;
            }
            if (element instanceof Line) {
                this.renderLine(gl, i, (Line)element);
                continue;
            }
            if (!(element instanceof Curve)) continue;
            throw new IllegalStateException();
        }
        if (!rotatable) {
            gl.glEnable(2896);
        }
        gl.glEndList();
    }

    private void renderRectangle(GL2 gl, int offset, org.nlogo.shape.Rectangle rect, boolean rotatable) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!rect.marked()) {
            float[] rgb = rect.getColor().getRGBColorComponents(null);
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rgb));
        }
        Point[] corners = rect.getCorners();
        float[] coords = new float[]{(float)corners[0].x * 0.001f - 0.15f, (float)(300 - corners[0].y) * 0.001f - 0.15f, (float)corners[1].x * 0.001f - 0.15f, (float)(300 - corners[1].y) * 0.001f - 0.15f};
        this.renderRectangle(gl, coords[0], coords[2], coords[3], coords[1], -zDepth, zDepth, !rect.filled(), rotatable);
        if (!rect.marked()) {
            gl.glPopAttrib();
        }
    }

    void renderRectangle(GL2 gl, float x0, float x1, float y0, float y1, float z0, float z1, boolean filled, boolean rotatable) {
        Rectangle.renderRectangularPrism(gl, x0, x1, y0, y1, z0, z1, filled, this.is3D && rotatable, rotatable);
    }

    private void renderCircle(GL2 gl, GLU glu, int offset, Circle circle, boolean rotatable) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!circle.marked()) {
            float[] rgb = circle.getColor().getRGBColorComponents(null);
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rgb));
        }
        float radius = (float)circle.getBounds().getWidth() * 5.0E-4f;
        float[] origin = new float[]{(float)circle.getOrigin().getX() * 0.001f - 0.15f, (300.0f - (float)circle.getOrigin().getY()) * 0.001f - 0.15f};
        gl.glPushMatrix();
        if (!circle.filled()) {
            glu.gluQuadricDrawStyle(this.quadric, 100013);
        }
        if (rotatable) {
            if (!circle.filled()) {
                glu.gluQuadricDrawStyle(this.quadric, 100012);
                gl.glDisable(2884);
            }
            gl.glTranslatef(origin[0], origin[1], -zDepth);
            glu.gluCylinder(this.quadric, (double)radius, (double)radius, (double)(2.0f * zDepth), 16, 1);
            if (!circle.filled()) {
                gl.glEnable(2884);
                glu.gluQuadricDrawStyle(this.quadric, 100013);
            }
            gl.glTranslatef(0.0f, 0.0f, 2.0f * zDepth);
        } else {
            gl.glTranslatef(origin[0], origin[1], zDepth);
        }
        this.renderCircle(gl, glu, 0.0f, radius, zDepth, rotatable);
        if (!circle.filled()) {
            glu.gluQuadricDrawStyle(this.quadric, 100012);
        }
        gl.glPopMatrix();
        if (!circle.marked()) {
            gl.glPopAttrib();
        }
    }

    private void renderCircle(GL2 gl, GLU glu, float innerRadius, float outerRadius, float zDepth, boolean rotatable) {
        glu.gluDisk(this.quadric, (double)innerRadius, (double)outerRadius, 16, 1);
        if (this.is3D && rotatable) {
            gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            gl.glTranslatef(0.0f, 0.0f, zDepth * 2.0f);
            glu.gluDisk(this.quadric, (double)innerRadius, (double)outerRadius, 16, 1);
        }
    }

    private void renderLine(GL2 gl, int offset, Line line) {
        float zDepth = (float)offset * 1.0E-4f;
        if (!line.marked()) {
            float[] rgb = line.getColor().getRGBColorComponents(null);
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rgb));
        }
        Point start2 = line.getStart();
        Point end = line.getEnd();
        float[] coords = new float[]{(float)start2.x * 0.001f - 0.15f, (float)(300 - start2.y) * 0.001f - 0.15f, (float)end.x * 0.001f - 0.15f, (float)(300 - end.y) * 0.001f - 0.15f};
        gl.glBegin(1);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(coords[0], coords[1], zDepth);
        gl.glVertex3f(coords[2], coords[3], zDepth);
        gl.glEnd();
        if (!line.marked()) {
            gl.glPopAttrib();
        }
    }

    private class AddShapeRequest {
        final AddShapeRequestType type;
        final Object data;

        AddShapeRequest(AddShapeRequestType type, Object data2) {
            this.type = type;
            this.data = data2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AddShapeRequestType {
        IMPORT,
        LIBRARY_TURTLE,
        LIBRARY_LINK;

    }
}

