/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.mc.CreateUserRequest;
import org.nlogo.mc.DisableableComboBox;
import org.nlogo.mc.FileImage;
import org.nlogo.mc.FileSelector;
import org.nlogo.mc.ModelingCommons;
import org.nlogo.mc.Month;
import org.nlogo.mc.Person;
import org.nlogo.mc.Request;
import org.nlogo.mc.SexOfPerson;

public strictfp class NewUserDialog
extends JDialog {
    private JButton loginButton;
    private JButton createAccountButton;
    private JButton cancelButton;
    private JTextField emailAddressField;
    private JRadioButton femaleRadioButton;
    private JRadioButton maleRadioButton;
    private JComboBox birthdayYearComboBox;
    private JComboBox birthdayMonthComboBox;
    private JComboBox birthdayDayComboBox;
    private JPasswordField passwordField;
    private JPasswordField passwordConfirmField;
    private JTextField firstNameField;
    private JTextField lastNameField;
    private DisableableComboBox countryComboBox;
    private JLabel errorLabel;
    private JPanel topLevelContainer;
    private JTextPane userAgreementTextPane;
    private JScrollPane userAgreementScrollPane;
    private JRadioButton imageFromFileRadioButton;
    private JRadioButton noProfilePictureRadioButton;
    private FileSelector fileSelector;
    private ModelingCommons communicator;
    private Frame frame;

    public NewUserDialog(Frame frame, ModelingCommons communicator, String errorLabelText) {
        super(frame);
        this.communicator = communicator;
        this.frame = frame;
        this.initializeGUIComponents();
        this.errorLabel.setText(errorLabelText);
        this.getRootPane().setDefaultButton(this.createAccountButton);
        for (String country : communicator.getPriorityCountries()) {
            this.countryComboBox.addItem(country, true);
        }
        this.countryComboBox.addItem("--------", false);
        for (String country : communicator.getUnpriorityCountries()) {
            this.countryComboBox.addItem(country, true);
        }
        this.femaleRadioButton.setSelected(true);
        this.userAgreementTextPane.setText(communicator.getNewUserAgreement());
        this.userAgreementTextPane.setCaretPosition(0);
        int startYear = 1930;
        this.birthdayYearComboBox.addItem(null);
        for (int y = Calendar.getInstance().get(1); y >= startYear; --y) {
            this.birthdayYearComboBox.addItem(y);
        }
        this.birthdayMonthComboBox.addItem(null);
        for (Month month : Month.getMonths()) {
            this.birthdayMonthComboBox.addItem(month);
        }
        this.birthdayDayComboBox.addItem(null);
        for (int d = 1; d <= 31; ++d) {
            this.birthdayDayComboBox.addItem(d);
        }
        this.imageFromFileRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (NewUserDialog.this.imageFromFileRadioButton.isSelected()) {
                    NewUserDialog.this.fileSelector.setEnabled(true);
                } else {
                    NewUserDialog.this.fileSelector.setEnabled(false);
                }
            }
        });
        this.imageFromFileRadioButton.setSelected(true);
        this.createAccountButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewUserDialog.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewUserDialog.this.onCancel();
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewUserDialog.this.dispose();
                NewUserDialog.this.communicator.promptForLogin();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NewUserDialog.this.onCancel();
            }
        });
        this.topLevelContainer.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewUserDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(true);
    }

    private boolean isValidInput() {
        if (this.firstNameField.getText().length() == 0) {
            this.errorLabel.setText("First name cannot be blank");
            return false;
        }
        if (this.lastNameField.getText().length() == 0) {
            this.errorLabel.setText("Last name cannot be blank");
            return false;
        }
        if (this.emailAddressField.getText().length() == 0) {
            this.errorLabel.setText("Email address cannot be blank");
            return false;
        }
        if (this.passwordField.getPassword().length == 0) {
            this.errorLabel.setText("Password cannot be blank");
            return false;
        }
        if (!Arrays.equals(this.passwordField.getPassword(), this.passwordConfirmField.getPassword())) {
            this.errorLabel.setText("Passwords do not match");
            return false;
        }
        return true;
    }

    private void onOK() {
        if (!this.isValidInput()) {
            return;
        }
        this.dispose();
        String firstName = this.firstNameField.getText().trim();
        String lastName = this.lastNameField.getText().trim();
        String emailAddress = this.emailAddressField.getText().trim();
        SexOfPerson sexOfPerson = this.femaleRadioButton.isSelected() ? SexOfPerson.FEMALE : SexOfPerson.MALE;
        String country = (String)this.countryComboBox.getSelectedObject();
        Integer birthdayYear = (Integer)this.birthdayYearComboBox.getSelectedItem();
        Month birthdayMonth = (Month)this.birthdayMonthComboBox.getSelectedItem();
        Integer birthdayDay = (Integer)this.birthdayDayComboBox.getSelectedItem();
        char[] passwordArr = this.passwordField.getPassword();
        String password = new String(passwordArr);
        Arrays.fill(passwordArr, '\u0000');
        FileImage profilePicture = null;
        if (this.imageFromFileRadioButton.isSelected() && this.fileSelector.getFilePath() != null) {
            profilePicture = new FileImage(this.fileSelector.getFilePath());
        }
        CreateUserRequest request = new CreateUserRequest(this.communicator.getHttpClient(), this.frame, firstName, lastName, emailAddress, sexOfPerson, country, birthdayYear, birthdayMonth, birthdayDay, password, profilePicture){

            protected void onCreateUser(String status, Person person) {
                if (status.equals("INVALID_PROFILE_PICTURE")) {
                    NewUserDialog.this.communicator.promptForCreateAccount("Invalid profile picture");
                } else if (status.equals("ERROR_CREATING_USER")) {
                    NewUserDialog.this.communicator.promptForCreateAccount("Error creating user");
                } else if (status.equals("CONNECTION_ERROR")) {
                    NewUserDialog.this.communicator.promptForCreateAccount("Error connecting to Modeling Commons");
                } else if (status.equals("SUCCESS")) {
                    NewUserDialog.this.communicator.setPerson(person);
                    NewUserDialog.this.communicator.promptForUpload();
                } else {
                    NewUserDialog.this.communicator.promptForCreateAccount("Unknown server error");
                }
            }
        };
        ((Request)request).execute();
    }

    private void onCancel() {
        this.dispose();
    }

    private void setMaxHeightToPreferredHeight(JComponent component) {
        component.setMaximumSize(new Dimension((int)component.getMaximumSize().getWidth(), (int)component.getPreferredSize().getHeight()));
    }

    private void initializeGUIComponents() {
        this.topLevelContainer = new JPanel();
        this.topLevelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.topLevelContainer.setLayout(new BoxLayout(this.topLevelContainer, 1));
        this.setContentPane(this.topLevelContainer);
        JPanel formPanel = new JPanel();
        JPanel errorPanel = new JPanel();
        JPanel userAgreementNoticePanel = new JPanel();
        JPanel userAgreementPanel = new JPanel();
        JPanel alreadyRegisteredPanel = new JPanel();
        JPanel buttonsPanel = new JPanel();
        this.topLevelContainer.add(formPanel);
        this.topLevelContainer.add(errorPanel);
        this.topLevelContainer.add(Box.createVerticalGlue());
        this.topLevelContainer.add(userAgreementNoticePanel);
        this.topLevelContainer.add(userAgreementPanel);
        this.topLevelContainer.add(alreadyRegisteredPanel);
        this.topLevelContainer.add(buttonsPanel);
        formPanel.setLayout(new BorderLayout());
        JPanel formLabels = new JPanel(new GridLayout(11, 1));
        formLabels.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel formFields = new JPanel(new GridLayout(11, 1));
        formPanel.add((Component)formLabels, "Before");
        formPanel.add((Component)formFields, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        formLabels.add(new JLabel("First Name"));
        this.firstNameField = new JTextField();
        JPanel firstNameFieldPanel = new JPanel(new GridBagLayout());
        firstNameFieldPanel.add((Component)this.firstNameField, constraints);
        formFields.add(firstNameFieldPanel);
        formLabels.add(new JLabel("Last Name"));
        this.lastNameField = new JTextField();
        JPanel lastNameFieldPanel = new JPanel(new GridBagLayout());
        lastNameFieldPanel.add((Component)this.lastNameField, constraints);
        formFields.add(lastNameFieldPanel);
        formLabels.add(new JLabel("Email Address"));
        this.emailAddressField = new JTextField();
        JPanel emailAddressFieldPanel = new JPanel(new GridBagLayout());
        emailAddressFieldPanel.add((Component)this.emailAddressField, constraints);
        formFields.add(emailAddressFieldPanel);
        formLabels.add(new JLabel(""));
        this.femaleRadioButton = new JRadioButton("Female");
        formFields.add(this.femaleRadioButton);
        formLabels.add(new JLabel("Sex"));
        this.maleRadioButton = new JRadioButton("Male");
        formFields.add(this.maleRadioButton);
        formLabels.add(new JLabel("Country"));
        this.countryComboBox = new DisableableComboBox();
        JPanel countryComboBoxPanel = new JPanel(new GridBagLayout());
        countryComboBoxPanel.add((Component)this.countryComboBox, constraints);
        formFields.add(countryComboBoxPanel);
        formLabels.add(new JLabel("Birthday (Optional)"));
        JPanel birthdayPanel = new JPanel(new GridLayout(1, 3, 10, 0));
        formFields.add(birthdayPanel);
        this.birthdayYearComboBox = new JComboBox();
        this.birthdayMonthComboBox = new JComboBox();
        this.birthdayDayComboBox = new JComboBox();
        JPanel birthdayYearComboBoxPanel = new JPanel(new GridBagLayout());
        JPanel birthdayMonthComboBoxPanel = new JPanel(new GridBagLayout());
        JPanel birthdayDayComboBoxPanel = new JPanel(new GridBagLayout());
        birthdayYearComboBoxPanel.add((Component)this.birthdayYearComboBox, constraints);
        birthdayMonthComboBoxPanel.add((Component)this.birthdayMonthComboBox, constraints);
        birthdayDayComboBoxPanel.add((Component)this.birthdayDayComboBox, constraints);
        birthdayPanel.add(birthdayYearComboBoxPanel);
        birthdayPanel.add(birthdayMonthComboBoxPanel);
        birthdayPanel.add(birthdayDayComboBoxPanel);
        formLabels.add(new JLabel("Password"));
        JPanel passwordFieldPanel = new JPanel(new GridBagLayout());
        this.passwordField = new JPasswordField();
        passwordFieldPanel.add((Component)this.passwordField, constraints);
        formFields.add(passwordFieldPanel);
        formLabels.add(new JLabel("Password Confirmation"));
        JPanel passwordConfirmFieldPanel = new JPanel(new GridBagLayout());
        this.passwordConfirmField = new JPasswordField();
        passwordConfirmFieldPanel.add((Component)this.passwordConfirmField, constraints);
        formFields.add(passwordConfirmFieldPanel);
        formLabels.add(new JLabel("Profile Picture"));
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        this.imageFromFileRadioButton = new JRadioButton("Image from file");
        filePanel.add(this.imageFromFileRadioButton);
        this.fileSelector = new FileSelector(filePanel);
        filePanel.add(this.fileSelector);
        formFields.add(filePanel);
        formLabels.add(new JLabel(""));
        this.noProfilePictureRadioButton = new JRadioButton("No profile picture");
        formFields.add(this.noProfilePictureRadioButton);
        this.setMaxHeightToPreferredHeight(formPanel);
        errorPanel.setLayout(new FlowLayout(3, 0, 5));
        this.errorLabel = new JLabel("Error message");
        this.errorLabel.setForeground(Color.RED);
        errorPanel.add(this.errorLabel);
        this.setMaxHeightToPreferredHeight(errorPanel);
        userAgreementNoticePanel.setLayout(new FlowLayout(3, 0, 5));
        userAgreementNoticePanel.add(new JLabel("By clicking 'Create Account', you agree to the user agreement below:"));
        this.setMaxHeightToPreferredHeight(userAgreementNoticePanel);
        userAgreementPanel.setLayout(new BorderLayout());
        JScrollPane userAgreementScrollPane = new JScrollPane();
        this.userAgreementTextPane = new JTextPane();
        this.userAgreementTextPane.setContentType("text/html");
        this.userAgreementTextPane.setText("<b>This</b> is some test text!!!");
        this.userAgreementTextPane.setPreferredSize(new Dimension(this.userAgreementTextPane.getPreferredSize().width, 150));
        userAgreementScrollPane.setViewportView(this.userAgreementTextPane);
        userAgreementPanel.add((Component)userAgreementScrollPane, "Center");
        this.setMaxHeightToPreferredHeight(userAgreementPanel);
        alreadyRegisteredPanel.setLayout(new FlowLayout(3, 0, 5));
        alreadyRegisteredPanel.add(new JLabel("Already registered?"));
        this.setMaxHeightToPreferredHeight(alreadyRegisteredPanel);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.loginButton = new JButton("Login");
        this.cancelButton = new JButton("Cancel");
        this.createAccountButton = new JButton("Create Account");
        buttonsPanel.add(this.loginButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonsPanel.add(this.createAccountButton);
        this.setMaxHeightToPreferredHeight(buttonsPanel);
        ButtonGroup sexButtonGroup = new ButtonGroup();
        sexButtonGroup.add(this.maleRadioButton);
        sexButtonGroup.add(this.femaleRadioButton);
        ButtonGroup profilePictureButtonGroup = new ButtonGroup();
        profilePictureButtonGroup.add(this.imageFromFileRadioButton);
        profilePictureButtonGroup.add(this.noProfilePictureRadioButton);
    }
}

