/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.util.Arrays;
import java.util.Comparator;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001%\u0011!\u0002\u0016:b]Nd\u0017\r^8s\u0015\t\u0019A!A\u0002tI6T!!\u0002\u0004\u0002\u000b9dwnZ8\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0006\u0013!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0006[>$W\r\u001c\t\u00037qi\u0011AA\u0005\u0003;\t\u0011Q!T8eK2D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\tG>l\u0007/\u001b7feB\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0004CBL\u0017BA\u0013#\u0005A\u0019u.\u001c9jY\u0016\u00148+\u001a:wS\u000e,7\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0004S)Z\u0003CA\u000e\u0001\u0011\u0015Ib\u00051\u0001\u001b\u0011\u0015yb\u00051\u0001!\u0011\u001di\u0003A1A\u0005\u00029\naa\u001d;pG.\u001cX#A\u0018\u0011\u0007A*t'D\u00012\u0015\t\u00114'A\u0004nkR\f'\r\\3\u000b\u0005Q\"\u0012AC2pY2,7\r^5p]&\u0011a'\r\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA\u000e9\u0013\tI$AA\u0003Ti>\u001c7\u000e\u0003\u0004<\u0001\u0001\u0006IaL\u0001\bgR|7m[:!\u0011\u001di\u0004A1A\u0005\u0002y\nQA]1uKN,\u0012a\u0010\t\u0004aU\u0002\u0005CA\u000eB\u0013\t\u0011%A\u0001\u0003SCR,\u0007B\u0002#\u0001A\u0003%q(\u0001\u0004sCR,7\u000f\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0003)\u0019wN\u001c<feR,'o]\u000b\u0002\u0011B\u0019\u0001'N%\u0011\u0005mQ\u0015BA&\u0003\u0005%\u0019uN\u001c<feR,'\u000f\u0003\u0004N\u0001\u0001\u0006I\u0001S\u0001\fG>tg/\u001a:uKJ\u001c\b\u0005C\u0004P\u0001\t\u0007I\u0011A$\u0002%\r|gn\u001d;b]R\u001cuN\u001c<feR,'o\u001d\u0005\u0007#\u0002\u0001\u000b\u0011\u0002%\u0002'\r|gn\u001d;b]R\u001cuN\u001c<feR,'o\u001d\u0011\t\u000fM\u0003!\u0019!C\u0001)\u0006\u0011A\r^\u000b\u0002+B\u00111BV\u0005\u0003/2\u0011aa\u0015;sS:<\u0007BB-\u0001A\u0003%Q+A\u0002ei\u0002BQa\u0017\u0001\u0005\u0002Q\u000baa]8ve\u000e,\u0007\"B/\u0001\t\u0013q\u0016\u0001\u00059s_\u000e,G-\u001e:f\r>\u0014(+\u0019;f)\t)v\fC\u0003a9\u0002\u0007\u0001)A\u0001s\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003U\u0001(o\\2fIV\u0014XMR8s\u0007>tg/\u001a:uKJ$\"!\u00163\t\u000b\u0015\f\u0007\u0019A%\u0002\u0003\rDQa\u001a\u0001\u0005\u0002!\fa$\u001b8ji&\fGNV1mk\u0016,\u0005\u0010\u001d:fgNLwN\u001c$peN#xnY6\u0015\u0005UK\u0007\"\u00026g\u0001\u00049\u0014!A:\t\u000b1\u0004A\u0011A7\u0002E%t\u0017\u000e^5bYZ\u000bG.^3FqB\u0014Xm]:j_:4uN]\"p]Z,'\u000f^3s)\t)f\u000eC\u0003fW\u0002\u0007\u0011\nC\u0003q\u0001\u0011\u0005\u0011/A\u000bva\u0012\fG/Z*u_\u000e\\W\t\u001f9sKN\u001c\u0018n\u001c8\u0015\u0005U\u0013\b\"\u00026p\u0001\u00049\u0004\"\u0002;\u0001\t\u0003)\u0018AC5t\u0007>t7\u000f^1oiR\u0011a/\u001f\t\u0003']L!\u0001\u001f\u000b\u0003\u000f\t{w\u000e\\3b]\")!n\u001da\u0001uB\u00111P \b\u0003'qL!! \u000b\u0002\rA\u0013X\rZ3g\u0013\t9vP\u0003\u0002~)\u00191\u00111\u0001\u0001\u0001\u0003\u000b\u0011qb\u0015;pG.\u001cu.\u001c9be\u0006$xN]\n\u0007\u0003\u0003Q\u0011q\u0001\n\u0011\u000b\u0005%\u0011qB\u001c\u000e\u0005\u0005-!bAA\u0007\u001d\u0005!Q\u000f^5m\u0013\u0011\t\t\"a\u0003\u0003\u0015\r{W\u000e]1sCR|'\u000fC\u0004(\u0003\u0003!\t!!\u0006\u0015\u0005\u0005]\u0001\u0003BA\r\u0003\u0003i\u0011\u0001\u0001\u0005\t\u0003;\t\t\u0001\"\u0001\u0002 \u000591m\\7qCJ,GCBA\u0011\u0003O\tY\u0003E\u0002\u0014\u0003GI1!!\n\u0015\u0005\rIe\u000e\u001e\u0005\b\u0003S\tY\u00021\u00018\u0003\t\u0019\u0018\u0007C\u0004\u0002.\u0005m\u0001\u0019A\u001c\u0002\u0005M\u0014\u0004")
public class Translator
implements ScalaObject {
    private final CompilerServices compiler;
    private final ListBuffer<Stock> stocks;
    private final ListBuffer<Rate> rates;
    private final ListBuffer<Converter> converters;
    private final ListBuffer<Converter> constantConverters;
    private final String dt;
    private volatile int bitmap$init$0;

    public ListBuffer<Stock> stocks() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.stocks;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 13".toString());
    }

    public ListBuffer<Rate> rates() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.rates;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 14".toString());
    }

    public ListBuffer<Converter> converters() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.converters;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 15".toString());
    }

    public ListBuffer<Converter> constantConverters() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.constantConverters;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 16".toString());
    }

    public String dt() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.dt;
        }
        throw new UninitializedFieldError("Uninitialized field: Translator.scala: 17".toString());
    }

    public String source() {
        Stock[] sortedStocks = (Stock[])this.stocks().toArray(ClassManifest$.MODULE$.classType(Stock.class));
        Arrays.sort((Object[])sortedStocks, new StockComparator(this));
        ObjectRef globals$1 = new ObjectRef("");
        ObjectRef procedures$1 = new ObjectRef("");
        ObjectRef plots$1 = new ObjectRef("");
        globals$1.elem = new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)";; System dynamics model globals\nglobals [\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)";; Initializes the system dynamics model.\n;; Call this in your model's SETUP procedure.\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)new StringBuilder().append((Object)"to system-dynamics-setup\n  reset-ticks\n  set dt ").append((Object)this.dt()).append((Object)"\n").toString()).toString();
        if (!this.constantConverters().isEmpty()) {
            globals$1.elem = new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)"  ;; constants\n").toString();
            procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"  ;; initialize constant values\n").toString();
            this.constantConverters().foreach(new Serializable(this, globals$1, procedures$1){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef globals$1;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Converter cc) {
                    this.globals$1.elem = new StringBuilder().append((Object)((String)this.globals$1.elem)).append((Object)new StringBuilder().append((Object)"  ").append((Object)cc.name()).append((Object)"\n").toString()).toString();
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.initialValueExpressionForConverter(cc)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.globals$1 = objectRef;
                    this.procedures$1 = objectRef2;
                }
            });
        }
        if (!this.stocks().isEmpty()) {
            globals$1.elem = new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)"  ;; stock values\n").toString();
            procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"  ;; initialize stock values\n").toString();
            Predef$.MODULE$.refArrayOps((Object[])sortedStocks).foreach(new Serializable(this, globals$1, procedures$1){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef globals$1;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock s) {
                    this.globals$1.elem = new StringBuilder().append((Object)((String)this.globals$1.elem)).append((Object)new StringBuilder().append((Object)"  ").append((Object)s.name()).append((Object)"\n").toString()).toString();
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.initialValueExpressionForStock(s)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.globals$1 = objectRef;
                    this.procedures$1 = objectRef2;
                }
            });
        }
        globals$1.elem = new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)"  ;; size of each step, see SYSTEM-DYNAMICS-GO\n  dt\n").toString();
        globals$1.elem = new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)"]\n\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"end\n\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)";; Step through the system dynamics model by performing next iteration of Euler's method.\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)";; Call this in your model's GO procedure.\n").toString();
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"to system-dynamics-go\n").toString();
        plots$1.elem = new StringBuilder().append((Object)((String)plots$1.elem)).append((Object)";; Plot the current state of the system dynamics model's stocks\n").toString();
        plots$1.elem = new StringBuilder().append((Object)((String)plots$1.elem)).append((Object)";; Call this procedure in your plot's update commands.\n").toString();
        plots$1.elem = new StringBuilder().append((Object)((String)plots$1.elem)).append((Object)"to system-dynamics-do-plot\n").toString();
        if (!this.converters().isEmpty() || !this.rates().isEmpty()) {
            procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"\n  ;; compute variable and flow values once per step\n").toString();
            this.converters().foreach(new Serializable(this, procedures$1){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Converter c) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  let local-").append((Object)c.name()).append((Object)" ").append((Object)c.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
            this.rates().foreach(new Serializable(this, procedures$1){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Rate r) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  let local-").append((Object)r.name()).append((Object)" ").append((Object)r.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
        }
        if (!this.stocks().isEmpty()) {
            procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"\n  ;; update stock values\n  ;; use temporary variables so order of computation doesn't affect result.\n").toString();
            Predef$.MODULE$.refArrayOps((Object[])sortedStocks).foreach(new Serializable(this, procedures$1, plots$1){
                public static final long serialVersionUID;
                private final Translator $outer;
                private final ObjectRef procedures$1;
                private final ObjectRef plots$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock s) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.updateStockExpression(s)).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"  if plot-pen-exists? \"").append((Object)s.name()).append((Object)"\" [\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"    set-current-plot-pen \"").append((Object)s.name()).append((Object)"\"\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)new StringBuilder().append((Object)"    plotxy ticks ").append((Object)s.name()).append((Object)"\n").toString()).toString();
                    this.plots$1.elem = new StringBuilder().append((Object)((String)this.plots$1.elem)).append((Object)"  ]\n").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.procedures$1 = objectRef;
                    this.plots$1 = objectRef2;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])sortedStocks).foreach(new Serializable(this, procedures$1){
                public static final long serialVersionUID;
                private final ObjectRef procedures$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Stock s) {
                    this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)new StringBuilder().append((Object)"  set ").append((Object)s.name()).append((Object)" new-").append((Object)s.name()).append((Object)"\n").toString()).toString();
                }
                {
                    this.procedures$1 = objectRef;
                }
            });
        }
        procedures$1.elem = new StringBuilder().append((Object)((String)procedures$1.elem)).append((Object)"\n  tick-advance dt\nend\n\n").toString();
        plots$1.elem = new StringBuilder().append((Object)((String)plots$1.elem)).append((Object)"end\n\n").toString();
        this.rates().foreach(new Serializable(this, procedures$1){
            public static final long serialVersionUID;
            private final Translator $outer;
            private final ObjectRef procedures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Rate r) {
                this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.org$nlogo$sdm$Translator$$procedureForRate(r)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.procedures$1 = objectRef;
            }
        });
        this.converters().foreach(new Serializable(this, procedures$1){
            public static final long serialVersionUID;
            private final Translator $outer;
            private final ObjectRef procedures$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Converter c) {
                this.procedures$1.elem = new StringBuilder().append((Object)((String)this.procedures$1.elem)).append((Object)this.$outer.procedureForConverter(c)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.procedures$1 = objectRef;
            }
        });
        return new StringBuilder().append((Object)((String)globals$1.elem)).append((Object)((String)procedures$1.elem)).append((Object)((String)plots$1.elem)).toString();
    }

    public final String org$nlogo$sdm$Translator$$procedureForRate(Rate r) {
        return new StringBuilder().append((Object)";; Report value of flow\nto-report ").append((Object)r.name()).append((Object)"\n").append((Object)"  report ( ").append((Object)(r.expression() == null ? "0" : r.expression())).append((Object)"\n  ) * ").append((Object)"dt").append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public String procedureForConverter(Converter c) {
        return new StringBuilder().append((Object)";; Report value of variable\nto-report ").append((Object)c.name()).append((Object)"\n").append((Object)"  report ").append((Object)(c.expression() == null ? "0" : c.expression())).append((Object)"\n").append((Object)"end\n\n").toString();
    }

    public String initialValueExpressionForStock(Stock s) {
        return new StringBuilder().append((Object)"  set ").append((Object)s.name()).append((Object)" ").append((Object)(s.initialValueExpression() == null ? "0" : s.initialValueExpression())).append((Object)"\n").toString();
    }

    public String initialValueExpressionForConverter(Converter c) {
        return new StringBuilder().append((Object)"  set ").append((Object)c.name()).append((Object)" ").append((Object)(c.expression() == null ? "0" : c.expression())).append((Object)"\n").toString();
    }

    public String updateStockExpression(Stock s$1) {
        ObjectRef expr$1 = new ObjectRef(new StringBuilder().append((Object)"  let new-").append((Object)s$1.name()).append((Object)(s$1.nonNegative() ? " max( list 0 ( " : " ( ")).append((Object)s$1.name()).append((Object)" ").toString());
        this.rates().foreach(new Serializable(this, s$1, expr$1){
            public static final long serialVersionUID;
            private final Stock s$1;
            private final ObjectRef expr$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Rate r) {
                String string2 = r.source().name();
                String string3 = this.s$1.name();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.expr$1.elem = new StringBuilder().append((Object)((String)this.expr$1.elem)).append((Object)new StringBuilder().append((Object)"- local-").append((Object)r.name()).append((Object)" ").toString()).toString();
                }
                String string4 = r.sink().name();
                String string5 = this.s$1.name();
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    this.expr$1.elem = new StringBuilder().append((Object)((String)this.expr$1.elem)).append((Object)new StringBuilder().append((Object)"+ local-").append((Object)r.name()).append((Object)" ").toString()).toString();
                }
            }
            {
                this.s$1 = stock;
                this.expr$1 = objectRef;
            }
        });
        if (s$1.nonNegative()) {
            expr$1.elem = new StringBuilder().append((Object)((String)expr$1.elem)).append((Object)") ").toString();
        }
        return new StringBuilder().append((Object)((String)expr$1.elem)).append((Object)")\n").toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isConstant(String s) {
        void var2_2;
        boolean exceptionResult1 = false;
        try {
            this.compiler.readFromString(s);
            exceptionResult1 = true;
        }
        catch (CompilerException compilerException) {
            exceptionResult1 = false;
        }
        return (boolean)var2_2;
    }

    public Translator(Model model, CompilerServices compiler) {
        this.compiler = compiler;
        this.stocks = new ListBuffer();
        this.bitmap$init$0 |= 1;
        this.rates = new ListBuffer();
        this.bitmap$init$0 |= 2;
        this.converters = new ListBuffer();
        this.bitmap$init$0 |= 4;
        this.constantConverters = new ListBuffer();
        this.bitmap$init$0 |= 8;
        this.dt = ((Object)BoxesRunTime.boxToDouble(model.dt())).toString();
        this.bitmap$init$0 |= 0x10;
        model.elements().withFilter((Function1<ModelElement, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(ModelElement element) {
                return !element.name().isEmpty();
            }
        })).foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final Translator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(ModelElement element) {
                Converter converter;
                Converter c;
                Rate rate;
                Rate r;
                ModelElement modelElement = element;
                Object object = modelElement instanceof Reservoir ? BoxedUnit.UNIT : (modelElement instanceof Stock ? this.$outer.stocks().$plus$eq((Object)((Stock)modelElement)) : (modelElement instanceof Rate ? ((r = (rate = (Rate)modelElement)).expression().isEmpty() ? BoxedUnit.UNIT : this.$outer.rates().$plus$eq((Object)r)) : (modelElement instanceof Converter ? ((c = (converter = (Converter)modelElement)).expression().isEmpty() ? BoxedUnit.UNIT : (this.$outer.isConstant(c.expression().toUpperCase()) ? this.$outer.constantConverters().$plus$eq((Object)c) : this.$outer.converters().$plus$eq((Object)c))) : BoxedUnit.UNIT)));
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StockComparator
    implements Comparator<Stock>,
    ScalaObject {
        public final Translator $outer;

        @Override
        public int compare(Stock s1, Stock s2) {
            String sname1 = s1.name().toUpperCase();
            String sname2 = s2.name().toUpperCase();
            String sexp1 = s1.initialValueExpression().toUpperCase();
            String sexp2 = s2.initialValueExpression().toUpperCase();
            return this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp1) ? (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2) ? sname1.compareTo(sname2) : -1) : (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2) ? 1 : sname1.compareTo(sname2));
        }

        public Translator org$nlogo$sdm$Translator$StockComparator$$$outer() {
            return this.$outer;
        }

        public StockComparator(Translator $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

