/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ModelReader;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.RandomServices;
import org.nlogo.api.Version;
import org.nlogo.api.VersionHistory;
import org.nlogo.plot.PlotManager;
import org.nlogo.util.Exceptions;
import org.nlogo.util.SysInfo;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.EditorFactory;
import org.nlogo.window.Events;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.WidgetRegistry;

public strictfp class InterfacePanelLite
extends JLayeredPane
implements WidgetContainer,
FocusListener,
Events.LoadSectionEvent.Handler,
Events.OutputEvent.Handler {
    private final Map<String, Widget> widgets;
    private final ViewWidgetInterface viewWidget;
    private final CompilerServices compiler;
    private final RandomServices random;
    private final PlotManager plotManager;
    private final EditorFactory editorFactory;
    boolean hasFocus = true;
    private boolean sliderEventOnReleaseOnly = false;

    public ViewWidgetInterface viewWidget() {
        return this.viewWidget;
    }

    public InterfacePanelLite(ViewWidgetInterface viewWidget, CompilerServices compiler, RandomServices random, PlotManager plotManager, EditorFactory editorFactory) {
        this.viewWidget = viewWidget;
        this.compiler = compiler;
        this.random = random;
        this.plotManager = plotManager;
        this.editorFactory = editorFactory;
        this.widgets = new HashMap<String, Widget>();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(e);
                } else {
                    InterfacePanelLite.this.requestFocus();
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(e);
                }
            }
        });
        this.addKeyListener(this.getKeyAdapter());
        this.addWidget((Widget)((Object)viewWidget), 0, 0);
    }

    protected KeyAdapter getKeyAdapter() {
        return new ButtonKeyAdapter();
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.enableButtonKeys(true);
    }

    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void reset() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof PlotWidget) {
                this.plotManager.forgetPlot(((PlotWidget)comps[i]).plot());
            }
            if (comps[i] instanceof ViewWidgetInterface) continue;
            this.remove(comps[i]);
        }
    }

    private void enableButtonKeys(boolean enabled) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof ButtonWidget)) continue;
            ButtonWidget button = (ButtonWidget)comps[i];
            button.keyEnabled(enabled);
        }
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.enableButtonKeys(false);
    }

    protected ButtonWidget findActionButton(char key) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ButtonWidget button;
            if (!(comps[i] instanceof ButtonWidget) || Character.toUpperCase((button = (ButtonWidget)comps[i]).actionKey()) != Character.toUpperCase(key)) continue;
            return button;
        }
        return null;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        int maxX = 0;
        int maxY = 0;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Widget)) continue;
            Point location = comps[i].getLocation();
            Dimension size2 = comps[i].getSize();
            int x2 = location.x + size2.width;
            int y = location.y + size2.height;
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        return new Dimension(maxX, maxY);
    }

    private OutputWidget getOutputWidget() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof OutputWidget)) continue;
            return (OutputWidget)comps[i];
        }
        return null;
    }

    public void handle(Events.OutputEvent e) {
        if (this.getOutputWidget() != null && !e.toCommandCenter) {
            if (e.clear) {
                this.getOutputWidget().outputArea().clear();
            }
            if (e.outputObject != null) {
                this.getOutputWidget().outputArea().append(e.outputObject, e.wrapLines);
            }
        }
    }

    public String getBoundsString(Widget widget) {
        StringBuilder buf = new StringBuilder();
        Rectangle r = this.getUnzoomedBounds(widget);
        buf.append(r.x + "\n");
        buf.append(r.y + "\n");
        buf.append(r.x + r.width + "\n");
        buf.append(r.y + r.height + "\n");
        return buf.toString();
    }

    public Rectangle getUnzoomedBounds(Component component) {
        return component.getBounds();
    }

    public void resetZoomInfo(Widget widget) {
    }

    public void resetSizeInfo(Widget widget) {
    }

    public boolean isZoomed() {
        return false;
    }

    private void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Version.version());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(SysInfo.getOSInfoString());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(SysInfo.getVMInfoString());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(SysInfo.getMemoryInfoString());
        item.setEnabled(false);
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    private void addWidget(Widget widget, int x2, int y) {
        this.widgets.put(widget.displayName(), widget);
        widget.addPopupListeners();
        this.add((Component)widget, DEFAULT_LAYER);
        this.moveToFront(widget);
        widget.setLocation(x2, y);
        widget.validate();
    }

    public void hideWidget(String widgetName) {
        Widget widget = this.widgets.get(widgetName);
        if (widget != null) {
            widget.setVisible(false);
        }
    }

    public void showWidget(String widgetName) {
        Widget widget = this.widgets.get(widgetName);
        if (widget != null) {
            widget.setVisible(true);
        }
    }

    public boolean sliderEventOnReleaseOnly() {
        return this.sliderEventOnReleaseOnly;
    }

    public void sliderEventOnReleaseOnly(boolean sliderEventOnReleaseOnly) {
        this.sliderEventOnReleaseOnly = sliderEventOnReleaseOnly;
    }

    public Widget loadWidget(String[] strings, final String modelVersion) {
        Widget.LoadHelper helper = new Widget.LoadHelper(){

            public String version() {
                return modelVersion;
            }

            public String convert(String source2, boolean reporter) {
                return InterfacePanelLite.this.compiler.autoConvert(source2, true, reporter, modelVersion);
            }
        };
        try {
            String type = strings[0];
            int x2 = Integer.parseInt(strings[1]);
            int y = Integer.parseInt(strings[2]);
            if (!type.equals("GRAPHICS-WINDOW") && VersionHistory.olderThan13pre1(modelVersion)) {
                y += this.viewWidget.getAdditionalHeight();
            }
            if (type.equals("GRAPHICS-WINDOW") || type.equals("VIEW")) {
                try {
                    this.viewWidget.asWidget().load(strings, helper);
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
                this.viewWidget.asWidget().setSize(this.viewWidget.asWidget().getSize());
                this.viewWidget.asWidget().setLocation(x2, y);
                return this.viewWidget.asWidget();
            }
            Widget newGuy = WidgetRegistry.apply(type);
            try {
                if (type.equals("MONITOR")) {
                    newGuy = new MonitorWidget(this.random.auxRNG());
                } else if (type.equals("PLOT")) {
                    newGuy = PlotWidget.apply(this.plotManager);
                } else if (type.equals("SLIDER")) {
                    newGuy = new SliderWidget(this.sliderEventOnReleaseOnly, this.random.auxRNG());
                } else if (type.equals("CHOOSER") || type.equals("CHOICE")) {
                    newGuy = new ChooserWidget(this.compiler);
                } else if (type.equals("INPUTBOX")) {
                    newGuy = new InputBoxWidget(this.editorFactory.newEditor(1, 20, false), this.editorFactory.newEditor(5, 20, true), this.compiler, this);
                } else if (type.equals("BUTTON")) {
                    newGuy = new ButtonWidget(this.random.mainRNG());
                } else if (type.equals("OUTPUT")) {
                    newGuy = new OutputWidget();
                }
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
            if (newGuy != null) {
                newGuy.load(strings, helper);
                this.addWidget(newGuy, x2, y);
            }
            return newGuy;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Events.LoadSectionEvent e) {
        if (e.section == ModelSectionJ.WIDGETS()) {
            try {
                List<List<String>> v = ModelReader.parseWidgets(e.lines);
                if (null != v) {
                    this.setVisible(false);
                    for (List<String> v2 : v) {
                        String[] strings = v2.toArray(new String[v2.size()]);
                        this.loadWidget(strings, e.version);
                    }
                }
            }
            finally {
                this.setVisible(true);
                this.revalidate();
            }
        }
    }

    protected strictfp class ButtonKeyAdapter
    extends KeyAdapter {
        protected ButtonKeyAdapter() {
        }

        protected boolean keyIsHandleable(KeyEvent e) {
            return e.getKeyChar() != '\uffff' && !e.isActionKey() && (e.getModifiers() & InterfacePanelLite.this.getToolkit().getMenuShortcutKeyMask()) == 0;
        }

        public void keyTyped(KeyEvent e) {
            ButtonWidget button;
            if (this.keyIsHandleable(e) && (button = InterfacePanelLite.this.findActionButton(e.getKeyChar())) != null) {
                this.buttonKeyed(button);
            }
        }

        public void buttonKeyed(ButtonWidget button) {
            button.keyTriggered();
        }
    }
}

