/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.api.I18N;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.awt.Fonts;
import org.nlogo.nvm.Workspace;
import org.nlogo.swing.ToolBar;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.SpeedSliderPanel;
import org.nlogo.window.WorldViewSettings;

public strictfp class ViewUpdatePanel
extends JPanel
implements Events.LoadEndEvent.Handler {
    private final GUIWorkspace workspace;
    private final SpeedSliderPanel speedSlider;
    private final JComboBox viewUpdates = new JComboBox();
    private final WorldViewSettings settings;
    private int speed;

    public ViewUpdatePanel(GUIWorkspace workspace, final JCheckBox displaySwitch, boolean editable) {
        this.workspace = workspace;
        this.speedSlider = new SpeedSliderPanel(workspace, true);
        displaySwitch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean selected = displaySwitch.isSelected();
                if (selected != ViewUpdatePanel.this.speedSlider.isEnabled()) {
                    ViewUpdatePanel.this.speedSlider.setEnabled(selected);
                    if (selected) {
                        ViewUpdatePanel.this.speedSlider.setValue(ViewUpdatePanel.this.speed);
                    } else {
                        ViewUpdatePanel.this.speed = ViewUpdatePanel.this.speedSlider.getValue();
                        ViewUpdatePanel.this.speedSlider.setValue(ViewUpdatePanel.this.speedSlider.getMaximum());
                    }
                }
            }
        });
        Fonts.adjustDefaultFont(displaySwitch);
        this.settings = workspace.viewWidget.settings();
        this.add(this.speedSlider);
        SettingsButton settingsButton = new SettingsButton();
        this.viewUpdates.addItem(I18N.guiJ().get("tabs.run.viewUpdates.dropdown.onticks"));
        this.viewUpdates.addItem(I18N.guiJ().get("tabs.run.viewUpdates.dropdown.continuous"));
        this.viewUpdates.setToolTipText(I18N.guiJ().get("tabs.run.viewUpdates.dropdown.tooltip"));
        if (editable) {
            JPanel panel = new JPanel(new ColumnLayout(0, 0.5f, 0.5f));
            panel.add(displaySwitch);
            Fonts.adjustDefaultFont(this.viewUpdates);
            panel.setOpaque(false);
            panel.add(this.viewUpdates);
            this.add(panel);
            this.viewUpdates.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ViewUpdatePanel.this.setMode((String)e.getItem());
                }
            });
            this.refreshSelection();
            this.add(new ToolBar.Separator());
            this.add(settingsButton);
        }
        this.setOpaque(true);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.speedSlider != null) {
            this.speedSlider.setBackground(color);
        }
        if (this.viewUpdates != null) {
            this.viewUpdates.setBackground(color);
        }
    }

    public void addNotify() {
        super.addNotify();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setFocusable(false);
            Fonts.adjustDefaultFont(comps[i]);
            if (!(comps[i] instanceof AbstractButton) || comps[i] instanceof JCheckBox) continue;
            ((AbstractButton)comps[i]).setVerticalTextPosition(3);
            ((AbstractButton)comps[i]).setHorizontalTextPosition(0);
        }
    }

    private void refreshSelection() {
        switch (this.workspace.updateMode()) {
            case TICK_BASED: {
                this.viewUpdates.setSelectedIndex(0);
                break;
            }
            case CONTINUOUS: {
                this.viewUpdates.setSelectedIndex(1);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setMode(String name) {
        if (name.equals(I18N.guiJ().get("tabs.run.viewUpdates.dropdown.onticks"))) {
            this.workspace.updateMode(Workspace.UpdateMode.TICK_BASED);
        } else if (name.equals(I18N.guiJ().get("tabs.run.viewUpdates.dropdown.continuous"))) {
            this.workspace.updateMode(Workspace.UpdateMode.CONTINUOUS);
        } else {
            throw new IllegalStateException();
        }
    }

    public void handle(Events.LoadEndEvent e) {
        this.refreshSelection();
        this.speedSlider.setValue((int)this.workspace.speedSliderPosition());
    }

    private strictfp class SettingsButton
    extends JButton {
        public SettingsButton() {
            super(I18N.guiJ().get("tabs.run.settingsButton"));
            this.setFont(new Font(Fonts.platformFont(), 0, 10));
            this.setFocusable(false);
            this.setToolTipText(I18N.guiJ().get("tabs.run.settingsButton.tooltip"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Events.EditWidgetEvent(ViewUpdatePanel.this.settings).raise(SettingsButton.this);
                }
            });
        }
    }
}

