/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.nlogo.api.FileIO;
import org.nlogo.api.Logger$;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.Version;
import org.nlogo.util.Utils$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ModelsLibrary {
    public static Node rootNode = null;

    private ModelsLibrary() {
        throw new IllegalStateException();
    }

    public static String modelsRoot() {
        return System.getProperty("netlogo.models.dir", "models");
    }

    public static String[] getModelPaths() {
        return ModelsLibrary.getModelPaths(false);
    }

    public static String[] getModelPaths(boolean exclusive) {
        ModelsLibrary.scanForModels(exclusive);
        ArrayList<String> result2 = new ArrayList<String>();
        String fileSep = File.separator;
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            Node node = (Node)models.nextElement();
            if (node.isFolder() || node.path.contains(String.format("%smodels%stest%s", fileSep, fileSep, fileSep))) continue;
            result2.add(node.path);
        }
        return result2.toArray(new String[0]);
    }

    public static String[] getModelPathsAtRoot(String path) {
        Node rnode = ModelsLibrary.scanForModelsAtRoot(path, false);
        ArrayList<String> result2 = new ArrayList<String>();
        Enumeration<TreeNode> models = rnode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            Node node = (Node)models.nextElement();
            if (node.isFolder()) continue;
            result2.add(node.path);
        }
        return result2.toArray(new String[0]);
    }

    public static List<String> findModelsBySubstring(String targetName) {
        Node model;
        String path;
        ModelsLibrary.scanForModels(false);
        ArrayList<String> result2 = new ArrayList<String>();
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            int loc;
            Node node = (Node)models.nextElement();
            if (node.isFolder() || (loc = (path = node.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf("/" + targetName.toUpperCase() + ".NLOGO")) == -1 || loc != path.lastIndexOf(47)) continue;
            result2.add(node.name);
            return result2;
        }
        models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            model = (Node)models.nextElement();
            if (model.isFolder() || (path = model.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf("/" + targetName.toUpperCase()) != path.lastIndexOf(47) || result2.contains(model.name)) continue;
            result2.add(model.name);
        }
        models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            model = (Node)models.nextElement();
            if (model.isFolder() || (path = model.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf(targetName.toUpperCase()) <= path.lastIndexOf(47) || result2.contains(model.name)) continue;
            result2.add(model.name);
        }
        return result2;
    }

    public static String getModelPath(String targetName) {
        ModelsLibrary.scanForModels(false);
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            Node model = (Node)models.nextElement();
            String path = model.path.replace(File.separator.charAt(0), '/');
            if (path.toUpperCase().indexOf("/" + targetName.toUpperCase() + ".NLOGO") != path.lastIndexOf(47)) continue;
            return model.path;
        }
        return null;
    }

    public static boolean needsModelScan() {
        return rootNode == null;
    }

    public static void scanForModels(boolean exclusive) {
        if (!ModelsLibrary.needsModelScan()) {
            return;
        }
        try {
            if (!Version.is3D() || !exclusive) {
                File directoryRoot = new File(ModelsLibrary.modelsRoot(), "").getCanonicalFile();
                rootNode = new Node(ModelsLibrary.modelsRoot(), "", true);
                ModelsLibrary.scanDirectory(directoryRoot, null, rootNode, exclusive);
            } else {
                File directoryRoot = new File(ModelsLibrary.modelsRoot(), "3D").getCanonicalFile();
                rootNode = new Node(ModelsLibrary.modelsRoot() + "/3D", "", true);
                ModelsLibrary.scanDirectory(directoryRoot, null, rootNode, exclusive);
            }
        }
        catch (IOException e) {
            Logger$.MODULE$.logCustomMessage("error: IOException canonicalizing models library path");
            Logger$.MODULE$.logCustomMessage(e.getMessage());
        }
    }

    public static Node scanForModelsAtRoot(String path, boolean exclusive) {
        File directoryRoot = new File(path, "");
        Node node = new Node(path, "", true);
        ModelsLibrary.scanDirectory(directoryRoot, null, node, exclusive);
        return node;
    }

    public static String getInfoWindow(String filePath) throws IOException {
        String file = FileIO.file2String(filePath);
        String delimiter = ModelReader$.MODULE$.SEPARATOR();
        int dlength = delimiter.length();
        int startIndex = 0;
        for (int i = 0; i < 2; ++i) {
            startIndex = file.indexOf(delimiter, startIndex);
            if (i >= 1) continue;
            startIndex += dlength;
        }
        int endIndex = file.indexOf(delimiter, startIndex += delimiter.length());
        if (startIndex >= 0 && startIndex <= file.length() && endIndex >= 0 && endIndex <= file.length()) {
            return file.substring(startIndex, endIndex).trim();
        }
        return "";
    }

    public static String getImagePath(String filePath) {
        int index = filePath.indexOf(".nlogo");
        if (index != -1) {
            filePath = filePath.substring(0, index);
        }
        return filePath + ".png";
    }

    private static void scanDirectory(File directory, Node grandparent, Node parent, boolean exclusive) {
        if (!directory.isDirectory() || Utils$.MODULE$.isSymlink(directory)) {
            return;
        }
        String[] rawEntries = directory.list();
        List<String> orderedEntries = new ArrayList<String>();
        for (int i = 0; i < rawEntries.length; ++i) {
            orderedEntries.add(rawEntries[i]);
        }
        orderedEntries = ModelsLibrary.orderItems(orderedEntries, parent.isRoot(), exclusive);
        boolean hasChild = false;
        for (int i = 0; i < orderedEntries.size(); ++i) {
            String fileName = orderedEntries.get(i);
            if (ModelsLibrary.isBadName(fileName)) continue;
            File file = new File(directory, fileName);
            Node child = new Node(ModelsLibrary.translateNameForDisplay(fileName), file.getAbsolutePath() + (file.isDirectory() ? "/" : ""), file.isDirectory());
            if (child.isFolder()) {
                hasChild = true;
                ModelsLibrary.scanDirectory(file, parent, child, exclusive);
                continue;
            }
            if (!fileName.toUpperCase().endsWith(".NLOGO") && !fileName.toUpperCase().endsWith(".NLOGO3D")) continue;
            hasChild = true;
            parent.add(child);
        }
        if (hasChild && grandparent != null) {
            grandparent.add(parent);
        }
    }

    private static String translateNameForDisplay(String name) {
        if (name.equalsIgnoreCase("UNVERIFIED")) {
            return "(unverified)";
        }
        return ModelsLibrary.removeSuffix(name);
    }

    private static List<String> orderItems(List<String> names2, boolean topLevel, boolean exclusive) {
        String[] orderednames;
        if (topLevel) {
            if (Version.is3D()) {
                if (exclusive) {
                    String[] stringArray = new String[]{"3D"};
                }
                orderednames = new String[]{"3D", "SAMPLE MODELS", "CURRICULAR MODELS", "CODE EXAMPLES", "HUBNET ACTIVITIES", "IABM TEXTBOOK", "ALTERNATIVE VISUALIZATIONS"};
            } else {
                orderednames = new String[]{"SAMPLE MODELS", "CURRICULAR MODELS", "CODE EXAMPLES", "HUBNET ACTIVITIES", "IABM TEXTBOOK", "ALTERNATIVE VISUALIZATIONS"};
            }
        } else {
            orderednames = new String[]{};
        }
        names2 = new ArrayList<String>(names2);
        Collections.sort(names2, new CustomComparator());
        ArrayList<String> tempFolders = new ArrayList<String>();
        block0: for (int number2 = 0; number2 < orderednames.length; ++number2) {
            for (int i = 0; i < names2.size(); ++i) {
                String tempName = names2.get(i);
                if (!tempName.equalsIgnoreCase(orderednames[number2])) continue;
                tempFolders.add(names2.get(i));
                names2.remove(i);
                continue block0;
            }
        }
        String unverified = null;
        for (int i = 0; i < names2.size(); ++i) {
            String temp = names2.get(i).toUpperCase();
            if (ModelsLibrary.isBadName(temp)) continue;
            if (temp.equals("UNVERIFIED")) {
                unverified = names2.get(i);
                continue;
            }
            tempFolders.add(names2.get(i));
        }
        if (unverified != null) {
            tempFolders.add(unverified);
        }
        return tempFolders;
    }

    private static boolean isBadName(String name) {
        return name.startsWith(".") || name.equals("BEATS") || !Version.is3D() && (name.equals("3D") || name.equals("VRML"));
    }

    private static String removeSuffix(String reference) {
        if (reference.endsWith(".nlogo")) {
            return reference.substring(0, reference.lastIndexOf(".nlogo"));
        }
        if (reference.endsWith(".nlogo3d")) {
            return reference.substring(0, reference.lastIndexOf(".nlogo3d"));
        }
        return reference;
    }

    public strictfp static class Node
    extends DefaultMutableTreeNode {
        private final String name;
        private final String path;

        Node(String name, String path, boolean isFolder) {
            this.name = name;
            this.path = path;
            this.allowsChildren = isFolder;
        }

        public boolean isFolder() {
            return this.allowsChildren;
        }

        public String getName() {
            return this.name;
        }

        public String getFilePath() {
            return this.path;
        }

        public String toString() {
            return this.name;
        }

        public boolean isLeaf() {
            return !this.isFolder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static class CustomComparator
    implements Comparator<String> {
        private CustomComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.munge(s1), this.munge(s2));
        }

        private String munge(String s) {
            return (s = s.toUpperCase()).endsWith(".NLOGO") ? s.substring(0, s.length() - 6) : (s.endsWith(".NLOGO3D") ? s.substring(0, s.length() - 8) : s);
        }
    }
}

