/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();
    static /* synthetic */ Class class$java$lang$Object;

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type, Type type2, boolean bl) {
        this(type, type2, null, bl);
    }

    public SimpleVerifier(Type type, Type type2, List list2, boolean bl) {
        this.currentClass = type;
        this.currentSuperClass = type2;
        this.currentClassInterfaces = list2;
        this.isInterface = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Value newValue(Type type) {
        Value value2;
        boolean bl;
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean bl2 = bl = type.getSort() == 9;
        if (bl) {
            switch (type.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(value2 = super.newValue(type))) {
            if (bl) {
                value2 = this.newValue(type.getElementType());
                String string2 = ((BasicValue)value2).getType().getDescriptor();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    string2 = '[' + string2;
                }
                value2 = new BasicValue(Type.getType(string2));
            } else {
                value2 = new BasicValue(type);
            }
        }
        return value2;
    }

    protected boolean isArrayValue(Value value2) {
        Type type = ((BasicValue)value2).getType();
        return type != null && ("Lnull;".equals(type.getDescriptor()) || type.getSort() == 9);
    }

    protected Value getElementValue(Value value2) throws AnalyzerException {
        Type type = ((BasicValue)value2).getType();
        if (type != null) {
            if (type.getSort() == 9) {
                return this.newValue(Type.getType(type.getDescriptor().substring(1)));
            }
            if ("Lnull;".equals(type.getDescriptor())) {
                return value2;
            }
        }
        throw new Error("Internal error");
    }

    protected boolean isSubTypeOf(Value value2, Value value3) {
        Type type = ((BasicValue)value3).getType();
        Type type2 = ((BasicValue)value2).getType();
        switch (type.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2.equals(type);
            }
            case 9: 
            case 10: {
                if ("Lnull;".equals(type2.getDescriptor())) {
                    return true;
                }
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    return this.isAssignableFrom(type, type2);
                }
                return false;
            }
        }
        throw new Error("Internal error");
    }

    public Value merge(Value value2, Value value3) {
        if (!value2.equals(value3)) {
            Type type = ((BasicValue)value2).getType();
            Type type2 = ((BasicValue)value3).getType();
            if (!(type == null || type.getSort() != 10 && type.getSort() != 9 || type2 == null || type2.getSort() != 10 && type2.getSort() != 9)) {
                if ("Lnull;".equals(type.getDescriptor())) {
                    return value3;
                }
                if ("Lnull;".equals(type2.getDescriptor())) {
                    return value2;
                }
                if (this.isAssignableFrom(type, type2)) {
                    return value2;
                }
                if (this.isAssignableFrom(type2, type)) {
                    return value3;
                }
                do {
                    if (type != null && !this.isInterface(type)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(type = this.getSuperClass(type), type2));
                return this.newValue(type);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return value2;
    }

    protected boolean isInterface(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type).isInterface();
    }

    protected Type getSuperClass(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class clazz = this.getClass(type).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    protected boolean isAssignableFrom(Type type, Type type2) {
        if (type.equals(type2)) {
            return true;
        }
        if (this.currentClass != null && type.equals(this.currentClass)) {
            if (this.getSuperClass(type2) == null) {
                return false;
            }
            if (this.isInterface) {
                return type2.getSort() == 10 || type2.getSort() == 9;
            }
            return this.isAssignableFrom(type, this.getSuperClass(type2));
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            if (this.isAssignableFrom(type, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type type3 = (Type)this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(type, type3)) continue;
                    return true;
                }
            }
            return false;
        }
        Class clazz = this.getClass(type);
        if (clazz.isInterface()) {
            clazz = class$java$lang$Object == null ? (class$java$lang$Object = SimpleVerifier.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return clazz.isAssignableFrom(this.getClass(type2));
    }

    protected Class getClass(Type type) {
        try {
            if (type.getSort() == 9) {
                return Class.forName(type.getDescriptor().replace('/', '.'), false, this.loader);
            }
            return Class.forName(type.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

