/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyApplicator<T>
extends AbstractBehavior<T> {
    private Map<String, String> properties;
    private transient Map<String, Method> setters = null;

    public PropertyApplicator(ComponentAdapter<T> delegate) throws PicoCompositionException {
        super(delegate);
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Object componentInstance = super.getComponentInstance(container, into);
        if (this.setters == null) {
            this.setters = this.getSetters(this.getComponentImplementation());
        }
        if (this.properties != null) {
            ComponentMonitor componentMonitor = this.currentMonitor();
            Set<String> propertyNames = this.properties.keySet();
            for (String propertyName : propertyNames) {
                String propertyValue = this.properties.get(propertyName);
                Method setter2 = this.setters.get(propertyName);
                Object valueToInvoke = this.getSetterParameter(propertyName, propertyValue, componentInstance, container);
                try {
                    componentMonitor.invoking(container, this, setter2, componentInstance, new Object[]{valueToInvoke});
                    long startTime = System.currentTimeMillis();
                    setter2.invoke(componentInstance, valueToInvoke);
                    componentMonitor.invoked(container, this, setter2, componentInstance, System.currentTimeMillis() - startTime, new Object[]{valueToInvoke}, null);
                }
                catch (Exception e) {
                    componentMonitor.invocationFailed(setter2, componentInstance, e);
                    throw new PicoCompositionException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                }
            }
        }
        return componentInstance;
    }

    @Override
    public String getDescriptor() {
        return "PropertyApplied";
    }

    private Map<String, Method> getSetters(Class<?> clazz) {
        Method[] methods2;
        HashMap<String, Method> result2 = new HashMap<String, Method>();
        for (Method method : methods2 = this.getMethods(clazz)) {
            if (!this.isSetter(method)) continue;
            result2.put(this.getPropertyName(method), method);
        }
        return result2;
    }

    private Method[] getMethods(final Class<?> clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return clazz.getMethods();
            }
        });
    }

    private String getPropertyName(Method method) {
        String name = method.getName();
        String result2 = name.substring(3);
        if (result2.length() > 1 && !Character.isUpperCase(result2.charAt(1))) {
            result2 = "" + Character.toLowerCase(result2.charAt(0)) + result2.substring(1);
        } else if (result2.length() == 1) {
            result2 = result2.toLowerCase();
        }
        return result2;
    }

    private boolean isSetter(Method method) {
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set") && method.getParameterTypes().length == 1;
    }

    private Object convertType(PicoContainer container, Method setter2, String propertyValue) {
        Object component;
        if (propertyValue == null) {
            return null;
        }
        Class<?> type = setter2.getParameterTypes()[0];
        String typeName = type.getName();
        Object result2 = PropertyApplicator.convert(typeName, propertyValue, Thread.currentThread().getContextClassLoader());
        if (result2 == null && container != null && (component = container.getComponent(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
            return component;
        }
        return result2;
    }

    public static Object convert(String typeName, String value2, ClassLoader classLoader) {
        if (typeName.equals(Boolean.class.getName()) || typeName.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(value2);
        }
        if (typeName.equals(Byte.class.getName()) || typeName.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(value2);
        }
        if (typeName.equals(Short.class.getName()) || typeName.equals(Short.TYPE.getName())) {
            return Short.valueOf(value2);
        }
        if (typeName.equals(Integer.class.getName()) || typeName.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(value2);
        }
        if (typeName.equals(Long.class.getName()) || typeName.equals(Long.TYPE.getName())) {
            return Long.valueOf(value2);
        }
        if (typeName.equals(Float.class.getName()) || typeName.equals(Float.TYPE.getName())) {
            return Float.valueOf(value2);
        }
        if (typeName.equals(Double.class.getName()) || typeName.equals(Double.TYPE.getName())) {
            return Double.valueOf(value2);
        }
        if (typeName.equals(Character.class.getName()) || typeName.equals(Character.TYPE.getName())) {
            return Character.valueOf(value2.toCharArray()[0]);
        }
        if (typeName.equals(String.class.getName()) || typeName.equals("string")) {
            return value2;
        }
        if (typeName.equals(File.class.getName()) || typeName.equals("file")) {
            return new File(value2);
        }
        if (typeName.equals(URL.class.getName()) || typeName.equals("url")) {
            try {
                return new URL(value2);
            }
            catch (MalformedURLException e) {
                throw new PicoCompositionException(e);
            }
        }
        if (typeName.equals(Class.class.getName()) || typeName.equals("class")) {
            return PropertyApplicator.loadClass(classLoader, value2);
        }
        Class<?> clazz = PropertyApplicator.loadClass(classLoader, typeName);
        PropertyEditor editor2 = PropertyEditorManager.findEditor(clazz);
        if (editor2 != null) {
            editor2.setAsText(value2);
            return editor2.getValue();
        }
        return null;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String typeName) {
        try {
            return classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new PicoClassNotFoundException(typeName, e);
        }
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private Object getSetterParameter(String propertyName, Object propertyValue, Object componentInstance, PicoContainer container) {
        if (propertyValue == null) {
            return null;
        }
        Method setter2 = this.setters.get(propertyName);
        Class<?> setterParameter = setter2.getParameterTypes()[0];
        Class<?> givenParameterClass = propertyValue.getClass();
        Object convertedValue = this.convertType(container, setter2, propertyValue.toString());
        if (convertedValue == null) {
            if (setterParameter.isAssignableFrom(givenParameterClass)) {
                convertedValue = propertyValue;
            } else {
                throw new ClassCastException("Setter: " + setter2.getName() + " for addComponent: " + componentInstance.toString() + " can only take objects of: " + setterParameter.getName() + " instead got: " + givenParameterClass.getName());
            }
        }
        return convertedValue;
    }

    public void setProperty(String name, String value2) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value2);
    }
}

