/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.annotations.Bind;
import org.picocontainer.injectors.IterativeInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedFieldInjector
extends IterativeInjector {
    private final List<String> fieldNames;

    public NamedFieldInjector(Object key, Class<?> impl, Parameter[] parameters, ComponentMonitor componentMonitor, String fieldNames) {
        super(key, (Class)impl, parameters, componentMonitor, true);
        this.fieldNames = Arrays.asList(fieldNames.trim().split(" "));
    }

    @Override
    protected void initializeInjectionMembersAndTypeLists() {
        Field[] fields;
        this.injectionMembers = new ArrayList();
        ArrayList<Annotation> bindingIds = new ArrayList<Annotation>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Field field2 : fields = this.getFields()) {
            if (!this.isNamedForInjection(field2)) continue;
            this.injectionMembers.add(field2);
            typeList.add(this.box(field2.getType()));
            bindingIds.add(this.getBinding(field2));
        }
        this.injectionTypes = typeList.toArray(new Type[0]);
        this.bindings = bindingIds.toArray(new Annotation[0]);
    }

    private Annotation getBinding(Field field2) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field2.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Bind.class)) continue;
            return annotation;
        }
        return null;
    }

    protected boolean isNamedForInjection(Field field2) {
        return this.fieldNames.contains(field2.getName());
    }

    private Field[] getFields() {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return NamedFieldInjector.this.getComponentImplementation().getDeclaredFields();
            }
        });
    }

    @Override
    protected Object injectIntoMember(AccessibleObject member, Object componentInstance, Object toInject) throws IllegalAccessException, InvocationTargetException {
        Field field2 = (Field)member;
        field2.setAccessible(true);
        field2.set(componentInstance, toInject);
        return null;
    }

    @Override
    public String getDescriptor() {
        return "NamedFieldInjector-";
    }

    @Override
    protected NameBinding makeParameterNameImpl(final AccessibleObject member) {
        return new NameBinding(){

            public String getName() {
                return ((Field)member).getName();
            }
        };
    }

    @Override
    protected Object memberInvocationReturn(Object lastReturn, AccessibleObject member, Object instance) {
        return instance;
    }

    List<String> getInjectionFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }
}

