/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.client4.Response$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Headers$;
import sttp.model.RequestMetadata;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode;

public class Response<T>
implements ResponseMetadata,
Product,
Serializable {
    private final Object body;
    private final int code;
    private final String statusText;
    private final Seq headers;
    private final List history;
    private final RequestMetadata request;

    public static <T> Response<T> apply(T t, int n, RequestMetadata requestMetadata) {
        return Response$.MODULE$.apply(t, n, requestMetadata);
    }

    public static <T> Response<T> apply(T t, int n, String string, Seq<Header> seq, List<ResponseMetadata> list, RequestMetadata requestMetadata) {
        return Response$.MODULE$.apply(t, n, string, seq, list, requestMetadata);
    }

    public static Response<?> fromProduct(Product product) {
        return Response$.MODULE$.fromProduct(product);
    }

    public static <T> Response<T> ok(T t, RequestMetadata requestMetadata) {
        return Response$.MODULE$.ok(t, requestMetadata);
    }

    public static <T> Response<T> unapply(Response<T> response) {
        return Response$.MODULE$.unapply(response);
    }

    public Response(T body2, int code, String statusText, Seq<Header> headers2, List<ResponseMetadata> history, RequestMetadata request) {
        this.body = body2;
        this.code = code;
        this.statusText = statusText;
        this.headers = headers2;
        this.history = history;
        this.request = request;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Response)) return false;
        Response response = (Response)object;
        if (!BoxesRunTime.equals(this.body(), response.body())) return false;
        if (this.code() != response.code()) return false;
        String string = this.statusText();
        String string2 = response.statusText();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<Header> seq = this.headers();
        Seq<Header> seq2 = response.headers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        List<ResponseMetadata> list = this.history();
        List<ResponseMetadata> list2 = response.history();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        RequestMetadata requestMetadata = this.request();
        RequestMetadata requestMetadata2 = response.request();
        if (requestMetadata == null) {
            if (requestMetadata2 != null) {
                return false;
            }
        } else if (!requestMetadata.equals(requestMetadata2)) return false;
        if (!response.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Response;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "Response";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return new StatusCode(this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "body";
            }
            case 1: {
                return "code";
            }
            case 2: {
                return "statusText";
            }
            case 3: {
                return "headers";
            }
            case 4: {
                return "history";
            }
            case 5: {
                return "request";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public T body() {
        return (T)this.body;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String statusText() {
        return this.statusText;
    }

    @Override
    public Seq<Header> headers() {
        return this.headers;
    }

    public List<ResponseMetadata> history() {
        return this.history;
    }

    public RequestMetadata request() {
        return this.request;
    }

    public String show(boolean includeBody, boolean includeHeaders, Set<String> sensitiveHeaders) {
        String headersStr = includeHeaders ? new StringBuilder(11).append(", headers: ").append(Headers$.MODULE$.toStringSafe(this.headers(), sensitiveHeaders).mkString(", ")).toString() : "";
        String body2 = includeBody ? new StringBuilder(8).append(", body: ").append(this.body()).toString() : "";
        return new StringBuilder(1).append(new StatusCode(this.code())).append(" ").append(this.statusText()).append(headersStr).append(body2).toString();
    }

    public boolean show$default$1() {
        return true;
    }

    public boolean show$default$2() {
        return true;
    }

    public Set<String> show$default$3() {
        return HeaderNames$.MODULE$.SensitiveHeaders();
    }

    @Override
    public String toString() {
        return new StringBuilder(15).append("Response(").append(this.body()).append(",").append(new StatusCode(this.code())).append(",").append(this.statusText()).append(",").append(Headers$.MODULE$.toStringSafe(this.headers(), Headers$.MODULE$.toStringSafe$default$2())).append(",").append(this.history()).append(",").append(this.request()).append(")").toString();
    }

    public <T> Response<T> copy(T body2, int code, String statusText, Seq<Header> headers2, List<ResponseMetadata> history, RequestMetadata request) {
        return new Response<T>(body2, code, statusText, headers2, history, request);
    }

    public <T> T copy$default$1() {
        return this.body();
    }

    public int copy$default$2() {
        return this.code();
    }

    public <T> String copy$default$3() {
        return this.statusText();
    }

    public <T> Seq<Header> copy$default$4() {
        return this.headers();
    }

    public <T> List<ResponseMetadata> copy$default$5() {
        return this.history();
    }

    public <T> RequestMetadata copy$default$6() {
        return this.request();
    }

    public T _1() {
        return this.body();
    }

    public int _2() {
        return this.code();
    }

    public String _3() {
        return this.statusText();
    }

    public Seq<Header> _4() {
        return this.headers();
    }

    public List<ResponseMetadata> _5() {
        return this.history();
    }

    public RequestMetadata _6() {
        return this.request();
    }
}

