/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.fetch;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import org.scalajs.dom.AbortController;
import org.scalajs.dom.AbortSignal;
import org.scalajs.dom.Blob;
import org.scalajs.dom.BlobPropertyBag$;
import org.scalajs.dom.CloseEvent;
import org.scalajs.dom.File;
import org.scalajs.dom.FilePropertyBag;
import org.scalajs.dom.FormData;
import org.scalajs.dom.Headers;
import org.scalajs.dom.Headers$;
import org.scalajs.dom.HttpMethod;
import org.scalajs.dom.MessageEvent;
import org.scalajs.dom.Request;
import org.scalajs.dom.RequestInit;
import org.scalajs.dom.Response;
import org.scalajs.dom.ResponseInit;
import org.scalajs.dom.WebSocket$;
import org.scalajs.dom.experimental.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Iterator;
import scala.scalajs.js.Iterator$;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.Object;
import scala.scalajs.js.Thenable;
import scala.scalajs.js.Thenable$;
import scala.scalajs.js.timers.SetTimeoutHandle;
import scala.scalajs.js.typedarray.ArrayBuffer;
import scala.scalajs.js.typedarray.DataView;
import scala.scalajs.js.typedarray.DataView$;
import scala.scalajs.js.typedarray.Int8Array;
import scala.scalajs.js.typedarray.Int8Array$;
import scala.scalajs.js.typedarray.package;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.client4.BasicBodyPart;
import sttp.client4.BodyPart;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.GenericWebSocketResponseAs;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.Response$;
import sttp.client4.ResponseAsWebSocket;
import sttp.client4.ResponseAsWebSocket$;
import sttp.client4.ResponseAsWebSocketStream;
import sttp.client4.ResponseAsWebSocketStream$;
import sttp.client4.ResponseAsWebSocketUnsafe;
import sttp.client4.ResponseAsWebSocketUnsafe$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.SttpClientException;
import sttp.client4.SttpClientException$;
import sttp.client4.WebSocketBackend;
import sttp.client4.WebSocketImpl$;
import sttp.client4.fetch.FetchOptions;
import sttp.client4.internal.BodyFromResponseAs;
import sttp.client4.internal.ConvertFromFuture;
import sttp.client4.internal.JSSimpleQueue;
import sttp.client4.internal.SttpFile;
import sttp.client4.internal.SttpFile$;
import sttp.client4.internal.package$;
import sttp.client4.internal.ws.WebSocketEvent;
import sttp.client4.internal.ws.WebSocketEvent$Error$;
import sttp.client4.internal.ws.WebSocketEvent$Frame$;
import sttp.client4.internal.ws.WebSocketEvent$Open$;
import sttp.client4.ws.GotAWebSocketException;
import sttp.client4.ws.NotAWebSocketException;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.Part;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode$;
import sttp.monad.MonadError;
import sttp.monad.syntax$;
import sttp.monad.syntax$MonadErrorValueOps$;
import sttp.ws.WebSocket;
import sttp.ws.WebSocketFrame$;
import sttp.ws.WebSocketFrame$Close$;

public abstract class AbstractFetchBackend<F, S extends package.Streams<S>>
implements WebSocketBackend<F> {
    public final FetchOptions sttp$client4$fetch$AbstractFetchBackend$$options;
    private final Function1<Request, Request> customizeRequest;
    private final MonadError<F> _monad;
    private BodyFromResponseAs bodyFromResponseAs$lzy1;
    private boolean bodyFromResponseAsbitmap$1;

    public AbstractFetchBackend(FetchOptions options, Function1<Request, Request> customizeRequest, MonadError<F> _monad) {
        this.sttp$client4$fetch$AbstractFetchBackend$$options = options;
        this.customizeRequest = customizeRequest;
        this._monad = _monad;
    }

    @Override
    public MonadError<F> monad() {
        return this._monad;
    }

    public abstract package.Streams<S> streams();

    @Override
    public <T> F send(GenericRequest<T, S> request) {
        return this.adjustExceptions(request, () -> this.send$$anonfun$1(request));
    }

    private <T> F adjustExceptions(GenericRequest<?, ?> request, Function0<F> t) {
        return (F)SttpClientException$.MODULE$.adjustExceptions(this.monad(), t, (Function1<Exception, Option<Exception>>)(Function1 & Serializable)_$2 -> SttpClientException$.MODULE$.defaultExceptionToSttpClientException((GenericRequest)request, (Exception)_$2));
    }

    private <T> F sendRegular(GenericRequest<T, S> request) {
        Function0 & Serializable intersect;
        Duration readTimeout = request.options().readTimeout();
        AbortController controller = new AbortController();
        AbortSignal signal = controller.signal();
        Duration duration = readTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration timeout = (FiniteDuration)duration;
            SetTimeoutHandle timeoutHandle = scala.scalajs.js.timers.package$.MODULE$.setTimeout(timeout, (Function0 & Serializable)() -> {
                AbstractFetchBackend.$anonfun$1(controller);
                return BoxedUnit.UNIT;
            });
            intersect = (Function0 & Serializable)() -> {
                scala.scalajs.js.timers.package$.MODULE$.clearTimeout(timeoutHandle);
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = (Function0 & Serializable)() -> {
                AbstractFetchBackend.$anonfun$3();
                return BoxedUnit.UNIT;
            };
        }
        Function0 & Serializable cancelTimeout = intersect;
        Function0 & Serializable cancel = (Function0 & Serializable)() -> {
            controller.abort();
            return BoxedUnit.UNIT;
        };
        Headers rheaders = new Headers(Headers$.MODULE$.$lessinit$greater$default$1());
        request.headers().foreach((Function1 & Serializable)header2 -> {
            AbstractFetchBackend.sendRegular$$anonfun$1(rheaders, header2);
            return BoxedUnit.UNIT;
        });
        java.lang.Object req = syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.$anonfun$5(request))).map((Function1 & Serializable)rbody -> {
            String rredirect = request.options().followRedirects() ? org.scalajs.dom.experimental.package$.MODULE$.RequestRedirect().follow() : org.scalajs.dom.experimental.package$.MODULE$.RequestRedirect().manual();
            AbortSignal rsignal = signal;
            RequestInit requestInitStatic = (RequestInit)scala.scalajs.runtime.package$.MODULE$.withContextualJSClassValue((java.lang.Object)scala.scalajs.runtime.package$.MODULE$.constructorOf(Object.class), (java.lang.Object)new RequestInit(request, rheaders, rbody, rredirect, rsignal, this){
                private java.lang.Object method;
                private java.lang.Object headers;
                private java.lang.Object body;
                private java.lang.Object referrer;
                private java.lang.Object referrerPolicy;
                private java.lang.Object mode;
                private java.lang.Object credentials;
                private java.lang.Object cache;
                private java.lang.Object redirect;
                private java.lang.Object integrity;
                private java.lang.Object keepalive;
                private java.lang.Object signal;
                private java.lang.Object duplex;
                private BoxedUnit window;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.method_$eq((HttpMethod)request$5.method());
                    this.headers_$eq(rheaders$3);
                    this.body_$eq(rbody$1);
                    this.referrer_$eq(scala.scalajs.js.package$.MODULE$.undefined());
                    this.referrerPolicy_$eq(scala.scalajs.js.package$.MODULE$.undefined());
                    Option option = JSConverters$.MODULE$.JSRichOption($outer.sttp$client4$fetch$AbstractFetchBackend$$options.mode());
                    this.mode_$eq(JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
                    Option option2 = JSConverters$.MODULE$.JSRichOption($outer.sttp$client4$fetch$AbstractFetchBackend$$options.credentials());
                    this.credentials_$eq(JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option2));
                    this.cache_$eq(scala.scalajs.js.package$.MODULE$.undefined());
                    this.redirect_$eq(rredirect$1);
                    this.integrity_$eq(scala.scalajs.js.package$.MODULE$.undefined());
                    this.keepalive_$eq(scala.scalajs.js.package$.MODULE$.undefined());
                    this.signal_$eq(rsignal$1);
                    this.window_$eq((BoxedUnit)scala.scalajs.js.package$.MODULE$.undefined());
                }

                public java.lang.Object method() {
                    return this.method;
                }

                public java.lang.Object headers() {
                    return this.headers;
                }

                public java.lang.Object body() {
                    return this.body;
                }

                public java.lang.Object referrer() {
                    return this.referrer;
                }

                public java.lang.Object referrerPolicy() {
                    return this.referrerPolicy;
                }

                public java.lang.Object mode() {
                    return this.mode;
                }

                public java.lang.Object credentials() {
                    return this.credentials;
                }

                public java.lang.Object cache() {
                    return this.cache;
                }

                public java.lang.Object redirect() {
                    return this.redirect;
                }

                public java.lang.Object integrity() {
                    return this.integrity;
                }

                public java.lang.Object keepalive() {
                    return this.keepalive;
                }

                public java.lang.Object signal() {
                    return this.signal;
                }

                public java.lang.Object duplex() {
                    return this.duplex;
                }

                public BoxedUnit window() {
                    return this.window;
                }

                public void method_$eq(java.lang.Object x$1) {
                    this.method = x$1;
                }

                public void headers_$eq(java.lang.Object x$1) {
                    this.headers = x$1;
                }

                public void body_$eq(java.lang.Object x$1) {
                    this.body = x$1;
                }

                public void referrer_$eq(java.lang.Object x$1) {
                    this.referrer = x$1;
                }

                public void referrerPolicy_$eq(java.lang.Object x$1) {
                    this.referrerPolicy = x$1;
                }

                public void mode_$eq(java.lang.Object x$1) {
                    this.mode = x$1;
                }

                public void credentials_$eq(java.lang.Object x$1) {
                    this.credentials = x$1;
                }

                public void cache_$eq(java.lang.Object x$1) {
                    this.cache = x$1;
                }

                public void redirect_$eq(java.lang.Object x$1) {
                    this.redirect = x$1;
                }

                public void integrity_$eq(java.lang.Object x$1) {
                    this.integrity = x$1;
                }

                public void keepalive_$eq(java.lang.Object x$1) {
                    this.keepalive = x$1;
                }

                public void signal_$eq(java.lang.Object x$1) {
                    this.signal = x$1;
                }

                public void duplex_$eq(java.lang.Object x$1) {
                    this.duplex = x$1;
                }

                public void window_$eq(BoxedUnit x$1) {
                    this.window = x$1;
                }
            });
            Dynamic requestInitDynamic = (Dynamic)requestInitStatic;
            requestInitDynamic.updateDynamic("signal", (Any)signal);
            requestInitDynamic.updateDynamic("redirect", Any$.MODULE$.fromString(rredirect));
            RequestInit requestInit = (RequestInit)requestInitDynamic;
            return new Request((java.lang.Object)request.uri().toString(), requestInit);
        }, this.monad());
        java.lang.Object result = syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.$anonfun$7(req))).flatMap((Function1 & Serializable)resp -> {
            Seq<Header> headers2 = this.convertResponseHeaders(resp.headers());
            ResponseMetadata metadata = ResponseMetadata$.MODULE$.apply(StatusCode$.MODULE$.apply(resp.status()), resp.statusText(), headers2);
            request.options().onBodyReceived().apply((java.lang.Object)metadata);
            F body2 = this.bodyFromResponseAs().apply(request.response(), metadata, (Either<Response, WebSocket<F>>)scala.package$.MODULE$.Left().apply(resp));
            return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> AbstractFetchBackend.$anonfun$8$$anonfun$1(body2))).map((Function1 & Serializable)b -> Response$.MODULE$.apply(b, StatusCode$.MODULE$.apply(resp.status()), resp.statusText(), headers2, (List<ResponseMetadata>)scala.package$.MODULE$.Nil(), request.onlyMetadata()), this.monad());
        }, this.monad());
        return this.addCancelTimeoutHook(result, (Function0<BoxedUnit>)cancel, (Function0<BoxedUnit>)cancelTimeout);
    }

    public abstract <T> F addCancelTimeoutHook(F var1, Function0<BoxedUnit> var2, Function0<BoxedUnit> var3);

    private Seq<Header> convertResponseHeaders(Headers headers2) {
        Iterator iterator = Iterator$.MODULE$.IteratorOps(headers2.jsIterator());
        return Iterator.IteratorOps$.MODULE$.toIterator$extension(iterator).flatMap((Function1 & Serializable)hs -> {
            if (hs.length() >= 2) {
                String name = (String)hs.apply(0);
                return ((List)Any$.MODULE$.wrapArray(hs).toList().drop(1)).map((Function1 & Serializable)v -> Header$.MODULE$.apply(name, (String)v));
            }
            return Seq$.MODULE$.empty();
        }).toList();
    }

    private F createBody(GenericRequestBody<S> body2) {
        GenericRequestBody<S> genericRequestBody = body2;
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            return this.monad().unit(scala.scalajs.js.package$.MODULE$.undefined());
        }
        if (genericRequestBody instanceof BasicBodyPart) {
            BasicBodyPart b = (BasicBodyPart)genericRequestBody;
            return this.monad().unit(this.writeBasicBody(b));
        }
        if (genericRequestBody instanceof StreamBody) {
            java.lang.Object BinaryStream;
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
            java.lang.Object s = BinaryStream = streamBody._1();
            return this.handleStreamBody(s);
        }
        if (genericRequestBody instanceof MultipartBody) {
            MultipartBody mp = (MultipartBody)genericRequestBody;
            FormData formData = new FormData();
            mp.parts().foreach((Function1 & Serializable)part -> {
                this.createBody$$anonfun$1(formData, (Part)part);
                return BoxedUnit.UNIT;
            });
            return this.monad().unit(formData);
        }
        throw new MatchError(genericRequestBody);
    }

    private java.lang.Object writeBasicBody(BasicBodyPart body2) {
        BasicBodyPart basicBodyPart = body2;
        if (basicBodyPart instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)basicBodyPart);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String b = string;
            String encoding = string2;
            if (encoding.compareToIgnoreCase(package$.MODULE$.Utf8()) == 0) {
                return b;
            }
            return package.AB2TA$.MODULE$.toTypedArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.AB2TA(b.getBytes(encoding)));
        }
        if (basicBodyPart instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody2 = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)basicBodyPart);
            byte[] byArray = byteArrayBody2._1();
            MediaType mediaType = byteArrayBody2._2();
            byte[] b = byArray;
            return package.AB2TA$.MODULE$.toTypedArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.AB2TA(b));
        }
        if (basicBodyPart instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody2 = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)basicBodyPart);
            ByteBuffer byteBuffer = byteBufferBody2._1();
            MediaType mediaType = byteBufferBody2._2();
            ByteBuffer b = byteBuffer;
            return package.AB2TA$.MODULE$.toTypedArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.AB2TA(this.byteBufferToArray(b)));
        }
        if (basicBodyPart instanceof InputStreamBody) {
            InputStreamBody inputStreamBody2 = InputStreamBody$.MODULE$.unapply((InputStreamBody)basicBodyPart);
            InputStream inputStream = inputStreamBody2._1();
            MediaType mediaType = inputStreamBody2._2();
            InputStream is = inputStream;
            return package.AB2TA$.MODULE$.toTypedArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.AB2TA(package$.MODULE$.toByteArray(is)));
        }
        if (basicBodyPart instanceof FileBody) {
            FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)basicBodyPart);
            SttpFile sttpFile = fileBody2._1();
            MediaType mediaType = fileBody2._2();
            SttpFile f = sttpFile;
            return f.toDomFile();
        }
        throw new MatchError((java.lang.Object)basicBodyPart);
    }

    private byte[] byteBufferToArray(ByteBuffer bb) {
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        return b;
    }

    private <T> F sendWebSocket(GenericRequest<T, S> request) {
        JSSimpleQueue queue = new JSSimpleQueue(this.convertFromFuture());
        org.scalajs.dom.WebSocket ws = new org.scalajs.dom.WebSocket(request.uri().toString(), WebSocket$.MODULE$.$lessinit$greater$default$2());
        ws.binaryType_$eq(WebSocketImpl$.MODULE$.BinaryType());
        Promise isOpen = Promise$.MODULE$.apply();
        ws.onopen_$eq(_$3 -> {
            isOpen.success((java.lang.Object)BoxedUnit.UNIT);
            queue.offer(WebSocketEvent$Open$.MODULE$.apply());
            return BoxedUnit.UNIT;
        });
        ws.onmessage_$eq(event -> {
            queue.offer(this.toWebSocketEvent((MessageEvent)event));
            return BoxedUnit.UNIT;
        });
        ws.onerror_$eq(_$4 -> {
            String msg = "Something went wrong in web socket or it could not be opened";
            if (!isOpen.isCompleted()) {
                return isOpen.failure((Throwable)new SttpClientException.ReadException(request, new RuntimeException(msg)));
            }
            queue.offer(WebSocketEvent$Error$.MODULE$.apply(new RuntimeException(msg)));
            return BoxedUnit.UNIT;
        });
        ws.onclose_$eq(event -> {
            queue.offer(this.toWebSocketEvent((CloseEvent)event));
            return BoxedUnit.UNIT;
        });
        return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.sendWebSocket$$anonfun$5(isOpen))).flatMap((Function1 & Serializable)_$5 -> {
            WebSocket<F> webSocket = WebSocketImpl$.MODULE$.newJSCoupledWebSocket(ws, queue, this.monad());
            return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.sendWebSocket$$anonfun$6$$anonfun$1(request, webSocket))).map((Function1 & Serializable)e -> Response$.MODULE$.ok(e, request.onlyMetadata()), this.monad());
        }, this.monad());
    }

    private WebSocketEvent toWebSocketEvent(MessageEvent msg) {
        java.lang.Object object = msg.data();
        if (object instanceof ArrayBuffer) {
            ArrayBuffer payload = (ArrayBuffer)object;
            DataView dv = new DataView(payload, DataView$.MODULE$.$lessinit$greater$default$2(), DataView$.MODULE$.$lessinit$greater$default$3());
            byte[] bytes = new byte[dv.byteLength()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dv.byteLength()).foreach((Function1 & Serializable)v1 -> {
                bytes[BoxesRunTime.unboxToInt((java.lang.Object)v1)] = dv.getInt8(BoxesRunTime.unboxToInt((java.lang.Object)v1));
                return BoxedUnit.UNIT;
            });
            return WebSocketEvent$Frame$.MODULE$.apply(WebSocketFrame$.MODULE$.binary(bytes));
        }
        if (object instanceof String) {
            String payload = (String)object;
            return WebSocketEvent$Frame$.MODULE$.apply(WebSocketFrame$.MODULE$.text(payload));
        }
        throw new RuntimeException(new StringBuilder(29).append("Unknown format of event.data ").append(msg.data()).toString());
    }

    private WebSocketEvent toWebSocketEvent(CloseEvent close) {
        return WebSocketEvent$Frame$.MODULE$.apply(WebSocketFrame$Close$.MODULE$.apply(close.code(), close.reason()));
    }

    public abstract F handleStreamBody(java.lang.Object var1);

    private BodyFromResponseAs<F, Response, WebSocket<F>, java.lang.Object> bodyFromResponseAs() {
        if (!this.bodyFromResponseAsbitmap$1) {
            this.bodyFromResponseAs$lzy1 = new BodyFromResponseAs<F, Response, WebSocket<F>, java.lang.Object>(this){
                private final /* synthetic */ AbstractFetchBackend $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.monad());
                }

                public java.lang.Object withReplayableBody(Response response, Either replayableBody) {
                    Either either = replayableBody;
                    if (!(either instanceof Left)) {
                        if (either instanceof Right) {
                            throw new IllegalArgumentException("Replayable file bodies are not supported");
                        }
                        throw new MatchError((java.lang.Object)either);
                    }
                    byte[] byteArray = (byte[])((Left)either).value();
                    byte[] bytes = byteArray;
                    Response response2 = (Response)syntax$.MODULE$.MonadErrorValueOps(new Response((java.lang.Object)package.AB2TA$.MODULE$.toTypedArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.AB2TA(bytes)), (ResponseInit)response));
                    return syntax$MonadErrorValueOps$.MODULE$.unit$extension(response2, this.$outer.monad());
                }

                public java.lang.Object regularIgnore(Response response) {
                    return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.regularIgnore$$anonfun$1(response))).map(AbstractFetchBackend::sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularIgnore$$anonfun$adapted$1, this.$outer.monad());
                }

                public java.lang.Object regularAsByteArray(Response response) {
                    return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.regularAsByteArray$$anonfun$1(response))).map(AbstractFetchBackend::sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsByteArray$$anonfun$2, this.$outer.monad());
                }

                public java.lang.Object regularAsFile(Response response, SttpFile file) {
                    return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.regularAsFile$$anonfun$1(response))).map(arg_0 -> AbstractFetchBackend.sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsFile$$anonfun$2(file, arg_0), this.$outer.monad());
                }

                public java.lang.Object regularAsStream(Response response) {
                    return this.$outer.handleResponseAsStream(response);
                }

                public java.lang.Object handleWS(GenericWebSocketResponseAs responseAs, ResponseMetadata meta, WebSocket ws) {
                    GenericWebSocketResponseAs genericWebSocketResponseAs = responseAs;
                    if (genericWebSocketResponseAs instanceof ResponseAsWebSocket) {
                        Function2<WebSocket<F>, ResponseMetadata, F> function2;
                        ResponseAsWebSocket<F, T> responseAsWebSocket = ResponseAsWebSocket$.MODULE$.unapply((ResponseAsWebSocket)genericWebSocketResponseAs);
                        Function2<WebSocket<F>, ResponseMetadata, F> f = function2 = responseAsWebSocket._1();
                        return f.apply((java.lang.Object)ws, (java.lang.Object)meta);
                    }
                    if (genericWebSocketResponseAs instanceof ResponseAsWebSocketUnsafe && ResponseAsWebSocketUnsafe$.MODULE$.unapply((ResponseAsWebSocketUnsafe)genericWebSocketResponseAs)) {
                        WebSocket webSocket = (WebSocket)syntax$.MODULE$.MonadErrorValueOps(ws);
                        return syntax$MonadErrorValueOps$.MODULE$.unit$extension(webSocket, this.$outer.monad());
                    }
                    if (genericWebSocketResponseAs instanceof ResponseAsWebSocketStream) {
                        Pipe Pipe;
                        ResponseAsWebSocketStream<S, Pipe> responseAsWebSocketStream = ResponseAsWebSocketStream$.MODULE$.unapply((ResponseAsWebSocketStream)genericWebSocketResponseAs);
                        package.Streams<S> streams = responseAsWebSocketStream._1();
                        Pipe pipe = Pipe = responseAsWebSocketStream._2();
                        return this.$outer.compileWebSocketPipe(ws, pipe);
                    }
                    throw new MatchError((java.lang.Object)genericWebSocketResponseAs);
                }

                public java.lang.Object cleanupWhenNotAWebSocket(Response response, NotAWebSocketException e) {
                    return this.$outer.monad().unit(BoxedUnit.UNIT);
                }

                public java.lang.Object cleanupWhenGotWebSocket(WebSocket response, GotAWebSocketException e) {
                    MonadError<F> monadError = this.$outer.monad();
                    response.close();
                    return monadError.unit(BoxedUnit.UNIT);
                }

                private final java.lang.Object regularIgnore$$anonfun$1(Response response$1) {
                    Thenable thenable = Thenable$.MODULE$.ThenableOps((Thenable)response$1.arrayBuffer());
                    return this.$outer.convertFromFuture().apply(Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable));
                }

                private final java.lang.Object regularAsByteArray$$anonfun$1(Response response$2) {
                    Thenable thenable = Thenable$.MODULE$.ThenableOps((Thenable)response$2.arrayBuffer());
                    return this.$outer.convertFromFuture().apply(Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable));
                }

                private final java.lang.Object regularAsFile$$anonfun$1(Response response$3) {
                    Thenable thenable = Thenable$.MODULE$.ThenableOps((Thenable)response$3.arrayBuffer());
                    return this.$outer.convertFromFuture().apply(Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable));
                }

                private static /* synthetic */ java.lang.Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{regularIgnore$$anonfun$1(org.scalajs.dom.Response ), sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularIgnore$$anonfun$adapted$1(scala.scalajs.js.typedarray.ArrayBuffer ), regularAsByteArray$$anonfun$1(org.scalajs.dom.Response ), sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsByteArray$$anonfun$2(scala.scalajs.js.typedarray.ArrayBuffer ), regularAsFile$$anonfun$1(org.scalajs.dom.Response ), sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsFile$$anonfun$2(sttp.client4.internal.SttpFile scala.scalajs.js.typedarray.ArrayBuffer )}, serializedLambda);
                }
            };
            this.bodyFromResponseAsbitmap$1 = true;
        }
        return this.bodyFromResponseAs$lzy1;
    }

    public abstract F handleResponseAsStream(Response var1);

    public abstract F compileWebSocketPipe(WebSocket<F> var1, java.lang.Object var2);

    @Override
    public F close() {
        return this.monad().unit(BoxedUnit.UNIT);
    }

    public abstract ConvertFromFuture<F> convertFromFuture();

    private final java.lang.Object send$$anonfun$1(GenericRequest request$1) {
        if (request$1.isWebSocket()) {
            return this.sendWebSocket(request$1);
        }
        return this.sendRegular(request$1);
    }

    private static final void $anonfun$1(AbortController controller$1) {
        controller$1.abort();
    }

    private static final /* synthetic */ void $anonfun$3() {
    }

    private static final /* synthetic */ void sendRegular$$anonfun$1(Headers rheaders$1, Header header2) {
        if (header2.is(HeaderNames$.MODULE$.ContentType()) && header2.value().toLowerCase().startsWith("multipart/")) {
            if (!header2.value().toLowerCase().startsWith(MediaType$.MODULE$.MultipartFormData().toString())) {
                throw new IllegalArgumentException("Multipart bodies other than multipart/form-data are not supported");
            }
            return;
        }
        rheaders$1.set(header2.name(), header2.value());
    }

    private final java.lang.Object $anonfun$5(GenericRequest request$3) {
        return this.createBody(request$3.body());
    }

    private static final java.lang.Object $anonfun$7$$anonfun$1$$anonfun$1(java.lang.Object req$3) {
        return req$3;
    }

    private final java.lang.Object $anonfun$7$$anonfun$1(java.lang.Object req$2) {
        return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> AbstractFetchBackend.$anonfun$7$$anonfun$1$$anonfun$1(req$2))).flatMap((Function1 & Serializable)r -> {
            Thenable thenable = Thenable$.MODULE$.ThenableOps((Thenable)package.Fetch$.MODULE$.fetch(this.customizeRequest.apply(r), package.Fetch$.MODULE$.fetch$default$2()));
            return this.convertFromFuture().apply(Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable));
        }, this.monad());
    }

    private final java.lang.Object $anonfun$7(java.lang.Object req$1) {
        return syntax$.MODULE$.MonadErrorOps((Function0<java.lang.Object>)((Function0 & Serializable)() -> this.$anonfun$7$$anonfun$1(req$1))).flatMap((Function1 & Serializable)resp -> {
            String string = resp.type();
            String string2 = org.scalajs.dom.experimental.package$.MODULE$.ResponseType().opaqueredirect();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.monad().error(new RuntimeException("Unexpected redirect"));
            }
            return this.monad().unit(resp);
        }, this.monad());
    }

    private static final java.lang.Object $anonfun$8$$anonfun$1(java.lang.Object body$1) {
        return body$1;
    }

    private final /* synthetic */ void createBody$$anonfun$1(FormData formData$1, Part part) {
        Blob blob;
        java.lang.Object value;
        BodyPart bodyPart = (BodyPart)part.body();
        if (!(bodyPart instanceof BasicBodyPart)) {
            if (bodyPart instanceof StreamBody) {
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)bodyPart);
                java.lang.Object BinaryStream = streamBody._1();
                throw new IllegalArgumentException("Streaming multipart bodies are not supported");
            }
            throw new MatchError((java.lang.Object)bodyPart);
        }
        BasicBodyPart body2 = (BasicBodyPart)bodyPart;
        java.lang.Object object = value = this.writeBasicBody(body2);
        if (object instanceof Blob) {
            Blob b;
            blob = b = (Blob)object;
        } else {
            java.lang.Object v = object;
            Iterable iterable = JSConverters$.MODULE$.JSRichIterable((Iterable)scala.package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new java.lang.Object[]{v})));
            Option option = JSConverters$.MODULE$.JSRichOption(part.contentType());
            Blob blob2 = new Blob(JSConverters.JSRichIterable$.MODULE$.toJSIterable$extension(iterable), BlobPropertyBag$.MODULE$.apply((java.lang.Object)JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option)));
            blob = blob2;
        }
        Blob blob3 = blob;
        Option<String> option = part.fileName();
        if (None$.MODULE$.equals(option)) {
            formData$1.append(part.name(), blob3, formData$1.append$default$3());
            return;
        }
        if (option instanceof Some) {
            String fileName = (String)((Some)option).value();
            formData$1.append(part.name(), blob3, fileName);
            return;
        }
        throw new MatchError(option);
    }

    private final java.lang.Object sendWebSocket$$anonfun$5(Promise isOpen$3) {
        return this.convertFromFuture().apply(isOpen$3.future());
    }

    private final java.lang.Object sendWebSocket$$anonfun$6$$anonfun$1(GenericRequest request$10, WebSocket webSocket$1) {
        return this.bodyFromResponseAs().apply(request$10.response(), ResponseMetadata$.MODULE$.apply(StatusCode$.MODULE$.Ok(), "", request$10.headers()), (Either<Response, WebSocket<F>>)scala.package$.MODULE$.Right().apply((java.lang.Object)webSocket$1));
    }

    private static final /* synthetic */ void regularIgnore$$anonfun$2(ArrayBuffer _$6) {
    }

    public static /* bridge */ /* synthetic */ java.lang.Object sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularIgnore$$anonfun$adapted$1(ArrayBuffer _$6) {
        AbstractFetchBackend.regularIgnore$$anonfun$2(_$6);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ byte[] sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsByteArray$$anonfun$2(ArrayBuffer ab) {
        return package.TA2AB$.MODULE$.toArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.TA2AB(new Int8Array(ab, Int8Array$.MODULE$.$lessinit$greater$default$2(), Int8Array$.MODULE$.$lessinit$greater$default$3())));
    }

    public static final /* synthetic */ SttpFile sttp$client4$fetch$AbstractFetchBackend$$anon$2$$_$regularAsFile$$anonfun$2(SttpFile file$1, ArrayBuffer ab) {
        Iterable iterable = JSConverters$.MODULE$.JSRichIterable((Iterable)scala.package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new java.lang.Object[]{ab})));
        return SttpFile$.MODULE$.fromDomFile(new File(JSConverters.JSRichIterable$.MODULE$.toJSIterable$extension(iterable), file$1.name(), (FilePropertyBag)BlobPropertyBag$.MODULE$.apply((java.lang.Object)file$1.toDomFile().type())));
    }
}

