/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Random$;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.internal.SttpFile;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.model.Uri;

public final class ToRfc2616Converter$
implements Serializable {
    private static final char[] BoundaryChars;
    public static final ToRfc2616Converter$ MODULE$;

    private ToRfc2616Converter$() {
    }

    static {
        MODULE$ = new ToRfc2616Converter$();
        BoundaryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ToRfc2616Converter$.class);
    }

    public String apply(GenericRequest<?, ?> request, Set<String> sensitiveHeaders, Set<String> sensitiveQueryParams) {
        String extractMethod = request.method();
        Uri extractUri = request.uri();
        String result = new StringBuilder(1).append(extractMethod).append(" ").append(extractUri.toStringSafe(sensitiveQueryParams)).toString();
        String headers2 = this.extractHeaders(request, sensitiveHeaders);
        String resultWithHeaders = headers2.isEmpty() ? result : new StringBuilder(0).append(result).append(new StringBuilder(1).append("\n").append(headers2).toString()).toString();
        String body2 = this.extractBody(request);
        if (body2.isEmpty()) {
            return resultWithHeaders;
        }
        return new StringBuilder(0).append(resultWithHeaders).append(new StringBuilder(2).append("\n\n").append(body2).toString()).toString();
    }

    public Set<String> apply$default$2() {
        return HeaderNames$.MODULE$.SensitiveHeaders();
    }

    public Set<String> apply$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private String extractBody(GenericRequest<?, ?> r) {
        GenericRequestBody<?> genericRequestBody = r.body();
        if (genericRequestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String text = string;
            return String.valueOf(text);
        }
        if (genericRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody2 = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
            byte[] byArray = byteArrayBody2._1();
            MediaType mediaType = byteArrayBody2._2();
            return "<PLACEHOLDER>";
        }
        if (genericRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody2 = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
            ByteBuffer byteBuffer = byteBufferBody2._1();
            MediaType mediaType = byteBufferBody2._2();
            return "<PLACEHOLDER>";
        }
        if (genericRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody2 = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
            InputStream inputStream = inputStreamBody2._1();
            MediaType mediaType = inputStreamBody2._2();
            return "<PLACEHOLDER>";
        }
        if (genericRequestBody instanceof StreamBody) {
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
            Object BinaryStream = streamBody._1();
            return "<PLACEHOLDER>";
        }
        if (genericRequestBody instanceof MultipartBody) {
            MultipartBody m = (MultipartBody)genericRequestBody;
            return this.handleMultipartBody(m.parts());
        }
        if (genericRequestBody instanceof FileBody) {
            FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
            SttpFile sttpFile = fileBody2._1();
            MediaType mediaType = fileBody2._2();
            SttpFile file = sttpFile;
            return new StringBuilder(1).append("<").append(file.name()).toString();
        }
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            return "";
        }
        throw new MatchError(genericRequestBody);
    }

    public String handleMultipartBody(Seq<Part<GenericRequestBody<?>>> parts) {
        String boundary = this.generateBoundary();
        return new StringBuilder(0).append(((IterableOnceOps)parts.map((Function1 & Serializable)p -> {
            GenericRequestBody genericRequestBody = (GenericRequestBody)p.body();
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                MediaType mediaType = stringBody._3();
                String s = string;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(93).append("--").append(boundary).append("\n               |Content-Disposition: form-data; name=\"").append(p.name()).append("\"\n               |\n               |").append(s).append("\n").toString()));
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody2._1();
                MediaType mediaType = fileBody2._2();
                SttpFile f = sttpFile;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(95).append("--").append(boundary).append("\n               |Content-Disposition: form-data; name=\"").append(p.name()).append("\"\n               |\n               |< ").append(f.name()).append("\n").toString()));
            }
            return new StringBuilder(2).append("--").append(boundary).toString();
        })).mkString("")).append(new StringBuilder(4).append("--").append(boundary).append("--").toString()).toString();
    }

    private String extractHeaders(GenericRequest<?, ?> r, Set<String> sensitiveHeaders) {
        return ((IterableOnceOps)((IterableOps)r.headers().filterNot((Function1 & Serializable)_$1 -> _$1.name().equalsIgnoreCase(HeaderNames$.MODULE$.AcceptEncoding()))).map((Function1 & Serializable)h -> h.toStringSafe(sensitiveHeaders))).mkString("\n");
    }

    private String generateBoundary() {
        Random$ random = Random$.MODULE$;
        return package$.MODULE$.List().fill(32, () -> ToRfc2616Converter$.generateBoundary$$anonfun$1(random)).mkString();
    }

    private static final char generateBoundary$$anonfun$1(Random$ random$1) {
        return BoundaryChars[random$1.nextInt(BoundaryChars.length)];
    }
}

