/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.headers;

import java.io.Serializable;
import java.util.regex.Matcher;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.model.ContentTypeRange;
import sttp.model.ContentTypeRange$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.internal.Patterns$;
import sttp.model.internal.Validate$;

public final class Accepts$
implements Serializable {
    public static final Accepts$ MODULE$ = new Accepts$();

    private Accepts$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Accepts$.class);
    }

    public Either<String, Seq<ContentTypeRange>> parse(Seq<Header> headers2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.parseAcceptHeader(headers2), this.parseAcceptCharsetHeader(headers2));
        if (tuple2 != null) {
            Either either = (Either)tuple2._1();
            Either either2 = (Either)tuple2._2();
            if (either instanceof Right) {
                Seq mts = (Seq)((Right)either).value();
                if (either2 instanceof Right) {
                    Seq chs = (Seq)((Right)either2).value();
                    return scala.package$.MODULE$.Right().apply(this.toContentTypeRanges((Seq<Tuple2<MediaType, Object>>)mts, (Seq<Tuple2<String, Object>>)chs));
                }
            }
            if (either instanceof Left) {
                String string;
                String errorMts = string = (String)((Left)either).value();
                if (either2 instanceof Left) {
                    String errorChs = (String)((Left)either2).value();
                    return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(1).append(errorMts).append("\n").append(errorChs).toString());
                }
                String error = string;
                return scala.package$.MODULE$.Left().apply((Object)error);
            }
            if (either2 instanceof Left) {
                String error = (String)((Left)either2).value();
                return scala.package$.MODULE$.Left().apply((Object)error);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<ContentTypeRange> unsafeParse(Seq<Header> headers2) {
        return this.toContentTypeRanges(Validate$.MODULE$.RichEither(this.parseAcceptHeader(headers2)).getOrThrow(), Validate$.MODULE$.RichEither(this.parseAcceptCharsetHeader(headers2)).getOrThrow());
    }

    private Seq<ContentTypeRange> toContentTypeRanges(Seq<Tuple2<MediaType, Object>> mediaTypes, Seq<Tuple2<String, Object>> charsets) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(mediaTypes, charsets);
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            Seq seq3 = seq;
            if (!(nil$ != null ? !nil$.equals(seq3) : seq3 != null)) {
                Nil$ nil$2 = scala.package$.MODULE$.Nil();
                Seq seq4 = seq2;
                if (!(nil$2 != null ? !nil$2.equals(seq4) : seq4 != null)) {
                    return scala.package$.MODULE$.Nil().$colon$colon((Object)ContentTypeRange$.MODULE$.AnyRange());
                }
                if (seq2 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)seq2;
                    Tuple2 tuple22 = (Tuple2)colon2.head();
                    List list = colon2.next$access$1();
                    if (tuple22 != null) {
                        String ch = (String)tuple22._1();
                        Nil$ nil$3 = scala.package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$3 != null ? !nil$3.equals(list2) : list2 != null)) {
                            ContentTypeRange contentTypeRange = ContentTypeRange$.MODULE$.apply(ContentTypeRange$.MODULE$.Wildcard(), ContentTypeRange$.MODULE$.Wildcard(), ch, ContentTypeRange$.MODULE$.EmptyParameters());
                            return scala.package$.MODULE$.Nil().$colon$colon((Object)contentTypeRange);
                        }
                    }
                }
            }
            if (seq instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)seq;
                Tuple2 tuple23 = (Tuple2)colon3.head();
                List list = colon3.next$access$1();
                if (tuple23 != null) {
                    MediaType mt = (MediaType)tuple23._1();
                    Nil$ nil$4 = scala.package$.MODULE$.Nil();
                    List list3 = list;
                    if (!(nil$4 != null ? !nil$4.equals(list3) : list3 != null)) {
                        Nil$ nil$5 = scala.package$.MODULE$.Nil();
                        Seq seq5 = seq2;
                        if (!(nil$5 != null ? !nil$5.equals(seq5) : seq5 != null)) {
                            ContentTypeRange contentTypeRange = ContentTypeRange$.MODULE$.apply(mt.mainType(), mt.subType(), ContentTypeRange$.MODULE$.Wildcard(), mt.otherParameters());
                            return scala.package$.MODULE$.Nil().$colon$colon((Object)contentTypeRange);
                        }
                    }
                }
            }
            Nil$ nil$6 = scala.package$.MODULE$.Nil();
            Seq seq6 = seq;
            if (!(nil$6 != null ? !nil$6.equals(seq6) : seq6 != null)) {
                Seq chs = seq2;
                return (Seq)((IterableOps)chs.sortBy((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        float q = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        return -q;
                    }
                    throw new MatchError((Object)tuple2);
                }, (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String ch = (String)tuple2._1();
                        return ContentTypeRange$.MODULE$.apply(ContentTypeRange$.MODULE$.Wildcard(), ContentTypeRange$.MODULE$.Wildcard(), ch, ContentTypeRange$.MODULE$.EmptyParameters());
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            Seq mts = seq;
            Nil$ nil$7 = scala.package$.MODULE$.Nil();
            Seq seq7 = seq2;
            if (!(nil$7 != null ? !nil$7.equals(seq7) : seq7 != null)) {
                return (Seq)((IterableOps)mts.sortBy((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        float q = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                        return -q;
                    }
                    throw new MatchError((Object)tuple2);
                }, (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        MediaType mt = (MediaType)tuple2._1();
                        return ContentTypeRange$.MODULE$.apply(mt.mainType(), mt.subType(), ContentTypeRange$.MODULE$.Wildcard(), mt.otherParameters());
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            Seq mts2 = seq;
            Seq chs = seq2;
            Seq seq8 = (Seq)mts2.flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    float mtQ = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    return (Seq)chs.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String ch = (String)tuple2._1();
                            float chQ = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                            Tuple2 tuple22 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)Tuple2$.MODULE$.apply((Object)mt, (Object)ch));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple22, (Object)BoxesRunTime.boxToFloat((float)package$.MODULE$.min(mtQ, chQ)));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            if (seq8 instanceof .colon.colon) {
                Tuple2 tuple24;
                .colon.colon colon4 = (.colon.colon)seq8;
                Tuple2 tuple25 = (Tuple2)colon4.head();
                List list = colon4.next$access$1();
                if (tuple25 != null && (tuple24 = (Tuple2)tuple25._1()) != null) {
                    MediaType mt = (MediaType)tuple24._1();
                    String ch = (String)tuple24._2();
                    Nil$ nil$8 = scala.package$.MODULE$.Nil();
                    List list4 = list;
                    if (!(nil$8 != null ? !nil$8.equals(list4) : list4 != null)) {
                        ContentTypeRange contentTypeRange = ContentTypeRange$.MODULE$.apply(mt.mainType(), mt.subType(), ch, mt.otherParameters());
                        return scala.package$.MODULE$.Nil().$colon$colon((Object)contentTypeRange);
                    }
                }
            }
            Seq merged = seq8;
            return (Seq)((IterableOps)merged.sortBy((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    float q = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    return -q;
                }
                throw new MatchError((Object)tuple2);
            }, (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    String ch = (String)tuple2._2();
                    return ContentTypeRange$.MODULE$.apply(mt.mainType(), mt.subType(), ch, mt.otherParameters());
                }
                throw new MatchError((Object)tuple22);
            });
        }
        throw new MatchError((Object)tuple2);
    }

    private Either<String, Seq<Tuple2<MediaType, Object>>> parseAcceptHeader(Seq<Header> headers2) {
        StringBuilder errors = new StringBuilder();
        Builder mts = scala.package$.MODULE$.List().newBuilder();
        this.extractEntries(headers2, HeaderNames$.MODULE$.Accept()).foreach((Function1 & Serializable)entry -> {
            Either either = MediaType$.MODULE$.parse((String)entry).flatMap((Function1 & Serializable)mt -> MODULE$.qValue((MediaType)mt).map((Function1 & Serializable)_$1 -> Accepts$.parseAcceptHeader$$anonfun$1$$anonfun$1$$anonfun$1(mt, BoxesRunTime.unboxToFloat((Object)_$1))));
            if (either instanceof Right) {
                Tuple2 mt2 = (Tuple2)((Right)either).value();
                return mts.$plus$eq((Object)mt2);
            }
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                Object object = errors.length() != 0 ? errors.append('\n') : BoxedUnit.UNIT;
                return errors.append(error);
            }
            throw new MatchError((Object)either);
        });
        if (errors.length() == 0) {
            return scala.package$.MODULE$.Right().apply(mts.result());
        }
        return scala.package$.MODULE$.Left().apply((Object)errors.toString());
    }

    private Either<String, Seq<Tuple2<String, Object>>> parseAcceptCharsetHeader(Seq<Header> headers2) {
        StringBuilder errors = new StringBuilder();
        Builder chs = scala.package$.MODULE$.List().newBuilder();
        this.extractEntries(headers2, HeaderNames$.MODULE$.AcceptCharset()).foreach((Function1 & Serializable)entry -> {
            Either<String, Tuple2<String, Object>> either = MODULE$.parseAcceptCharsetEntry((String)entry);
            if (either instanceof Right) {
                Tuple2 ch = (Tuple2)((Right)either).value();
                return chs.$plus$eq((Object)ch);
            }
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                Object object = errors.length() != 0 ? errors.append('\n') : BoxedUnit.UNIT;
                return errors.append(error);
            }
            throw new MatchError(either);
        });
        if (errors.length() == 0) {
            return scala.package$.MODULE$.Right().apply(chs.result());
        }
        return scala.package$.MODULE$.Left().apply((Object)errors.toString());
    }

    private Either<String, Tuple2<String, Object>> parseAcceptCharsetEntry(String entry) {
        Matcher name = Patterns$.MODULE$.Type().matcher(entry);
        if (name.lookingAt()) {
            return Patterns$.MODULE$.parseMediaTypeParameters(entry, name.end()).flatMap((Function1 & Serializable)_$2 -> MODULE$.qValueFrom((Map<String, String>)_$2).map((Function1 & Serializable)_$3 -> Accepts$.parseAcceptCharsetEntry$$anonfun$1$$anonfun$1(name, BoxesRunTime.unboxToFloat((Object)_$3))));
        }
        return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(24).append("No charset found for: \"").append(entry).append("\"").toString());
    }

    private Seq<String> extractEntries(Seq<Header> headers2, String name) {
        Builder entries = scala.package$.MODULE$.List().newBuilder();
        headers2.foreach((Function1)(JProcedure1 & Serializable)h -> {
            if (h.is(name)) {
                entries.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])MODULE$.trimInPlace(h.value().split(","))));
                return;
            }
        });
        return (Seq)entries.result();
    }

    private String[] trimInPlace(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = ss[i].trim();
        }
        return ss;
    }

    private Either<String, Object> qValue(MediaType mt) {
        return this.qValueFrom(mt.otherParameters());
    }

    private Either<String, Object> qValueFrom(Map<String, String> parameters) {
        Option option = parameters.get((Object)"q");
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToFloat((float)1.0f));
        }
        if (option instanceof Some) {
            String q = (String)((Some)option).value();
            Matcher qValue = Patterns$.MODULE$.QValue().matcher(q);
            if (qValue.matches() && qValue.groupCount() == 1) {
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(qValue.group(1)))));
            }
            return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(79).append("q must be numeric value between <0, 1> with up to 3 decimal points, provided \"").append(q).append("\"").toString());
        }
        throw new MatchError((Object)option);
    }

    private static final /* synthetic */ Tuple2 parseAcceptHeader$$anonfun$1$$anonfun$1$$anonfun$1(MediaType mt$2, float _$1) {
        MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mt$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, (Object)BoxesRunTime.boxToFloat((float)_$1));
    }

    private static final /* synthetic */ Tuple2 parseAcceptCharsetEntry$$anonfun$1$$anonfun$1(Matcher name$2, float _$3) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name$2.group(1).toLowerCase());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToFloat((float)_$3));
    }
}

