/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.FieldName;
import sttp.tapir.Schema;
import sttp.tapir.ValidationError;
import sttp.tapir.ValidationError$;
import sttp.tapir.ValidationResult;
import sttp.tapir.ValidationResult$;
import sttp.tapir.ValidationResult$Invalid$;
import sttp.tapir.ValidationResult$Valid$;
import sttp.tapir.Validator$;
import sttp.tapir.Validator$All$;
import sttp.tapir.Validator$Any$;
import sttp.tapir.Validator$Custom$;
import sttp.tapir.Validator$Enumeration$;
import sttp.tapir.Validator$Mapped$;
import sttp.tapir.Validator$Max$;
import sttp.tapir.Validator$MaxLength$;
import sttp.tapir.Validator$MaxSize$;
import sttp.tapir.Validator$Min$;
import sttp.tapir.Validator$MinLength$;
import sttp.tapir.Validator$MinSize$;
import sttp.tapir.Validator$Pattern$;

public interface Validator<T> {
    public static <T> Validator<T> all(Seq<Validator<T>> seq) {
        return Validator$.MODULE$.all(seq);
    }

    public static <T> Validator<T> any(Seq<Validator<T>> seq) {
        return Validator$.MODULE$.any(seq);
    }

    public static <T> Validator<T> custom(Function1<T, ValidationResult> function1, Option<String> option) {
        return Validator$.MODULE$.custom(function1, option);
    }

    public static <T> Enumeration<T> enumeration(List<T> list) {
        return Validator$.MODULE$.enumeration(list);
    }

    public static <T> Enumeration<T> enumeration(List<T> list, Function1<T, Option<Object>> function1, Option<Schema.SName> option) {
        return Validator$.MODULE$.enumeration(list, function1, option);
    }

    public static <T extends String> Validator<T> fixedLength(int n) {
        return Validator$.MODULE$.fixedLength(n);
    }

    public static <T extends String> Validator<T> fixedLength(int n, boolean bl) {
        return Validator$.MODULE$.fixedLength(n, bl);
    }

    public static <T, C extends Iterable<?>> Validator<Iterable<T>> fixedSize(int n) {
        return Validator$.MODULE$.fixedSize(n);
    }

    public static <T> Validator<T> inRange(T t, T t2, boolean bl, boolean bl2, Numeric<T> numeric) {
        return Validator$.MODULE$.inRange(t, t2, bl, bl2, numeric);
    }

    public static <T> Primitive<T> max(T t, boolean bl, Numeric<T> numeric) {
        return Validator$.MODULE$.max(t, bl, numeric);
    }

    public static <T extends String> Primitive<T> maxLength(int n) {
        return Validator$.MODULE$.maxLength(n);
    }

    public static <T extends String> Primitive<T> maxLength(int n, boolean bl) {
        return Validator$.MODULE$.maxLength(n, bl);
    }

    public static <T, C extends Iterable<?>> Primitive<Iterable<T>> maxSize(int n) {
        return Validator$.MODULE$.maxSize(n);
    }

    public static <T> Primitive<T> min(T t, boolean bl, Numeric<T> numeric) {
        return Validator$.MODULE$.min(t, bl, numeric);
    }

    public static <T extends String> Primitive<T> minLength(int n) {
        return Validator$.MODULE$.minLength(n);
    }

    public static <T extends String> Primitive<T> minLength(int n, boolean bl) {
        return Validator$.MODULE$.minLength(n, bl);
    }

    public static <T, C extends Iterable<?>> Primitive<Iterable<T>> minSize(int n) {
        return Validator$.MODULE$.minSize(n);
    }

    public static <T> Primitive<T> negative(Numeric<T> numeric) {
        return Validator$.MODULE$.negative(numeric);
    }

    public static <T, C extends Iterable<?>> Primitive<Iterable<T>> nonEmpty() {
        return Validator$.MODULE$.nonEmpty();
    }

    public static <T extends String> Primitive<T> nonEmptyString() {
        return Validator$.MODULE$.nonEmptyString();
    }

    public static <T> Validator<T> pass() {
        return Validator$.MODULE$.pass();
    }

    public static <T extends String> Primitive<T> pattern(String string) {
        return Validator$.MODULE$.pattern(string);
    }

    public static <T> Primitive<T> positive(Numeric<T> numeric) {
        return Validator$.MODULE$.positive(numeric);
    }

    public static <T> Primitive<T> positiveOrZero(Numeric<T> numeric) {
        return Validator$.MODULE$.positiveOrZero(numeric);
    }

    public static <T> Validator<T> reject() {
        return Validator$.MODULE$.reject();
    }

    public static <T> Option<String> custom$default$2() {
        return Validator$.MODULE$.custom$default$2();
    }

    public static <T> boolean max$default$2() {
        return Validator$.MODULE$.max$default$2();
    }

    public static <T> boolean min$default$2() {
        return Validator$.MODULE$.min$default$2();
    }

    public static <T> Option<Schema.SName> enumeration$default$3() {
        return Validator$.MODULE$.enumeration$default$3();
    }

    public static <T> boolean inRange$default$3() {
        return Validator$.MODULE$.inRange$default$3();
    }

    public static <T> boolean inRange$default$4() {
        return Validator$.MODULE$.inRange$default$4();
    }

    public List<ValidationError<?>> apply(T var1);

    public static Validator contramap$(Validator $this, Function1 g) {
        return $this.contramap(g);
    }

    default public <TT> Validator<TT> contramap(Function1<TT, T> g) {
        return Validator$Mapped$.MODULE$.apply(this, g);
    }

    public static Validator and$(Validator $this, Validator other) {
        return $this.and(other);
    }

    default public Validator<T> and(Validator<T> other) {
        return Validator$.MODULE$.all(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Validator[]{this, other}));
    }

    public static Validator or$(Validator $this, Validator other) {
        return $this.or(other);
    }

    default public Validator<T> or(Validator<T> other) {
        return Validator$.MODULE$.any(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Validator[]{this, other}));
    }

    public static Option show$(Validator $this) {
        return $this.show();
    }

    default public Option<String> show() {
        return Validator$.MODULE$.show(this);
    }

    public static class All<T>
    implements Validator<T>,
    Product,
    Serializable {
        private final Seq validators;

        public static All<?> fromProduct(Product product) {
            return Validator$All$.MODULE$.fromProduct(product);
        }

        public static <T> All<T> unapply(All<T> all) {
            return Validator$All$.MODULE$.unapply(all);
        }

        public All(Seq<Validator<T>> validators) {
            this.validators = validators;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof All)) return false;
            All all = (All)object;
            Seq<Validator<T>> seq = this.validators();
            Seq<Validator<T>> seq2 = all.validators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!all.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof All;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "All";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "validators";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Validator<T>> validators() {
            return this.validators;
        }

        @Override
        public List<ValidationError<?>> apply(T t) {
            return ((IterableOnceOps)this.validators().flatMap(arg_0 -> Validator$.sttp$tapir$Validator$All$$_$apply$$anonfun$2(t, arg_0))).toList();
        }

        @Override
        public <TT> Validator<TT> contramap(Function1<TT, T> g) {
            if (this.validators().isEmpty()) {
                return this;
            }
            return Validator.contramap$(this, g);
        }

        @Override
        public Validator<T> and(Validator<T> other) {
            if (this.validators().isEmpty()) {
                return other;
            }
            return Validator$All$.MODULE$.apply((Seq)this.validators().$colon$plus(other));
        }

        public <T> All<T> copy(Seq<Validator<T>> validators) {
            return new All<T>(validators);
        }

        public <T> Seq<Validator<T>> copy$default$1() {
            return this.validators();
        }

        public Seq<Validator<T>> _1() {
            return this.validators();
        }
    }

    public static class Any<T>
    implements Validator<T>,
    Product,
    Serializable {
        private final Seq validators;

        public static <T> Primitive<T> PrimitiveRejectValidator() {
            return Validator$Any$.MODULE$.PrimitiveRejectValidator();
        }

        public static Any<?> fromProduct(Product product) {
            return Validator$Any$.MODULE$.fromProduct(product);
        }

        public static <T> Any<T> unapply(Any<T> any) {
            return Validator$Any$.MODULE$.unapply(any);
        }

        public Any(Seq<Validator<T>> validators) {
            this.validators = validators;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Any)) return false;
            Any any = (Any)object;
            Seq<Validator<T>> seq = this.validators();
            Seq<Validator<T>> seq2 = any.validators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!any.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Any;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Any";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "validators";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Validator<T>> validators() {
            return this.validators;
        }

        @Override
        public List<ValidationError<?>> apply(T t) {
            Seq results = (Seq)this.validators().map(arg_0 -> Validator$.sttp$tapir$Validator$Any$$_$_$$anonfun$4(t, arg_0));
            if (results.exists(Validator$::sttp$tapir$Validator$Any$$_$apply$$anonfun$3)) {
                return package$.MODULE$.List().empty();
            }
            if (this.validators().nonEmpty()) {
                return ((IterableOnceOps)results.flatten(Predef$.MODULE$.$conforms())).toList();
            }
            return (List)new .colon.colon(ValidationError$.MODULE$.apply(Validator$Any$.MODULE$.PrimitiveRejectValidator(), t, ValidationError$.MODULE$.$lessinit$greater$default$3(), ValidationError$.MODULE$.$lessinit$greater$default$4()), (List)Nil$.MODULE$);
        }

        @Override
        public <TT> Validator<TT> contramap(Function1<TT, T> g) {
            if (this.validators().isEmpty()) {
                return Validator$Any$.MODULE$.apply(package$.MODULE$.Nil());
            }
            return Validator.contramap$(this, g);
        }

        @Override
        public Validator<T> or(Validator<T> other) {
            if (this.validators().isEmpty()) {
                return other;
            }
            return Validator$Any$.MODULE$.apply((Seq)this.validators().$colon$plus(other));
        }

        public <T> Any<T> copy(Seq<Validator<T>> validators) {
            return new Any<T>(validators);
        }

        public <T> Seq<Validator<T>> copy$default$1() {
            return this.validators();
        }

        public Seq<Validator<T>> _1() {
            return this.validators();
        }
    }

    public static class Custom<T>
    implements Primitive<T>,
    Product,
    Serializable {
        private final Function1 validationLogic;
        private final Option showMessage;

        public static Custom<?> fromProduct(Product product) {
            return Validator$Custom$.MODULE$.fromProduct(product);
        }

        public static <T> Custom<T> unapply(Custom<T> custom) {
            return Validator$Custom$.MODULE$.unapply(custom);
        }

        public static <T> Option<String> $lessinit$greater$default$2() {
            return Validator$Custom$.MODULE$.$lessinit$greater$default$2();
        }

        public Custom(Function1<T, ValidationResult> validationLogic, Option<String> showMessage) {
            this.validationLogic = validationLogic;
            this.showMessage = showMessage;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Custom)) return false;
            Custom custom = (Custom)object;
            Function1<T, ValidationResult> function1 = this.validationLogic();
            Function1<T, ValidationResult> function12 = custom.validationLogic();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Option<String> option = this.showMessage();
            Option<String> option2 = custom.showMessage();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!custom.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Custom;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Custom";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "validationLogic";
            }
            if (1 == n2) {
                return "showMessage";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<T, ValidationResult> validationLogic() {
            return this.validationLogic;
        }

        public Option<String> showMessage() {
            return this.showMessage;
        }

        @Override
        public ValidationResult doValidate(T t) {
            return (ValidationResult)this.validationLogic().apply(t);
        }

        public <T> Custom<T> copy(Function1<T, ValidationResult> validationLogic, Option<String> showMessage) {
            return new Custom<T>(validationLogic, showMessage);
        }

        public <T> Function1<T, ValidationResult> copy$default$1() {
            return this.validationLogic();
        }

        public <T> Option<String> copy$default$2() {
            return this.showMessage();
        }

        public Function1<T, ValidationResult> _1() {
            return this.validationLogic();
        }

        public Option<String> _2() {
            return this.showMessage();
        }
    }

    public static class Enumeration<T>
    implements Primitive<T>,
    Product,
    Serializable {
        private final List possibleValues;
        private final Option encode;
        private final Option name;

        public static Enumeration<?> fromProduct(Product product) {
            return Validator$Enumeration$.MODULE$.fromProduct(product);
        }

        public static <T> Enumeration<T> unapply(Enumeration<T> enumeration) {
            return Validator$Enumeration$.MODULE$.unapply(enumeration);
        }

        public Enumeration(List<T> possibleValues, Option<Function1<T, Option<Object>>> encode, Option<Schema.SName> name) {
            this.possibleValues = possibleValues;
            this.encode = encode;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Enumeration)) return false;
            Enumeration enumeration = (Enumeration)object;
            List<T> list = this.possibleValues();
            List<T> list2 = enumeration.possibleValues();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            Option<Function1<T, Option<Object>>> option = this.encode();
            Option<Function1<T, Option<Object>>> option2 = enumeration.encode();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Schema.SName> option3 = this.name();
            Option<Schema.SName> option4 = enumeration.name();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!enumeration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Enumeration;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Enumeration";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "possibleValues";
                }
                case 1: {
                    return "encode";
                }
                case 2: {
                    return "name";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<T> possibleValues() {
            return this.possibleValues;
        }

        public Option<Function1<T, Option<Object>>> encode() {
            return this.encode;
        }

        public Option<Schema.SName> name() {
            return this.name;
        }

        @Override
        public ValidationResult doValidate(T t) {
            return ValidationResult$.MODULE$.validWhen(this.possibleValues().contains(t));
        }

        public Enumeration<T> encode(Function1<T, Object> e) {
            Some some = Some$.MODULE$.apply(arg_0 -> Validator$.sttp$tapir$Validator$Enumeration$$_$_$$anonfun$1(e, arg_0));
            List<T> list = this.copy$default$1();
            Option<Schema.SName> option = this.copy$default$3();
            return this.copy(list, (Option<Function1<T, Option<Object>>>)some, option);
        }

        public Enumeration<T> encodeWithPlainCodec(Codec<String, T, CodecFormat.TextPlain> c) {
            Some some = Some$.MODULE$.apply(arg_0 -> Validator$.sttp$tapir$Validator$Enumeration$$_$_$$anonfun$2(c, arg_0));
            List<T> list = this.copy$default$1();
            Option<Schema.SName> option = this.copy$default$3();
            return this.copy(list, (Option<Function1<T, Option<Object>>>)some, option);
        }

        public <CF extends CodecFormat> Enumeration<T> encodeWithCodec(Codec<String, T, CF> c) {
            Some some = Some$.MODULE$.apply(arg_0 -> Validator$.sttp$tapir$Validator$Enumeration$$_$_$$anonfun$3(c, arg_0));
            List<T> list = this.copy$default$1();
            Option<Schema.SName> option = this.copy$default$3();
            return this.copy(list, (Option<Function1<T, Option<Object>>>)some, option);
        }

        public <T> Enumeration<T> copy(List<T> possibleValues, Option<Function1<T, Option<Object>>> encode, Option<Schema.SName> name) {
            return new Enumeration<T>(possibleValues, encode, name);
        }

        public <T> List<T> copy$default$1() {
            return this.possibleValues();
        }

        public <T> Option<Function1<T, Option<Object>>> copy$default$2() {
            return this.encode();
        }

        public <T> Option<Schema.SName> copy$default$3() {
            return this.name();
        }

        public List<T> _1() {
            return this.possibleValues();
        }

        public Option<Function1<T, Option<Object>>> _2() {
            return this.encode();
        }

        public Option<Schema.SName> _3() {
            return this.name();
        }
    }

    public static class Mapped<TT, T>
    implements Validator<TT>,
    Product,
    Serializable {
        private final Validator wrapped;
        private final Function1 g;

        public static Mapped<?, ?> fromProduct(Product product) {
            return Validator$Mapped$.MODULE$.fromProduct(product);
        }

        public static <TT, T> Mapped<TT, T> unapply(Mapped<TT, T> mapped) {
            return Validator$Mapped$.MODULE$.unapply(mapped);
        }

        public Mapped(Validator<T> wrapped, Function1<TT, T> g) {
            this.wrapped = wrapped;
            this.g = g;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Mapped)) return false;
            Mapped mapped = (Mapped)object;
            Validator<T> validator = this.wrapped();
            Validator<T> validator2 = mapped.wrapped();
            if (validator == null) {
                if (validator2 != null) {
                    return false;
                }
            } else if (!validator.equals(validator2)) return false;
            Function1<TT, T> function1 = this.g();
            Function1<TT, T> function12 = mapped.g();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!mapped.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Mapped;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Mapped";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "wrapped";
            }
            if (1 == n2) {
                return "g";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Validator<T> wrapped() {
            return this.wrapped;
        }

        public Function1<TT, T> g() {
            return this.g;
        }

        @Override
        public List<ValidationError<?>> apply(TT t) {
            return this.wrapped().apply(this.g().apply(t));
        }

        public <TT, T> Mapped<TT, T> copy(Validator<T> wrapped, Function1<TT, T> g) {
            return new Mapped<TT, T>(wrapped, g);
        }

        public <TT, T> Validator<T> copy$default$1() {
            return this.wrapped();
        }

        public <TT, T> Function1<TT, T> copy$default$2() {
            return this.g();
        }

        public Validator<T> _1() {
            return this.wrapped();
        }

        public Function1<TT, T> _2() {
            return this.g();
        }
    }

    public static class Max<T>
    implements Primitive<T>,
    Product,
    Serializable {
        private final Object value;
        private final boolean exclusive;
        private final Numeric valueIsNumeric;

        public static <T> Max<T> unapply(Max<T> max) {
            return Validator$Max$.MODULE$.unapply(max);
        }

        public Max(T value, boolean exclusive, Numeric<T> valueIsNumeric) {
            this.value = value;
            this.exclusive = exclusive;
            this.valueIsNumeric = valueIsNumeric;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            n = Statics.mix((int)n, (int)(this.exclusive() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Max)) return false;
            Max max = (Max)object;
            if (this.exclusive() != max.exclusive()) return false;
            if (!BoxesRunTime.equals(this.value(), max.value())) return false;
            if (!max.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Max;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Max";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "exclusive";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T value() {
            return (T)this.value;
        }

        public boolean exclusive() {
            return this.exclusive;
        }

        public Numeric<T> valueIsNumeric() {
            return this.valueIsNumeric;
        }

        @Override
        public ValidationResult doValidate(T t) {
            return ValidationResult$.MODULE$.validWhen(((Ordering)Predef$.MODULE$.implicitly(this.valueIsNumeric())).lt(t, this.value()) || !this.exclusive() && ((Ordering)Predef$.MODULE$.implicitly(this.valueIsNumeric())).equiv(t, this.value()));
        }

        public <T> Max<T> copy(T value, boolean exclusive, Numeric<T> valueIsNumeric) {
            return new Max<T>(value, exclusive, valueIsNumeric);
        }

        public <T> T copy$default$1() {
            return this.value();
        }

        public boolean copy$default$2() {
            return this.exclusive();
        }

        public T _1() {
            return this.value();
        }

        public boolean _2() {
            return this.exclusive();
        }
    }

    public static class MaxLength<T extends String>
    implements Primitive<T>,
    Product,
    Serializable {
        private final int value;
        private final boolean countCodePoints;

        public static MaxLength<?> fromProduct(Product product) {
            return Validator$MaxLength$.MODULE$.fromProduct(product);
        }

        public static <T extends String> MaxLength<T> unapply(MaxLength<T> maxLength) {
            return Validator$MaxLength$.MODULE$.unapply(maxLength);
        }

        public MaxLength(int value, boolean countCodePoints) {
            this.value = value;
            this.countCodePoints = countCodePoints;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.value());
            n = Statics.mix((int)n, (int)(this.countCodePoints() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MaxLength)) return false;
            MaxLength maxLength = (MaxLength)object;
            if (this.value() != maxLength.value()) return false;
            if (this.countCodePoints() != maxLength.countCodePoints()) return false;
            if (!maxLength.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MaxLength;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MaxLength";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "countCodePoints";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int value() {
            return this.value;
        }

        public boolean countCodePoints() {
            return this.countCodePoints;
        }

        public MaxLength(int value) {
            this(value, false);
        }

        public <TT extends String> MaxLength<TT> copy(int value) {
            return Validator$MaxLength$.MODULE$.apply(value, false);
        }

        public <TT extends String> MaxLength<TT> copy(int value, boolean countCodePoints) {
            return Validator$MaxLength$.MODULE$.apply(value, countCodePoints);
        }

        public int copy$default$1() {
            return this.value();
        }

        public boolean copy$default$2() {
            return this.countCodePoints();
        }

        @Override
        public ValidationResult doValidate(T t) {
            int size = this.countCodePoints() ? ((String)t).codePointCount(0, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(t))) : StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(t));
            return ValidationResult$.MODULE$.validWhen(size <= this.value());
        }

        public int _1() {
            return this.value();
        }

        public boolean _2() {
            return this.countCodePoints();
        }
    }

    public static class MaxSize<T, C extends Iterable<?>>
    implements Primitive<C>,
    Product,
    Serializable {
        private final int value;

        public static MaxSize<?, ?> fromProduct(Product product) {
            return Validator$MaxSize$.MODULE$.fromProduct(product);
        }

        public static <T, C extends Iterable<?>> MaxSize<T, C> unapply(MaxSize<T, C> maxSize) {
            return Validator$MaxSize$.MODULE$.unapply(maxSize);
        }

        public MaxSize(int value) {
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MaxSize)) return false;
            MaxSize maxSize = (MaxSize)object;
            if (this.value() != maxSize.value()) return false;
            if (!maxSize.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MaxSize;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MaxSize";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int value() {
            return this.value;
        }

        @Override
        public ValidationResult doValidate(C t) {
            return ValidationResult$.MODULE$.validWhen(t.size() <= this.value());
        }

        public <T, C extends Iterable<?>> MaxSize<T, C> copy(int value) {
            return new MaxSize<T, C>(value);
        }

        public int copy$default$1() {
            return this.value();
        }

        public int _1() {
            return this.value();
        }
    }

    public static class Min<T>
    implements Primitive<T>,
    Product,
    Serializable {
        private final Object value;
        private final boolean exclusive;
        private final Numeric valueIsNumeric;

        public static <T> Min<T> unapply(Min<T> min) {
            return Validator$Min$.MODULE$.unapply(min);
        }

        public Min(T value, boolean exclusive, Numeric<T> valueIsNumeric) {
            this.value = value;
            this.exclusive = exclusive;
            this.valueIsNumeric = valueIsNumeric;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            n = Statics.mix((int)n, (int)(this.exclusive() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Min)) return false;
            Min min = (Min)object;
            if (this.exclusive() != min.exclusive()) return false;
            if (!BoxesRunTime.equals(this.value(), min.value())) return false;
            if (!min.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Min;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Min";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "exclusive";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T value() {
            return (T)this.value;
        }

        public boolean exclusive() {
            return this.exclusive;
        }

        public Numeric<T> valueIsNumeric() {
            return this.valueIsNumeric;
        }

        @Override
        public ValidationResult doValidate(T t) {
            return ValidationResult$.MODULE$.validWhen(((Ordering)Predef$.MODULE$.implicitly(this.valueIsNumeric())).gt(t, this.value()) || !this.exclusive() && ((Ordering)Predef$.MODULE$.implicitly(this.valueIsNumeric())).equiv(t, this.value()));
        }

        public <T> Min<T> copy(T value, boolean exclusive, Numeric<T> valueIsNumeric) {
            return new Min<T>(value, exclusive, valueIsNumeric);
        }

        public <T> T copy$default$1() {
            return this.value();
        }

        public boolean copy$default$2() {
            return this.exclusive();
        }

        public T _1() {
            return this.value();
        }

        public boolean _2() {
            return this.exclusive();
        }
    }

    public static class MinLength<T extends String>
    implements Primitive<T>,
    Product,
    Serializable {
        private final int value;
        private final boolean countCodePoints;

        public static MinLength<?> fromProduct(Product product) {
            return Validator$MinLength$.MODULE$.fromProduct(product);
        }

        public static <T extends String> MinLength<T> unapply(MinLength<T> minLength) {
            return Validator$MinLength$.MODULE$.unapply(minLength);
        }

        public MinLength(int value, boolean countCodePoints) {
            this.value = value;
            this.countCodePoints = countCodePoints;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.value());
            n = Statics.mix((int)n, (int)(this.countCodePoints() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MinLength)) return false;
            MinLength minLength = (MinLength)object;
            if (this.value() != minLength.value()) return false;
            if (this.countCodePoints() != minLength.countCodePoints()) return false;
            if (!minLength.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MinLength;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MinLength";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "countCodePoints";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int value() {
            return this.value;
        }

        public boolean countCodePoints() {
            return this.countCodePoints;
        }

        public MinLength(int value) {
            this(value, false);
        }

        public <TT extends String> MinLength<TT> copy(int value) {
            return Validator$MinLength$.MODULE$.apply(value, false);
        }

        public <TT extends String> MinLength<TT> copy(int value, boolean countCodePoints) {
            return Validator$MinLength$.MODULE$.apply(value, countCodePoints);
        }

        public int copy$default$1() {
            return this.value();
        }

        public boolean copy$default$2() {
            return this.countCodePoints();
        }

        @Override
        public ValidationResult doValidate(T t) {
            int size = this.countCodePoints() ? ((String)t).codePointCount(0, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(t))) : StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(t));
            return ValidationResult$.MODULE$.validWhen(size >= this.value());
        }

        public int _1() {
            return this.value();
        }

        public boolean _2() {
            return this.countCodePoints();
        }
    }

    public static class MinSize<T, C extends Iterable<?>>
    implements Primitive<C>,
    Product,
    Serializable {
        private final int value;

        public static MinSize<?, ?> fromProduct(Product product) {
            return Validator$MinSize$.MODULE$.fromProduct(product);
        }

        public static <T, C extends Iterable<?>> MinSize<T, C> unapply(MinSize<T, C> minSize) {
            return Validator$MinSize$.MODULE$.unapply(minSize);
        }

        public MinSize(int value) {
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MinSize)) return false;
            MinSize minSize = (MinSize)object;
            if (this.value() != minSize.value()) return false;
            if (!minSize.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MinSize;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MinSize";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int value() {
            return this.value;
        }

        @Override
        public ValidationResult doValidate(C t) {
            return ValidationResult$.MODULE$.validWhen(t.size() >= this.value());
        }

        public <T, C extends Iterable<?>> MinSize<T, C> copy(int value) {
            return new MinSize<T, C>(value);
        }

        public int copy$default$1() {
            return this.value();
        }

        public int _1() {
            return this.value();
        }
    }

    public static class Pattern<T extends String>
    implements Primitive<T>,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Pattern.class.getDeclaredField("pattern$lzy1"));
        private final String value;
        private volatile Object pattern$lzy1;

        public static Pattern<?> fromProduct(Product product) {
            return Validator$Pattern$.MODULE$.fromProduct(product);
        }

        public static <T extends String> Pattern<T> unapply(Pattern<T> pattern) {
            return Validator$Pattern$.MODULE$.unapply(pattern);
        }

        public Pattern(String value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pattern)) return false;
            Pattern pattern = (Pattern)object;
            String string = this.value();
            String string2 = pattern.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!pattern.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pattern;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Pattern";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        private java.util.regex.Pattern pattern() {
            Object object = this.pattern$lzy1;
            if (object instanceof java.util.regex.Pattern) {
                return (java.util.regex.Pattern)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (java.util.regex.Pattern)this.pattern$lzyINIT1();
        }

        private Object pattern$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.pattern$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        java.util.regex.Pattern pattern = null;
                        try {
                            pattern = java.util.regex.Pattern.compile(this.value());
                            object2 = pattern == null ? LazyVals.NullValue$.MODULE$ : pattern;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.pattern$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return pattern;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ValidationResult doValidate(T t) {
            return ValidationResult$.MODULE$.validWhen(this.pattern().matcher((CharSequence)t).matches());
        }

        public <T extends String> Pattern<T> copy(String value) {
            return new Pattern<T>(value);
        }

        public <T extends String> String copy$default$1() {
            return this.value();
        }

        public String _1() {
            return this.value();
        }
    }

    public static interface Primitive<T>
    extends Validator<T> {
        public ValidationResult doValidate(T var1);

        public static List apply$(Primitive $this, Object t) {
            return $this.apply(t);
        }

        @Override
        default public List<ValidationError<T>> apply(T t) {
            ValidationResult validationResult = this.doValidate(t);
            if (ValidationResult$Valid$.MODULE$.equals(validationResult)) {
                return package$.MODULE$.Nil();
            }
            if (validationResult instanceof ValidationResult.Invalid) {
                List<String> list;
                List<String> customMessages;
                ValidationResult.Invalid invalid = ValidationResult$Invalid$.MODULE$.unapply((ValidationResult.Invalid)validationResult);
                List<String> list2 = customMessages = (list = invalid._1());
                Nil$ nil$ = package$.MODULE$.Nil();
                List<String> list3 = list2;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    return (List)new .colon.colon(ValidationError$.MODULE$.apply(this, t, (List<FieldName>)package$.MODULE$.Nil(), (Option<String>)None$.MODULE$), (List)Nil$.MODULE$);
                }
                List<String> l = list2;
                return l.map((Function1 & Serializable)m -> ValidationError$.MODULE$.apply(this, t, (List<FieldName>)package$.MODULE$.Nil(), (Option<String>)Some$.MODULE$.apply(m)));
            }
            throw new MatchError((Object)validationResult);
        }
    }
}

