/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.sttp4;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.scalajs.dom.File;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.client4.BasicBodyPart;
import sttp.client4.DuplicateHeaderBehavior$Add$;
import sttp.client4.DuplicateHeaderBehavior$Replace$;
import sttp.client4.PartialRequest;
import sttp.client4.Request;
import sttp.client4.ResponseAs;
import sttp.client4.package$;
import sttp.model.ContentTypeRange;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Part;
import sttp.model.QueryParams;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.model.Uri$EmptyPath$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.DecodeResult$Error$;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointIO$Body$;
import sttp.tapir.EndpointIO$Empty$;
import sttp.tapir.EndpointIO$FixedHeader$;
import sttp.tapir.EndpointIO$Header$;
import sttp.tapir.EndpointIO$Headers$;
import sttp.tapir.EndpointIO$MappedPair$;
import sttp.tapir.EndpointIO$OneOfBody$;
import sttp.tapir.EndpointIO$OneOfBodyVariant$;
import sttp.tapir.EndpointIO$Pair$;
import sttp.tapir.EndpointIO$StreamBodyWrapper$;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointInput$Cookie$;
import sttp.tapir.EndpointInput$ExtractFromRequest$;
import sttp.tapir.EndpointInput$FixedMethod$;
import sttp.tapir.EndpointInput$FixedPath$;
import sttp.tapir.EndpointInput$MappedPair$;
import sttp.tapir.EndpointInput$Pair$;
import sttp.tapir.EndpointInput$PathCapture$;
import sttp.tapir.EndpointInput$PathsCapture$;
import sttp.tapir.EndpointInput$Query$;
import sttp.tapir.EndpointInput$QueryParams$;
import sttp.tapir.EndpointOutput;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.RawBodyType$ByteArrayBody$;
import sttp.tapir.RawBodyType$ByteBufferBody$;
import sttp.tapir.RawBodyType$FileBody$;
import sttp.tapir.RawBodyType$InputStreamBody$;
import sttp.tapir.RawBodyType$InputStreamRangeBody$;
import sttp.tapir.RawBodyType$MultipartBody$;
import sttp.tapir.RawBodyType$StringBody$;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.StreamBodyIO$;
import sttp.tapir.client.ClientOutputParams;
import sttp.tapir.client.sttp4.SttpClientOptions;
import sttp.tapir.internal.package;
import sttp.tapir.internal.package$ParamsAsAny$;

public interface EndpointToSttpClientBase {
    public static boolean isSuccess$(EndpointToSttpClientBase $this, ResponseMetadata meta) {
        return $this.isSuccess(meta);
    }

    default public boolean isSuccess(ResponseMetadata meta) {
        return meta.isSuccess();
    }

    public static Tuple2 prepareRequestWithInput$(EndpointToSttpClientBase $this, Endpoint e, Option baseUri, Object aParams, Object iParams) {
        return $this.prepareRequestWithInput(e, (Option<Uri>)baseUri, aParams, iParams);
    }

    default public <A, E, O, I, R> Tuple2<Request<?>, Option<Tuple2<package.Streams<?>, Object>>> prepareRequestWithInput(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, A aParams, I iParams) {
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple3 = this.setInputParams((EndpointInput<I>)e.securityInput(), package$ParamsAsAny$.MODULE$.apply(aParams), (Uri)baseUri.getOrElse(EndpointToSttpClientBase::$anonfun$1), package$.MODULE$.basicRequest(), (Option<Tuple2<package.Streams<?>, Object>>)None$.MODULE$);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Uri uri1 = (Uri)tuple3._1();
        PartialRequest req1 = (PartialRequest)tuple3._2();
        Option streamBody1 = (Option)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)uri1, (Object)req1, (Object)streamBody1);
        Uri uri12 = (Uri)tuple32._1();
        PartialRequest req12 = (PartialRequest)tuple32._2();
        Option streamBody12 = (Option)tuple32._3();
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple33 = this.setInputParams(e.input(), package$ParamsAsAny$.MODULE$.apply(iParams), uri12, req12, streamBody12);
        if (tuple33 == null) {
            throw new MatchError(tuple33);
        }
        Uri uri2 = (Uri)tuple33._1();
        PartialRequest req2 = (PartialRequest)tuple33._2();
        Option streamBody2 = (Option)tuple33._3();
        Tuple3 tuple34 = Tuple3$.MODULE$.apply((Object)uri2, (Object)req2, (Object)streamBody2);
        Uri uri22 = (Uri)tuple34._1();
        PartialRequest req22 = (PartialRequest)tuple34._2();
        Option streamBody22 = (Option)tuple34._3();
        return Tuple2$.MODULE$.apply(req22.method(Method$.MODULE$.apply(((Method)e.method().getOrElse((Function0 & Serializable)() -> new Method(EndpointToSttpClientBase.prepareRequestWithInput$$anonfun$1()))).method()), uri22), (Object)streamBody22);
    }

    public static DecodeResult mapReqOutputWithMetadata$(EndpointToSttpClientBase $this, Endpoint e, Object body2, ResponseMetadata meta, ClientOutputParams clientOutputParams) {
        return $this.mapReqOutputWithMetadata(e, body2, meta, clientOutputParams);
    }

    default public <A, I, E, O, R, T> DecodeResult<Either<Object, Object>> mapReqOutputWithMetadata(Endpoint<A, I, E, O, R> e, T body2, ResponseMetadata meta, ClientOutputParams clientOutputParams) {
        EndpointOutput<Object> output = this.isSuccess(meta) ? e.output() : e.errorOutput();
        DecodeResult<package.Params> params2 = clientOutputParams.apply(output, body2, meta);
        return params2.map((Function1 & Serializable)_$1 -> _$1.asAny()).map((Function1 & Serializable)p -> {
            if (this.isSuccess(meta)) {
                return scala.package$.MODULE$.Right().apply(p);
            }
            return scala.package$.MODULE$.Left().apply(p);
        });
    }

    public static DecodeResult mapDecodeError$(EndpointToSttpClientBase $this, DecodeResult decodeResult, Request req) {
        return $this.mapDecodeError(decodeResult, req);
    }

    default public DecodeResult<Either<Object, Object>> mapDecodeError(DecodeResult<Either<Object, Object>> decodeResult, Request<?> req) {
        DecodeResult<Either<Object, Object>> decodeResult2 = decodeResult;
        if (decodeResult2 instanceof DecodeResult.Error) {
            DecodeResult.Error error = DecodeResult$Error$.MODULE$.unapply((DecodeResult.Error)decodeResult2);
            String string = error._1();
            Throwable throwable = error._2();
            String o = string;
            Throwable e = throwable;
            return DecodeResult$Error$.MODULE$.apply(o, new IllegalArgumentException(new StringBuilder(32).append("Cannot decode from: ").append(o).append(", request: ").append(new Method(req.method())).append(" ").append(req.uri()).toString(), e));
        }
        DecodeResult<Either<Object, Object>> other = decodeResult2;
        return other;
    }

    public static ResponseAs outToResponseAs$(EndpointToSttpClientBase $this, EndpointOutput out, SttpClientOptions clientOptions) {
        return $this.outToResponseAs(out, clientOptions);
    }

    default public ResponseAs<Object> outToResponseAs(EndpointOutput<?> out, SttpClientOptions clientOptions) {
        return (ResponseAs)sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).bodyType().map((Function1 & Serializable)x$1 -> {
            RawBodyType rawBodyType = x$1;
            if (rawBodyType instanceof RawBodyType.StringBody) {
                Charset charset;
                RawBodyType.StringBody stringBody = RawBodyType$StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
                Charset charset2 = charset = stringBody._1();
                return package$.MODULE$.asStringAlways(charset2.name());
            }
            if (RawBodyType$ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways();
            }
            if (RawBodyType$ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)x$0 -> ByteBuffer.wrap(x$0));
            }
            if (RawBodyType$InputStreamBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)_$2 -> new ByteArrayInputStream((byte[])_$2));
            }
            if (RawBodyType$FileBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asFileAlways((File)clientOptions.createFile().apply()).map((Function1 & Serializable)d -> FileRange$.MODULE$.apply((File)d, (Option)FileRange$.MODULE$.$lessinit$greater$default$2()));
            }
            if (RawBodyType$InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)b -> InputStreamRange$.MODULE$.apply((Function0<InputStream>)(Function0 & Serializable)() -> new ByteArrayInputStream((byte[])b), InputStreamRange$.MODULE$.$lessinit$greater$default$2()));
            }
            if (rawBodyType instanceof RawBodyType.MultipartBody) {
                RawBodyType.MultipartBody multipartBody2 = RawBodyType$MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
                Map<String, RawBodyType<?>> map = multipartBody2._1();
                Option<RawBodyType<?>> option = multipartBody2._2();
                throw new IllegalArgumentException("Multipart bodies aren't supported in responses");
            }
            throw new MatchError((Object)rawBodyType);
        }).getOrElse(EndpointToSttpClientBase::outToResponseAs$$anonfun$2);
    }

    private <I> Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> setInputParams(EndpointInput<I> input, package.Params params2, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        EndpointIO.Body body2;
        while (true) {
            EndpointIO.StreamBodyWrapper streamBodyWrapper;
            StreamBodyIO streamBodyIO;
            if ((body2 = input) instanceof EndpointInput.FixedMethod) {
                EndpointInput.FixedMethod fixedMethod = EndpointInput$FixedMethod$.MODULE$.unapply((EndpointInput.FixedMethod)((Object)body2));
                String string = fixedMethod._1();
                Codec codec2 = fixedMethod._2();
                EndpointIO.Info info = fixedMethod._3();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (body2 instanceof EndpointInput.FixedPath) {
                EndpointInput.FixedPath fixedPath = EndpointInput$FixedPath$.MODULE$.unapply((EndpointInput.FixedPath)((Object)body2));
                String string = fixedPath._1();
                Codec codec3 = fixedPath._2();
                EndpointIO.Info info = fixedPath._3();
                String p = string;
                return Tuple3$.MODULE$.apply((Object)uri.addPath(p, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req, streamBody);
            }
            if (body2 instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = EndpointInput$PathCapture$.MODULE$.unapply((EndpointInput.PathCapture)((Object)body2));
                Option<String> option = pathCapture._1();
                Codec codec4 = pathCapture._2();
                EndpointIO.Info info = pathCapture._3();
                Codec codec5 = codec4;
                String v = codec5.encode(EndpointToSttpClientBase.value$1(params2));
                return Tuple3$.MODULE$.apply((Object)uri.addPath(v, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req, streamBody);
            }
            if (body2 instanceof EndpointInput.PathsCapture) {
                EndpointInput.PathsCapture pathsCapture = EndpointInput$PathsCapture$.MODULE$.unapply((EndpointInput.PathsCapture)((Object)body2));
                Codec codec6 = pathsCapture._1();
                EndpointIO.Info info = pathsCapture._2();
                Codec codec7 = codec6;
                List<String> ps = codec7.encode(EndpointToSttpClientBase.value$1(params2));
                return Tuple3$.MODULE$.apply((Object)uri.addPath((Seq<String>)ps), req, streamBody);
            }
            if (body2 instanceof EndpointInput.Query) {
                EndpointInput.Query query2 = EndpointInput$Query$.MODULE$.unapply((EndpointInput.Query)((Object)body2));
                String string = query2._1();
                Option option = query2._2();
                Codec codec8 = query2._3();
                EndpointIO.Info info = query2._4();
                String name = string;
                if (option instanceof Some) {
                    Object flagValue = ((Some)option).value();
                    if (BoxesRunTime.equals((Object)EndpointToSttpClientBase.value$1(params2), (Object)flagValue)) {
                        return Tuple3$.MODULE$.apply((Object)uri.withParams(uri.params().param(name, (scala.collection.immutable.Seq<String>)scala.package$.MODULE$.Nil())), req, streamBody);
                    }
                }
                String name2 = string;
                Codec codec9 = codec8;
                Uri uri2 = (Uri)((LinearSeqOps)codec9.encode(EndpointToSttpClientBase.value$1(params2))).foldLeft((Object)uri, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Uri u = (Uri)tuple2._1();
                        String v = (String)tuple2._2();
                        return u.addParam(name2, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri2, req, streamBody);
            }
            if (body2 instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie2 = EndpointInput$Cookie$.MODULE$.unapply((EndpointInput.Cookie)((Object)body2));
                String string = cookie2._1();
                Codec codec10 = cookie2._2();
                EndpointIO.Info info = cookie2._3();
                String name = string;
                Codec codec11 = codec10;
                PartialRequest req2 = (PartialRequest)Option$.MODULE$.option2Iterable(codec11.encode(EndpointToSttpClientBase.value$1(params2))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return (PartialRequest)r.cookie(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (body2 instanceof EndpointInput.QueryParams) {
                EndpointInput.QueryParams queryParams = EndpointInput$QueryParams$.MODULE$.unapply((EndpointInput.QueryParams)((Object)body2));
                Codec codec12 = queryParams._1();
                EndpointIO.Info info = queryParams._2();
                Codec codec13 = codec12;
                QueryParams mqp = codec13.encode(EndpointToSttpClientBase.value$1(params2));
                Uri uri2 = uri.addParams(mqp.toSeq());
                return Tuple3$.MODULE$.apply((Object)uri2, req, streamBody);
            }
            if (body2 instanceof EndpointIO.Empty) {
                EndpointIO.Empty empty = EndpointIO$Empty$.MODULE$.unapply((EndpointIO.Empty)((Object)body2));
                Codec codec14 = empty._1();
                EndpointIO.Info info = empty._2();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (body2 instanceof EndpointIO.Body) {
                EndpointIO.Body body3 = EndpointIO$Body$.MODULE$.unapply(body2);
                RawBodyType rawBodyType = body3._1();
                Codec codec15 = body3._2();
                EndpointIO.Info info = body3._3();
                RawBodyType bodyType = rawBodyType;
                Codec codec16 = codec15;
                PartialRequest<?> req2 = this.setBody(EndpointToSttpClientBase.value$1(params2), bodyType, codec16, req);
                return Tuple3$.MODULE$.apply((Object)uri, req2, streamBody);
            }
            if (body2 instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO$OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)((Object)body2));
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list2 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant2 = EndpointIO$OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant2._1();
                        Either either = oneOfBodyVariant2._2();
                        if (either instanceof Left) {
                            EndpointIO.Body body4;
                            input = body4 = (EndpointIO.Body)((Left)either).value();
                            continue;
                        }
                    }
                }
            }
            if (body2 instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO$OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)((Object)body2));
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list3 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.StreamBodyWrapper streamBodyWrapper2;
                        StreamBodyIO streamBodyIO2;
                        EndpointIO.StreamBodyWrapper streamBodyWrapper3;
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant3 = EndpointIO$OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant3._1();
                        Either either = oneOfBodyVariant3._2();
                        if (either instanceof Right && (streamBodyWrapper3 = (EndpointIO.StreamBodyWrapper)((Right)either).value()) instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO2 = (streamBodyWrapper2 = EndpointIO$StreamBodyWrapper$.MODULE$.unapply(streamBodyWrapper3))._1()) instanceof StreamBodyIO) {
                            StreamBodyIO streamBodyIO3 = StreamBodyIO$.MODULE$.unapply(streamBodyIO2);
                            package.Streams<?> streams = streamBodyIO3._1();
                            Codec codec17 = streamBodyIO3._2();
                            EndpointIO.Info info = streamBodyIO3._3();
                            Option<Charset> option = streamBodyIO3._4();
                            List<EndpointIO.Example<Object>> list4 = streamBodyIO3._5();
                            package.Streams<?> streams2 = streams;
                            PartialRequest req2 = (PartialRequest)req.body((InputStream)EndpointToSttpClientBase.value$1(params2));
                            return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
                        }
                    }
                }
            }
            if (body2 instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO$OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)((Object)body2));
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    throw new RuntimeException("One of body without variants");
                }
            }
            if (body2 instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO$StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)((Object)body2)))._1()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO4 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                package.Streams<?> streams = streamBodyIO4._1();
                Codec codec18 = streamBodyIO4._2();
                EndpointIO.Info info = streamBodyIO4._3();
                Option<Charset> option = streamBodyIO4._4();
                List<EndpointIO.Example<Object>> list = streamBodyIO4._5();
                package.Streams<?> streams3 = streams;
                Codec codec19 = codec18;
                return Tuple3$.MODULE$.apply((Object)uri, req, (Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(streams3, codec19.encode(EndpointToSttpClientBase.value$1(params2)))));
            }
            if (body2 instanceof EndpointIO.Header) {
                EndpointIO.Header header2 = EndpointIO$Header$.MODULE$.unapply((EndpointIO.Header)((Object)body2));
                String string = header2._1();
                Codec codec20 = header2._2();
                EndpointIO.Info info = header2._3();
                String name = string;
                Codec codec21 = codec20;
                PartialRequest req2 = (PartialRequest)((LinearSeqOps)codec21.encode(EndpointToSttpClientBase.value$1(params2))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return (PartialRequest)r.header(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (body2 instanceof EndpointIO.Headers) {
                EndpointIO.Headers headers2 = EndpointIO$Headers$.MODULE$.unapply((EndpointIO.Headers)((Object)body2));
                Codec codec22 = headers2._1();
                EndpointIO.Info info = headers2._2();
                Codec codec23 = codec22;
                List<Header> headers3 = codec23.encode(EndpointToSttpClientBase.value$1(params2));
                PartialRequest req2 = (PartialRequest)headers3.foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        Header h = (Header)tuple2._2();
                        DuplicateHeaderBehavior$Replace$ onDuplicate = HeaderNames$.MODULE$.ContentType().equalsIgnoreCase(h.name()) || HeaderNames$.MODULE$.ContentLength().equalsIgnoreCase(h.name()) ? DuplicateHeaderBehavior$Replace$.MODULE$ : DuplicateHeaderBehavior$Add$.MODULE$;
                        return (PartialRequest)r.header(h, onDuplicate);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (body2 instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = EndpointIO$FixedHeader$.MODULE$.unapply((EndpointIO.FixedHeader)((Object)body2));
                Header header3 = fixedHeader._1();
                Codec codec24 = fixedHeader._2();
                EndpointIO.Info info = fixedHeader._3();
                Header h = header3;
                PartialRequest req2 = (PartialRequest)req.header(h, req.header$default$2());
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (body2 instanceof EndpointInput.ExtractFromRequest) {
                EndpointInput.ExtractFromRequest extractFromRequest = EndpointInput$ExtractFromRequest$.MODULE$.unapply((EndpointInput.ExtractFromRequest)((Object)body2));
                Codec codec25 = extractFromRequest._1();
                EndpointIO.Info info = extractFromRequest._2();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (!(body2 instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth a = (EndpointInput.Auth)((Object)body2);
            input = a.input();
        }
        if (body2 instanceof EndpointInput.Pair) {
            EndpointInput.Pair pair = EndpointInput$Pair$.MODULE$.unapply((EndpointInput.Pair)((Object)body2));
            EndpointInput endpointInput2 = pair._1();
            EndpointInput endpointInput3 = pair._2();
            Function2<package.Params, package.Params, package.Params> function2 = pair._3();
            Function1<package.Params, Tuple2<package.Params, package.Params>> function1 = pair._4();
            EndpointInput left = endpointInput2;
            EndpointInput right = endpointInput3;
            Function1<package.Params, Tuple2<package.Params, package.Params>> split = function1;
            return this.handleInputPair(left, right, params2, split, uri, req, streamBody);
        }
        if (body2 instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = EndpointIO$Pair$.MODULE$.unapply((EndpointIO.Pair)((Object)body2));
            EndpointIO endpointIO = pair._1();
            EndpointIO endpointIO2 = pair._2();
            Function2<package.Params, package.Params, package.Params> function2 = pair._3();
            Function1<package.Params, Tuple2<package.Params, package.Params>> function1 = pair._4();
            EndpointIO left = endpointIO;
            EndpointIO right = endpointIO2;
            Function1<package.Params, Tuple2<package.Params, package.Params>> split = function1;
            return this.handleInputPair(left, right, params2, split, uri, req, streamBody);
        }
        if (body2 instanceof EndpointInput.MappedPair) {
            EndpointInput.MappedPair mappedPair = EndpointInput$MappedPair$.MODULE$.unapply((EndpointInput.MappedPair)((Object)body2));
            EndpointInput.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointInput.Pair wrapped = pair;
            Mapping codec26 = mapping;
            return this.handleMapped(wrapped, codec26, params2, uri, req, streamBody);
        }
        if (body2 instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = EndpointIO$MappedPair$.MODULE$.unapply((EndpointIO.MappedPair)((Object)body2));
            EndpointIO.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointIO.Pair wrapped = pair;
            Mapping codec27 = mapping;
            return this.handleMapped(wrapped, codec27, params2, uri, req, streamBody);
        }
        throw new MatchError(body2);
    }

    private Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> handleInputPair(EndpointInput<?> left, EndpointInput<?> right, package.Params params2, Function1<package.Params, Tuple2<package.Params, package.Params>> split, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple3 = this.setInputParams(left, leftParams2, uri, req, streamBody);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Uri uri2 = (Uri)tuple3._1();
        PartialRequest req2 = (PartialRequest)tuple3._2();
        Option streamBody2 = (Option)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)uri2, (Object)req2, (Object)streamBody2);
        Uri uri22 = (Uri)tuple32._1();
        PartialRequest req22 = (PartialRequest)tuple32._2();
        Option streamBody22 = (Option)tuple32._3();
        return this.setInputParams(right, rightParams2, uri22, req22, streamBody22);
    }

    private <II, T> Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> handleMapped(EndpointInput<?> tuple, Mapping<T, II> codec2, package.Params params2, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        return this.setInputParams(tuple, package$ParamsAsAny$.MODULE$.apply(codec2.encode(params2.asAny())), uri, req, streamBody);
    }

    private <L, H, CF extends CodecFormat> PartialRequest<?> setBody(H v, RawBodyType<L> bodyType, Codec<L, H, CF> codec2, PartialRequest<?> req) {
        PartialRequest partialRequest;
        boolean wasContentTypeAlreadySet = req.header(HeaderNames$.MODULE$.ContentType()).nonEmpty();
        L encoded = codec2.encode(v);
        RawBodyType<L> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType$StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            partialRequest = (PartialRequest)req.body((String)encoded, charset2.name());
        } else if (RawBodyType$ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((byte[])encoded);
        } else if (RawBodyType$ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((ByteBuffer)encoded);
        } else if (RawBodyType$InputStreamBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((InputStream)encoded);
        } else if (RawBodyType$FileBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body(((FileRange)encoded).file());
        } else if (RawBodyType$InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((InputStream)((InputStreamRange)encoded).inputStream().apply());
        } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            scala.collection.immutable.Seq parts = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)encoded).flatMap((Function1 & Serializable)p -> m.partType(p.name()).map((Function1 & Serializable)partType -> {
                Part<BasicBodyPart> sttpPart1 = this.partToSttpPart((Part)p, (RawBodyType)partType);
                Part sttpPart2 = (Part)p.headers().foldLeft(sttpPart1, (Function2 & Serializable)(part, header2) -> part.header((Header)header2, header2.is(HeaderNames$.MODULE$.ContentType())));
                return (Part)p.otherDispositionParams().foldLeft((Object)sttpPart2, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Part part = (Part)tuple2._1();
                        if (tuple22 != null) {
                            String k = (String)tuple22._1();
                            String v = (String)tuple22._2();
                            return part.dispositionParam(k, v);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }));
            partialRequest = (PartialRequest)req.multipartBody((scala.collection.immutable.Seq)parts.toList());
        } else {
            throw new MatchError(rawBodyType);
        }
        PartialRequest req2 = partialRequest;
        if (wasContentTypeAlreadySet) {
            return req2;
        }
        return (PartialRequest)req2.contentType(codec2.format().mediaType());
    }

    private <T> Part<BasicBodyPart> partToSttpPart(Part<T> p, RawBodyType<T> bodyType) {
        RawBodyType<T> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType$StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            return package$.MODULE$.multipart(p.name(), (String)p.body(), charset2.toString());
        }
        if (RawBodyType$ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (byte[])p.body());
        }
        if (RawBodyType$ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (ByteBuffer)p.body());
        }
        if (RawBodyType$InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (InputStream)p.body());
        }
        if (RawBodyType$FileBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipartFile(p.name(), ((FileRange)p.body()).file());
        }
        if (RawBodyType$InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (InputStream)((InputStreamRange)p.body()).inputStream().apply());
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody2 = RawBodyType$MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
            Map<String, RawBodyType<?>> map = multipartBody2._1();
            Option<RawBodyType<?>> option = multipartBody2._2();
            throw new IllegalArgumentException("Nested multipart bodies aren't supported");
        }
        throw new MatchError(rawBodyType);
    }

    private static Uri $anonfun$1() {
        return Uri$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$EmptyPath$.MODULE$, (scala.collection.immutable.Seq<Uri.QuerySegment>)scala.package$.MODULE$.Nil(), (Option<Uri.Segment>)None$.MODULE$);
    }

    private static String prepareRequestWithInput$$anonfun$1() {
        return Method$.MODULE$.GET();
    }

    private static ResponseAs outToResponseAs$$anonfun$2() {
        return package$.MODULE$.ignore();
    }

    private static Object value$1(package.Params params$1) {
        return params$1.asAny();
    }
}

