/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pack;

import java.util.function.Supplier;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.git.AbstractGitCommandFactory;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.pack.GitPackCommand;
import org.apache.sshd.server.command.CommandFactory;

public class GitPackCommandFactory
extends AbstractGitCommandFactory {
    public static final String GIT_FACTORY_NAME = "git-pack";
    public static final String GIT_COMMAND_PREFIX = "git-";

    public GitPackCommandFactory() {
        this((GitLocationResolver)null);
    }

    public GitPackCommandFactory(GitLocationResolver resolver) {
        super(GIT_FACTORY_NAME, GIT_COMMAND_PREFIX);
        this.withGitLocationResolver(resolver);
    }

    @Override
    public GitPackCommandFactory withDelegate(CommandFactory delegate) {
        return (GitPackCommandFactory)super.withDelegate(delegate);
    }

    @Override
    public GitPackCommandFactory withGitLocationResolver(GitLocationResolver rootDirResolver) {
        return (GitPackCommandFactory)super.withGitLocationResolver(rootDirResolver);
    }

    @Override
    public GitPackCommandFactory withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
        return (GitPackCommandFactory)super.withExecutorServiceProvider(provider);
    }

    @Override
    public GitPackCommand createGitCommand(String command) {
        return new GitPackCommand(this.getGitLocationResolver(), command, this.resolveExecutorService(command));
    }
}

