/*
 * Decompiled with CFR 0.152.
 */
package cats.data;

import cats.Align;
import cats.Applicative;
import cats.Show;
import cats.Show$;
import cats.TraverseFilter;
import cats.data.Chain$;
import cats.data.Chain$Append$;
import cats.data.Chain$Empty$;
import cats.data.Chain$Singleton$;
import cats.data.Chain$Wrap$;
import cats.data.ChainCompat;
import cats.data.NonEmptyChainImpl$;
import cats.data.NonEmptyChainOps$;
import cats.kernel.Eq;
import cats.kernel.Hash;
import cats.kernel.Monoid;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.kernel.Semigroup;
import cats.kernel.instances.StaticMethods$;
import cats.package$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public abstract class Chain<A>
implements ChainCompat<A> {
    public static <A> Chain<A> apply(Seq<A> seq) {
        return Chain$.MODULE$.apply(seq);
    }

    public static <A> Eq<Chain<A>> catsDataEqForChain(Eq<A> eq2) {
        return Chain$.MODULE$.catsDataEqForChain(eq2);
    }

    public static <A> Hash<Chain<A>> catsDataHashForChain(Hash<A> hash2) {
        return Chain$.MODULE$.catsDataHashForChain(hash2);
    }

    public static Align<Chain> catsDataInstancesForChain() {
        return Chain$.MODULE$.catsDataInstancesForChain();
    }

    public static <A> Monoid<Chain<A>> catsDataMonoidForChain() {
        return Chain$.MODULE$.catsDataMonoidForChain();
    }

    public static <A> Order<Chain<A>> catsDataOrderForChain(Order<A> order2) {
        return Chain$.MODULE$.catsDataOrderForChain(order2);
    }

    public static <A> PartialOrder<Chain<A>> catsDataPartialOrderForChain(PartialOrder<A> partialOrder2) {
        return Chain$.MODULE$.catsDataPartialOrderForChain(partialOrder2);
    }

    public static <A> Show<Chain<A>> catsDataShowForChain(Show<A> show) {
        return Chain$.MODULE$.catsDataShowForChain(show);
    }

    public static TraverseFilter<Chain> catsDataTraverseFilterForChain() {
        return Chain$.MODULE$.catsDataTraverseFilterForChain();
    }

    public static <A> Chain<A> empty() {
        return Chain$.MODULE$.empty();
    }

    public static <A> Chain<A> fromIterableOnce(IterableOnce<A> iterableOnce) {
        return Chain$.MODULE$.fromIterableOnce((IterableOnce)iterableOnce);
    }

    public static <A> Chain<A> fromOption(Option<A> option) {
        return Chain$.MODULE$.fromOption(option);
    }

    public static <A> Chain<A> fromSeq(Seq<A> seq) {
        return Chain$.MODULE$.fromSeq((Seq)seq);
    }

    public static Chain<Nothing$> nil() {
        return Chain$.MODULE$.nil();
    }

    public static <A> Chain<A> one(A a) {
        return Chain$.MODULE$.one(a);
    }

    public static int ordinal(Chain<?> chain) {
        return Chain$.MODULE$.ordinal(chain);
    }

    public static <G, A, B> Object traverseFilterViaChain(IndexedSeq<A> indexedSeq, Function1<A, Object> function1, Applicative<G> applicative) {
        return Chain$.MODULE$.traverseFilterViaChain(indexedSeq, function1, applicative);
    }

    public static <G, A, B> Object traverseViaChain(IndexedSeq<A> indexedSeq, Function1<A, Object> function1, Applicative<G> applicative) {
        return Chain$.MODULE$.traverseViaChain(indexedSeq, function1, applicative);
    }

    public static <A> Option<Seq<A>> unapplySeq(Chain<A> chain) {
        return Chain$.MODULE$.unapplySeq(chain);
    }

    public final Option<Tuple2<A, Chain<A>>> uncons() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            Chain<Nothing$> rights = null;
            Tuple2 result = null;
            while (result == null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    Chain<Nothing$> next = rights == null ? Chain$.MODULE$.nil() : rights;
                    result = Tuple2$.MODULE$.apply(a2, next);
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty<Nothing$> nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty<Nothing$> r = nonEmpty3;
                    rights = rights == null ? r : Chain$Append$.MODULE$.apply(r, rights);
                    c = l;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    Chain<Nothing$> chain2;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Chain<Nothing$> tail = Chain$.MODULE$.fromSeq((Seq)seq2.tail());
                    if (rights == null) {
                        chain2 = tail;
                    } else {
                        Chain<Nothing$> chain3 = tail;
                        if (chain3 instanceof NonEmpty) {
                            NonEmpty non2 = (NonEmpty)chain3;
                            chain2 = Chain$Append$.MODULE$.apply(non2, rights);
                        } else {
                            chain2 = rights;
                        }
                    }
                    Chain<Nothing$> next = chain2;
                    result = Tuple2$.MODULE$.apply(seq2.head(), next);
                    continue;
                }
                throw new MatchError((Object)nonEmpty);
            }
            return Some$.MODULE$.apply(result);
        }
        return None$.MODULE$;
    }

    public final Option<Tuple2<Chain<A>, A>> initLast() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            Chain<Nothing$> lefts = null;
            Tuple2 result = null;
            while (result == null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    Chain<Nothing$> pre = lefts == null ? Chain$.MODULE$.nil() : lefts;
                    result = Tuple2$.MODULE$.apply(pre, a2);
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty<Nothing$> nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty<Nothing$> l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    lefts = lefts == null ? l : Chain$Append$.MODULE$.apply(lefts, l);
                    c = r;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    Chain<Nothing$> chain2;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Chain<Nothing$> init = Chain$.MODULE$.fromSeq((Seq)seq2.init());
                    if (lefts == null) {
                        chain2 = init;
                    } else {
                        Chain<Nothing$> chain3 = init;
                        if (chain3 instanceof NonEmpty) {
                            NonEmpty non2 = (NonEmpty)chain3;
                            chain2 = Chain$Append$.MODULE$.apply(lefts, non2);
                        } else {
                            chain2 = lefts;
                        }
                    }
                    Chain<Nothing$> pre = chain2;
                    result = Tuple2$.MODULE$.apply(pre, seq2.last());
                    continue;
                }
                throw new MatchError((Object)nonEmpty);
            }
            return Some$.MODULE$.apply(result);
        }
        return None$.MODULE$;
    }

    public Option<A> headOption() {
        return this.uncons().map((Function1 & Serializable)_$1 -> _$1._1());
    }

    public final Option<A> lastOption() {
        return this.initLast().map((Function1 & Serializable)_$2 -> _$2._2());
    }

    public boolean isEmpty() {
        return !(this instanceof NonEmpty);
    }

    public final boolean nonEmpty() {
        return !this.isEmpty();
    }

    private boolean isEmptyOrSingleton() {
        return this.isEmpty() || this instanceof Singleton;
    }

    public final <A2> Chain<A2> concat(Chain<A2> c) {
        return Chain$.MODULE$.concat(this, c);
    }

    public final <A2> Chain<A2> $plus$plus(Chain<A2> c) {
        return this.concat(c);
    }

    public final <A2> Chain<A2> prepend(A2 a) {
        return Chain$.MODULE$.concat(Chain$.MODULE$.one(a), this);
    }

    public final <A2> Chain<A2> $plus$colon(A2 a) {
        return this.prepend(a);
    }

    public final <A2> Chain<A2> append(A2 a) {
        return Chain$.MODULE$.concat(this, Chain$.MODULE$.one(a));
    }

    public final <A2> Chain<A2> $colon$plus(A2 a) {
        return this.append(a);
    }

    public final <B> Chain<B> map(Function1<A, B> f) {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.map(f));
        }
        return Chain$.MODULE$.fromSeq((Seq)this.iterator().map(f).toVector());
    }

    public final <B> Chain<B> flatMap(Function1<A, Chain<B>> f) {
        Chain<Object> result = Chain$.MODULE$.empty();
        Iterator<A> iter = this.iterator();
        while (iter.hasNext()) {
            result = result.$plus$plus((Chain)f.apply(iter.next()));
        }
        return result;
    }

    public final <B> B foldLeft(B z, Function2<B, A, B> f) {
        Object result = z;
        Iterator<A> iter = this.iterator();
        while (iter.hasNext()) {
            result = f.apply(result, iter.next());
        }
        return result;
    }

    public final Chain<A> takeWhile(Function1<A, Object> p) {
        ObjectRef result = ObjectRef.create(Chain$.MODULE$.empty());
        this.foreachUntil((Function1 & Serializable)a -> {
            boolean pr = BoxesRunTime.unboxToBoolean((Object)p.apply(a));
            if (pr) {
                result$1.elem = ((Chain)result$1.elem).$colon$plus(a);
            }
            return !pr;
        });
        return (Chain)result.elem;
    }

    public final Chain<A> take(long count) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            if (count > 0L) {
                return Chain.go$1(Chain$Empty$.MODULE$, count, ne, Chain$Empty$.MODULE$);
            }
        }
        return Chain$Empty$.MODULE$;
    }

    public final Chain<A> takeRight(long count) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            if (count > 0L) {
                return Chain.go$2(Chain$Empty$.MODULE$, count, ne, Chain$Empty$.MODULE$);
            }
        }
        return Chain$Empty$.MODULE$;
    }

    public final Chain<A> dropWhile(Function1<A, Object> p) {
        return Chain.go$3(p, this);
    }

    public final Chain<A> drop(long count) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            if (count > 0L) {
                return Chain.go$4(count, ne, Chain$Empty$.MODULE$);
            }
        }
        return this;
    }

    public final Chain<A> dropRight(long count) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            if (count > 0L) {
                return Chain.go$5(Chain$Empty$.MODULE$, count, ne);
            }
        }
        return this;
    }

    public final <B> B foldRight(B z, Function2<A, B, B> f) {
        Object result = z;
        Iterator<A> iter = this.reverseIterator();
        while (iter.hasNext()) {
            result = f.apply(iter.next(), result);
        }
        return result;
    }

    public final <B> Chain<B> collect(PartialFunction<A, B> pf) {
        return this.foldLeft(Chain$.MODULE$.nil(), (Function2 & Serializable)(acc, a) -> {
            Object x = pf.applyOrElse(a, Chain$.cats$data$Chain$$$sentinel);
            if (x != Chain$.cats$data$Chain$$$sentinel) {
                return acc.$colon$plus(x);
            }
            return acc;
        });
    }

    public final <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.foreachUntil((Function1 & Serializable)a -> {
            Object x = pf.applyOrElse(a, Chain$.cats$data$Chain$$$sentinel);
            if (x != Chain$.cats$data$Chain$$$sentinel) {
                result$2.elem = Some$.MODULE$.apply(x);
                return true;
            }
            return false;
        });
        return (Option)result.elem;
    }

    public final <B> Option<B> collectFirstSome(Function1<A, Option<B>> f) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.foreachUntil((Function1 & Serializable)a -> {
            Option x = (Option)f.apply(a);
            if (x.isDefined()) {
                result$3.elem = x;
                return true;
            }
            return false;
        });
        return (Option)result.elem;
    }

    public final Chain<A> filter(Function1<A, Object> f) {
        return this.collect((PartialFunction)new Serializable(f){
            private final Function1 f$2;
            {
                this.f$2 = f$28;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                Object a = object;
                return BoxesRunTime.unboxToBoolean((Object)this.f$2.apply(a));
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                Object a = object;
                if (BoxesRunTime.unboxToBoolean((Object)this.f$2.apply(a))) {
                    return a;
                }
                return function1.apply(x);
            }
        });
    }

    public final Chain<A> filterNot(Function1<A, Object> f) {
        return this.filter((Function1 & Serializable)a -> !BoxesRunTime.unboxToBoolean((Object)f.apply(a)));
    }

    public final Option<A> find(Function1<A, Object> f) {
        ObjectRef result = ObjectRef.create((Object)Option$.MODULE$.empty());
        this.foreachUntil((Function1 & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean((Object)f.apply(a));
            if (b) {
                result$4.elem = Option$.MODULE$.apply(a);
            }
            return b;
        });
        return (Option)result.elem;
    }

    public final boolean exists(Function1<A, Object> f) {
        BooleanRef result = BooleanRef.create((boolean)false);
        this.foreachUntil((Function1 & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean((Object)f.apply(a));
            if (b) {
                result$5.elem = true;
            }
            return b;
        });
        return result.elem;
    }

    public final boolean forall(Function1<A, Object> f) {
        BooleanRef result = BooleanRef.create((boolean)true);
        this.foreachUntil((Function1 & Serializable)a -> {
            boolean b = BoxesRunTime.unboxToBoolean((Object)f.apply(a));
            if (!b) {
                result$6.elem = false;
            }
            return !b;
        });
        return result.elem;
    }

    public final <AA> boolean contains(AA a, Eq<AA> A) {
        return this.exists((Function1 & Serializable)_$3 -> A.eqv(a, _$3));
    }

    public final <B, C> Chain<C> zipWith(Chain<B> other, Function2<A, B, C> f) {
        if (this.isEmpty() || other.isEmpty()) {
            return Chain$Empty$.MODULE$;
        }
        Iterator<A> iterA = this.iterator();
        Iterator<B> iterB = other.iterator();
        Chain<Object> result = Chain$.MODULE$.one(f.apply(iterA.next(), iterB.next()));
        while (iterA.hasNext() && iterB.hasNext()) {
            result = result.$colon$plus(f.apply(iterA.next(), iterB.next()));
        }
        return result;
    }

    public final Chain<Tuple2<A, Object>> zipWithIndex() {
        Chain chain;
        Chain chain2 = this;
        if (chain2 instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain2);
            Object a2 = a = singleton._1();
            chain = Chain$Singleton$.MODULE$.apply(Tuple2$.MODULE$.apply(a2, (Object)BoxesRunTime.boxToInteger((int)0)));
        } else if (chain2 instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain2);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            Append a = (Append)chain2;
            chain = Chain$Wrap$.MODULE$.apply(a.iterator().zipWithIndex().toVector());
        } else if (chain2 instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain2);
            Seq seq2 = seq = wrap._1();
            chain = Chain$Wrap$.MODULE$.apply((Seq)seq2.zipWithIndex());
        } else {
            chain = Chain$Empty$.MODULE$;
        }
        return chain;
    }

    public final <B> SortedMap<B, Object> groupBy(Function1<A, B> f, Order<B> B) {
        return this.groupMap(f, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), B);
    }

    public final <K, B> SortedMap<K, Object> groupMap(Function1<A, K> key, Function1<A, B> f, Order<K> K) {
        Ordering<K> ordering = K.toOrdering();
        ObjectRef m = ObjectRef.create((Object)((SortedMap)SortedMap$.MODULE$.empty(ordering)));
        this.iterator().foreach((Function1)(JProcedure1 & Serializable)elem -> {
            Object k = key.apply(elem);
            Option option = ((SortedMap)m$1.elem).get(k);
            if (option instanceof Some) {
                Object cat = ((Some)option).value();
                Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(cat);
                m$1.elem = (SortedMap)((SortedMap)m$1.elem).updated(k, NonEmptyChainOps$.MODULE$.$colon$plus$extension(object, f.apply(elem)));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                Object object = Predef$.MODULE$.ArrowAssoc(k);
                m$1.elem = (SortedMap)((SortedMap)m$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, cats.data.package$.MODULE$.NonEmptyChain().one(f.apply(elem))));
                return;
            }
            throw new MatchError((Object)option);
        });
        return (SortedMap)m.elem;
    }

    public final <K, B> SortedMap<K, B> groupMapReduce(Function1<A, K> key, Function1<A, B> f, Order<K> K, Semigroup<B> S) {
        return this.groupMapReduceWith(key, f, (Function2 & Serializable)(x, y) -> S.combine(x, y), K);
    }

    public final <K, B> SortedMap<K, B> groupMapReduceWith(Function1<A, K> key, Function1<A, B> f, Function2<B, B, B> combine, Order<K> K) {
        Ordering<K> ordering = K.toOrdering();
        ObjectRef m = ObjectRef.create((Object)((SortedMap)SortedMap$.MODULE$.empty(ordering)));
        this.iterator().foreach((Function1)(JProcedure1 & Serializable)elem -> {
            Object k = key.apply(elem);
            Option option = ((SortedMap)m$2.elem).get(k);
            if (option instanceof Some) {
                Object b = ((Some)option).value();
                m$2.elem = (SortedMap)((SortedMap)m$2.elem).updated(k, combine.apply(b, f.apply(elem)));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                Object object = Predef$.MODULE$.ArrowAssoc(k);
                m$2.elem = (SortedMap)((SortedMap)m$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, f.apply(elem)));
                return;
            }
            throw new MatchError((Object)option);
        });
        return (SortedMap)m.elem;
    }

    public Chain<A> reverse() {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            NonEmpty l = nonEmpty;
            NonEmpty r = nonEmpty2;
            return Chain.loop$1(l, scala.package$.MODULE$.Nil().$colon$colon(r), Chain$Empty$.MODULE$);
        }
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.reverse());
        }
        return this;
    }

    public final Option<Tuple2<A, Chain<A>>> deleteFirst(Function1<A, Object> f) {
        return Chain.go$6(f, this, Chain$.MODULE$.nil());
    }

    private final void foreachUntil(Function1<A, Object> f) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty non;
            NonEmpty c = non = (NonEmpty)chain;
            Nil$ rights = scala.package$.MODULE$.Nil();
            while (c != null) {
                NonEmpty nonEmpty = c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    Object a2 = a;
                    boolean b = BoxesRunTime.unboxToBoolean((Object)f.apply(a2));
                    if (b) {
                        return;
                    }
                    if (rights.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)rights.head();
                        rights = (List)rights.tail();
                        nonEmpty2 = head;
                    }
                    c = nonEmpty2;
                    continue;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty3 = append._1();
                    NonEmpty nonEmpty4 = append._2();
                    NonEmpty l = nonEmpty3;
                    NonEmpty r = nonEmpty4;
                    rights = rights.$colon$colon(r);
                    c = l;
                    continue;
                }
                if (nonEmpty instanceof Wrap) {
                    NonEmpty nonEmpty5;
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Iterator iterator = seq2.iterator();
                    while (iterator.hasNext()) {
                        boolean b = BoxesRunTime.unboxToBoolean((Object)f.apply(iterator.next()));
                        if (!b) continue;
                        return;
                    }
                    if (rights.isEmpty()) {
                        nonEmpty5 = null;
                    } else {
                        NonEmpty head = (NonEmpty)rights.head();
                        rights = (List)rights.tail();
                        nonEmpty5 = head;
                    }
                    c = nonEmpty5;
                    continue;
                }
                throw new MatchError((Object)nonEmpty);
            }
            return;
        }
    }

    public final Iterator<A> iterator() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.iterator();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Iterator().single(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app);
        }
        return scala.package$.MODULE$.Iterator().empty();
    }

    public final Iterator<A> reverseIterator() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.reverseIterator();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Iterator().single(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainReverseIterator(app);
        }
        return scala.package$.MODULE$.Iterator().empty();
    }

    public final long length() {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            return Chain.loop$2(ne, (List)scala.package$.MODULE$.Nil(), 0L);
        }
        return 0L;
    }

    public final long size() {
        return this.length();
    }

    public final int lengthCompare(long len) {
        Chain chain = this;
        if (chain instanceof NonEmpty) {
            NonEmpty ne = (NonEmpty)chain;
            return Chain.loop$3(ne, (List)scala.package$.MODULE$.Nil(), len);
        }
        return Long.compare(0L, len);
    }

    public final int sizeCompare(long size) {
        return this.lengthCompare(size);
    }

    public final List<A> toList() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.toList();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return scala.package$.MODULE$.Nil().$colon$colon(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app).toList();
        }
        return scala.package$.MODULE$.Nil();
    }

    public final Vector<A> toVector() {
        Chain chain = this;
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return seq2.toVector();
        }
        if (chain instanceof Singleton) {
            Object a;
            Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)chain);
            Object a2 = a = singleton._1();
            return (Vector)scala.package$.MODULE$.Vector().empty().$colon$plus(a2);
        }
        if (chain instanceof Append) {
            Append app = (Append)chain;
            return new ChainIterator(app).toVector();
        }
        return scala.package$.MODULE$.Vector().empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <AA> boolean $eq$eq$eq(Chain<AA> that, Eq<AA> A) {
        if (this == that) return true;
        Iterator<A> iterX = this.iterator();
        Iterator<AA> iterY = that.iterator();
        while (iterX.hasNext() && iterY.hasNext()) {
            if (A.eqv(iterX.next(), iterY.next())) continue;
            return false;
        }
        if (iterX.hasNext() != iterY.hasNext()) return false;
        return true;
    }

    public <AA> Chain<AA> distinct(Order<AA> O) {
        if (this.isEmptyOrSingleton()) {
            return this;
        }
        Ordering<AA> ord = O.toOrdering();
        ReusableBuilder bldr = scala.package$.MODULE$.Vector().newBuilder();
        TreeSet seen = TreeSet$.MODULE$.empty(ord);
        Iterator<A> it = this.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!seen.add(next)) continue;
            bldr.$plus$eq(next);
        }
        return Chain$.MODULE$.fromSeq((Seq)bldr.result());
    }

    public <B> Chain<A> distinctBy(Function1<A, B> f, Order<B> O) {
        if (this.isEmptyOrSingleton()) {
            return this;
        }
        Ordering<B> ord = O.toOrdering();
        ReusableBuilder bldr = scala.package$.MODULE$.Vector().newBuilder();
        TreeSet seen = TreeSet$.MODULE$.empty(ord);
        Iterator<A> it = this.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!seen.add(f.apply(next))) continue;
            bldr.$plus$eq(next);
        }
        return Chain$.MODULE$.fromSeq((Seq)bldr.result());
    }

    public <AA> String show(Show<AA> AA) {
        StringBuilder builder = new StringBuilder("Chain(");
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreachUntil((Function1 & Serializable)a -> {
            BoxedUnit boxedUnit;
            if (first$1.elem) {
                builder.$plus$plus$eq(AA.show(a));
                first$1.elem = false;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = builder.$plus$plus$eq(new java.lang.StringBuilder(2).append(", ").append(AA.show(a)).toString());
            }
            return false;
        });
        builder.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)')'));
        return builder.result();
    }

    public <AA> int hash(Hash<AA> hashA) {
        return StaticMethods$.MODULE$.orderedHash(this.iterator(), hashA);
    }

    public String toString() {
        return this.show(Show$.MODULE$.fromToString());
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Chain) {
            Chain thatChain = (Chain)object;
            return this.$eq$eq$eq(thatChain, package$.MODULE$.Eq().fromUniversalEquals());
        }
        return false;
    }

    public int hashCode() {
        return this.hash(package$.MODULE$.Hash().fromUniversalHashCode());
    }

    public final Option<A> get(long idx) {
        if (idx < 0L) {
            return None$.MODULE$;
        }
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        LongRef i = LongRef.create((long)0L);
        this.foreachUntil((Function1 & Serializable)a -> {
            if (idx == i$1.elem) {
                result$7.elem = Some$.MODULE$.apply(a);
                return true;
            }
            ++i$1.elem;
            return false;
        });
        return (Option)result.elem;
    }

    public final <B> Chain<A> sortBy(Function1<A, B> f, Order<B> B) {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            return Chain$Wrap$.MODULE$.apply((Seq)this.toVector().sortBy(f, B.toOrdering()));
        }
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.sortBy(f, B.toOrdering()));
        }
        return this;
    }

    public final <AA> Chain<AA> sorted(Order<AA> AA) {
        Chain chain = this;
        if (chain instanceof Append) {
            Append append = Chain$Append$.MODULE$.unapply((Append)chain);
            NonEmpty nonEmpty = append._1();
            NonEmpty nonEmpty2 = append._2();
            return Chain$Wrap$.MODULE$.apply((Seq)this.toVector().sorted(AA.toOrdering()));
        }
        if (chain instanceof Wrap) {
            Seq seq;
            Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)chain);
            Seq seq2 = seq = wrap._1();
            return Chain$Wrap$.MODULE$.apply((Seq)seq2.sorted(AA.toOrdering()));
        }
        return this;
    }

    private static final Chain go$1(Chain lhs, long count, NonEmpty arg, Chain rhs) {
        NonEmpty nonEmpty;
        block6: {
            NonEmpty newLhs;
            while (true) {
                if ((nonEmpty = arg) instanceof Wrap) {
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    if (count == 1L) {
                        return lhs.append(seq2.head());
                    }
                    Seq taken = count < Integer.MAX_VALUE ? (Seq)seq2.take((int)count) : (Seq)seq2.take(Integer.MAX_VALUE);
                    long newCount = count - (long)taken.length();
                    Wrap wrapped = Chain$Wrap$.MODULE$.apply(taken);
                    NonEmpty newLhs2 = lhs.isEmpty() ? wrapped : Chain$Append$.MODULE$.apply(lhs, wrapped);
                    NonEmpty nonEmpty2 = rhs;
                    if (nonEmpty2 instanceof NonEmpty) {
                        NonEmpty rhsNE = nonEmpty2;
                        if (newCount > 0L) {
                            NonEmpty nonEmpty3 = newLhs2;
                            long l = newCount;
                            NonEmpty nonEmpty4 = rhsNE;
                            Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                            lhs = nonEmpty3;
                            count = l;
                            arg = nonEmpty4;
                            rhs = chain$Empty$;
                            continue;
                        }
                    }
                    return newLhs2;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty5 = append._1();
                    NonEmpty nonEmpty6 = append._2();
                    NonEmpty l = nonEmpty5;
                    NonEmpty r = nonEmpty6;
                    NonEmpty nonEmpty7 = l;
                    NonEmpty nonEmpty8 = rhs.isEmpty() ? r : Chain$Append$.MODULE$.apply(r, rhs);
                    arg = nonEmpty7;
                    rhs = nonEmpty8;
                    continue;
                }
                if (!(nonEmpty instanceof Singleton)) break block6;
                Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                Object a = singleton._1();
                Singleton s = (Singleton)nonEmpty;
                newLhs = lhs.isEmpty() ? s : Chain$Append$.MODULE$.apply(lhs, s);
                NonEmpty nonEmpty9 = rhs;
                if (!(nonEmpty9 instanceof NonEmpty)) break;
                NonEmpty rhsNE = nonEmpty9;
                if (count <= 1L) break;
                NonEmpty nonEmpty10 = newLhs;
                long l = count - 1L;
                NonEmpty nonEmpty11 = rhsNE;
                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                lhs = nonEmpty10;
                count = l;
                arg = nonEmpty11;
                rhs = chain$Empty$;
            }
            return newLhs;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final Chain go$2(Chain lhs, long count, NonEmpty arg, Chain rhs) {
        NonEmpty nonEmpty;
        block6: {
            NonEmpty newRhs;
            while (true) {
                if ((nonEmpty = arg) instanceof Wrap) {
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    if (count == 1L) {
                        Object object = seq2.last();
                        return rhs.$plus$colon(object);
                    }
                    Seq taken = count < Integer.MAX_VALUE ? (Seq)seq2.takeRight((int)count) : (Seq)seq2.takeRight(Integer.MAX_VALUE);
                    long newCount = count - (long)taken.length();
                    Wrap wrapped = Chain$Wrap$.MODULE$.apply(taken);
                    NonEmpty newRhs2 = rhs.isEmpty() ? wrapped : Chain$Append$.MODULE$.apply(wrapped, rhs);
                    NonEmpty nonEmpty2 = lhs;
                    if (nonEmpty2 instanceof NonEmpty) {
                        NonEmpty lhsNE = nonEmpty2;
                        if (newCount > 0L) {
                            Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                            long l = newCount;
                            NonEmpty nonEmpty3 = lhsNE;
                            NonEmpty nonEmpty4 = newRhs2;
                            lhs = chain$Empty$;
                            count = l;
                            arg = nonEmpty3;
                            rhs = nonEmpty4;
                            continue;
                        }
                    }
                    return newRhs2;
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty5 = append._1();
                    NonEmpty nonEmpty6 = append._2();
                    NonEmpty l = nonEmpty5;
                    NonEmpty r = nonEmpty6;
                    NonEmpty nonEmpty7 = lhs.isEmpty() ? l : Chain$Append$.MODULE$.apply(lhs, l);
                    NonEmpty nonEmpty8 = r;
                    lhs = nonEmpty7;
                    arg = nonEmpty8;
                    continue;
                }
                if (!(nonEmpty instanceof Singleton)) break block6;
                Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                Object a = singleton._1();
                Singleton s = (Singleton)nonEmpty;
                newRhs = rhs.isEmpty() ? s : Chain$Append$.MODULE$.apply(s, rhs);
                NonEmpty nonEmpty9 = lhs;
                if (!(nonEmpty9 instanceof NonEmpty)) break;
                NonEmpty lhsNE = nonEmpty9;
                if (count <= 1L) break;
                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                long l = count - 1L;
                NonEmpty nonEmpty10 = lhsNE;
                NonEmpty nonEmpty11 = newRhs;
                lhs = chain$Empty$;
                count = l;
                arg = nonEmpty10;
                rhs = nonEmpty11;
            }
            return newRhs;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final Chain go$3(Function1 p$2, Chain rem) {
        Tuple2 tuple2;
        Option option;
        while ((option = rem.uncons()) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object a = tuple2._1();
            Chain tail = (Chain)tuple2._2();
            if (BoxesRunTime.unboxToBoolean((Object)p$2.apply(a))) {
                rem = tail;
                continue;
            }
            return rem;
        }
        if (None$.MODULE$.equals(option)) {
            return Chain$.MODULE$.nil();
        }
        throw new MatchError(option);
    }

    private static final Chain go$4(long count, NonEmpty arg, Chain rhs) {
        NonEmpty nonEmpty;
        block7: {
            while (true) {
                if ((nonEmpty = arg) instanceof Wrap) {
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Seq dropped = count < Integer.MAX_VALUE ? (Seq)seq2.drop((int)count) : (Seq)seq2.drop(Integer.MAX_VALUE);
                    int lc = dropped.lengthCompare(1);
                    if (lc < 0) {
                        long newCount = count - (long)seq2.length();
                        NonEmpty nonEmpty2 = rhs;
                        if (nonEmpty2 instanceof NonEmpty) {
                            NonEmpty rhsNE = nonEmpty2;
                            if (newCount > 0L) {
                                long l = newCount;
                                NonEmpty nonEmpty3 = rhsNE;
                                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                                count = l;
                                arg = nonEmpty3;
                                rhs = chain$Empty$;
                                continue;
                            }
                        }
                        return rhs;
                    }
                    NonEmpty wrapped = lc > 0 ? Chain$Wrap$.MODULE$.apply(dropped) : Chain$Singleton$.MODULE$.apply(dropped.head());
                    if (rhs.isEmpty()) {
                        return wrapped;
                    }
                    return Chain$Append$.MODULE$.apply(wrapped, rhs);
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty4 = append._1();
                    NonEmpty nonEmpty5 = append._2();
                    NonEmpty l = nonEmpty4;
                    NonEmpty r = nonEmpty5;
                    NonEmpty nonEmpty6 = l;
                    NonEmpty nonEmpty7 = rhs.isEmpty() ? r : Chain$Append$.MODULE$.apply(r, rhs);
                    arg = nonEmpty6;
                    rhs = nonEmpty7;
                    continue;
                }
                if (!(nonEmpty instanceof Singleton)) break block7;
                Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                Object a = singleton._1();
                NonEmpty nonEmpty8 = rhs;
                if (!(nonEmpty8 instanceof NonEmpty)) break;
                NonEmpty rhsNE = nonEmpty8;
                if (count <= 1L) break;
                long l = count - 1L;
                NonEmpty nonEmpty9 = rhsNE;
                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                count = l;
                arg = nonEmpty9;
                rhs = chain$Empty$;
            }
            return rhs;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final Chain go$5(Chain lhs, long count, NonEmpty arg) {
        NonEmpty nonEmpty;
        block7: {
            while (true) {
                if ((nonEmpty = arg) instanceof Wrap) {
                    Seq seq;
                    Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                    Seq seq2 = seq = wrap._1();
                    Seq dropped = count < Integer.MAX_VALUE ? (Seq)seq2.dropRight((int)count) : (Seq)seq2.dropRight(Integer.MAX_VALUE);
                    int lc = dropped.lengthCompare(1);
                    if (lc < 0) {
                        long newCount = count - (long)seq2.length();
                        NonEmpty nonEmpty2 = lhs;
                        if (nonEmpty2 instanceof NonEmpty) {
                            NonEmpty lhsNE = nonEmpty2;
                            if (newCount > 0L) {
                                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                                long l = newCount;
                                NonEmpty nonEmpty3 = lhsNE;
                                lhs = chain$Empty$;
                                count = l;
                                arg = nonEmpty3;
                                continue;
                            }
                        }
                        return lhs;
                    }
                    NonEmpty wrapped = lc > 0 ? Chain$Wrap$.MODULE$.apply(dropped) : Chain$Singleton$.MODULE$.apply(dropped.head());
                    if (lhs.isEmpty()) {
                        return wrapped;
                    }
                    return Chain$Append$.MODULE$.apply(lhs, wrapped);
                }
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty4 = append._1();
                    NonEmpty nonEmpty5 = append._2();
                    NonEmpty l = nonEmpty4;
                    NonEmpty r = nonEmpty5;
                    NonEmpty nonEmpty6 = lhs.isEmpty() ? l : Chain$Append$.MODULE$.apply(lhs, l);
                    NonEmpty nonEmpty7 = r;
                    lhs = nonEmpty6;
                    arg = nonEmpty7;
                    continue;
                }
                if (!(nonEmpty instanceof Singleton)) break block7;
                Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                Object a = singleton._1();
                NonEmpty nonEmpty8 = lhs;
                if (!(nonEmpty8 instanceof NonEmpty)) break;
                NonEmpty lhsNE = nonEmpty8;
                if (count <= 1L) break;
                Chain$Empty$ chain$Empty$ = Chain$Empty$.MODULE$;
                long l = count - 1L;
                NonEmpty nonEmpty9 = lhsNE;
                lhs = chain$Empty$;
                count = l;
                arg = nonEmpty9;
            }
            return lhs;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final Chain loop$1(NonEmpty h, List tail, Chain acc) {
        NonEmpty nonEmpty;
        block4: {
            Chain nextAcc;
            while (true) {
                Seq seq;
                if ((nonEmpty = h) instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    h = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    Singleton sing = (Singleton)nonEmpty;
                    Chain nextAcc2 = sing.concat(acc);
                    List list = tail;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        NonEmpty h1 = (NonEmpty)colon2.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        Chain chain = nextAcc2;
                        h = nonEmpty5;
                        tail = list3;
                        acc = chain;
                        continue;
                    }
                    return nextAcc2;
                }
                if (!(nonEmpty instanceof Wrap)) break block4;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                nextAcc = Chain$Wrap$.MODULE$.apply((Seq)seq2.reverse()).concat(acc);
                List list = tail;
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon3 = (.colon.colon)list;
                List list4 = colon3.next$access$1();
                NonEmpty h1 = (NonEmpty)colon3.head();
                List t1 = list4;
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                Chain chain = nextAcc;
                h = nonEmpty6;
                tail = list5;
                acc = chain;
            }
            return nextAcc;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final Option go$6(Function1 f$9, Chain rem, Chain acc) {
        Tuple2 tuple2;
        Option option;
        while ((option = rem.uncons()) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object a = tuple2._1();
            Chain tail = (Chain)tuple2._2();
            if (!BoxesRunTime.unboxToBoolean((Object)f$9.apply(a))) {
                Chain chain = tail;
                Chain<Object> chain2 = acc.$colon$plus(a);
                rem = chain;
                acc = chain2;
                continue;
            }
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(a, acc.$plus$plus(tail)));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private static final long loop$2(NonEmpty head, List tail, long acc) {
        NonEmpty nonEmpty;
        block4: {
            long nextAcc;
            while (true) {
                Seq seq;
                if ((nonEmpty = head) instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    head = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    long nextAcc2 = acc + 1L;
                    List list = tail;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        NonEmpty h1 = (NonEmpty)colon2.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        long l = nextAcc2;
                        head = nonEmpty5;
                        tail = list3;
                        acc = l;
                        continue;
                    }
                    return nextAcc2;
                }
                if (!(nonEmpty instanceof Wrap)) break block4;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                nextAcc = acc + (long)seq2.length();
                List list = tail;
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon3 = (.colon.colon)list;
                List list4 = colon3.next$access$1();
                NonEmpty h1 = (NonEmpty)colon3.head();
                List t1 = list4;
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                long l = nextAcc;
                head = nonEmpty6;
                tail = list5;
                acc = l;
            }
            return nextAcc;
        }
        throw new MatchError((Object)nonEmpty);
    }

    private static final int loop$3(NonEmpty head, List tail, long len) {
        NonEmpty nonEmpty;
        block6: {
            int c;
            while (true) {
                Seq seq;
                if (len <= 0L) {
                    return 1;
                }
                nonEmpty = head;
                if (nonEmpty instanceof Append) {
                    Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                    NonEmpty nonEmpty2 = append._1();
                    NonEmpty nonEmpty3 = append._2();
                    NonEmpty l = nonEmpty2;
                    NonEmpty r = nonEmpty3;
                    NonEmpty nonEmpty4 = l;
                    List list = tail.$colon$colon(r);
                    head = nonEmpty4;
                    tail = list;
                    continue;
                }
                if (nonEmpty instanceof Singleton) {
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a = singleton._1();
                    List list = tail;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        NonEmpty h1 = (NonEmpty)colon2.head();
                        List t1 = list2;
                        NonEmpty nonEmpty5 = h1;
                        List list3 = t1;
                        long l = len - 1L;
                        head = nonEmpty5;
                        tail = list3;
                        len = l;
                        continue;
                    }
                    return Long.compare(1L, len);
                }
                if (!(nonEmpty instanceof Wrap)) break block6;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                c = len <= Integer.MAX_VALUE ? seq2.lengthCompare((int)len) : -1;
                List list = tail;
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon3 = (.colon.colon)list;
                List list4 = colon3.next$access$1();
                NonEmpty h1 = (NonEmpty)colon3.head();
                List t1 = list4;
                if (c >= 0) {
                    return 1;
                }
                NonEmpty nonEmpty6 = h1;
                List list5 = t1;
                long l = len - (long)seq2.length();
                head = nonEmpty6;
                tail = list5;
                len = l;
            }
            return c;
        }
        throw new MatchError((Object)nonEmpty);
    }

    public static final class Append<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final NonEmpty leftNE;
        private final NonEmpty rightNE;

        public static <A> Append<A> apply(Chain<A> chain, Chain<A> chain2) {
            return Chain$Append$.MODULE$.apply(chain, chain2);
        }

        public static <A> Append<A> apply(NonEmpty<A> nonEmpty, NonEmpty<A> nonEmpty2) {
            return Chain$Append$.MODULE$.apply(nonEmpty, nonEmpty2);
        }

        public static Append<?> fromProduct(Product product) {
            return Chain$Append$.MODULE$.fromProduct(product);
        }

        public static <A> Append<A> unapply(Append<A> append) {
            return Chain$Append$.MODULE$.unapply(append);
        }

        public Append(NonEmpty<A> leftNE, NonEmpty<A> rightNE) {
            this.leftNE = leftNE;
            this.rightNE = rightNE;
        }

        public boolean canEqual(Object that) {
            return that instanceof Append;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Append";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "leftNE";
            }
            if (1 == n2) {
                return "rightNE";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmpty<A> leftNE() {
            return this.leftNE;
        }

        public NonEmpty<A> rightNE() {
            return this.rightNE;
        }

        public Append(Chain<A> left, Chain<A> right) {
            this((NonEmpty)left, (NonEmpty)right);
        }

        public Chain<A> left() {
            return this.leftNE();
        }

        public Chain<A> right() {
            return this.rightNE();
        }

        public Append<A> copy(Chain<A> left, Chain<A> right) {
            return new Append<A>(left, right);
        }

        public Chain<A> copy$default$1() {
            return this.left();
        }

        public Chain<A> copy$default$2() {
            return this.right();
        }

        public <A> Append<A> copy(NonEmpty<A> leftNE, NonEmpty<A> rightNE) {
            return new Append<A>(leftNE, rightNE);
        }

        public <A> NonEmpty<A> copy$default$1() {
            return this.leftNE();
        }

        public <A> NonEmpty<A> copy$default$2() {
            return this.rightNE();
        }

        public NonEmpty<A> _1() {
            return this.leftNE();
        }

        public NonEmpty<A> _2() {
            return this.rightNE();
        }
    }

    public static class ChainIterator<A>
    implements Iterator<A> {
        private NonEmpty<A> c;
        private List<NonEmpty<A>> rights;
        private Iterator<A> currentIterator;

        public ChainIterator(NonEmpty<A> self) {
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.c = self;
            this.rights = scala.package$.MODULE$.Nil();
            this.currentIterator = null;
        }

        public ChainIterator(Chain<A> chain) {
            NonEmpty non;
            Chain<A> chain2 = chain;
            this(chain2 instanceof NonEmpty ? (non = (NonEmpty)chain2) : null);
        }

        public boolean hasNext() {
            return this.c != null || this.currentIterator != null && this.currentIterator.hasNext();
        }

        public A next() {
            return (A)this.go$7();
        }

        private final Object go$7() {
            NonEmpty<A> nonEmpty;
            while (true) {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = null;
                nonEmpty = this.c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    if (this.rights.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)this.rights.head();
                        this.rights = (List)this.rights.tail();
                        nonEmpty2 = head;
                    }
                    this.c = nonEmpty2;
                    return a2;
                }
                if (!(nonEmpty instanceof Append)) break;
                Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                NonEmpty nonEmpty3 = append._1();
                NonEmpty nonEmpty4 = append._2();
                NonEmpty l = nonEmpty3;
                NonEmpty r = nonEmpty4;
                this.c = l;
                this.rights = this.rights.$colon$colon(r);
            }
            if (nonEmpty instanceof Wrap) {
                NonEmpty nonEmpty5;
                Seq seq;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                if (this.rights.isEmpty()) {
                    nonEmpty5 = null;
                } else {
                    NonEmpty head = (NonEmpty)this.rights.head();
                    this.rights = (List)this.rights.tail();
                    nonEmpty5 = head;
                }
                this.c = nonEmpty5;
                this.currentIterator = seq2.iterator();
                return this.currentIterator.next();
            }
            if (nonEmpty == null) {
                throw new NoSuchElementException("next called on empty iterator");
            }
            throw new MatchError(nonEmpty);
        }
    }

    public static class ChainReverseIterator<A>
    implements Iterator<A> {
        private NonEmpty<A> c;
        private List<NonEmpty<A>> lefts;
        private Iterator<A> currentIterator;

        public ChainReverseIterator(NonEmpty<A> self) {
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.c = self;
            this.lefts = scala.package$.MODULE$.Nil();
            this.currentIterator = null;
        }

        public ChainReverseIterator(Chain<A> chain) {
            NonEmpty non;
            Chain<A> chain2 = chain;
            this(chain2 instanceof NonEmpty ? (non = (NonEmpty)chain2) : null);
        }

        public boolean hasNext() {
            return this.c != null || this.currentIterator != null && this.currentIterator.hasNext();
        }

        public A next() {
            return (A)this.go$8();
        }

        private final Object go$8() {
            NonEmpty<A> nonEmpty;
            while (true) {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = null;
                nonEmpty = this.c;
                if (nonEmpty instanceof Singleton) {
                    NonEmpty nonEmpty2;
                    Object a;
                    Singleton singleton = Chain$Singleton$.MODULE$.unapply((Singleton)nonEmpty);
                    Object a2 = a = singleton._1();
                    if (this.lefts.isEmpty()) {
                        nonEmpty2 = null;
                    } else {
                        NonEmpty head = (NonEmpty)this.lefts.head();
                        this.lefts = (List)this.lefts.tail();
                        nonEmpty2 = head;
                    }
                    this.c = nonEmpty2;
                    return a2;
                }
                if (!(nonEmpty instanceof Append)) break;
                Append append = Chain$Append$.MODULE$.unapply((Append)nonEmpty);
                NonEmpty nonEmpty3 = append._1();
                NonEmpty nonEmpty4 = append._2();
                NonEmpty l = nonEmpty3;
                NonEmpty r = nonEmpty4;
                this.c = r;
                this.lefts = this.lefts.$colon$colon(l);
            }
            if (nonEmpty instanceof Wrap) {
                NonEmpty nonEmpty5;
                Seq seq;
                Wrap wrap = Chain$Wrap$.MODULE$.unapply((Wrap)nonEmpty);
                Seq seq2 = seq = wrap._1();
                if (this.lefts.isEmpty()) {
                    nonEmpty5 = null;
                } else {
                    NonEmpty head = (NonEmpty)this.lefts.head();
                    this.lefts = (List)this.lefts.tail();
                    nonEmpty5 = head;
                }
                this.c = nonEmpty5;
                this.currentIterator = seq2.reverseIterator();
                return this.currentIterator.next();
            }
            if (nonEmpty == null) {
                throw new NoSuchElementException("next called on empty iterator");
            }
            throw new MatchError(nonEmpty);
        }
    }

    public static abstract class NonEmpty<A>
    extends Chain<A> {
    }

    public static final class Singleton<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final Object a;

        public static <A> Singleton<A> apply(A a) {
            return Chain$Singleton$.MODULE$.apply(a);
        }

        public static Singleton<?> fromProduct(Product product) {
            return Chain$Singleton$.MODULE$.fromProduct(product);
        }

        public static <A> Singleton<A> unapply(Singleton<A> singleton) {
            return Chain$Singleton$.MODULE$.unapply(singleton);
        }

        public Singleton(A a) {
            this.a = a;
        }

        public boolean canEqual(Object that) {
            return that instanceof Singleton;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Singleton";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "a";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public A a() {
            return (A)this.a;
        }

        public <A> Singleton<A> copy(A a) {
            return new Singleton<A>(a);
        }

        public <A> A copy$default$1() {
            return this.a();
        }

        public A _1() {
            return this.a();
        }
    }

    public static final class Wrap<A>
    extends NonEmpty<A>
    implements Product,
    Serializable {
        private final Seq seq;

        public static <A> Wrap<A> apply(Seq<A> seq) {
            return Chain$Wrap$.MODULE$.apply(seq);
        }

        public static Wrap<?> fromProduct(Product product) {
            return Chain$Wrap$.MODULE$.fromProduct(product);
        }

        public static <A> Wrap<A> unapply(Wrap<A> wrap) {
            return Chain$Wrap$.MODULE$.unapply(wrap);
        }

        public Wrap(Seq<A> seq) {
            this.seq = seq;
        }

        public boolean canEqual(Object that) {
            return that instanceof Wrap;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Wrap";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "seq";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<A> seq() {
            return this.seq;
        }

        public <A> Wrap<A> copy(Seq<A> seq) {
            return new Wrap<A>(seq);
        }

        public <A> Seq<A> copy$default$1() {
            return this.seq();
        }

        public Seq<A> _1() {
            return this.seq();
        }
    }
}

