/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;

public final class JSArrayQueue<A> {
    private final Array<A> buffer = Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}));
    private int startIndex = 0;
    private int endIndex = 1;
    private boolean empty = true;

    public boolean isEmpty() {
        return this.empty;
    }

    public A take() {
        Object a = this.buffer.apply(this.startIndex);
        this.buffer.update(this.startIndex, null);
        ++this.startIndex;
        if (this.startIndex == this.endIndex) {
            this.empty = true;
        }
        if (this.startIndex >= this.buffer.length()) {
            this.startIndex = 0;
        }
        return (A)a;
    }

    public void offer(A a) {
        this.growIfNeeded();
        ++this.endIndex;
        if (this.endIndex > this.buffer.length()) {
            this.endIndex = 1;
        }
        this.buffer.update(this.endIndex - 1, a);
        this.empty = false;
    }

    private void growIfNeeded() {
        if (!this.empty) {
            if (this.startIndex == 0 && this.endIndex == this.buffer.length()) {
                this.buffer.push((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}));
                return;
            }
            if (this.startIndex == this.endIndex) {
                for (int i = 0; i < this.endIndex; ++i) {
                    this.buffer.push((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.buffer.apply(i)}));
                    this.buffer.update(i, null);
                }
                this.endIndex = this.buffer.length();
                return;
            }
            return;
        }
    }

    public void foreach(Function1<A, BoxedUnit> f) {
        int i;
        if (this.empty) {
            return;
        }
        if (this.startIndex < this.endIndex) {
            for (int i2 = this.startIndex; i2 < this.endIndex; ++i2) {
                f.apply(this.buffer.apply(i2));
            }
            return;
        }
        for (i = this.startIndex; i < this.buffer.length(); ++i) {
            f.apply(this.buffer.apply(i));
        }
        for (i = 0; i < this.endIndex; ++i) {
            f.apply(this.buffer.apply(i));
        }
    }
}

