/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class WeakBag<A> {
    private final int MaxSizePow2;
    private final ReferenceQueue<A> queue = new ReferenceQueue();
    private int capacity = 256;
    private Entry<A>[] table = new Entry[this.capacity];
    private int index = 0;
    private final AtomicBoolean synchronizationPoint = new AtomicBoolean(true);

    public WeakBag() {
        this.MaxSizePow2 = 0x40000000;
    }

    public AtomicBoolean synchronizationPoint() {
        return this.synchronizationPoint;
    }

    public Handle insert(A a) {
        while (true) {
            Entry oldEntry = (Entry)this.queue.poll();
            int cap = this.capacity;
            int idx = this.index++;
            if (oldEntry != null) {
                int oldIndex = oldEntry.index();
                Entry<A> entry = new Entry<A>(a, oldIndex, this.queue);
                this.table[oldIndex] = entry;
                return entry;
            }
            if (idx < cap) {
                Entry<A> entry = new Entry<A>(a, idx, this.queue);
                this.table[idx] = entry;
                return entry;
            }
            if (cap == Integer.MAX_VALUE) {
                return () -> {};
            }
            Entry<A>[] oldTable = this.table;
            int newCap = cap == this.MaxSizePow2 ? Integer.MAX_VALUE : cap << 1;
            Entry[] newTable = new Entry[newCap];
            System.arraycopy(oldTable, 0, newTable, 0, idx);
            this.table = newTable;
            this.capacity = newCap;
        }
    }

    public void forEach(Function1<A, BoxedUnit> f) {
        int sz = this.index;
        for (int i = 0; i < sz; ++i) {
            Object a = this.table[i].get();
            if (a == null) continue;
            f.apply(a);
        }
    }

    public int size() {
        int count = 0;
        int sz = this.index;
        for (int i = 0; i < sz; ++i) {
            Object a = this.table[i].get();
            if (a == null) continue;
            ++count;
        }
        return count;
    }

    public static final class Entry<A>
    extends WeakReference<A>
    implements Handle {
        private final int index;

        public Entry(A a, int index, ReferenceQueue<A> rq) {
            this.index = index;
            super(a, rq);
        }

        public int index() {
            return this.index;
        }

        @Override
        public void deregister() {
            boolean bl = this.enqueue();
        }
    }

    public static interface Handle {
        public void deregister();
    }
}

