/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber;
import cats.effect.Trace;
import cats.effect.tracing.Tracing;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ParkedSignal;
import cats.effect.unsafe.ParkedSignal$Interrupting$;
import cats.effect.unsafe.ParkedSignal$ParkedPolling$;
import cats.effect.unsafe.ParkedSignal$ParkedSimple$;
import cats.effect.unsafe.ParkedSignal$Unparked$;
import cats.effect.unsafe.PollResult;
import cats.effect.unsafe.PollResult$Complete$;
import cats.effect.unsafe.PollResult$Interrupted$;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.TimerHeap;
import cats.effect.unsafe.UnsafeNonFatal;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread$;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.BlockContext;
import scala.concurrent.CanAwait;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Right;

public final class WorkerThread<P>
extends Thread
implements BlockContext {
    private int tick;
    private LocalQueue queue;
    private AtomicReference parked;
    private final ScalQueue<Object> external;
    private WeakBag<Runnable> fiberBag;
    private TimerHeap sleepers;
    private final PollingSystem system;
    private P _poller;
    private Metrics metrics;
    private TransferState transferState;
    private final WorkStealingThreadPool<P> pool;
    private int _index;
    private ThreadLocalRandom random;
    private Runnable cedeBypass;
    private boolean blocking;
    private long now;
    private Runnable _active;
    private final Duration runtimeBlockingExpiration;
    private IOFiber currentIOFiber;
    private final Right<Nothing$, BoxedUnit> RightUnit;
    private final Runnable noop;
    private final int nameIndex;

    public static TransferState transferStateSentinel() {
        return WorkerThread$.MODULE$.transferStateSentinel();
    }

    public WorkerThread(int idx, int tick, LocalQueue queue, AtomicReference<ParkedSignal> parked, ScalQueue<Object> external, WeakBag<Runnable> fiberBag, TimerHeap sleepers, PollingSystem system, P _poller, Metrics metrics, TransferState transferState, WorkStealingThreadPool<P> pool) {
        this.tick = tick;
        this.queue = queue;
        this.parked = parked;
        this.external = external;
        this.fiberBag = fiberBag;
        this.sleepers = sleepers;
        this.system = system;
        this._poller = _poller;
        this.metrics = metrics;
        this.transferState = transferState;
        this.pool = pool;
        this.setUncaughtExceptionHandler(pool.uncaughtExceptionHandler());
        this._index = idx;
        this.blocking = false;
        this.now = System.nanoTime();
        this.runtimeBlockingExpiration = pool.runtimeBlockingExpiration();
        this.RightUnit = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        this.noop = new Function0<BoxedUnit>(){

            public void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }

            public void run() {
            }
        };
        this.nameIndex = pool.blockedWorkerThreadNamingIndex().getAndIncrement();
        this.setDaemon(true);
        String prefix = pool.threadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(idx).toString());
    }

    public AtomicReference<ParkedSignal> parked() {
        return this.parked;
    }

    public void parked_$eq(AtomicReference<ParkedSignal> x$1) {
        this.parked = x$1;
    }

    public long now() {
        return this.now;
    }

    public void now_$eq(long x$1) {
        this.now = x$1;
    }

    public IOFiber<?> currentIOFiber() {
        return this.currentIOFiber;
    }

    public void currentIOFiber_$eq(IOFiber<?> x$1) {
        this.currentIOFiber = x$1;
    }

    public int nameIndex() {
        return this.nameIndex;
    }

    public P poller() {
        return this._poller;
    }

    public void schedule(Runnable fiber) {
        ThreadLocalRandom rnd = this.random;
        this.queue.enqueue(fiber, this.external, rnd);
        this.pool.notifyParked(rnd);
    }

    public void reschedule(Runnable fiber) {
        if (this.cedeBypass == null && this.queue.isEmpty()) {
            this.cedeBypass = fiber;
            return;
        }
        this.schedule(fiber);
    }

    private long nanoTime() {
        long _now = System.nanoTime();
        this.now_$eq(_now);
        return _now;
    }

    public Runnable sleep(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        return this.sleepImpl(this.nanoTime(), delay.toNanos(), callback);
    }

    public Runnable sleepLate(long scheduledAt, FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        long _now = this.nanoTime();
        long newDelay = delay.toNanos() - (_now - scheduledAt);
        if (newDelay > 0L) {
            return this.sleepImpl(_now, newDelay, callback);
        }
        callback.apply(this.RightUnit);
        return this.noop;
    }

    private Runnable sleepImpl(long now, long delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        Function1[] out = new Function1[1];
        Runnable cancel = this.sleepers.insert(now, delay, callback, out);
        Function1 cb = out[0];
        if (cb != null) {
            cb.apply(this.RightUnit);
        }
        return cancel;
    }

    public boolean isOwnedBy(WorkStealingThreadPool<?> threadPool) {
        return this.pool == threadPool && !this.blocking;
    }

    public boolean canExecuteBlockingCodeOn(WorkStealingThreadPool<?> threadPool) {
        return this.pool == threadPool;
    }

    public WeakBag.Handle monitor(Runnable fiber) {
        return this.fiberBag.insert(fiber);
    }

    public int index() {
        return this._index;
    }

    public Runnable active() {
        return this._active;
    }

    public void active_$eq(Runnable fiber) {
        this._active = fiber;
    }

    public Map<Runnable, Trace> suspendedTraces() {
        scala.collection.mutable.Map foreign = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.fiberBag.forEach((Function1<Runnable, BoxedUnit>)(JProcedure1 & Serializable)r -> foreign.$plus$plus$eq(Tracing.captureTrace(r)));
        return foreign.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean ownsPoller(P poller) {
        return poller == this._poller;
    }

    public boolean ownsTimers(TimerHeap timers) {
        return this.sleepers == timers;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        self = this;
        rnd = this.random = ThreadLocalRandom.current();
        done = this.pool.done();
        while (!done.get()) {
            block34: {
                block31: {
                    block32: {
                        block33: {
                            if (this.blocking) {
                                this.queue = null;
                                this.sleepers = null;
                                this.parked_$eq(null);
                                this.fiberBag = null;
                                this._active = null;
                                this._poller = null;
                                this.metrics = null;
                                this.transferState = null;
                                try {
                                    len = this.runtimeBlockingExpiration.length();
                                    unit = this.runtimeBlockingExpiration.unit();
                                    newState = this.pool.transferStateStack().poll(len, unit);
                                    if (newState == null || newState == WorkerThread$.MODULE$.transferStateSentinel()) {
                                        this.pool.blockedWorkerThreadCounter().decrementAndGet();
                                        return;
                                    }
                                    this.init(newState);
                                }
                                catch (InterruptedException v0) {
                                    return;
                                }
                            }
                            if ((this.tick & WorkStealingThreadPoolConstants.ExternalWorkTicksMask) != 0) break block31;
                            if ((this.tick & WorkStealingThreadPoolConstants.PollingTicksMask) != 0) break block32;
                            if (!this.pool.blockedThreadDetectionEnabled()) break block33;
                            idx = this.index();
                            threadCount = this.pool.getWorkerThreadCount();
                            otherIdx = (idx + this.random.nextInt(threadCount - 1) + 1) % threadCount;
                            thread = this.pool.getWorkerThread(otherIdx);
                            state = thread.getState();
                            parked = thread.parked();
                            if (parked == null) break block33;
                            pst = parked.get();
                            expectAlive = pst == ParkedSignal$Unparked$.MODULE$ || pst == ParkedSignal$Interrupting$.MODULE$;
                            v1 = state;
                            var17_16 = Thread.State.BLOCKED;
                            if (!(v1 == null ? var17_16 != null : v1.equals((Object)var17_16) == false)) ** GOTO lbl-1000
                            v2 = state;
                            var18_17 = Thread.State.WAITING;
                            if (!(v2 == null ? var18_17 != null : v2.equals((Object)var18_17) == false)) ** GOTO lbl-1000
                            v3 = state;
                            var19_18 = Thread.State.TIMED_WAITING;
                            if (!(v3 != null ? v3.equals((Object)var19_18) == false : var19_18 != null)) lbl-1000:
                            // 3 sources

                            {
                                v4 = true;
                            } else {
                                v4 = actuallyBlocked = false;
                            }
                            if (expectAlive && actuallyBlocked) {
                                System.err.println(this.mkWarning(state, thread.getStackTrace()));
                            }
                        }
                        this.sleepers.packIfNeeded();
                        this.metrics.incrementPolledCount();
                        if (this.system.needsPoll(this._poller)) {
                            var20_19 = this.drainReadyEvents$1(this.system.poll(this._poller, 0L), false);
                        }
                        this.now_$eq(System.nanoTime());
                        break block34;
                    }
                    element = this.external.poll(rnd);
                    if (element instanceof Runnable[]) {
                        batch = (Runnable[])element;
                        this.queue.drainBatch(this.external, rnd);
                        fiber = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        try {
                            fiber.run();
                        }
                        catch (Throwable var24_23) {
                            t = var25_24 = var24_23;
                            if (UnsafeNonFatal.apply(t)) {
                                this.pool.reportFailure(t);
                            }
                            if (var25_24 != null) {
                                t = var25_24;
                                throw IOFiber.onFatalFailure(t);
                            }
                            throw var24_23;
                        }
                    } else if (element instanceof Runnable) {
                        fiber = (Runnable)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber;
                            this.parked().lazySet(ParkedSignal$Unparked$.MODULE$);
                        }
                        try {
                            fiber.run();
                        }
                        catch (Throwable var29_27) {
                            t = var30_28 = var29_27;
                            if (UnsafeNonFatal.apply(t)) {
                                this.pool.reportFailure(t);
                            }
                            if (var30_28 != null) {
                                t = var30_28;
                                throw IOFiber.onFatalFailure(t);
                            }
                            throw var29_27;
                        }
                    }
                    break block34;
                }
                cont = true;
                while (cont) {
                    cb = this.sleepers.pollFirstIfTriggered(this.now());
                    if (cb != null) {
                        cb.apply(this.RightUnit);
                        continue;
                    }
                    cont = false;
                }
                if (this.cedeBypass == null) {
                    v5 = this.queue.dequeue(self);
                } else {
                    f = this.cedeBypass;
                    this.cedeBypass = null;
                    v5 = fiber = f;
                }
                if (fiber != null) {
                    try {
                        fiber.run();
                    }
                    catch (Throwable var37_34) {
                        t = var38_35 = var37_34;
                        if (UnsafeNonFatal.apply(t)) {
                            this.pool.reportFailure(t);
                        }
                        if (var38_35 != null) {
                            t = var38_35;
                            throw IOFiber.onFatalFailure(t);
                        }
                        throw var37_34;
                    }
                } else {
                    this.lookForWork$1(rnd, self, done);
                }
            }
            ++this.tick;
        }
    }

    private String mkWarning(Thread.State state2, StackTraceElement[] stackTrace) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(297).append("|[WARNING] A Cats Effect worker thread was detected to be in a blocked state (").append((Object)state2).append(")\n        |").append(WorkerThread.formatTrace$1(stackTrace)).append("\n        |This is very likely to be due to suspending a blocking call in IO via\n        |`IO.delay` or `IO.apply`. If this is the case then you should use\n        |`IO.blocking` or `IO.interruptible` instead.").toString()));
    }

    public void prepareForBlocking() {
        if (this.blocking) {
            return;
        }
        this.metrics.incrementBlockingCount();
        Runnable bypass = this.cedeBypass;
        if (bypass != null) {
            this.queue.enqueue(bypass, this.external, this.random);
            this.cedeBypass = null;
        }
        this.blocking = true;
        String prefix = this.pool.blockerThreadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(this.nameIndex()).toString());
        int idx = this.index();
        this.transferState.index_$eq(idx);
        this.transferState.tick_$eq(this.tick + 1);
        if (this.pool.transferStateStack().offer(this.transferState)) {
            return;
        }
        this.metrics.incrementRespawnCount();
        int idx2 = this.index();
        WorkerThread<P> clone = new WorkerThread<P>(idx2, this.tick + 1, this.queue, this.parked(), this.external, this.fiberBag, this.sleepers, this.system, this._poller, this.metrics, this.transferState, this.pool);
        String clonePrefix = this.pool.threadPrefix();
        clone.setName(new java.lang.StringBuilder(1).append(clonePrefix).append("-").append(idx2).toString());
        this.pool.replaceWorker(idx2, clone);
        this.pool.blockedWorkerThreadCounter().incrementAndGet();
        clone.start();
    }

    public <T> T blockOn(Function0<T> thunk, CanAwait permission) {
        this.prepareForBlocking();
        return (T)thunk.apply();
    }

    private void init(TransferState newState) {
        int newIdx;
        this._index = newIdx = newState.index();
        this.tick = newState.tick();
        this.queue = this.pool.localQueues()[newIdx];
        this.sleepers = this.pool.sleepers()[newIdx];
        this.parked_$eq(this.pool.parkedSignals()[newIdx]);
        this.fiberBag = this.pool.fiberBags()[newIdx];
        this._poller = this.pool.pollers()[newIdx];
        this.metrics = this.pool.metrices()[newIdx];
        this.transferState = newState;
        String prefix = this.pool.threadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(this._index).toString());
        this.blocking = false;
        this.pool.replaceWorker(newIdx, this);
    }

    private final void lookForWork$1(ThreadLocalRandom rnd$1, WorkerThread self$1, AtomicBoolean done$1) {
        boolean permissionToSteal;
        boolean bl;
        Object element = this.external.poll(rnd$1);
        if (element instanceof Runnable[]) {
            Runnable[] batch = (Runnable[])element;
            Runnable fiber = this.queue.enqueueBatch(batch, self$1);
            this.pool.notifyParked(rnd$1);
            try {
                fiber.run();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable t = throwable2 = throwable;
                if (UnsafeNonFatal.apply(t)) {
                    this.pool.reportFailure(t);
                }
                if (throwable2 != null) {
                    Throwable t2 = throwable2;
                    throw IOFiber.onFatalFailure(t2);
                }
                throw throwable;
            }
            return;
        }
        if (element instanceof Runnable) {
            Runnable fiber = (Runnable)element;
            if (TracingConstants.isStackTracing) {
                this._active = fiber;
                this.parked().lazySet(ParkedSignal$Unparked$.MODULE$);
            }
            try {
                fiber.run();
            }
            catch (Throwable throwable) {
                Throwable throwable3;
                Throwable t = throwable3 = throwable;
                if (UnsafeNonFatal.apply(t)) {
                    this.pool.reportFailure(t);
                }
                if (throwable3 != null) {
                    Throwable t3 = throwable3;
                    throw IOFiber.onFatalFailure(t3);
                }
                throw throwable;
            }
            return;
        }
        if (this.pool.transitionWorkerToSearching()) {
            bl = true;
        } else {
            if (TracingConstants.isStackTracing) {
                this._active = null;
            }
            boolean needsPoll = this.system.needsPoll(this._poller);
            this.flagForParking$1(needsPoll);
            this.pool.transitionWorkerToParked();
            if (this.park$1(rnd$1, done$1, needsPoll)) {
                return;
            }
            bl = permissionToSteal = false;
        }
        if (permissionToSteal) {
            this.now_$eq(System.nanoTime());
            boolean stoleTimers = this.pool.stealTimers(this.now(), rnd$1);
            Runnable fiber = this.pool.stealFromOtherWorkerThread(this.index(), rnd$1, self$1);
            if (stoleTimers || fiber != null) {
                this.pool.transitionWorkerFromSearching(rnd$1);
                if (fiber != null) {
                    try {
                        fiber.run();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable4;
                        Throwable t = throwable4 = throwable;
                        if (UnsafeNonFatal.apply(t)) {
                            this.pool.reportFailure(t);
                        }
                        if (throwable4 != null) {
                            Throwable t4 = throwable4;
                            throw IOFiber.onFatalFailure(t4);
                        }
                        throw throwable;
                    }
                }
                return;
            }
            if (TracingConstants.isStackTracing) {
                this._active = null;
            }
            boolean needsPoll = this.system.needsPoll(this._poller);
            this.flagForParking$1(needsPoll);
            if (this.pool.transitionWorkerToParkedWhenSearching()) {
                this.pool.notifyIfWorkPending(rnd$1);
            }
            if (this.park$1(rnd$1, done$1, needsPoll)) {
                return;
            }
        }
        while (!done$1.get()) {
            Object element2 = this.external.poll(rnd$1);
            if (element2 instanceof Runnable[]) {
                Runnable[] batch = (Runnable[])element2;
                this.pool.transitionWorkerFromSearching(rnd$1);
                Runnable fiber = this.queue.enqueueBatch(batch, self$1);
                this.pool.notifyParked(rnd$1);
                try {
                    fiber.run();
                }
                catch (Throwable throwable) {
                    Throwable throwable5;
                    Throwable t = throwable5 = throwable;
                    if (UnsafeNonFatal.apply(t)) {
                        this.pool.reportFailure(t);
                    }
                    if (throwable5 != null) {
                        Throwable t5 = throwable5;
                        throw IOFiber.onFatalFailure(t5);
                    }
                    throw throwable;
                }
                return;
            }
            if (element2 instanceof Runnable) {
                Runnable fiber = (Runnable)element2;
                if (TracingConstants.isStackTracing) {
                    this._active = fiber;
                    this.parked().lazySet(ParkedSignal$Unparked$.MODULE$);
                }
                this.pool.transitionWorkerFromSearching(rnd$1);
                try {
                    fiber.run();
                }
                catch (Throwable throwable) {
                    Throwable throwable6;
                    Throwable t = throwable6 = throwable;
                    if (UnsafeNonFatal.apply(t)) {
                        this.pool.reportFailure(t);
                    }
                    if (throwable6 != null) {
                        Throwable t6 = throwable6;
                        throw IOFiber.onFatalFailure(t6);
                    }
                    throw throwable;
                }
                return;
            }
            this.now_$eq(System.nanoTime());
            boolean stoleTimers = this.pool.stealTimers(this.now(), rnd$1);
            Runnable fiber = this.pool.stealFromOtherWorkerThread(this.index(), rnd$1, self$1);
            if (stoleTimers || fiber != null) {
                this.pool.transitionWorkerFromSearching(rnd$1);
                if (fiber != null) {
                    try {
                        fiber.run();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable7;
                        Throwable t = throwable7 = throwable;
                        if (UnsafeNonFatal.apply(t)) {
                            this.pool.reportFailure(t);
                        }
                        if (throwable7 != null) {
                            Throwable t7 = throwable7;
                            throw IOFiber.onFatalFailure(t7);
                        }
                        throw throwable;
                    }
                }
                return;
            }
            if (TracingConstants.isStackTracing) {
                this._active = null;
            }
            boolean needsPoll = this.system.needsPoll(this._poller);
            this.flagForParking$1(needsPoll);
            if (this.pool.transitionWorkerToParkedWhenSearching()) {
                this.pool.notifyIfWorkPending(rnd$1);
            }
            if (!this.park$1(rnd$1, done$1, needsPoll)) continue;
            return;
        }
    }

    private final void flagForParking$1(boolean needsPoll) {
        this.parked().lazySet(needsPoll ? ParkedSignal$ParkedPolling$.MODULE$ : ParkedSignal$ParkedSimple$.MODULE$);
    }

    private final boolean park$1(ThreadLocalRandom rnd$2, AtomicBoolean done$2, boolean needsPoll) {
        boolean workFound;
        boolean bl;
        this.metrics.incrementParkedCount();
        long tt = this.sleepers.peekFirstTriggerTime();
        if (tt == Long.MIN_VALUE) {
            if (this.parkLoop$1(done$2, needsPoll)) {
                this.pool.transitionWorkerFromSearching(rnd$2);
                bl = true;
            } else {
                bl = false;
            }
        } else if (this.parkLoopUntilNextSleeper$1(done$2, needsPoll)) {
            this.pool.transitionWorkerFromSearching(rnd$2);
            bl = true;
        } else {
            bl = workFound = false;
        }
        if (!workFound) {
            long nextTrigger = this.sleepers.peekFirstTriggerTime();
            if (nextTrigger != Long.MIN_VALUE && nextTrigger - this.now() <= 0L) {
                this.pool.transitionWorkerFromSearching(rnd$2);
                return true;
            }
            return false;
        }
        return true;
    }

    private final boolean drainReadyEvents$1(PollResult result, boolean acc) {
        while (result != PollResult$Interrupted$.MODULE$) {
            boolean tasksScheduled = this.system.processReadyEvents(this._poller) | acc;
            if (result == PollResult$Complete$.MODULE$) {
                return tasksScheduled;
            }
            PollResult pollResult = this.system.poll(this._poller, 0L);
            boolean bl = tasksScheduled;
            result = pollResult;
            acc = bl;
        }
        return acc;
    }

    private final void notifyDoneSleeping$1() {
        ParkedSignal st = this.parked().get();
        if (st != ParkedSignal$Unparked$.MODULE$) {
            if (st == ParkedSignal$Interrupting$.MODULE$) {
                while (this.parked().get() == ParkedSignal$Interrupting$.MODULE$) {
                }
                return;
            }
            if (this.parked().compareAndSet(st, ParkedSignal$Unparked$.MODULE$)) {
                this.pool.doneSleeping();
                return;
            }
            return;
        }
    }

    private final boolean parkLoop$1(AtomicBoolean done$3, boolean needsPoll) {
        ParkedSignal st;
        do {
            PollResult pollResult;
            if (done$3.get()) {
                return false;
            }
            long start = System.nanoTime();
            this.metrics.incrementPolledCount();
            if (needsPoll) {
                pollResult = this.system.poll(this._poller, -1L);
            } else {
                LockSupport.park();
                pollResult = PollResult$Interrupted$.MODULE$;
            }
            PollResult$Interrupted$ pollResult2 = pollResult;
            this.now_$eq(System.nanoTime());
            this.metrics.addIdleTime(this.now() - start);
            if (this.isInterrupted()) {
                this.pool.shutdown();
                return false;
            }
            if (pollResult2 != PollResult$Interrupted$.MODULE$) {
                this.notifyDoneSleeping$1();
                boolean bl = this.drainReadyEvents$1(pollResult2, false);
                return true;
            }
            st = this.parked().get();
            if (st != ParkedSignal$Unparked$.MODULE$) continue;
            return false;
        } while (st != ParkedSignal$Interrupting$.MODULE$);
        while (this.parked().get() == ParkedSignal$Interrupting$.MODULE$) {
        }
        return false;
    }

    private final boolean parkLoopUntilNextSleeper$1(AtomicBoolean done$4, boolean needsPoll) {
        block9: {
            ParkedSignal st;
            do {
                boolean polled;
                PollResult pollResult;
                if (done$4.get()) {
                    return false;
                }
                long triggerTime = this.sleepers.peekFirstTriggerTime();
                if (triggerTime == Long.MIN_VALUE) {
                    return this.parkLoop$1(done$4, needsPoll);
                }
                this.now_$eq(System.nanoTime());
                long nanos = triggerTime - this.now();
                if (nanos <= 0L) break block9;
                long start = this.now();
                this.metrics.incrementPolledCount();
                if (needsPoll) {
                    pollResult = this.system.poll(this._poller, nanos);
                } else {
                    LockSupport.parkNanos(nanos);
                    pollResult = PollResult$Interrupted$.MODULE$;
                }
                PollResult$Interrupted$ pollResult2 = pollResult;
                this.now_$eq(System.nanoTime());
                this.metrics.addIdleTime(this.now() - start);
                if (this.isInterrupted()) {
                    this.pool.shutdown();
                    return false;
                }
                boolean bl = polled = pollResult2 != PollResult$Interrupted$.MODULE$;
                if (polled || triggerTime - this.now() <= 0L) {
                    this.notifyDoneSleeping$1();
                    if (polled) {
                        boolean bl2 = this.drainReadyEvents$1(pollResult2, false);
                    }
                    return true;
                }
                st = this.parked().get();
                if (st != ParkedSignal$Unparked$.MODULE$) continue;
                return false;
            } while (st != ParkedSignal$Interrupting$.MODULE$);
            while ((st = this.parked().get()) == ParkedSignal$Interrupting$.MODULE$) {
            }
            return false;
        }
        this.notifyDoneSleeping$1();
        return true;
    }

    private static final String formatTrace$1(StackTraceElement[] st) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < st.length; ++i) {
            sb.append("  at ");
            sb.append(st[i].toString());
            if (i == st.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final class Metrics {
        private long idleTime = 0L;
        private long parkedCount = 0L;
        private long polledCount = 0L;
        private long blockingCount = 0L;
        private long respawnCount = 0L;

        public long getIdleTime() {
            return this.idleTime;
        }

        public void addIdleTime(long x) {
            this.idleTime += x;
        }

        public long getParkedCount() {
            return this.parkedCount;
        }

        public void incrementParkedCount() {
            ++this.parkedCount;
        }

        public long getPolledCount() {
            return this.polledCount;
        }

        public void incrementPolledCount() {
            ++this.polledCount;
        }

        public long getBlockingCount() {
            return this.blockingCount;
        }

        public void incrementBlockingCount() {
            ++this.blockingCount;
        }

        public long getRespawnCount() {
            return this.respawnCount;
        }

        public void incrementRespawnCount() {
            ++this.respawnCount;
        }
    }

    public static final class TransferState {
        private int index;
        private int tick;

        public int index() {
            return this.index;
        }

        public void index_$eq(int x$1) {
            this.index = x$1;
        }

        public int tick() {
            return this.tick;
        }

        public void tick_$eq(int x$1) {
            this.tick = x$1;
        }
    }
}

