/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.util;

import com.raquo.ew.JsArray;
import com.raquo.ew.JsArray$;
import com.raquo.ew.JsArray$RichJsArray$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;

public class JsPriorityQueue<A> {
    private final Function1<A, Object> getRank;
    private final JsArray<A> queue;

    public JsPriorityQueue(Function1<A, Object> getRank) {
        this.getRank = getRank;
        this.queue = JsArray$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public void enqueue(A item) {
        int itemRank = BoxesRunTime.unboxToInt((Object)this.getRank.apply(item));
        int insertAtIndex = 0;
        boolean foundHigherRank = false;
        while (insertAtIndex < this.queue.length() && !foundHigherRank) {
            if (BoxesRunTime.unboxToInt((Object)this.getRank.apply(this.queue.apply(insertAtIndex))) > itemRank) {
                foundHigherRank = true;
                continue;
            }
            ++insertAtIndex;
        }
        this.queue.splice(insertAtIndex, 0, (Seq<A>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{item}));
    }

    public A dequeue() {
        if (this.nonEmpty()) {
            return this.queue.shift();
        }
        throw new Exception("Unable to dequeue an empty JsPriorityQueue");
    }

    public boolean contains(A item) {
        return this.queue.indexOf(item) != -1;
    }

    public int size() {
        return this.queue.length();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public List<A> debugQueue() {
        JsArray jsArray = JsArray$.MODULE$.RichJsArray(this.queue);
        return Any$.MODULE$.wrapArray(JsArray$RichJsArray$.MODULE$.asScalaJs$extension(jsArray)).toList();
    }
}

