'use strict'

const assert = require('assert')
const rgba = require('./')

assert.deepEqual(rgba('red'), [1, 0, 0, 1])
assert.deepEqual(rgba('rgb(80, 120, 160)', 'uint8'), new Uint8Array([80, 120, 160, 255]))
assert.deepEqual(rgba('rgb(255, 255, 255, .5)', 'float64'), new Float64Array([1, 1, 1, 1]))
assert.deepEqual(rgba('rgba(255, 255, 255, .5)', 'float64'), new Float64Array([1, 1, 1, .5]))
assert.deepEqual(rgba('hsla(109, 50%, 50%, .75)', 'uint8'), new Uint8Array([87, 191, 63, 191]))
assert.deepEqual(rgba(new Float32Array([0, 0.25, 0, 1]), 'uint8_clamped'), new Uint8ClampedArray([0, 63, 0, 255]))
assert.deepEqual(rgba(new Uint8Array([0, 72, 0, 255]), 'array'), [0, 0.2823529411764706, 0, 1])
assert.deepEqual(rgba(new Uint8Array([0, 72, 0, 255]), 'uint8'), new Uint8Array([0, 72, 0, 255]))

assert.deepEqual(rgba([0,0,0,1]), [0,0,0,1])
assert.deepEqual(rgba(0x00ff00), [0,1,0,1])

assert.deepEqual(rgba(new Uint8Array([0, 72, 0]), 'uint8'), new Uint8Array([0, 72, 0, 255]))

assert.deepEqual(rgba([127.5,127.5,127.5,127.5]), [.5,.5,.5,.5])
assert.deepEqual(rgba([127,127,127,127], 'uint8'), new Uint8Array([127,127,127,127]))
assert.deepEqual(rgba([.5,.5,.5,.5]), [.5,.5,.5,.5])
assert.deepEqual(rgba([.5,.5,.5,.5], 'uint8'), new Uint8Array([127,127,127,127]))
assert.deepEqual(rgba([0,0,0,0]), [0,0,0,0])
assert.deepEqual(rgba([0,0,0,0], 'uint'), new Uint8Array([0,0,0,0]))
assert.deepEqual(rgba([0,0,0]), [0,0,0,1])
assert.deepEqual(rgba([0,0,0], 'uint'), new Uint8Array([0,0,0,255]))
assert.deepEqual(rgba([0,0,1]), [0,0,1,1])
assert.deepEqual(rgba([0,0,1], 'uint'), new Uint8Array([0,0,255,255]))
assert.deepEqual(rgba([1,1,1]), [1,1,1,1])
assert.deepEqual(rgba([1,1,1], 'uint'), new Uint8Array([255,255,255,255]))


assert.deepEqual(rgba([0,0,0]), [0,0,0,1])
// assert.deepEqual(rgba([.5,.5,.5]), [.5,.5,.5,1])
assert.deepEqual(rgba([1,1,1]), [1,1,1,1])
assert.deepEqual(rgba([127.5,127.5,127.5]), [.5,.5,.5,1])
assert.deepEqual(rgba([255,255,255]), [1,1,1,1])
