/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.HenriesPerMeter$;
import squants.electro.Henry$;
import squants.electro.Inductance$;
import squants.electro.InductanceUnit;
import squants.electro.MagneticFlux;
import squants.electro.Microhenry$;
import squants.electro.Millihenry$;
import squants.electro.Nanohenry$;
import squants.electro.Permeability;
import squants.electro.Picohenry$;
import squants.electro.Webers$;
import squants.space.Length;

public final class Inductance
extends Quantity<Inductance> {
    private final double value;
    private final InductanceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Inductance$.class, "0bitmap$1");

    public static Try<Inductance> apply(Object object) {
        return Inductance$.MODULE$.apply(object);
    }

    public static <A> Inductance apply(A a, InductanceUnit inductanceUnit, Numeric<A> numeric) {
        return Inductance$.MODULE$.apply(a, inductanceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Inductance$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Inductance$.MODULE$.name();
    }

    public static Try<Inductance> parseString(String string) {
        return Inductance$.MODULE$.parseString(string);
    }

    public static <N> Try<Inductance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Inductance$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Inductance$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Inductance$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Inductance>> symbolToUnit(String string) {
        return Inductance$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Inductance$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Inductance$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Inductance(double value, InductanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public InductanceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Inductance> dimension() {
        return Inductance$.MODULE$;
    }

    public MagneticFlux $times(ElectricCurrent that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toHenry() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Permeability $div(Length that) {
        return HenriesPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toHenry() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toHenry() {
        return this.to(Henry$.MODULE$);
    }

    public double toMillihenry() {
        return this.to(Millihenry$.MODULE$);
    }

    public double toMicrohenry() {
        return this.to(Microhenry$.MODULE$);
    }

    public double toNanohenry() {
        return this.to(Nanohenry$.MODULE$);
    }

    public double toPicohenry() {
        return this.to(Picohenry$.MODULE$);
    }
}

