/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Conductivity;
import squants.electro.ElectricalResistance;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity$;
import squants.electro.ResistivityUnit;
import squants.electro.SiemensPerMeter$;
import squants.package$;
import squants.space.Length;

public final class Resistivity
extends Quantity<Resistivity> {
    private final double value;
    private final ResistivityUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Resistivity$.class, "0bitmap$1");

    public static Try<Resistivity> apply(Object object) {
        return Resistivity$.MODULE$.apply(object);
    }

    public static <A> Resistivity apply(A a, ResistivityUnit resistivityUnit, Numeric<A> numeric) {
        return Resistivity$.MODULE$.apply(a, resistivityUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Resistivity$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Resistivity$.MODULE$.name();
    }

    public static Try<Resistivity> parseString(String string) {
        return Resistivity$.MODULE$.parseString(string);
    }

    public static <N> Try<Resistivity> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Resistivity$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Resistivity$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Resistivity$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Resistivity>> symbolToUnit(String string) {
        return Resistivity$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Resistivity$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Resistivity$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Resistivity(double value, ResistivityUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ResistivityUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Resistivity> dimension() {
        return Resistivity$.MODULE$;
    }

    public ElectricalResistance $div(Length that) {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhmMeters() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(ElectricalResistance that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toOhmMeters() / that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhmMeters() {
        return this.to(OhmMeters$.MODULE$);
    }

    public Conductivity inSiemensPerMeter() {
        return SiemensPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.toOhmMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }
}

