/*
 * Decompiled with CFR 0.152.
 */
package squants.space;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.EnergyDensity;
import squants.energy.Joules$;
import squants.mass.ChemicalAmount;
import squants.mass.Density;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.CubicMetersPerSecond$;
import squants.motion.VolumeFlow;
import squants.package$;
import squants.space.AcreFeet$;
import squants.space.Area;
import squants.space.Centilitres$;
import squants.space.CubicFeet$;
import squants.space.CubicInches$;
import squants.space.CubicMeters$;
import squants.space.CubicUsMiles$;
import squants.space.CubicYards$;
import squants.space.Decilitres$;
import squants.space.Feet$;
import squants.space.FluidOunces$;
import squants.space.Hectolitres$;
import squants.space.ImperialCups$;
import squants.space.ImperialGallons$;
import squants.space.ImperialPints$;
import squants.space.ImperialQuarts$;
import squants.space.Inches$;
import squants.space.Length;
import squants.space.Litres$;
import squants.space.Microlitres$;
import squants.space.Millilitres$;
import squants.space.Nanolitres$;
import squants.space.SquareFeet$;
import squants.space.SquareInches$;
import squants.space.SquareMeters$;
import squants.space.SquareUsMiles$;
import squants.space.SquareYards$;
import squants.space.Tablespoons$;
import squants.space.Teaspoons$;
import squants.space.UsCups$;
import squants.space.UsDryCups$;
import squants.space.UsDryGallons$;
import squants.space.UsDryPints$;
import squants.space.UsDryQuarts$;
import squants.space.UsGallons$;
import squants.space.UsMiles$;
import squants.space.UsPints$;
import squants.space.UsQuarts$;
import squants.space.Volume$;
import squants.space.VolumeUnit;
import squants.space.Yards$;
import squants.time.Time;
import squants.time.TimeIntegral;

public final class Volume
extends Quantity<Volume>
implements TimeIntegral<VolumeFlow> {
    private final double value;
    private final VolumeUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Volume$.class, "0bitmap$1");

    public static Try<Volume> apply(Object object) {
        return Volume$.MODULE$.apply(object);
    }

    public static <A> Volume apply(A a, VolumeUnit volumeUnit, Numeric<A> numeric) {
        return Volume$.MODULE$.apply(a, volumeUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Volume$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Volume$.MODULE$.name();
    }

    public static Try<Volume> parseString(String string) {
        return Volume$.MODULE$.parseString(string);
    }

    public static <N> Try<Volume> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Volume$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Volume$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Volume$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Volume>> symbolToUnit(String string) {
        return Volume$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Volume$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Volume$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Volume(double value, VolumeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public VolumeUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Volume> dimension() {
        return Volume$.MODULE$;
    }

    @Override
    public VolumeFlow timeDerived() {
        return CubicMetersPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toCubicMeters()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Mass $times(Density that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCubicMeters() * that.toKilogramsPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(EnergyDensity that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCubicMeters() * that.toJoulesPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Area that) {
        VolumeUnit volumeUnit = this.unit();
        return CubicUsMiles$.MODULE$.equals(volumeUnit) ? UsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toSquareUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicYards$.MODULE$.equals(volumeUnit) ? Yards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toSquareYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicFeet$.MODULE$.equals(volumeUnit) ? Feet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toSquareFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicInches$.MODULE$.equals(volumeUnit) ? Inches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toSquareInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toCubicMeters() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
    }

    public Area $div(Length that) {
        VolumeUnit volumeUnit = this.unit();
        return CubicUsMiles$.MODULE$.equals(volumeUnit) ? SquareUsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicYards$.MODULE$.equals(volumeUnit) ? SquareYards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicFeet$.MODULE$.equals(volumeUnit) ? SquareFeet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (CubicInches$.MODULE$.equals(volumeUnit) ? SquareInches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCubicMeters() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
    }

    public Nothing$ $div(Mass that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ $div(ChemicalAmount that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Length cubeRoot() {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.cbrt(this.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toCubicMeters() {
        return this.to(CubicMeters$.MODULE$);
    }

    public double toLitres() {
        return this.to(Litres$.MODULE$);
    }

    public double toNanolitres() {
        return this.to(Nanolitres$.MODULE$);
    }

    public double toMicrolitres() {
        return this.to(Microlitres$.MODULE$);
    }

    public double toMillilitres() {
        return this.to(Millilitres$.MODULE$);
    }

    public double toCentilitres() {
        return this.to(Centilitres$.MODULE$);
    }

    public double toDecilitres() {
        return this.to(Decilitres$.MODULE$);
    }

    public double toHectolitres() {
        return this.to(Hectolitres$.MODULE$);
    }

    public double toCubicMiles() {
        return this.to(CubicUsMiles$.MODULE$);
    }

    public double toCubicYards() {
        return this.to(CubicYards$.MODULE$);
    }

    public double toCubicFeet() {
        return this.to(CubicFeet$.MODULE$);
    }

    public double toCubicInches() {
        return this.to(CubicInches$.MODULE$);
    }

    public double toUsGallons() {
        return this.to(UsGallons$.MODULE$);
    }

    public double toUsQuarts() {
        return this.to(UsQuarts$.MODULE$);
    }

    public double toUsPints() {
        return this.to(UsPints$.MODULE$);
    }

    public double toUsCups() {
        return this.to(UsCups$.MODULE$);
    }

    public double toFluidOunces() {
        return this.to(FluidOunces$.MODULE$);
    }

    public double toTablespoons() {
        return this.to(Tablespoons$.MODULE$);
    }

    public double toTeaspoons() {
        return this.to(Teaspoons$.MODULE$);
    }

    public double toUsDryGallons() {
        return this.to(UsDryGallons$.MODULE$);
    }

    public double toUsDryQuarts() {
        return this.to(UsDryQuarts$.MODULE$);
    }

    public double toUsDryPints() {
        return this.to(UsDryPints$.MODULE$);
    }

    public double toUsDryCups() {
        return this.to(UsDryCups$.MODULE$);
    }

    public double toImperialGallons() {
        return this.to(ImperialGallons$.MODULE$);
    }

    public double toImperialQuarts() {
        return this.to(ImperialQuarts$.MODULE$);
    }

    public double toImperialPints() {
        return this.to(ImperialPints$.MODULE$);
    }

    public double toImperialCups() {
        return this.to(ImperialCups$.MODULE$);
    }

    public double toAcreFeet() {
        return this.to(AcreFeet$.MODULE$);
    }
}

